/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.page;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.data.Sort;
import jakarta.data.page.PageRequest;
import jakarta.data.page.PageRequestCursor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
record Pagination<T>(long page, int size, List<Sort<? super T>> sorts, PageRequest.Mode mode, PageRequest.Cursor type, boolean requestTotal) implements PageRequest<T>
{
    static final long serialVersionUID = 7051894085083600119L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    Pagination {
        if (page < 1L) {
            throw new IllegalArgumentException("pageNumber: " + page);
        }
        if (size < 1) {
            throw new IllegalArgumentException("maxPageSize: " + size);
        }
        if (mode != PageRequest.Mode.OFFSET && (type == null || type.size() == 0)) {
            throw new IllegalArgumentException("No key values were provided.");
        }
    }

    @Override
    public PageRequest<T> afterKey(Object ... componentsOfKey) {
        return new Pagination<T>(this.page, this.size, this.sorts, PageRequest.Mode.CURSOR_NEXT, new PageRequestCursor(componentsOfKey), this.requestTotal);
    }

    @Override
    public PageRequest<T> afterCursor(PageRequest.Cursor cursor) {
        return new Pagination<T>(this.page, this.size, this.sorts, PageRequest.Mode.CURSOR_NEXT, cursor, this.requestTotal);
    }

    private static final <E> List<E> append(List<E> list, E element) {
        int size = list.size();
        if (size == 0) {
            return List.of(element);
        }
        Object[] array = list.toArray(new Object[size + 1]);
        array[size] = element;
        List<Object> newList = Collections.unmodifiableList(Arrays.asList(array));
        return newList;
    }

    @Override
    public PageRequest<T> asc(String property) {
        return new Pagination<T>(this.page, this.size, Pagination.append(this.sorts, Sort.asc(property)), this.mode, this.type, this.requestTotal);
    }

    @Override
    public PageRequest<T> ascIgnoreCase(String attribute) {
        return new Pagination<T>(this.page, this.size, Pagination.append(this.sorts, Sort.ascIgnoreCase(attribute)), this.mode, this.type, this.requestTotal);
    }

    @Override
    public PageRequest<T> beforeKey(Object ... componentsOfKey) {
        return new Pagination<T>(this.page, this.size, this.sorts, PageRequest.Mode.CURSOR_PREVIOUS, new PageRequestCursor(componentsOfKey), this.requestTotal);
    }

    @Override
    public PageRequest<T> beforeCursor(PageRequest.Cursor cursor) {
        return new Pagination<T>(this.page, this.size, this.sorts, PageRequest.Mode.CURSOR_PREVIOUS, cursor, this.requestTotal);
    }

    @Override
    public Optional<PageRequest.Cursor> cursor() {
        return this.type == null ? Optional.empty() : Optional.of(this.type);
    }

    @Override
    public PageRequest<T> desc(String attribute) {
        return new Pagination<T>(this.page, this.size, Pagination.append(this.sorts, Sort.desc(attribute)), this.mode, this.type, this.requestTotal);
    }

    @Override
    public PageRequest<T> descIgnoreCase(String attribute) {
        return new Pagination<T>(this.page, this.size, Pagination.append(this.sorts, Sort.descIgnoreCase(attribute)), this.mode, this.type, this.requestTotal);
    }

    @Override
    public Pagination<T> next() {
        if (this.mode == PageRequest.Mode.OFFSET) {
            return new Pagination<T>(this.page + 1L, this.size, this.sorts, this.mode, null, this.requestTotal);
        }
        throw new UnsupportedOperationException("Not supported for cursor-based pagination. Instead use afterKey or afterCursor to provide a cursor or obtain the nextPageRequest from a CursoredPage.");
    }

    @Override
    public Pagination<T> page(long pageNumber) {
        return new Pagination<T>(pageNumber, this.size, this.sorts, this.mode, this.type, this.requestTotal);
    }

    @Override
    public PageRequest<T> previous() {
        if (this.mode == PageRequest.Mode.OFFSET) {
            if (this.page > 1L) {
                return new Pagination<T>(this.page - 1L, this.size, this.sorts, this.mode, null, this.requestTotal);
            }
            return null;
        }
        throw new UnsupportedOperationException("Not supported for cursor-based pagination. Instead use beforeKey or beforeCursor to provide a cursor or obtain the previousPageRequest from a CursoredPage.");
    }

    @Override
    public Pagination<T> size(int maxPageSize) {
        return new Pagination<T>(this.page, maxPageSize, this.sorts, this.mode, this.type, this.requestTotal);
    }

    @Override
    public Pagination<T> sortBy(Iterable<Sort<? super T>> sorts) {
        List<Sort<? super T>> sortList = sorts instanceof List ? List.copyOf((List)sorts) : (sorts == null ? Collections.emptyList() : StreamSupport.stream(sorts.spliterator(), false).collect(Collectors.toUnmodifiableList()));
        return new Pagination<T>(this.page, this.size, sortList, this.mode, this.type, this.requestTotal);
    }

    @Override
    public PageRequest<T> sortBy(Sort<? super T> sort) {
        return new Pagination<T>(this.page, this.size, List.of(sort), this.mode, this.type, this.requestTotal);
    }

    @Override
    public PageRequest<T> sortBy(Sort<? super T> sort1, Sort<? super T> sort2) {
        return new Pagination<T>(this.page, this.size, List.of(sort1, sort2), this.mode, this.type, this.requestTotal);
    }

    @Override
    public PageRequest<T> sortBy(Sort<? super T> sort1, Sort<? super T> sort2, Sort<? super T> sort3) {
        return new Pagination<T>(this.page, this.size, List.of(sort1, sort2, sort3), this.mode, this.type, this.requestTotal);
    }

    @Override
    public PageRequest<T> sortBy(Sort<? super T> sort1, Sort<? super T> sort2, Sort<? super T> sort3, Sort<? super T> sort4) {
        return new Pagination<T>(this.page, this.size, List.of(sort1, sort2, sort3, sort4), this.mode, this.type, this.requestTotal);
    }

    @Override
    public PageRequest<T> sortBy(Sort<? super T> sort1, Sort<? super T> sort2, Sort<? super T> sort3, Sort<? super T> sort4, Sort<? super T> sort5) {
        return new Pagination<T>(this.page, this.size, List.of(sort1, sort2, sort3, sort4, sort5), this.mode, this.type, this.requestTotal);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("PageRequest{page=").append(this.page).append(", size=").append(this.size);
        if (this.type != null) {
            b.append(", mode=").append((Object)this.mode).append(", ").append(this.type.size()).append(" keys");
        }
        for (Sort<T> o : this.sorts) {
            b.append(", ").append(o.property()).append(o.ignoreCase() ? " IGNORE CASE" : "").append(o.isDescending() ? " DESC" : " ASC");
        }
        b.append("}");
        return b.toString();
    }

    @Override
    public PageRequest<T> withoutTotal() {
        return new Pagination<T>(this.page, this.size, this.sorts, this.mode, this.type, false);
    }

    @Override
    public PageRequest<T> withTotal() {
        return new Pagination<T>(this.page, this.size, this.sorts, this.mode, this.type, true);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"jakarta.data.page.Pagination", Pagination.class, null, null);
    }
}

