/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.page.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.data.page.Page;
import jakarta.data.page.PageRequest;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public record PageRecord<T>(PageRequest<T> pageRequest, List<T> content, long totalElements, boolean moreResults) implements Page<T>
{
    private final long totalElements;
    static final long serialVersionUID = 4127386629181679805L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public PageRecord(PageRequest<T> req, List<T> content, long total) {
        this(req, content, total, content.size() == req.size() && (total < 0L || req.page() * (long)req.size() < total));
    }

    @Override
    public boolean hasContent() {
        return !this.content.isEmpty();
    }

    @Override
    public boolean hasNext() {
        return this.moreResults;
    }

    @Override
    public boolean hasPrevious() {
        return this.pageRequest.page() > 1L;
    }

    @Override
    public boolean hasTotals() {
        return this.totalElements >= 0L;
    }

    @Override
    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    @Override
    public PageRequest<T> nextPageRequest() {
        if (this.hasNext()) {
            return this.pageRequest.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public <E> PageRequest<E> nextPageRequest(Class<E> entityClass) {
        return this.nextPageRequest();
    }

    @Override
    public int numberOfElements() {
        return this.content.size();
    }

    @Override
    public <E> PageRequest<E> pageRequest(Class<E> entityClass) {
        return this.pageRequest;
    }

    @Override
    public PageRequest<T> previousPageRequest() {
        if (this.hasPrevious()) {
            return this.pageRequest.previous();
        }
        throw new NoSuchElementException();
    }

    @Override
    public <E> PageRequest<E> previousPageRequest(Class<E> entityClass) {
        return this.previousPageRequest();
    }

    @Override
    public long totalElements() {
        if (this.totalElements >= 0L) {
            return this.totalElements;
        }
        throw new IllegalStateException("total elements are not available");
    }

    @Override
    public long totalPages() {
        if (this.totalElements >= 0L) {
            int maxPageSize = this.pageRequest.size();
            return (this.totalElements + (long)(maxPageSize - 1)) / (long)maxPageSize;
        }
        throw new IllegalStateException("total elements are not available");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"jakarta.data.page.impl.PageRecord", PageRecord.class, null, null);
    }
}

