/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.netty.internal.tcp;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.openliberty.netty.internal.ConfigConstants;
import java.util.concurrent.atomic.AtomicInteger;

@ChannelHandler.Sharable
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MaxOpenConnectionsHandler
extends ChannelInboundHandlerAdapter {
    private static final TraceComponent tc = Tr.register(MaxOpenConnectionsHandler.class, (String)"Netty", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private final AtomicInteger connections = new AtomicInteger();
    private final int maxConnections;
    private long lastConnExceededTime = 0L;
    static final long serialVersionUID = 5558014304754560579L;

    public MaxOpenConnectionsHandler(int maxConnectionCount) {
        this.maxConnections = maxConnectionCount;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        int val = this.connections.incrementAndGet();
        if (val <= this.maxConnections) {
            super.channelActive(ctx);
        } else {
            ctx.close();
            long currentTime = System.currentTimeMillis();
            if (currentTime > this.lastConnExceededTime + 600000L) {
                String channelName = (String)ctx.channel().attr(ConfigConstants.NAME_KEY).get();
                Tr.warning((TraceComponent)tc, (String)"MAX_CONNS_EXCEEDED", (Object[])new Object[]{channelName, this.maxConnections});
                this.lastConnExceededTime = currentTime;
            }
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.connections.decrementAndGet();
    }
}

