/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.bci;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class DeferConstructorProcessingMethodAdapter
extends MethodVisitor {
    private static final Object THIS = new Object(){

        public String toString() {
            return "this";
        }
    };
    private static final Object OTHER = new Object(){

        public String toString() {
            return "other";
        }
    };
    private boolean waitingForSuper = false;
    private List<Object> currentStack = new ArrayList<Object>();
    private final Map<Label, List<Object>> branchTargets = new HashMap<Label, List<Object>>();

    DeferConstructorProcessingMethodAdapter(MethodVisitor visitor) {
        super(589824, visitor);
    }

    private void push(Object stackElement, int count) {
        for (int i = 0; i < count; ++i) {
            this.currentStack.add(stackElement);
        }
    }

    private Object pop(int count) {
        Object popped = null;
        for (int i = count; i > 0; --i) {
            popped = this.currentStack.remove(this.currentStack.size() - 1);
        }
        return popped;
    }

    private void addBranchTarget(Label target) {
        if (!this.branchTargets.containsKey(target)) {
            this.branchTargets.put(target, new ArrayList<Object>(this.currentStack));
        }
    }

    public void visitCode() {
        super.visitCode();
        this.waitingForSuper = true;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        super.visitFieldInsn(opcode, owner, name, desc);
        if (!this.waitingForSuper) {
            return;
        }
        Type type = Type.getType((String)desc);
        switch (opcode) {
            case 178: {
                this.push(OTHER, type.getSize());
                break;
            }
            case 180: {
                this.push(OTHER, type.getSize() - 1);
                break;
            }
            case 179: {
                this.pop(type.getSize());
                break;
            }
            case 181: {
                this.pop(type.getSize() + 1);
            }
        }
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        if (!this.waitingForSuper) {
            return;
        }
        switch (opcode) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                this.push(OTHER, 1);
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                this.push(OTHER, 2);
                break;
            }
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                this.pop(1);
                break;
            }
            case 47: 
            case 49: {
                break;
            }
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.pop(3);
                break;
            }
            case 80: 
            case 82: {
                this.pop(4);
                break;
            }
            case 87: {
                this.pop(1);
                break;
            }
            case 88: {
                this.pop(2);
                break;
            }
            case 89: {
                Object top = this.currentStack.get(this.currentStack.size() - 1);
                this.push(top, 1);
                break;
            }
            case 90: {
                Object top = this.currentStack.get(this.currentStack.size() - 1);
                int addPosition = this.currentStack.size() - 2;
                this.currentStack.add(addPosition, top);
                break;
            }
            case 91: {
                Object top = this.currentStack.get(this.currentStack.size() - 1);
                int addPosition = this.currentStack.size() - 3;
                this.currentStack.add(addPosition, top);
                break;
            }
            case 92: {
                int position = this.currentStack.size() - 2;
                this.currentStack.add(this.currentStack.get(position));
                this.currentStack.add(this.currentStack.get(position + 1));
                break;
            }
            case 93: {
                int addPosition = this.currentStack.size() - 3;
                this.currentStack.add(addPosition, this.currentStack.get(this.currentStack.size() - 1));
                this.currentStack.add(addPosition, this.currentStack.get(this.currentStack.size() - 2));
                break;
            }
            case 94: {
                int addPosition = this.currentStack.size() - 4;
                this.currentStack.add(addPosition, this.currentStack.get(this.currentStack.size() - 1));
                this.currentStack.add(addPosition, this.currentStack.get(this.currentStack.size() - 2));
                break;
            }
            case 95: {
                Object o = this.currentStack.remove(this.currentStack.size() - 2);
                this.currentStack.add(o);
                break;
            }
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 114: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                this.pop(1);
                break;
            }
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                this.pop(2);
                break;
            }
            case 133: 
            case 135: 
            case 140: 
            case 141: {
                this.push(OTHER, 1);
                break;
            }
            case 134: 
            case 139: 
            case 145: 
            case 146: 
            case 147: {
                break;
            }
            case 136: 
            case 137: 
            case 142: 
            case 144: {
                this.pop(1);
                break;
            }
            case 138: 
            case 143: {
                break;
            }
            case 148: 
            case 151: 
            case 152: {
                this.pop(3);
                break;
            }
            case 149: 
            case 150: {
                this.pop(1);
                break;
            }
            case 172: 
            case 174: 
            case 176: {
                this.pop(1);
                break;
            }
            case 173: 
            case 175: {
                this.pop(2);
                break;
            }
            case 177: {
                break;
            }
            case 190: {
                break;
            }
            case 191: {
                this.pop(1);
                break;
            }
            case 194: 
            case 195: {
                this.pop(1);
                break;
            }
        }
    }

    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        if (!this.waitingForSuper) {
            return;
        }
        switch (opcode) {
            case 16: 
            case 17: {
                this.push(OTHER, 1);
            }
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        if (!this.waitingForSuper) {
            return;
        }
        switch (opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                this.pop(1);
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.pop(2);
                break;
            }
            case 167: {
                break;
            }
            case 168: {
                this.push(OTHER, 1);
                break;
            }
            case 198: 
            case 199: {
                this.pop(1);
            }
        }
        this.addBranchTarget(label);
    }

    public void visitLabel(Label label) {
        super.visitLabel(label);
        if (!this.waitingForSuper) {
            return;
        }
        if (this.branchTargets.containsKey(label)) {
            this.currentStack = this.branchTargets.get(label);
        }
    }

    public void visitLdcInsn(Object cst) {
        super.visitLdcInsn(cst);
        if (!this.waitingForSuper) {
            return;
        }
        if (cst instanceof Long || cst instanceof Double) {
            this.push(OTHER, 2);
        } else {
            this.push(OTHER, 1);
        }
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        if (!this.waitingForSuper) {
            return;
        }
        this.pop(1);
        this.addBranchTarget(dflt);
        for (Label label : labels) {
            this.addBranchTarget(label);
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        super.visitMethodInsn(opcode, owner, name, desc, itf);
        if (!this.waitingForSuper) {
            return;
        }
        for (Type arg : Type.getArgumentTypes((String)desc)) {
            this.pop(arg.getSize());
        }
        switch (opcode) {
            case 184: {
                break;
            }
            case 182: 
            case 185: {
                this.pop(1);
                break;
            }
            case 183: {
                Object top = this.pop(1);
                if (top != THIS) break;
                this.waitingForSuper = false;
            }
        }
        Type returnType = Type.getReturnType((String)desc);
        if (returnType != Type.VOID_TYPE) {
            this.push(OTHER, returnType.getSize());
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        super.visitMultiANewArrayInsn(desc, dims);
        if (!this.waitingForSuper) {
            return;
        }
        this.pop(dims);
        this.push(OTHER, 1);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        if (!this.waitingForSuper) {
            return;
        }
        this.pop(1);
        this.addBranchTarget(dflt);
        for (Label label : labels) {
            this.addBranchTarget(label);
        }
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        if (!this.waitingForSuper) {
            return;
        }
        switch (opcode) {
            case 187: {
                this.push(OTHER, 1);
                break;
            }
        }
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        if (!this.waitingForSuper) {
            return;
        }
        switch (opcode) {
            case 25: {
                this.push(var == 0 ? THIS : OTHER, 1);
                break;
            }
            case 21: 
            case 23: {
                this.push(OTHER, 1);
                break;
            }
            case 22: 
            case 24: {
                this.push(OTHER, 2);
                break;
            }
            case 54: 
            case 56: 
            case 58: {
                this.pop(1);
                break;
            }
            case 55: 
            case 57: {
                this.pop(2);
                break;
            }
        }
    }
}

