/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.collector;

import com.ibm.ws.logging.collector.BurstDateFormat;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.Locale;

public class DateFormatHelper {
    private static final BurstDateFormat localeDateFormat;
    private static final BurstDateFormat isoDateFormat;

    private static final String removeClockFormat(StringBuilder sb) {
        char letter;
        int start;
        int end = sb.length() - 1;
        for (start = 0; start <= end && ((letter = sb.charAt(start)) == ' ' || letter == 'a'); ++start) {
        }
        while (end > start && ((letter = sb.charAt(end)) == ' ' || letter == 'a')) {
            --end;
        }
        for (int i = start; i <= end; ++i) {
            letter = sb.charAt(i);
            if (letter == 'h' || letter == 'k' || letter == 'K') {
                sb.setCharAt(i, 'H');
                continue;
            }
            if (letter != 'a') continue;
            sb.setCharAt(i, ' ');
        }
        return sb.substring(start, end + 1);
    }

    public static final String formatTime(long timestamp, boolean useIsoDateFormat) {
        return (useIsoDateFormat ? isoDateFormat : localeDateFormat).format(timestamp);
    }

    static {
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        String pattern = DateTimeFormatterBuilder.getLocalizedDateTimePattern(FormatStyle.SHORT, FormatStyle.MEDIUM, Chronology.ofLocale(locale), locale);
        int patternLength = pattern.length();
        int endOfSecsIndex = pattern.lastIndexOf(115) + 1;
        StringBuilder newPattern = new StringBuilder(pattern.substring(0, endOfSecsIndex) + ":SSS z");
        if (endOfSecsIndex < patternLength) {
            newPattern.append(pattern.substring(endOfSecsIndex, patternLength));
        }
        String localeDatePattern = DateFormatHelper.removeClockFormat(newPattern);
        localeDateFormat = new BurstDateFormat(localeDatePattern, ':', locale);
        isoDateFormat = new BurstDateFormat("uuuu-MM-dd'T'HH:mm:ss.SSSZ", '.');
    }
}

