/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.classloader;

import com.ibm.ws.kernel.boot.classloader.ClassLoaderHook;
import java.lang.reflect.Method;
import java.net.URL;

final class SharedClassCacheHook
implements ClassLoaderHook {
    private static final Object sharedClassHelperFactoryClass;
    private static final Method getURLHelperMethod;
    private static final Method findSharedClassMethod;
    private static final Method storeSharedClassMethod;
    private final Object sharedClassURLHelper;

    static ClassLoaderHook newInstance(ClassLoader loader) {
        Object helper = null;
        if (getURLHelperMethod != null && sharedClassHelperFactoryClass != null) {
            try {
                helper = getURLHelperMethod.invoke(sharedClassHelperFactoryClass, loader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return helper == null ? null : new SharedClassCacheHook(helper);
    }

    private SharedClassCacheHook(Object sharedClassHelper) {
        this.sharedClassURLHelper = sharedClassHelper;
    }

    @Override
    public byte[] loadClass(URL path, String name) {
        if (findSharedClassMethod != null) {
            try {
                return (byte[])findSharedClassMethod.invoke(this.sharedClassURLHelper, path, name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void storeClass(URL path, Class<?> clazz) {
        if (storeSharedClassMethod != null) {
            try {
                storeSharedClassMethod.invoke(this.sharedClassURLHelper, path, clazz);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        Object sharedClassHelperFactory = null;
        Method getURLHelper = null;
        Method findSharedClass = null;
        Method storeSharedClass = null;
        try {
            Class<?> sharedClass = Class.forName("com.ibm.oti.shared.Shared");
            Method m = sharedClass.getDeclaredMethod("getSharedClassHelperFactory", new Class[0]);
            sharedClassHelperFactory = m.invoke(null, new Object[0]);
            getURLHelper = m.getReturnType().getDeclaredMethod("getURLHelper", ClassLoader.class);
            Class<?> sharedClassURLHelperClass = getURLHelper.getReturnType();
            findSharedClass = sharedClassURLHelperClass.getDeclaredMethod("findSharedClass", URL.class, String.class);
            storeSharedClass = sharedClassURLHelperClass.getDeclaredMethod("storeSharedClass", URL.class, Class.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        sharedClassHelperFactoryClass = sharedClassHelperFactory;
        getURLHelperMethod = getURLHelper;
        findSharedClassMethod = findSharedClass;
        storeSharedClassMethod = storeSharedClass;
    }
}

