/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.util;

import com.ibm.ws.crypto.util.InvalidPasswordCipherException;
import com.ibm.ws.crypto.util.PasswordHashGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HashedData {
    private static final String DEFAULT_ALGORITHM = PasswordHashGenerator.getDefaultAlgorithm();
    private static final int DEFAULT_ITERATION = PasswordHashGenerator.getDefaultIteration();
    private static final int DEFAULT_OUTPUT_LENGTH = PasswordHashGenerator.getDefaultOutputLength();
    private static final int LR_LENGTH = 4;
    private static final int TAG_LENGTH = 1;
    private static final byte TAG_VERSION_V1 = 1;
    private static final byte TAG_ALGORITHM = 16;
    private static final byte TAG_ITERATION = 32;
    private static final byte TAG_SALT = 48;
    private static final byte TAG_DIGEST = 64;
    private static final byte TAG_OUTPUT_LENGTH = 80;
    private final char[] plain;
    private String algorithm;
    private int iteration;
    private int length;
    private byte[] salt;
    private byte[] digest;
    private final byte[] bytes;
    private static final Class<?> CLASS_NAME = HashedData.class;
    private static final Logger logger = Logger.getLogger(CLASS_NAME.getCanonicalName());

    HashedData() {
        this.plain = null;
        this.algorithm = null;
        this.iteration = -1;
        this.salt = null;
        this.digest = null;
        this.bytes = null;
        this.length = 0;
    }

    HashedData(char[] plain, String algorithm, byte[] salt, int iteration, int length, byte[] digest) {
        this.plain = plain;
        this.algorithm = algorithm;
        this.iteration = iteration;
        this.salt = salt;
        this.digest = digest;
        this.length = length;
        this.bytes = null;
    }

    HashedData(byte[] input) throws InvalidPasswordCipherException {
        block15: {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ctor:HashedData");
                logger.fine(PasswordHashGenerator.hexDump(input));
            }
            try {
                if (input != null) {
                    ByteArrayInputStream buffer = new ByteArrayInputStream(input);
                    if (1 == (byte)(buffer.read() & 0xFF)) {
                        this.algorithm = DEFAULT_ALGORITHM;
                        this.iteration = DEFAULT_ITERATION;
                        this.length = DEFAULT_OUTPUT_LENGTH;
                        this.plain = null;
                        this.salt = null;
                        this.digest = null;
                        this.bytes = input;
                        block10: while (buffer.available() > 0) {
                            byte id = (byte)(buffer.read() & 0xFF);
                            switch (id) {
                                case 16: {
                                    this.algorithm = this.readString(buffer);
                                    continue block10;
                                }
                                case 32: {
                                    this.iteration = this.readInt(buffer);
                                    continue block10;
                                }
                                case 48: {
                                    this.salt = this.readByte(buffer);
                                    if (!logger.isLoggable(Level.FINE)) continue block10;
                                    logger.fine("salt length : " + this.salt.length);
                                    logger.fine(PasswordHashGenerator.hexDump(this.salt));
                                    continue block10;
                                }
                                case 64: {
                                    this.digest = this.readByte(buffer);
                                    if (!logger.isLoggable(Level.FINE)) continue block10;
                                    logger.fine("digest length : " + this.digest.length);
                                    logger.fine(PasswordHashGenerator.hexDump(this.digest));
                                    continue block10;
                                }
                                case 80: {
                                    this.length = this.readInt(buffer);
                                    continue block10;
                                }
                            }
                            throw new InvalidPasswordCipherException("Invalid format: data contains unknown identifier.");
                        }
                        if (this.salt == null || this.digest == null) {
                            throw new InvalidPasswordCipherException("Invalid format: one of required data is missing.");
                        }
                        break block15;
                    }
                    throw new InvalidPasswordCipherException("Invalid format: invalid data identifier.");
                }
                throw new InvalidPasswordCipherException("Invalid format: null object.");
            }
            catch (InvalidPasswordCipherException ipe) {
                throw ipe;
            }
            catch (Exception e) {
                throw (InvalidPasswordCipherException)new InvalidPasswordCipherException(e.getMessage()).initCause(e);
            }
        }
    }

    public byte[] toBytes() throws InvalidPasswordCipherException {
        byte[] output = null;
        if (this.bytes != null) {
            output = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, output, 0, this.bytes.length);
        } else if (this.algorithm != null && this.algorithm.length() > 0 && this.iteration > 0 && this.salt != null && this.salt.length > 0) {
            try {
                if (this.digest == null) {
                    this.getDigest();
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                buffer.write(1);
                if (!DEFAULT_ALGORITHM.equals(this.algorithm)) {
                    buffer.write(16);
                    this.writeString(buffer, this.algorithm);
                }
                if (this.iteration != DEFAULT_ITERATION) {
                    buffer.write(32);
                    this.writeInt(buffer, this.iteration);
                }
                if (this.length != DEFAULT_OUTPUT_LENGTH) {
                    buffer.write(80);
                    this.writeInt(buffer, this.length);
                }
                buffer.write(48);
                this.writeByte(buffer, this.salt);
                buffer.write(64);
                this.writeByte(buffer, this.digest);
                output = buffer.toByteArray();
            }
            catch (Exception e) {
                throw (InvalidPasswordCipherException)new InvalidPasswordCipherException("An error while serializing object").initCause(e);
            }
        }
        return output;
    }

    public char[] getPlain() {
        char[] output = null;
        if (this.plain != null) {
            output = (char[])this.plain.clone();
        }
        return output;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public int getIteration() {
        return this.iteration;
    }

    public byte[] getSalt() {
        byte[] output = null;
        if (this.salt != null) {
            output = (byte[])this.salt.clone();
        }
        return output;
    }

    public byte[] getDigest() throws InvalidPasswordCipherException {
        if (this.digest == null) {
            this.digest = PasswordHashGenerator.digest(this);
        }
        byte[] output = null;
        if (this.digest != null) {
            output = (byte[])this.digest.clone();
        }
        return output;
    }

    public int getOutputLength() {
        return this.length;
    }

    private int readInt(ByteArrayInputStream input) throws NumberFormatException {
        if (input != null) {
            byte[] data = new byte[4];
            input.read(data, 0, 4);
            return this.readInt(data, 0);
        }
        throw new NumberFormatException("null object");
    }

    private int readInt(byte[] input, int offset) throws NumberFormatException {
        int output = 0;
        if (input != null && input.length >= 4 + offset) {
            for (int i = 0; i < 4; ++i) {
                output = output << 8 | input[i + offset] & 0xFF;
            }
        } else {
            throw new NumberFormatException("either length of byte array or offset is not valid.");
        }
        return output;
    }

    private String readString(ByteArrayInputStream input) throws InvalidPasswordCipherException, UnsupportedEncodingException {
        String output = null;
        if (input != null) {
            int length = this.readInt(input);
            if (length > 0) {
                byte[] data = new byte[length];
                input.read(data, 0, length);
                output = new String(data, StandardCharsets.UTF_8);
            }
        } else {
            throw new InvalidPasswordCipherException("null object");
        }
        return output;
    }

    private byte[] readByte(ByteArrayInputStream input) throws InvalidPasswordCipherException {
        byte[] output = null;
        if (input != null) {
            int length = this.readInt(input);
            if (length > 0) {
                output = new byte[length];
                input.read(output, 0, length);
            }
        } else {
            throw new InvalidPasswordCipherException("null object");
        }
        return output;
    }

    private void writeInt(ByteArrayOutputStream output, int value) throws InvalidPasswordCipherException {
        if (output == null) {
            throw new InvalidPasswordCipherException("null object");
        }
        byte[] b = this.toByte(value);
        output.write(b, 0, b.length);
    }

    private void writeString(ByteArrayOutputStream output, String value) throws InvalidPasswordCipherException, UnsupportedEncodingException {
        if (output == null || value == null) {
            throw new InvalidPasswordCipherException("null object");
        }
        byte[] b = this.toByte(value.length());
        output.write(b, 0, b.length);
        b = value.getBytes(StandardCharsets.UTF_8);
        output.write(b, 0, b.length);
    }

    private void writeByte(ByteArrayOutputStream output, byte[] value) throws InvalidPasswordCipherException {
        if (output == null || value == null) {
            throw new InvalidPasswordCipherException("null object");
        }
        byte[] b = this.toByte(value.length);
        output.write(b, 0, b.length);
        output.write(value, 0, value.length);
    }

    private byte[] toByte(int input) {
        byte[] output = new byte[]{(byte)(input >> 24 & 0xFF), (byte)(input >> 16 & 0xFF), (byte)(input >> 8 & 0xFF), (byte)(input >> 0 & 0xFF)};
        return output;
    }
}

