/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.strategies.writeable;

import com.ibm.ws.repository.common.enums.State;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.exceptions.RepositoryBadDataException;
import com.ibm.ws.repository.exceptions.RepositoryResourceCreationException;
import com.ibm.ws.repository.exceptions.RepositoryResourceException;
import com.ibm.ws.repository.exceptions.RepositoryResourceNoConnectionException;
import com.ibm.ws.repository.exceptions.RepositoryResourceUpdateException;
import com.ibm.ws.repository.exceptions.RepositoryResourceValidationException;
import com.ibm.ws.repository.resources.internal.RepositoryResourceImpl;
import com.ibm.ws.repository.strategies.writeable.BaseStrategy;
import java.util.ArrayList;
import java.util.List;

public class UpdateInPlaceStrategy
extends BaseStrategy {
    private boolean _forceReplace;
    private List<RepositoryResourceImpl> _matchingResources = null;

    public UpdateInPlaceStrategy() {
    }

    public UpdateInPlaceStrategy(State desiredStateIfMatchingFound, State desiredStateIfNoMatchingFound, boolean forceReplace) {
        super(desiredStateIfMatchingFound, desiredStateIfNoMatchingFound);
        this._forceReplace = forceReplace;
    }

    public UpdateInPlaceStrategy(State desiredStateIfMatchingFound, State desiredStateIfNoMatchingFound, boolean forceReplace, RepositoryResourceImpl matchingResource) {
        super(desiredStateIfMatchingFound, desiredStateIfNoMatchingFound);
        this._forceReplace = forceReplace;
        if (matchingResource != null) {
            this._matchingResources = new ArrayList<RepositoryResourceImpl>();
            this._matchingResources.add(matchingResource);
        }
    }

    @Override
    public List<RepositoryResourceImpl> findMatchingResources(RepositoryResourceImpl resource) throws RepositoryResourceValidationException, RepositoryBackendException, RepositoryBadDataException, RepositoryResourceNoConnectionException {
        if (this._matchingResources != null) {
            return this._matchingResources;
        }
        return resource.findMatchingResource();
    }

    @Override
    public void uploadAsset(RepositoryResourceImpl resource, List<RepositoryResourceImpl> matchingResources) throws RepositoryBackendException, RepositoryResourceException {
        RepositoryResourceImpl firstMatch = matchingResources == null || matchingResources.isEmpty() ? null : matchingResources.get(0);
        State targetState = this.calculateTargetState(firstMatch);
        if (firstMatch != null && firstMatch.getState() == State.PUBLISHED) {
            firstMatch.unpublish();
        }
        switch (resource.updateRequired(firstMatch)) {
            case ADD: {
                resource.addAsset();
                break;
            }
            case NOTHING: {
                if (!this._forceReplace) {
                    resource.copyAsset(firstMatch);
                    break;
                }
            }
            case UPDATE: {
                resource.overWriteAssetData(firstMatch, true);
                resource.updateAsset();
            }
        }
        for (RepositoryResourceImpl.AttachmentResourceImpl attachment : resource.getAttachmentImpls()) {
            this.uploadAttachment(resource, attachment, firstMatch);
        }
        resource.refreshFromMassive();
        resource.moveToState(targetState);
    }

    public void uploadAttachment(RepositoryResourceImpl resource, RepositoryResourceImpl.AttachmentResourceImpl attachment, RepositoryResourceImpl matchingResource) throws RepositoryResourceCreationException, RepositoryBadDataException, RepositoryResourceUpdateException, RepositoryBackendException, RepositoryResourceException {
        switch (attachment.updateRequired(matchingResource)) {
            case ADD: {
                resource.addAttachment(attachment);
                break;
            }
            case UPDATE: {
                resource.updateAttachment(attachment);
                break;
            }
        }
    }
}

