/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.utils;

import com.ibm.websphere.ras.annotation.Trivial;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@Trivial
public final class KeyBasedLockStore<Key, Lock> {
    private final ReferenceQueue<Lock> refQueue = new ReferenceQueue();
    private final ConcurrentHashMap<Key, LockWeakRef> lockMap = new ConcurrentHashMap();
    private final Supplier<Lock> lockCreator;

    public KeyBasedLockStore(Supplier<Lock> lockCreator) {
        this.lockCreator = lockCreator;
    }

    public final Lock getLock(Key key) {
        Lock lock;
        this.poll();
        LockWeakRef lockRef = this.lockMap.get(key);
        Lock Lock = lock = lockRef != null ? (Lock)lockRef.get() : null;
        if (lock != null) {
            return lock;
        }
        lock = this.lockCreator.get();
        LockWeakRef retVal;
        while ((retVal = this.lockMap.putIfAbsent(key, new LockWeakRef(lock, key))) != null) {
            Object retLock = retVal.get();
            if (retLock != null) {
                return (Lock)retLock;
            }
            this.lockMap.remove(key, retVal);
        }
        return lock;
    }

    private final void poll() {
        LockWeakRef lockRef;
        while ((lockRef = (LockWeakRef)this.refQueue.poll()) != null) {
            this.lockMap.remove(lockRef.key, lockRef);
        }
    }

    private final class LockWeakRef
    extends WeakReference<Lock> {
        final Key key;

        @Trivial
        public LockWeakRef(Lock referent, Key keyValue) {
            super(referent, KeyBasedLockStore.this.refQueue);
            this.key = keyValue;
        }
    }
}

