/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi.stackjoiner;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.logging.internal.osgi.Activator;
import com.ibm.ws.logging.internal.osgi.stackjoiner.MethodProxy;
import com.ibm.ws.logging.internal.osgi.stackjoiner.ReflectionHelper;
import com.ibm.ws.logging.internal.osgi.stackjoiner.bci.AddVersionFieldClassAdapter;
import com.ibm.ws.logging.internal.osgi.stackjoiner.bci.ThrowableClassFileTransformer;
import com.ibm.ws.logging.internal.osgi.stackjoiner.boot.templates.ThrowableProxy;
import com.ibm.ws.logging.utils.StackJoinerConfigurations;
import io.openliberty.asm.ASMHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SimpleRemapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class StackJoinerManager {
    private static final TraceComponent tc = Tr.register(StackJoinerManager.class);
    private MethodProxy methodProxy;
    private static volatile boolean isThrowableClassTransformed = false;
    public final String BOOT_DELEGATED_PACKAGE = "com.ibm.ws.boot.delegated.logging";
    final String TEMPLATE_CLASSES_PATH = ThrowableProxy.class.getPackage().getName().replaceAll("\\.", "/");
    public final String THROWABLE_PROXY_CLASS_NAME = "com.ibm.ws.boot.delegated.logging." + ThrowableProxy.class.getSimpleName();
    public final String THROWABLE_PROXY_CLASS_INTERNAL_NAME = this.THROWABLE_PROXY_CLASS_NAME.replaceAll("\\.", "/");
    final String VERSION_FIELD_NAME = "BUNDLE_VERSION";
    final String LOGGING_VERSION_MANIFEST_HEADER = "Liberty-Logging-Osgi-Bundle-Version";
    final String BASE_TRACE_SERVICE_CLASS_NAME = "com.ibm.ws.logging.internal.impl.BaseTraceService";
    final String BASE_TRACE_SERVICE_METHOD_NAME = "prePrintStackTrace";
    private final String STACK_JOIN_SERVER_XML_CONFIG_NAME = "stackTraceSingleEntry";
    private static Instrumentation instrumentation = null;
    private static BundleContext bundleContext = null;
    private static volatile StackJoinerManager instance = null;

    private StackJoinerManager() {
    }

    public static synchronized StackJoinerManager getInstance() {
        if (instance == null) {
            instance = new StackJoinerManager();
            instance.init();
        }
        return instance;
    }

    public void init() {
        instrumentation = Activator.getInstrumentation();
        bundleContext = Activator.getBundleContex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        block12: {
            if (isThrowableClassTransformed) {
                return;
            }
            if (instrumentation == null || bundleContext == null) {
                this.init();
                if (instrumentation == null || bundleContext == null) {
                    Tr.debug((TraceComponent)tc, (String)"Can not activate Stack Joiner functionality. Unable to resolve Instrumentation and Bundle Context references.", (Object[])new Object[0]);
                    return;
                }
            }
            if (this.methodProxy == null) {
                this.methodProxy = new MethodProxy(instrumentation, "com.ibm.ws.logging.internal.impl.BaseTraceService", "prePrintStackTrace", Throwable.class, PrintStream.class);
                if (!this.methodProxy.isInitialized()) {
                    this.methodProxy = null;
                    return;
                }
            }
            String runtimeVersion = this.getRuntimeClassVersion();
            ThrowableClassFileTransformer tcfTransformer = null;
            try {
                if (runtimeVersion == null || runtimeVersion != null && !runtimeVersion.equals(this.getCurrentVersion())) {
                    JarFile proxyJar = this.getBootProxyJarIfCurrent();
                    if (proxyJar == null) {
                        proxyJar = this.createBootProxyJar();
                    }
                    instrumentation.appendToBootstrapClassLoaderSearch(proxyJar);
                }
                this.bindThrowableProxyMethodTarget();
                tcfTransformer = new ThrowableClassFileTransformer();
                instrumentation.addTransformer(tcfTransformer, true);
                instrumentation.retransformClasses(Throwable.class);
                isThrowableClassTransformed = true;
                if (tcfTransformer == null) break block12;
                instrumentation.removeTransformer(tcfTransformer);
            }
            catch (Exception e) {
                try {
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getCanonicalName() + ".activate"), (String)"1");
                    e.printStackTrace();
                    if (tcfTransformer == null) break block12;
                    instrumentation.removeTransformer(tcfTransformer);
                }
                catch (Throwable throwable) {
                    if (tcfTransformer != null) {
                        instrumentation.removeTransformer(tcfTransformer);
                    }
                    throw throwable;
                }
            }
        }
    }

    public void deactivate() {
        try {
            if (isThrowableClassTransformed) {
                instrumentation.retransformClasses(Throwable.class);
                isThrowableClassTransformed = false;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getCanonicalName() + ".deactivate"), (String)"2");
            e.printStackTrace();
        }
    }

    public synchronized void resolveStackJoinFeature(Map<String, Object> serverConfigMap) {
        Object o;
        boolean isStackJoinerEnabled = false;
        isStackJoinerEnabled = StackJoinerConfigurations.stackJoinerEnabled();
        if (serverConfigMap != null && (o = serverConfigMap.get("stackTraceSingleEntry")) != null) {
            isStackJoinerEnabled = (Boolean)o;
        }
        if (isStackJoinerEnabled) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    @FFDCIgnore(value={Exception.class})
    String getRuntimeClassVersion() {
        String runtimeVersion = null;
        try {
            Class<?> clazz = Class.forName(this.THROWABLE_PROXY_CLASS_NAME);
            Field version = ReflectionHelper.getDeclaredField(clazz, "BUNDLE_VERSION");
            runtimeVersion = (String)version.get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return runtimeVersion;
    }

    JarFile createBootProxyJar() throws IOException {
        File dataFile = bundleContext.getDataFile("boot-proxy-throwable.jar");
        if (!dataFile.exists()) {
            dataFile.createNewFile();
        }
        Manifest manifest = this.createBootJarManifest();
        FileOutputStream fileOutputStream = new FileOutputStream(dataFile, false);
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)fileOutputStream, manifest);
        this.createDirectoryEntries(jarOutputStream, "com.ibm.ws.boot.delegated.logging");
        Bundle bundle = bundleContext.getBundle();
        Enumeration entryPaths = bundle.getEntryPaths(this.TEMPLATE_CLASSES_PATH);
        if (entryPaths != null) {
            while (entryPaths.hasMoreElements()) {
                URL sourceClassResource = bundle.getEntry((String)entryPaths.nextElement());
                if (sourceClassResource == null) continue;
                this.writeRemappedClass(sourceClassResource, jarOutputStream, "com.ibm.ws.boot.delegated.logging");
            }
        }
        jarOutputStream.close();
        fileOutputStream.close();
        return new JarFile(dataFile);
    }

    private void writeRemappedClass(URL classUrl, JarOutputStream jarStream, String targetPackage) throws IOException {
        InputStream inputStream = classUrl.openStream();
        String sourceInternalName = this.getClassInternalName(classUrl);
        String targetInternalName = this.getTargetInternalName(sourceInternalName, targetPackage);
        SimpleRemapper remapper = new SimpleRemapper(sourceInternalName, targetInternalName);
        ClassReader reader = new ClassReader(inputStream);
        ClassWriter writer = new ClassWriter(reader, 2);
        ClassRemapper remappingVisitor = new ClassRemapper((ClassVisitor)writer, (Remapper)remapper);
        AddVersionFieldClassAdapter versionVisitor = new AddVersionFieldClassAdapter((ClassVisitor)remappingVisitor, "BUNDLE_VERSION", this.getCurrentVersion());
        reader.accept((ClassVisitor)versionVisitor, 8);
        JarEntry jarEntry = new JarEntry(targetInternalName + ".class");
        jarStream.putNextEntry(jarEntry);
        jarStream.write(writer.toByteArray());
    }

    public void createDirectoryEntries(JarOutputStream jarStream, String packageName) throws IOException {
        StringBuilder entryName = new StringBuilder(packageName.length());
        for (String str : packageName.split("\\.")) {
            entryName.append(str).append("/");
            JarEntry jarEntry = new JarEntry(entryName.toString());
            jarStream.putNextEntry(jarEntry);
        }
    }

    String getClassInternalName(URL classUrl) throws IOException {
        InputStream inputStream = classUrl.openStream();
        ClassReader reader = new ClassReader(inputStream);
        reader.accept(new ClassVisitor(ASMHelper.getCurrentASM()){}, 7);
        inputStream.close();
        return reader.getClassName();
    }

    String getTargetInternalName(String sourceInternalName, String targetPackage) {
        StringBuilder targetInternalName = new StringBuilder();
        targetInternalName.append(targetPackage.replaceAll("\\.", "/"));
        int lastSlashIndex = sourceInternalName.lastIndexOf(47);
        targetInternalName.append(sourceInternalName.substring(lastSlashIndex));
        return targetInternalName.toString();
    }

    JarFile getBootProxyJarIfCurrent() {
        File dataFile = bundleContext.getDataFile("boot-proxy-throwable.jar");
        if (!dataFile.exists()) {
            return null;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(dataFile);
            Manifest manifest = jarFile.getManifest();
            Attributes attrs = manifest.getMainAttributes();
            String jarVersion = attrs.getValue("Liberty-Logging-Osgi-Bundle-Version");
            if (!this.getCurrentVersion().equals(jarVersion)) {
                jarFile.close();
                jarFile = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jarFile;
    }

    Manifest createBootJarManifest() {
        Manifest manifest = new Manifest();
        Attributes manifestAttributes = manifest.getMainAttributes();
        manifestAttributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        manifestAttributes.putValue("Created-By", "Liberty Logging Osgi Extender");
        manifestAttributes.putValue("Created-Time", DateFormat.getInstance().format(new Date()));
        manifestAttributes.putValue("Liberty-Logging-Osgi-Bundle-Version", this.getCurrentVersion());
        return manifest;
    }

    String getCurrentVersion() {
        return bundleContext.getBundle().getVersion().toString();
    }

    void bindThrowableProxyMethodTarget() throws Exception {
        Method method = ReflectionHelper.getDeclaredMethod(this.getClass(), "printStackTraceOverride", Throwable.class, PrintStream.class);
        ReflectionHelper.setAccessible(method, true);
        this.findThrowableProxySetFireTargetMethod().invoke(null, this, method);
    }

    Method findThrowableProxySetFireTargetMethod() throws Exception {
        Class<?> proxyClass = Class.forName(this.THROWABLE_PROXY_CLASS_NAME);
        Method method = ReflectionHelper.getDeclaredMethod(proxyClass, "setFireTarget", Object.class, Method.class);
        ReflectionHelper.setAccessible(method, true);
        return method;
    }

    public boolean printStackTraceOverride(Throwable t, PrintStream originalStream) {
        Method method = this.methodProxy.getMethodProxy();
        Boolean b = false;
        try {
            b = (Boolean)method.invoke(null, t, originalStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return b;
    }
}

