/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.cmdline;

import com.ibm.ws.kernel.feature.provisioning.FeatureResource;

public enum APIType {
    API("dev/api", "apiJar"),
    SPI("dev/spi", "spiJar");

    public final String prefix;
    public final String attribute;

    private APIType(String prefix, String attribute) {
        this.prefix = prefix;
        this.attribute = attribute;
    }

    public boolean matches(FeatureResource resource) {
        String attrValue = resource.getAttributes().get(this.attribute);
        return attrValue == null || Boolean.parseBoolean(attrValue);
    }

    public String getElementName() {
        return this.attribute;
    }

    public static APIType getAPIType(FeatureResource resource) {
        String location = resource.getLocation();
        if (location != null) {
            location = location.trim();
            for (APIType apiType : APIType.values()) {
                if (!location.startsWith(apiType.prefix)) continue;
                return apiType.matches(resource) ? apiType : null;
            }
        }
        return null;
    }
}

