/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.diagnostics.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.Introspector;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BundleWiringIntrospection
implements Introspector {
    BundleContext context;
    static final long serialVersionUID = -8577266277589731346L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void activate(BundleContext context) {
        this.context = context.getBundle("System Bundle").getBundleContext();
    }

    public String getIntrospectorName() {
        return "BundleWiringIntrospection";
    }

    public String getIntrospectorDescription() {
        return "Introspect all bundles' wiring.";
    }

    public void introspect(PrintWriter out) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = this.context.getBundles()) {
            out.println(BundleWiringIntrospection.getBundleInfo(bundle));
            BundleWiringIntrospection.introspectBundleWiringInfo(bundle, out);
            out.println();
        }
    }

    private static void introspectBundleWiringInfo(Bundle bundle, PrintWriter result) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring != null) {
            result.println("Required Wires:");
            ArrayList reqs = wiring.getRequirements(null);
            Collections.sort(reqs, new Comparator<BundleRequirement>(){
                static final long serialVersionUID = -3406846800963110288L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public int compare(BundleRequirement arg0, BundleRequirement arg1) {
                    String attrs0 = new TreeMap(arg0.getAttributes()).toString();
                    String attrs1 = new TreeMap(arg1.getAttributes()).toString();
                    int siga = attrs0.toString().compareTo(attrs1.toString());
                    if (siga != 0) {
                        return siga;
                    }
                    String drs0 = new TreeMap(arg0.getDirectives()).toString();
                    String drs1 = new TreeMap(arg1.getDirectives()).toString();
                    int sigd = drs0.compareTo(drs1);
                    return sigd;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.diagnostics.osgi.BundleWiringIntrospection$1", 1.class, null, null);
                }
            });
            if (reqs != null && !reqs.isEmpty()) {
                reqs = new ArrayList(reqs);
                List reqWires = wiring.getRequiredWires(null);
                if (reqWires != null && !reqWires.isEmpty()) {
                    Iterator reqsItr = reqs.iterator();
                    while (reqsItr.hasNext()) {
                        BundleRequirement req = (BundleRequirement)reqsItr.next();
                        boolean removed = false;
                        Iterator iterator = reqWires.iterator();
                        while (iterator.hasNext()) {
                            BundleWire reqWire = (BundleWire)iterator.next();
                            if (!reqWire.getRequirement().equals(req)) continue;
                            if (!removed) {
                                result.println("  Requirement:");
                                BundleWiringIntrospection.introspectBundleRequirementInfo(req, result);
                                reqsItr.remove();
                                removed = true;
                            }
                            BundleWiring provWiring = reqWire.getProviderWiring();
                            Bundle provBundle = provWiring.getBundle();
                            result.println("    Provided by: " + BundleWiringIntrospection.getBundleInfo(provBundle));
                        }
                    }
                } else {
                    result.println("  No required wires");
                }
            }
            if (reqs != null && !reqs.isEmpty()) {
                result.println("Not Satisfied Requirements:");
                for (BundleRequirement req : reqs) {
                    result.println("  Requirement:");
                    BundleWiringIntrospection.introspectBundleRequirementInfo(req, result);
                }
            }
            result.println("Provided Wires:");
            List caps = wiring.getCapabilities(null);
            if (caps != null && !caps.isEmpty()) {
                ArrayList provWires = wiring.getProvidedWires(null);
                if (provWires != null && !provWires.isEmpty()) {
                    provWires = new ArrayList(provWires);
                    Collections.sort(provWires, new Comparator<BundleWire>(){
                        static final long serialVersionUID = -7111942252384974178L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public int compare(BundleWire arg0, BundleWire arg1) {
                            return Long.signum(arg0.getRequirerWiring().getBundle().getBundleId() - arg1.getRequirerWiring().getBundle().getBundleId());
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.diagnostics.osgi.BundleWiringIntrospection$2", 2.class, null, null);
                        }
                    });
                    Iterator capsItr = caps.iterator();
                    while (capsItr.hasNext()) {
                        BundleCapability cap = (BundleCapability)capsItr.next();
                        boolean removed = false;
                        for (BundleWire provWire : provWires) {
                            if (!provWire.getCapability().equals(cap)) continue;
                            if (!removed) {
                                result.println("  Capability:");
                                BundleWiringIntrospection.introspectBundleCapabilityInfo(cap, result);
                                capsItr.remove();
                                removed = true;
                            }
                            BundleWiring reqrWiring = provWire.getRequirerWiring();
                            Bundle reqrBundle = reqrWiring.getBundle();
                            result.println("    Used by: " + BundleWiringIntrospection.getBundleInfo(reqrBundle));
                        }
                    }
                } else {
                    result.println("  No provided wires");
                }
            }
            if (caps != null && !caps.isEmpty()) {
                result.println("Not Utilized Capabilities:");
                for (BundleCapability cap : caps) {
                    result.println("  Capability:");
                    BundleWiringIntrospection.introspectBundleCapabilityInfo(cap, result);
                }
            }
        } else {
            result.println("No wiring");
        }
    }

    private static String getBundleInfo(Bundle bundle) {
        return bundle.getBundleId() + " [" + BundleWiringIntrospection.getBundleState(bundle) + "] " + bundle.getSymbolicName() + " " + bundle.getVersion();
    }

    private static void introspectBundleCapabilityInfo(BundleCapability cap, PrintWriter result) {
        result.append("    Attributes:");
        result.println(cap.getAttributes().toString());
        result.append("    Directives:");
        result.println(cap.getDirectives().toString());
    }

    private static void introspectBundleRequirementInfo(BundleRequirement req, PrintWriter result) {
        result.append("    Attributes:");
        result.println(new TreeMap(req.getAttributes()).toString());
        result.append("    Directives:");
        result.println(new TreeMap(req.getDirectives()).toString());
    }

    private static String getBundleState(Bundle bundle) {
        int state = bundle.getState();
        switch (state) {
            case 1: {
                return "Uninstalled";
            }
            case 2: {
                return "Installed";
            }
            case 4: {
                return "Resolved";
            }
            case 16: {
                return "Stopping";
            }
            case 8: {
                return "Starting";
            }
            case 32: {
                return "Active";
            }
        }
        return "Unknown";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.diagnostics.osgi.BundleWiringIntrospection", BundleWiringIntrospection.class, null, null);
    }
}

