/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.featureUtility.props;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.MavenRepository;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class FeatureUtilityProperties {
    private static final String FILEPATH_EXT = "/etc/featureUtility.properties";
    private static final String FeatureVerifyQualifier = "feature.verify";
    private static final Set<String> DEFINED_OPTIONS = new HashSet<String>(Arrays.asList("proxyHost", "proxyPort", "proxyUser", "proxyPassword", "http.nonProxyHosts", "featureLocalRepo", "feature.verify"));
    private static Map<String, String> definedVariables = new HashMap<String, String>();
    private static List<MavenRepository> repositoryList = new ArrayList<MavenRepository>();
    private static List<String> bomIdList = new ArrayList<String>();
    private static Map<String, Map<String, String>> keyMap = new HashMap<String, Map<String, String>>();
    private static final String bomIdQualifier = ".featuresbom";
    private static boolean didFileParse;

    public static List<MavenRepository> getMirrorRepositories() {
        return repositoryList;
    }

    public static List<String> getBomIds() {
        return bomIdList;
    }

    public static Map<String, Map<String, String>> getKeyMap() {
        return keyMap;
    }

    public static boolean bomIdsRequired() {
        return !FeatureUtilityProperties.getBomIds().isEmpty();
    }

    public static boolean canConstructHttpProxy() {
        return FeatureUtilityProperties.getProxyHost() != null && FeatureUtilityProperties.getProxyPort() != null;
    }

    public static boolean canConstructHttpsProxy() {
        return FeatureUtilityProperties.getProxyHost() != null && FeatureUtilityProperties.getProxyPort() != null && FeatureUtilityProperties.getProxyUser() != null && FeatureUtilityProperties.getProxyPassword() != null;
    }

    public static String getProxyHost() {
        return definedVariables.get("proxyHost");
    }

    public static String getProxyPort() {
        return definedVariables.get("proxyPort");
    }

    public static String getProxyUser() {
        return definedVariables.get("proxyUser");
    }

    public static String getProxyPassword() {
        return definedVariables.get("proxyPassword");
    }

    public static String getNoProxySetting() {
        return definedVariables.get("http.nonProxyHosts");
    }

    public static String getFeatureLocalRepo() {
        return definedVariables.get("featureLocalRepo");
    }

    public static boolean didLoadProperties() {
        return didFileParse;
    }

    public static File getRepoPropertiesFile() {
        return new File(Utils.getInstallDir() + FILEPATH_EXT);
    }

    public static String getRepoPropertiesFileLocation() {
        return new File(Utils.getInstallDir() + FILEPATH_EXT).getPath();
    }

    public static String getFeatureVerifyOption() {
        return definedVariables.get(FeatureVerifyQualifier);
    }

    public static boolean isUsingDefaultRepo() {
        return FeatureUtilityProperties.getMirrorRepositories().size() == 0;
    }

    public static Properties loadProperties() throws InstallException {
        Properties properties;
        Properties properties2 = new Properties(){
            private final HashSet<Object> keys = new LinkedHashSet<Object>();

            @Override
            public Enumeration<Object> keys() {
                return Collections.enumeration(this.keys);
            }

            @Override
            public Object put(Object key, Object value) {
                this.keys.add(key);
                return super.put(key, value);
            }
        };
        FileInputStream fileIn = new FileInputStream(FeatureUtilityProperties.getRepoPropertiesFileLocation());
        try {
            properties2.load(fileIn);
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileIn.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_REPOSITORY_PROPS_NOT_LOADED", new Object[]{FeatureUtilityProperties.getRepoPropertiesFileLocation()}), 25);
            }
        }
        fileIn.close();
        return properties;
    }

    private static boolean parseProperties(Properties properties) {
        definedVariables = new HashMap<String, String>();
        LinkedHashMap<String, Map> repoMap = new LinkedHashMap<String, Map>();
        for (Object obj : Collections.list(properties.keys())) {
            HashMap<String, String> individualMap;
            String key2 = obj.toString();
            String value2 = properties.getProperty(key2);
            if (DEFINED_OPTIONS.contains(key2)) {
                definedVariables.putIfAbsent(key2, value2);
                continue;
            }
            if (key2.toLowerCase().contains(bomIdQualifier)) {
                bomIdList.add(value2);
                continue;
            }
            String[] split = key2.toString().split("\\.");
            if (split.length < 2) continue;
            String propName = split[0];
            String option = split[split.length - 1];
            if (option.equalsIgnoreCase("keyid") || option.equalsIgnoreCase("keyurl")) {
                if (keyMap.containsKey(propName)) {
                    keyMap.get(propName).put(option, value2);
                    continue;
                }
                individualMap = new HashMap<String, String>();
                individualMap.put(option, value2);
                keyMap.put(propName, individualMap);
                continue;
            }
            if (repoMap.containsKey(propName)) {
                ((Map)repoMap.get(propName)).put(option, value2);
                continue;
            }
            individualMap = new HashMap();
            individualMap.put(option, value2);
            repoMap.put(propName, individualMap);
        }
        repositoryList = new ArrayList<MavenRepository>();
        repoMap.forEach((key, value) -> repositoryList.add(new MavenRepository(key, (String)value.get("url"), (String)value.get("user"), (String)value.get("password"))));
        return true;
    }

    static {
        Properties properties = null;
        try {
            properties = FeatureUtilityProperties.loadProperties();
            didFileParse = FeatureUtilityProperties.parseProperties(properties);
        }
        catch (InstallException e) {
            didFileParse = false;
        }
    }
}

