/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.equinox.metatype.EquinoxAttributeDefinition;
import org.eclipse.equinox.metatype.EquinoxMetaTypeInformation;
import org.eclipse.equinox.metatype.EquinoxObjectClassDefinition;
import org.eclipse.equinox.metatype.impl.LogTracker;
import org.eclipse.equinox.metatype.impl.MetaTypeMsg;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;
import org.osgi.util.tracker.ServiceTracker;

public class MetaTypeProviderTracker
implements EquinoxMetaTypeInformation {
    private final Bundle _bundle;
    private final LogTracker log;
    private final ServiceTracker<Object, Object> _tracker;

    public MetaTypeProviderTracker(Bundle bundle, LogTracker log, ServiceTracker<Object, Object> tracker) {
        this._bundle = bundle;
        this._tracker = tracker;
        this.log = log;
    }

    private String[] getPids(boolean factory) {
        if (this._bundle.getState() != 32) {
            return new String[0];
        }
        MetaTypeProviderWrapper[] wrappers = this.getMetaTypeProviders();
        ArrayList<String> results = new ArrayList<String>();
        MetaTypeProviderWrapper[] metaTypeProviderWrapperArray = wrappers;
        int n = wrappers.length;
        int n2 = 0;
        while (n2 < n) {
            MetaTypeProviderWrapper wrapper = metaTypeProviderWrapperArray[n2];
            if (factory == wrapper.factory) {
                results.add(wrapper.pid);
            }
            ++n2;
        }
        return results.toArray(new String[results.size()]);
    }

    @Override
    public String[] getPids() {
        return this.getPids(false);
    }

    @Override
    public String[] getFactoryPids() {
        return this.getPids(true);
    }

    @Override
    public Bundle getBundle() {
        return this._bundle;
    }

    @Override
    public EquinoxObjectClassDefinition getObjectClassDefinition(String id, String locale) {
        MetaTypeProviderWrapper[] wrappers;
        if (this._bundle.getState() != 32) {
            return null;
        }
        MetaTypeProviderWrapper[] metaTypeProviderWrapperArray = wrappers = this.getMetaTypeProviders();
        int n = wrappers.length;
        int n2 = 0;
        while (n2 < n) {
            MetaTypeProviderWrapper wrapper = metaTypeProviderWrapperArray[n2];
            if (id.equals(wrapper.pid)) {
                return wrapper.getObjectClassDefinition(id, locale);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String[] getLocales() {
        if (this._bundle.getState() != 32) {
            return new String[0];
        }
        MetaTypeProviderWrapper[] wrappers = this.getMetaTypeProviders();
        ArrayList<String> locales = new ArrayList<String>();
        MetaTypeProviderWrapper[] metaTypeProviderWrapperArray = wrappers;
        int n = wrappers.length;
        int n2 = 0;
        while (n2 < n) {
            MetaTypeProviderWrapper wrapper = metaTypeProviderWrapperArray[n2];
            String[] wrappedLocales = wrapper.getLocales();
            if (wrappedLocales != null) {
                String[] stringArray = wrappedLocales;
                int n3 = wrappedLocales.length;
                int n4 = 0;
                while (n4 < n3) {
                    String wrappedLocale = stringArray[n4];
                    if (!locales.contains(wrappedLocale)) {
                        locales.add(wrappedLocale);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return locales.toArray(new String[locales.size()]);
    }

    private MetaTypeProviderWrapper[] getMetaTypeProviders() {
        SortedMap services = this._tracker.getTracked();
        if (services.isEmpty()) {
            return new MetaTypeProviderWrapper[0];
        }
        HashSet<MetaTypeProviderWrapper> result = new HashSet<MetaTypeProviderWrapper>();
        for (Map.Entry entry : services.entrySet()) {
            Object service;
            ServiceReference serviceReference = (ServiceReference)entry.getKey();
            if (serviceReference.getBundle() != this._bundle || !((service = entry.getValue()) instanceof MetaTypeProvider)) continue;
            this.addMetaTypeProviderWrappers("metatype.pid", (ServiceReference<Object>)serviceReference, (MetaTypeProvider)service, false, result);
            this.addMetaTypeProviderWrappers("metatype.factory.pid", (ServiceReference<Object>)serviceReference, (MetaTypeProvider)service, true, result);
            if (service instanceof ManagedService) {
                this.addMetaTypeProviderWrappers("service.pid", (ServiceReference<Object>)serviceReference, (MetaTypeProvider)service, false, result);
                continue;
            }
            if (!(service instanceof ManagedServiceFactory)) continue;
            this.addMetaTypeProviderWrappers("service.pid", (ServiceReference<Object>)serviceReference, (MetaTypeProvider)service, true, result);
        }
        return result.toArray(new MetaTypeProviderWrapper[result.size()]);
    }

    private void addMetaTypeProviderWrappers(String servicePropertyName, ServiceReference<Object> serviceReference, MetaTypeProvider service, boolean factory, Set<MetaTypeProviderWrapper> wrappers) {
        String[] pids;
        String[] stringArray = pids = this.getStringProperty(servicePropertyName, serviceReference.getProperty(servicePropertyName));
        int n = pids.length;
        int n2 = 0;
        while (n2 < n) {
            String pid = stringArray[n2];
            wrappers.add(new MetaTypeProviderWrapper(service, pid, factory));
            ++n2;
        }
    }

    private String[] getStringProperty(String name, Object value) {
        if (value == null) {
            return new String[0];
        }
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        ArrayStoreException e = null;
        if (value instanceof Collection) {
            Collection temp = (Collection)value;
            try {
                return temp.toArray(new String[temp.size()]);
            }
            catch (ArrayStoreException ase) {
                e = ase;
            }
        }
        this.log.log(2, NLS.bind((String)MetaTypeMsg.INVALID_PID_METATYPE_PROVIDER_IGNORED, (Object[])new Object[]{this._bundle.getSymbolicName(), this._bundle.getBundleId(), name, value}), e);
        return new String[0];
    }

    public class MetaTypeProviderWrapper
    implements MetaTypeProvider {
        private final MetaTypeProvider provider;
        final String pid;
        final boolean factory;

        MetaTypeProviderWrapper(MetaTypeProvider provider, String pid, boolean factory) {
            this.provider = provider;
            this.pid = pid;
            this.factory = factory;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof MetaTypeProviderWrapper)) {
                return false;
            }
            MetaTypeProviderWrapper that = (MetaTypeProviderWrapper)object;
            return this.provider.equals(that.provider) && this.pid.equals(that.pid) && this.factory == that.factory;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.provider.hashCode();
            result = 31 * result + this.pid.hashCode();
            result = 31 * result + (this.factory ? 1 : 0);
            return result;
        }

        @Override
        public EquinoxObjectClassDefinition getObjectClassDefinition(String id, String locale) {
            final ObjectClassDefinition ocd = this.provider.getObjectClassDefinition(id, locale);
            if (ocd == null) {
                return null;
            }
            return new EquinoxObjectClassDefinition(){

                @Override
                public String getName() {
                    return ocd.getName();
                }

                @Override
                public String getID() {
                    return ocd.getID();
                }

                @Override
                public String getDescription() {
                    return ocd.getDescription();
                }

                @Override
                public InputStream getIcon(int size) throws IOException {
                    return ocd.getIcon(size);
                }

                @Override
                public Map<String, String> getExtensionAttributes(String schema) {
                    return Collections.emptyMap();
                }

                @Override
                public Set<String> getExtensionUris() {
                    return Collections.emptySet();
                }

                @Override
                public EquinoxAttributeDefinition[] getAttributeDefinitions(int filter) {
                    AttributeDefinition[] ads = ocd.getAttributeDefinitions(filter);
                    if (ads == null || ads.length == 0) {
                        return new EquinoxAttributeDefinition[0];
                    }
                    ArrayList<1> result = new ArrayList<1>(ads.length);
                    AttributeDefinition[] attributeDefinitionArray = ads;
                    int n = ads.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final AttributeDefinition ad = attributeDefinitionArray[n2];
                        result.add(new EquinoxAttributeDefinition(){

                            @Override
                            public String getName() {
                                return ad.getName();
                            }

                            @Override
                            public String getID() {
                                return ad.getID();
                            }

                            @Override
                            public String getDescription() {
                                return ad.getDescription();
                            }

                            @Override
                            public int getCardinality() {
                                return ad.getCardinality();
                            }

                            @Override
                            public int getType() {
                                return ad.getType();
                            }

                            @Override
                            public String[] getOptionValues() {
                                return ad.getOptionValues();
                            }

                            @Override
                            public String[] getOptionLabels() {
                                return ad.getOptionLabels();
                            }

                            @Override
                            public String validate(String value) {
                                return ad.validate(value);
                            }

                            @Override
                            public String[] getDefaultValue() {
                                return ad.getDefaultValue();
                            }

                            @Override
                            public Map<String, String> getExtensionAttributes(String schema) {
                                return Collections.emptyMap();
                            }

                            @Override
                            public Set<String> getExtensionUris() {
                                return Collections.emptySet();
                            }

                            @Override
                            public String getMax() {
                                return null;
                            }

                            @Override
                            public String getMin() {
                                return null;
                            }
                        });
                        ++n2;
                    }
                    return result.toArray(new EquinoxAttributeDefinition[result.size()]);
                }
            };
        }

        @Override
        public String[] getLocales() {
            return this.provider.getLocales();
        }
    }
}

