/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.CpuInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.internal.IntervalTask;
import com.ibm.ws.threading.internal.ThroughputDistribution;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ThreadPoolExecutor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class ThreadPoolController {
    private static final TraceComponent tc = Tr.register(ThreadPoolController.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
    private static final long interval;
    private static final long hangInterval;
    private int hangResolutionCountdown = 0;
    private static final int hangResolutionCycles = 3;
    private int hangBufferPoolSize = 0;
    private int currentMinimumPoolSize = 0;
    private int controllerCyclesWithoutHang = 0;
    private static final int noHangCyclesThreshold = 8;
    private static final int compareRange;
    private final int numberCpus;
    private int controllerCycle = 0;
    private boolean distributionReset = false;
    private int poolIncrement;
    private int poolDecrement;
    private int maxThreadsPoolDecrement = this.poolDecrement = (this.poolIncrement = 1);
    private final int poolChangeBasis;
    private final int poolIncrementBoundLow;
    private final int poolIncrementBoundMedium;
    private final int poolIncrementBoundHigh;
    private final int poolIncrementBoundExtraHigh;
    private final int poolIncrementMax;
    private static final int poolIncrementMin;
    private static final int POOL_INCREMENT_MIN_DEFAULT = 1;
    private final int POOL_INCREMENT_MAX_DEFAULT;
    private static final int minimumDesiredPoolSizeAdjustments;
    private int targetPoolSize = -1;
    private int consecutiveTargetPoolSizeWrong = 0;
    private static final int MAX_CONSECUTIVE_TARGET_POOLSIZE_WRONG = 3;
    private static final int highCpu;
    private static final double lowTputThreadsRatio;
    private static final double activeThreadsGrowthRatio;
    private static final double dataAgePruneLevel;
    private static final int compareSpanPruneMultiplier;
    private static final double tputRatioPruneLevel;
    private static final double poolTputRatioHigh;
    private static final double poolTputRatioLow;
    private static final int compareSpanRatioMultiplier;
    private static final double growScoreFilterLevel;
    private static final double shrinkScoreFilterLevel;
    private static final double growShrinkDiffFilter;
    private static final double resetDistroStdDevEwmaRatio;
    private static final double resetDistroNewTputEwmaRatio;
    private static final double resetDistroConsecutiveOutliers;
    private static final int deepQueueMultiple;
    private static final int consecutiveDeepQueueThreshold;
    private static final int deepQueuePoolIncrementMultiple;
    private static final int startupPoolSize;
    private static boolean initialStartupCompleted;
    private static final int startupHangCpuUtilThreshold;
    private static final int startupHangControllerCyclesSkip;
    private double processCpuUtil = -1.0;
    private double systemCpuUtil = -1.0;
    private double cpuUtil = -1.0;
    private static DecimalFormat df;
    private int queueDepth = 0;
    private boolean deepQueue;
    private int consecutiveDeepQueueCycles = 0;
    private int activeThreads = 0;
    private static final int MAX_INTERVALS_WITHOUT_CHANGE = 5;
    static final double EMPTY_QUEUE_SHRINK_MAGIC_PER_INTERVAL = 0.04;
    private static final int IDLE_INTERVALS_BEFORE_PAUSE = 3;
    private static final int MAX_OUTLIER_AFTER_CHANGE_BEFORE_RESET;
    private final int maxThreadsToBreakHang;
    private LastAction lastAction = LastAction.NONE;
    private final Timer timer = new Timer("Executor Service Control Timer", true);
    private IntervalTask activeTask = null;
    private boolean paused = false;
    private long lastTimerPop = 0L;
    private long previousCompleted = 0L;
    private double previousThroughput = 0.0;
    private int consecutiveQueueEmptyCount = 0;
    private int consecutiveNoAdjustment = 0;
    private int consecutiveOutlierAfterAdjustment = 0;
    private int consecutiveIdleCount = 0;
    private final int maxThreads;
    private final int coreThreads;
    private final int threadRange;
    ThreadPoolExecutor threadPool;
    private TreeMap<Integer, ThroughputDistribution> threadStats = new TreeMap();
    private int poolSizeWhenHangDetected = -1;
    private int hangIntervalCounter = 0;
    private boolean hangMaxThreadsMessageEmitted = false;
    private int startupCycleSkipCount = startupHangControllerCyclesSkip;
    static final long serialVersionUID = -6489739396965965396L;

    ThreadPoolController(ThreadPoolExecutor pool) {
        this.threadPool = pool;
        this.currentMinimumPoolSize = this.coreThreads = pool.getCorePoolSize();
        this.maxThreads = pool.getMaximumPoolSize();
        this.threadRange = this.maxThreads - this.coreThreads;
        if (!initialStartupCompleted) {
            this.setPoolSize(Math.min(startupPoolSize, this.maxThreads));
            if (startupPoolSize < this.maxThreads) {
                this.activeTask = new IntervalTask(this);
                this.timer.schedule((TimerTask)this.activeTask, interval, interval);
            }
        } else {
            this.setPoolSize(this.coreThreads);
            if (this.coreThreads != this.maxThreads) {
                this.activeTask = new IntervalTask(this);
                this.timer.schedule((TimerTask)this.activeTask, interval, interval);
            }
        }
        this.targetPoolSize = this.coreThreads;
        this.resetStatistics(true);
        this.numberCpus = CpuInfo.getAvailableProcessors().get();
        this.processCpuUtil = CpuInfo.getJavaCpuUsage();
        this.systemCpuUtil = CpuInfo.getSystemCpuUsage();
        this.cpuUtil = Math.max(this.systemCpuUtil, this.processCpuUtil);
        this.poolChangeBasis = this.coreThreads < this.numberCpus * 2 ? Math.max(1, this.coreThreads / 2) : this.numberCpus;
        this.maxThreadsToBreakHang = Math.min(1000, 128 * this.numberCpus);
        String tpcPoolIncrementBoundLow = ThreadPoolController.getSystemProperty("tpcPoolIncrementBoundLow");
        this.poolIncrementBoundLow = tpcPoolIncrementBoundLow == null ? this.poolChangeBasis * 16 : Integer.parseInt(tpcPoolIncrementBoundLow);
        String tpcPoolIncrementBoundMedium = ThreadPoolController.getSystemProperty("tpcPoolIncrementBoundMedium");
        this.poolIncrementBoundMedium = tpcPoolIncrementBoundMedium == null ? this.poolChangeBasis * 64 : Integer.parseInt(tpcPoolIncrementBoundMedium);
        this.poolIncrementBoundHigh = this.poolIncrementBoundMedium * 2;
        this.poolIncrementBoundExtraHigh = this.poolIncrementBoundHigh * 2;
        this.POOL_INCREMENT_MAX_DEFAULT = this.poolChangeBasis * 4;
        String tpcPoolIncrementMax = ThreadPoolController.getSystemProperty("tpcPoolIncrementMax");
        int n = this.poolIncrementMax = tpcPoolIncrementMax == null ? this.POOL_INCREMENT_MAX_DEFAULT : Integer.parseInt(tpcPoolIncrementMax);
        if (tc.isEventEnabled()) {
            this.reportSystemProperties();
        }
    }

    synchronized void startupCompleted() {
        if (!initialStartupCompleted) {
            initialStartupCompleted = true;
            if (this.threadPool == null) {
                return;
            }
            this.setPoolSize(this.coreThreads);
            if (this.coreThreads < this.maxThreads) {
                if (this.activeTask == null && !this.paused) {
                    this.activeTask = new IntervalTask(this);
                    this.timer.schedule((TimerTask)this.activeTask, interval, interval);
                }
            } else if (this.activeTask != null) {
                this.activeTask.cancel();
                this.activeTask = null;
            }
        }
    }

    void resetStatistics(boolean clearHistory) {
        this.lastTimerPop = System.currentTimeMillis();
        this.previousCompleted = this.threadPool == null ? 0L : this.threadPool.getCompletedTaskCount();
        this.previousThroughput = 0.0;
        this.consecutiveQueueEmptyCount = 0;
        this.consecutiveNoAdjustment = 0;
        this.consecutiveOutlierAfterAdjustment = 0;
        this.consecutiveIdleCount = 0;
        if (clearHistory) {
            this.threadStats = new TreeMap();
        }
        this.lastAction = LastAction.NONE;
    }

    void resetThreadPool() {
        if (this.threadPool == null) {
            return;
        }
        int availableProcessors = this.numberCpus;
        int factor = 2500 * availableProcessors / Math.max(1, (int)this.previousThroughput);
        factor = Math.min(factor, 4);
        factor = Math.max(factor, 2);
        int newThreads = Math.min(factor * availableProcessors, this.maxThreads);
        newThreads = Math.max(newThreads, this.coreThreads);
        this.currentMinimumPoolSize = this.coreThreads;
        this.targetPoolSize = newThreads;
        this.setPoolSize(newThreads);
        this.resetStatistics(true);
    }

    synchronized void deactivate() {
        this.paused = false;
        if (this.activeTask != null) {
            this.activeTask.cancel();
            this.activeTask = null;
        }
        this.threadPool = null;
    }

    synchronized void pause() {
        this.paused = true;
        if (this.activeTask != null) {
            this.activeTask.cancel();
            this.activeTask = null;
        }
    }

    @Trivial
    void resumeIfPaused() {
        if (this.paused) {
            this.resume();
        }
    }

    synchronized void resume() {
        this.paused = false;
        if (this.activeTask == null) {
            this.activeTask = new IntervalTask(this);
            this.timer.schedule((TimerTask)this.activeTask, interval, interval);
        }
    }

    @Trivial
    ThroughputDistribution getThroughputDistribution(int numberOfThreads, boolean create) {
        Integer threads;
        ThroughputDistribution throughput;
        if (numberOfThreads < this.coreThreads) {
            numberOfThreads = this.coreThreads;
        }
        if ((throughput = this.threadStats.get(threads = Integer.valueOf(numberOfThreads))) == null && create) {
            throughput = new ThroughputDistribution();
            throughput.setLastUpdate(this.controllerCycle);
            this.threadStats.put(threads, throughput);
        }
        return throughput;
    }

    boolean manageIdlePool(ThreadPoolExecutor threadPool, long intervalCompleted) {
        this.consecutiveIdleCount = intervalCompleted == 0L && threadPool.getActiveCount() == 0 ? ++this.consecutiveIdleCount : 0;
        if (this.consecutiveIdleCount >= 3) {
            this.pause();
            this.lastAction = LastAction.PAUSE;
            return true;
        }
        return false;
    }

    boolean handleOutliers(ThroughputDistribution distribution, double throughput) {
        boolean currentIsOutlier;
        if (throughput < 0.0) {
            this.resetStatistics(false);
            return true;
        }
        if (throughput == 0.0) {
            return false;
        }
        double zScore = distribution.getZScore(throughput);
        boolean bl = currentIsOutlier = zScore <= -3.0 || zScore >= 3.0;
        if (currentIsOutlier) {
            double ewma = distribution.getMovingAverage();
            double stddev = distribution.getStddev();
            if (stddev / ewma > resetDistroStdDevEwmaRatio || Math.abs(throughput - ewma) / ewma > resetDistroNewTputEwmaRatio || (double)distribution.incrementAndGetConsecutiveOutliers() >= resetDistroConsecutiveOutliers) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"reset distribution", (Object[])new Object[]{" distribution: " + distribution + ", new throughput: " + throughput});
                }
                distribution.reset(throughput, this.controllerCycle);
                this.distributionReset = true;
            } else if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"outlier detected", (Object[])new Object[]{" distribution: " + distribution + ", new throughput: " + throughput});
            }
        } else {
            distribution.resetConsecutiveOutliers();
        }
        if (this.lastAction != LastAction.NONE) {
            this.consecutiveOutlierAfterAdjustment = this.distributionReset ? ++this.consecutiveOutlierAfterAdjustment : 0;
        }
        if (this.consecutiveOutlierAfterAdjustment >= MAX_OUTLIER_AFTER_CHANGE_BEFORE_RESET) {
            this.resetThreadPool();
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    double getShrinkScore(int poolSize, double forecast, double throughput, boolean cpuHigh, boolean lowActivity, boolean systemCpuNA) {
        double shrinkScore = 0.0;
        double shrinkMagic = 0.0;
        boolean flippedCoin = false;
        int downwardCompareSpan = 0;
        if (!cpuHigh && this.deepQueue) {
            shrinkScore = 0.0;
            return shrinkScore;
        }
        if (poolSize >= this.currentMinimumPoolSize + this.poolDecrement) {
            downwardCompareSpan = Math.min(compareRange * this.poolDecrement, poolSize - this.currentMinimumPoolSize);
            boolean smallPool = poolSize - this.currentMinimumPoolSize <= downwardCompareSpan;
            Integer shrinkKey = this.threadStats.lowerKey(poolSize);
            Integer priorKey = poolSize;
            int smallerPools = 0;
            int pruneLimit = this.currentMinimumPoolSize;
            while (shrinkKey != null) {
                priorKey = shrinkKey;
                shrinkKey = this.threadStats.lowerKey(shrinkKey);
                int distance = 0;
                boolean pruned = false;
                boolean inHangBuffer = true;
                ThroughputDistribution priorStats = this.threadStats.get(priorKey);
                distance = poolSize - priorKey;
                if (priorKey > pruneLimit) {
                    inHangBuffer = false;
                    if (this.pruneData(priorStats, forecast)) {
                        this.threadStats.remove(priorKey);
                        pruned = true;
                    }
                }
                if (pruned) continue;
                ++smallerPools;
                shrinkScore += priorStats.getProbabilityGreaterThan(forecast);
                if (!(inHangBuffer ? smallerPools >= compareRange : distance >= downwardCompareSpan)) continue;
                break;
            }
            if (smallerPools < compareRange && !smallPool) {
                shrinkScore += this.flipCoin() ? 0.7 : 0.0;
                ++smallerPools;
                flippedCoin = true;
            }
            shrinkScore /= (double)smallerPools;
            if (!(this.consecutiveQueueEmptyCount <= 0 || this.lastAction == LastAction.SHRINK && throughput < this.previousThroughput)) {
                shrinkMagic = Math.min((double)this.consecutiveQueueEmptyCount * 0.04, 0.5);
                shrinkScore += shrinkMagic;
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"shrinkMagic info", (Object[])new Object[]{" shrinkMagic added: " + shrinkMagic});
                }
            }
            if (shrinkScore < 0.5 && lowActivity) {
                double d = shrinkScore = this.flipCoin() ? 0.5 : shrinkScore;
            }
            if (shrinkScore < 0.5 && poolSize > this.currentMinimumPoolSize && !smallPool) {
                if (cpuHigh || flippedCoin && systemCpuNA) {
                    shrinkScore = this.flipCoin() ? 0.7 : shrinkScore;
                } else if (flippedCoin) {
                    try {
                        int upwardCompareSpan = Math.min(compareRange * this.poolIncrement, this.maxThreads - poolSize);
                        Integer largestPoolSize = this.getLargestValidPoolSize(poolSize, forecast);
                        if (largestPoolSize - poolSize > upwardCompareSpan * compareSpanRatioMultiplier && this.leanTowardShrinking(poolSize, largestPoolSize, forecast, this.threadStats.get(largestPoolSize).getMovingAverage())) {
                            shrinkScore = 0.7;
                        }
                    }
                    catch (Exception upwardCompareSpan) {
                        void e;
                        FFDCFilter.processException((Throwable)upwardCompareSpan, (String)"com.ibm.ws.threading.internal.ThreadPoolController", (String)"1169", (Object)this, (Object[])new Object[]{poolSize, forecast, throughput, cpuHigh, lowActivity, systemCpuNA});
                        FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getShrinkScore - largestPoolSize", (Object)this);
                    }
                } else {
                    try {
                        Integer smallestPoolSize = this.getSmallestValidPoolSize(poolSize, forecast);
                        if (poolSize - smallestPoolSize > downwardCompareSpan * compareSpanRatioMultiplier && this.leanTowardShrinking(smallestPoolSize, poolSize, this.threadStats.get(smallestPoolSize).getMovingAverage(), forecast)) {
                            shrinkScore = 0.7;
                        }
                    }
                    catch (Exception smallestPoolSize) {
                        void e;
                        FFDCFilter.processException((Throwable)smallestPoolSize, (String)"com.ibm.ws.threading.internal.ThreadPoolController", (String)"1181", (Object)this, (Object[])new Object[]{poolSize, forecast, throughput, cpuHigh, lowActivity, systemCpuNA});
                        FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getShrinkScore - smallestPoolSize", (Object)this);
                    }
                }
            } else if (flippedCoin && this.queueDepth > poolSize * 4) {
                shrinkScore = this.flipCoin() ? 0.0 : shrinkScore;
            }
        }
        return shrinkScore;
    }

    /*
     * WARNING - void declaration
     */
    double getGrowScore(int poolSize, double forecast, double throughput, boolean cpuHigh, boolean lowActivity, boolean systemCpuNA) {
        double growScore = 0.0;
        boolean flippedCoin = false;
        int upwardCompareSpan = 0;
        if (!cpuHigh && this.deepQueue) {
            growScore = 1.0;
            return growScore;
        }
        if (poolSize + this.poolIncrement <= this.maxThreads && !lowActivity) {
            upwardCompareSpan = Math.min(compareRange * this.poolIncrement, this.maxThreads - poolSize);
            Integer growKey = this.threadStats.higherKey(poolSize);
            Integer priorKey = poolSize;
            int largerPools = 0;
            while (true) {
                int distance = 0;
                if (growKey == null) break;
                priorKey = growKey;
                growKey = this.threadStats.higherKey(growKey);
                ThroughputDistribution priorStats = this.threadStats.get(priorKey);
                distance = priorKey - poolSize;
                if (this.pruneData(priorStats, forecast)) {
                    this.threadStats.remove(priorKey);
                    continue;
                }
                ++largerPools;
                growScore += priorStats.getProbabilityGreaterThan(forecast);
                if (distance >= upwardCompareSpan) break;
            }
            if (largerPools < compareRange) {
                growScore += this.flipCoin() ? 0.7 : 0.0;
                ++largerPools;
                flippedCoin = true;
            }
            growScore /= (double)largerPools;
            ThroughputDistribution currentStats = this.getThroughputDistribution(poolSize, false);
            ThroughputDistribution growStats = this.getThroughputDistribution(poolSize + this.poolIncrement, false);
            if (currentStats != null && growStats != null && growScore < 0.5 && currentStats.getProbabilityGreaterThan(growStats.getMovingAverage()) >= 0.5) {
                growScore = 0.0;
            }
            if ((cpuHigh || systemCpuNA) && growScore > 0.0 && flippedCoin) {
                if (poolSize > this.currentMinimumPoolSize) {
                    growScore = this.flipCoin() ? growScore : 0.0;
                }
            } else if (growScore == 0.0 && flippedCoin && this.queueDepth > poolSize * 4) {
                growScore = this.flipCoin() ? 0.5 : 0.0;
            } else if (growScore > 0.0) {
                if (flippedCoin) {
                    try {
                        int downwardCompareSpan = Math.min(compareRange * this.poolDecrement, poolSize - this.currentMinimumPoolSize);
                        Integer smallestPoolSize = this.getSmallestValidPoolSize(poolSize, forecast);
                        if (poolSize - smallestPoolSize > downwardCompareSpan * compareSpanRatioMultiplier && this.leanTowardShrinking(smallestPoolSize, poolSize, this.threadStats.get(smallestPoolSize).getMovingAverage(), forecast)) {
                            growScore = 0.0;
                        }
                    }
                    catch (Exception downwardCompareSpan) {
                        void e;
                        FFDCFilter.processException((Throwable)downwardCompareSpan, (String)"com.ibm.ws.threading.internal.ThreadPoolController", (String)"1308", (Object)this, (Object[])new Object[]{poolSize, forecast, throughput, cpuHigh, lowActivity, systemCpuNA});
                        FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getGrowScore - smallestPoolSize", (Object)this);
                    }
                } else if (growScore < 0.5) {
                    try {
                        Integer largestPoolSize = this.getLargestValidPoolSize(poolSize, forecast);
                        if (largestPoolSize - poolSize > upwardCompareSpan * compareSpanRatioMultiplier && this.leanTowardShrinking(poolSize, largestPoolSize, forecast, this.threadStats.get(largestPoolSize).getMovingAverage())) {
                            growScore = 0.0;
                        }
                    }
                    catch (Exception largestPoolSize) {
                        void e;
                        FFDCFilter.processException((Throwable)largestPoolSize, (String)"com.ibm.ws.threading.internal.ThreadPoolController", (String)"1323", (Object)this, (Object[])new Object[]{poolSize, forecast, throughput, cpuHigh, lowActivity, systemCpuNA});
                        FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getGrowScore - largestPoolSize", (Object)this);
                    }
                }
            }
        }
        return growScore;
    }

    @Trivial
    int forceVariation(int poolSize, int calculatedAdjustment, long intervalCompleted, boolean lowActivity) {
        this.consecutiveNoAdjustment = calculatedAdjustment == 0 && intervalCompleted != 0L ? ++this.consecutiveNoAdjustment : 0;
        int forcedAdjustment = calculatedAdjustment;
        if (this.consecutiveNoAdjustment >= 5) {
            this.consecutiveNoAdjustment = 0;
            if (this.flipCoin() && poolSize + this.poolIncrement <= this.maxThreads) {
                if (!lowActivity) {
                    forcedAdjustment = this.poolIncrement;
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"force variation", (Object[])new Object[]{" forced increase: " + forcedAdjustment});
                    }
                }
            } else if (poolSize - this.poolDecrement >= this.currentMinimumPoolSize) {
                forcedAdjustment = -this.poolDecrement;
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"force variation", (Object[])new Object[]{" forced decrease: " + forcedAdjustment});
                }
            }
        }
        return forcedAdjustment;
    }

    boolean flipCoin() {
        return Math.random() >= 0.5;
    }

    int adjustPoolSize(int poolSize, int poolAdjustment) {
        if (this.threadPool == null) {
            return poolSize;
        }
        int newPoolSize = poolSize + poolAdjustment;
        this.lastAction = LastAction.NONE;
        if (poolAdjustment != 0) {
            if (poolAdjustment < 0 && newPoolSize >= this.currentMinimumPoolSize) {
                this.lastAction = LastAction.SHRINK;
                this.setPoolSize(newPoolSize);
            } else if (poolAdjustment > 0 && newPoolSize <= this.maxThreads) {
                this.lastAction = LastAction.GROW;
                this.setPoolSize(newPoolSize);
            } else {
                newPoolSize = poolSize;
            }
        }
        return newPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized String evaluateInterval() {
        if (this.threadPool == null) {
            return "threadPool == null";
        }
        int poolSize = this.threadPool.getPoolSize();
        if (poolSize <= 0) {
            return "poolSize <= 0";
        }
        if (poolSize < this.coreThreads && initialStartupCompleted) {
            this.setPoolSize(this.coreThreads);
            return "poolSize " + poolSize + " < coreThreads " + this.coreThreads;
        }
        this.processCpuUtil = CpuInfo.getJavaCpuUsage();
        this.systemCpuUtil = CpuInfo.getSystemCpuUsage();
        this.cpuUtil = Math.max(this.systemCpuUtil, this.processCpuUtil);
        boolean cpuHigh = this.cpuUtil > (double)highCpu;
        boolean systemCpuNA = this.systemCpuUtil < 0.0;
        long currentTime = System.currentTimeMillis();
        long completedWork = this.threadPool.getCompletedTaskCount();
        long deltaTime = Math.max(currentTime - this.lastTimerPop, interval);
        long deltaCompleted = completedWork - this.previousCompleted;
        double throughput = 1000.0 * (double)deltaCompleted / (double)deltaTime;
        try {
            boolean queueEmpty;
            block44: {
                if (!initialStartupCompleted) {
                    if (poolSize < startupPoolSize) {
                        this.setPoolSize(startupPoolSize);
                        String string = "poolSize " + poolSize + " < startupPoolSize " + startupPoolSize;
                        return string;
                    }
                    if (this.startupCycleSkipCount > 0) {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)("     skipping startup hang check - cycles remaining to skip: " + this.startupCycleSkipCount), (Object[])new Object[]{"       " + this.threadPool});
                        }
                        --this.startupCycleSkipCount;
                        String string = "server startup in progress";
                        return string;
                    }
                    String cpuUtilString = "";
                    if (tc.isEventEnabled()) {
                        cpuUtilString = String.format(" cpuUtil = %.2f", this.processCpuUtil);
                    }
                    if (deltaCompleted <= 0L) {
                        if (this.processCpuUtil < (double)startupHangCpuUtilThreshold) {
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)("     hang detected during startup, process " + cpuUtilString + "%  - switching to normal controller operation"), (Object[])new Object[0]);
                            }
                            initialStartupCompleted = true;
                            this.setPoolSize(this.coreThreads);
                            poolSize = this.threadPool.getPoolSize();
                            break block44;
                        } else {
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)("     no tasks completed this interval, process " + cpuUtilString + "%"), (Object[])new Object[]{"       " + this.threadPool});
                            }
                            String string = "server startup in progress";
                            return string;
                        }
                    }
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("     tasks completed: " + deltaCompleted + ", process " + cpuUtilString + "%"), (Object[])new Object[]{"       " + this.threadPool});
                    }
                    String string = "server startup in progress";
                    return string;
                }
            }
            this.queueDepth = this.threadPool.getQueue().size();
            boolean bl = queueEmpty = this.queueDepth <= 0;
            if (!queueEmpty) {
                this.consecutiveQueueEmptyCount = 0;
            } else if (this.lastAction != LastAction.SHRINK) {
                ++this.consecutiveQueueEmptyCount;
            }
            boolean bl2 = this.deepQueue = this.queueDepth > deepQueueMultiple * this.poolIncrement;
            this.consecutiveDeepQueueCycles = this.deepQueue ? ++this.consecutiveDeepQueueCycles : 0;
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("deepQueue: " + this.deepQueue + ", queueDepth: " + this.queueDepth + ", deepQueueMultiple: " + deepQueueMultiple + ", poolIncrement: " + this.poolIncrement), (Object[])new Object[0]);
            }
            this.activeThreads = this.threadPool.getActiveCount();
            if (this.manageIdlePool(this.threadPool, deltaCompleted)) {
                String string = "monitoring paused";
                return string;
            }
            if (this.resolveHang(deltaCompleted, queueEmpty, poolSize, cpuHigh)) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Executor hang detected - poolSize: " + poolSize + ", activeThreads: " + this.activeThreads + ", queueDepth: " + this.queueDepth + ", cpuUtil: " + df.format(this.cpuUtil) + ", processCpuUtil: " + df.format(this.processCpuUtil) + ", systemCpuUtil: " + df.format(this.systemCpuUtil)), (Object[])new Object[0]);
                }
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.threading.internal.ThreadPoolController", (String)"1560", (Object)this, (Object[])new Object[0]);
                }
                completedWork = this.threadPool.getCompletedTaskCount();
                String string = "action taken to resolve hang";
                return string;
            }
            if (this.checkTargetPoolSize(poolSize)) {
                String string = "poolSize != targetPoolSize";
                return string;
            }
            ++this.controllerCycle;
            ThroughputDistribution currentStats = this.getThroughputDistribution(poolSize, true);
            this.distributionReset = false;
            if (this.handleOutliers(currentStats, throughput)) {
                String string = "aberrant workload";
                return string;
            }
            if (!this.distributionReset && throughput > 0.0) {
                currentStats.addDataPoint(throughput, this.controllerCycle);
            }
            boolean lowActivity = false;
            if (queueEmpty && (throughput < (double)poolSize * lowTputThreadsRatio || (double)this.activeThreads < (double)poolSize * activeThreadsGrowthRatio)) {
                lowActivity = true;
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("low activity flag set: throughput: " + df.format(throughput) + ", poolSize: " + poolSize + ", activeThreads: " + this.activeThreads + ", queueDepth: " + this.queueDepth + ", tasks completed: " + deltaCompleted), (Object[])new Object[0]);
                }
            }
            this.setPoolIncrementDecrement(poolSize);
            double forecast = currentStats.getMovingAverage();
            double shrinkScore = this.getShrinkScore(poolSize, forecast, throughput, cpuHigh, lowActivity, systemCpuNA);
            double growScore = this.getGrowScore(poolSize, forecast, throughput, cpuHigh, lowActivity, systemCpuNA);
            int poolAdjustment = 0;
            if (growScore >= growScoreFilterLevel && growScore - growShrinkDiffFilter > shrinkScore) {
                poolAdjustment = this.poolIncrement;
                if (!cpuHigh && !systemCpuNA && this.deepQueue && this.consecutiveDeepQueueCycles > consecutiveDeepQueueThreshold) {
                    poolAdjustment = Math.min(poolAdjustment * deepQueuePoolIncrementMultiple, this.maxThreads - poolSize);
                }
            } else if (shrinkScore >= shrinkScoreFilterLevel && shrinkScore - growShrinkDiffFilter > growScore) {
                poolAdjustment = -this.poolDecrement;
            }
            poolAdjustment = this.forceVariation(poolSize, poolAdjustment, deltaCompleted, lowActivity);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Interval data", (Object[])new Object[]{this.toIntervalData(throughput, forecast, deltaCompleted, shrinkScore, growScore, poolSize, poolAdjustment)});
            }
            this.targetPoolSize = this.adjustPoolSize(poolSize, poolAdjustment);
            return "";
        }
        finally {
            this.lastTimerPop = currentTime;
            this.previousCompleted = completedWork;
            this.previousThroughput = throughput;
        }
    }

    @Trivial
    private String toIntervalData(double throughput, double forecast, long deltaCompleted, double shrinkScore, double growScore, int poolSize, int poolAdjustment) {
        int i;
        int RANGE = 25;
        StringBuilder sb = new StringBuilder();
        sb.append("\nThroughput:");
        sb.append(String.format(" previous = %.6f", this.previousThroughput));
        sb.append(String.format(" current = %.6f", throughput));
        sb.append(String.format(" forecast = %.6f", forecast));
        sb.append(String.format(" tasks this interval = %6d", deltaCompleted));
        sb.append("\nHeuristics:");
        sb.append(String.format(" queueDepth = %8d", this.queueDepth));
        sb.append(String.format(" consecutiveQueueEmptyCount = %2d", this.consecutiveQueueEmptyCount));
        sb.append(String.format(" consecutiveDeepQueueCycles = %2d", this.consecutiveDeepQueueCycles));
        sb.append(String.format(" consecutiveNoAdjustment = %2d", this.consecutiveNoAdjustment));
        sb.append("\nOutliers:  ");
        sb.append(String.format(" consecutiveOutlierAfterAdjustment = %2d", this.consecutiveOutlierAfterAdjustment));
        sb.append(String.format(" hangBufferPoolSize = %2d", this.hangBufferPoolSize));
        sb.append("\nAttraction:");
        sb.append(String.format(" shrinkScore = %.6f", shrinkScore));
        sb.append(String.format(" growScore = %.6f", growScore));
        sb.append(String.format(" lastAction = %s", new Object[]{this.lastAction}));
        sb.append("\nCPU:");
        sb.append(String.format(" cpuUtil = %.2f", this.cpuUtil));
        sb.append(String.format(" processCpuUtil = %.2f", this.processCpuUtil));
        sb.append(String.format(" systemCpuUtil = %.2f", this.systemCpuUtil));
        sb.append("\nIncrement:");
        sb.append(String.format(" poolSize = %2d", poolSize));
        sb.append(String.format(" activeThreads = %2d", this.activeThreads));
        sb.append(String.format(" poolIncrement = %2d", this.poolIncrement));
        sb.append(String.format(" poolDecrement = %2d", this.poolDecrement));
        sb.append(String.format(" poolAdjustment = %2d", poolAdjustment));
        sb.append(String.format(" compareRange = %2d", compareRange));
        sb.append("\nConfig:");
        sb.append(String.format(" coreThreads = %2d", this.coreThreads));
        sb.append(String.format(" maxThreads = %2d", this.maxThreads));
        sb.append(String.format(" currentMinimumPoolSize = %2d", this.currentMinimumPoolSize));
        sb.append("\nStatistics:\n");
        Integer[] poolSizes = new Integer[51];
        ThroughputDistribution[] tputDistros = new ThroughputDistribution[51];
        Integer poolSizeInteger = poolSize;
        int start = 25;
        int end = 25;
        poolSizes[25] = poolSizeInteger;
        tputDistros[25] = this.getThroughputDistribution(poolSize, false);
        Integer prior = this.threadStats.lowerKey(poolSizeInteger);
        Integer next = this.threadStats.higherKey(poolSizeInteger);
        for (i = 1; i <= 25; ++i) {
            if (prior != null) {
                poolSizes[--start] = prior;
                tputDistros[start] = this.getThroughputDistribution(prior, false);
                prior = this.threadStats.lowerKey(prior);
            }
            if (next == null) continue;
            poolSizes[++end] = next;
            tputDistros[end] = this.getThroughputDistribution(next, false);
            next = this.threadStats.higherKey(next);
        }
        for (i = start; i <= end; ++i) {
            sb.append(String.format("%s%3d threads: %s%n", poolSizes[i] == poolSizeInteger ? "-->" : "   ", poolSizes[i], String.valueOf(tputDistros[i])));
        }
        if (poolAdjustment == 0) {
            sb.append("### No pool adjustment ###");
        } else if (poolAdjustment < 0) {
            sb.append("--- Shrinking to " + (poolSize + poolAdjustment) + " ---");
        } else {
            sb.append("+++ Growing to " + (poolSize + poolAdjustment) + " +++");
        }
        return sb.toString();
    }

    private String poolTputRatioData(double poolTputRatio, double poolRatio, double tputRatio, double smallerPoolTput, double largerPoolTput, int smallerPoolSize, int largerPoolSize) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n ");
        sb.append(String.format(" poolTputRatio: %.3f", poolTputRatio));
        sb.append(String.format(" poolRatio: %.3f", poolRatio));
        sb.append(String.format(" tputRatio: %.3f", tputRatio));
        sb.append("\n ");
        sb.append(String.format(" smallerPoolSize: %d", smallerPoolSize));
        sb.append(String.format(" largerPoolSize: %d", largerPoolSize));
        sb.append(String.format(" smallerPoolTput: %.3f", smallerPoolTput));
        sb.append(String.format(" largerPoolTput: %.3f", largerPoolTput));
        return sb.toString();
    }

    private boolean resolveHang(long tasksCompleted, boolean queueEmpty, int poolSize, boolean highCpu) {
        boolean poolHung;
        boolean bl = poolHung = tasksCompleted == 0L && !queueEmpty;
        if (poolHung) {
            if (this.hangResolutionCountdown == 0) {
                this.activeTask.cancel();
                this.activeTask = new IntervalTask(this);
                this.timer.schedule((TimerTask)this.activeTask, hangInterval, hangInterval);
            }
            this.hangResolutionCountdown = 3;
            this.controllerCyclesWithoutHang = 0;
            if (this.poolSizeWhenHangDetected < 0) {
                this.poolSizeWhenHangDetected = poolSize;
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Executor hang detected at poolSize=" + this.poolSizeWhenHangDetected), (Object[])new Object[0]);
                }
            } else if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Executor hang continued at poolSize=" + poolSize), (Object[])new Object[0]);
            }
            if (!this.checkTargetPoolSize(poolSize)) {
                if (!highCpu) {
                    this.setPoolIncrementDecrement(poolSize);
                    if (poolSize + this.poolIncrement <= this.maxThreads && poolSize < this.maxThreadsToBreakHang) {
                        int targetSize;
                        this.targetPoolSize = this.adjustPoolSize(poolSize, this.poolIncrement);
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)("Increasing pool size to resolve hang, from " + poolSize + " to " + this.targetPoolSize), (Object[])new Object[0]);
                        }
                        if (this.hangBufferPoolSize < (targetSize = poolSize + this.poolIncrement)) {
                            this.currentMinimumPoolSize = this.hangBufferPoolSize = targetSize;
                        }
                    } else if (!this.hangMaxThreadsMessageEmitted && this.hangIntervalCounter > 0) {
                        if (tc.isWarningEnabled()) {
                            Tr.warning((TraceComponent)tc, (String)"unbreakableExecutorHang", (Object[])new Object[]{this.poolSizeWhenHangDetected, poolSize});
                        }
                        this.hangMaxThreadsMessageEmitted = true;
                    }
                } else if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Executor hung but no action taken because highCpu: " + highCpu), (Object[])new Object[0]);
                }
                ++this.hangIntervalCounter;
            }
        } else {
            this.poolSizeWhenHangDetected = -1;
            this.hangIntervalCounter = 0;
            this.hangMaxThreadsMessageEmitted = false;
            if (this.hangResolutionCountdown > 0) {
                --this.hangResolutionCountdown;
                if (this.hangResolutionCountdown <= 0) {
                    this.activeTask.cancel();
                    this.activeTask = new IntervalTask(this);
                    this.timer.schedule((TimerTask)this.activeTask, interval, interval);
                }
            }
            if (this.hangBufferPoolSize > this.coreThreads && this.hangBufferPoolSize >= poolSize) {
                ++this.controllerCyclesWithoutHang;
                if (this.controllerCyclesWithoutHang > 8) {
                    this.setPoolIncrementDecrement(poolSize);
                    this.hangBufferPoolSize -= this.poolDecrement;
                    this.currentMinimumPoolSize = this.hangBufferPoolSize;
                    this.controllerCyclesWithoutHang = 0;
                }
            }
        }
        return poolHung;
    }

    private void setPoolSize(int newPoolSize) {
        if (newPoolSize < this.threadPool.getCorePoolSize()) {
            this.threadPool.setCorePoolSize(newPoolSize);
            this.threadPool.setMaximumPoolSize(newPoolSize);
        } else {
            this.threadPool.setMaximumPoolSize(newPoolSize);
            this.threadPool.setCorePoolSize(newPoolSize);
        }
    }

    private boolean pruneData(ThroughputDistribution priorStats, double forecast) {
        boolean prune = false;
        double tputRatio = forecast / priorStats.getMovingAverage();
        if (tputRatio > tputRatioPruneLevel || tputRatio < 1.0 / tputRatioPruneLevel) {
            prune = true;
        } else {
            double variability;
            int age = this.controllerCycle - priorStats.getLastUpdate();
            if ((double)age * (variability = priorStats.getStddev() / priorStats.getMovingAverage()) > dataAgePruneLevel) {
                prune = true;
            }
        }
        return prune;
    }

    private Integer getSmallestValidPoolSize(Integer poolSize, Double forecast) {
        Integer smallestPoolSize = this.threadStats.firstKey();
        Integer nextPoolSize = this.threadStats.higherKey(smallestPoolSize);
        Integer pruneSize = -1;
        boolean validSmallData = false;
        while (!validSmallData && nextPoolSize != null) {
            ThroughputDistribution smallestPoolSizeStats = this.getThroughputDistribution(smallestPoolSize, false);
            if (this.pruneData(smallestPoolSizeStats, forecast)) {
                pruneSize = smallestPoolSize;
                smallestPoolSize = nextPoolSize;
                nextPoolSize = this.threadStats.higherKey(smallestPoolSize);
                if (pruneSize <= this.currentMinimumPoolSize) continue;
                this.threadStats.remove(pruneSize);
                continue;
            }
            validSmallData = true;
        }
        return smallestPoolSize;
    }

    private Integer getLargestValidPoolSize(Integer poolSize, Double forecast) {
        Integer largestPoolSize = -1;
        boolean validLargeData = false;
        while (!validLargeData) {
            largestPoolSize = this.threadStats.lastKey();
            ThroughputDistribution largestPoolSizeStats = this.getThroughputDistribution(largestPoolSize, false);
            if (this.pruneData(largestPoolSizeStats, forecast)) {
                this.threadStats.remove(largestPoolSize);
                continue;
            }
            validLargeData = true;
        }
        return largestPoolSize;
    }

    private boolean leanTowardShrinking(Integer smallerPoolSize, int largerPoolSize, double smallerPoolTput, double largerPoolTput) {
        boolean shouldShrink = false;
        double poolRatio = largerPoolSize / smallerPoolSize;
        double tputRatio = largerPoolTput / smallerPoolTput;
        double poolTputRatio = poolRatio / tputRatio;
        if (tputRatio < 1.0) {
            shouldShrink = !this.flipCoin() || !this.flipCoin();
        } else if (poolTputRatio > poolTputRatioHigh) {
            shouldShrink = !this.flipCoin() || !this.flipCoin();
        } else if (poolTputRatio > poolTputRatioLow) {
            boolean bl = shouldShrink = !this.flipCoin();
        }
        if (tc.isEventEnabled() && shouldShrink) {
            Tr.event((TraceComponent)tc, (String)"Tput ratio shrinkScore adjustment, larger poolSizes", (Object[])new Object[]{this.poolTputRatioData(poolTputRatio, poolRatio, tputRatio, smallerPoolTput, largerPoolTput, smallerPoolSize, largerPoolSize)});
        }
        return shouldShrink;
    }

    private void setPoolIncrementDecrement(int poolSize) {
        if (this.threadRange < this.poolChangeBasis * minimumDesiredPoolSizeAdjustments) {
            if (this.threadRange < minimumDesiredPoolSizeAdjustments) {
                this.poolIncrement = 1;
                this.poolDecrement = 1;
            } else {
                this.poolDecrement = this.poolIncrement = this.threadRange / minimumDesiredPoolSizeAdjustments;
            }
        } else if (poolSize <= this.poolIncrementBoundLow) {
            this.poolDecrement = this.poolIncrement = this.poolChangeBasis;
        } else if (poolSize <= this.poolIncrementBoundMedium) {
            this.poolDecrement = this.poolIncrement = this.poolChangeBasis * 2;
            if (poolSize == this.poolIncrementBoundLow + this.poolChangeBasis) {
                this.poolDecrement = this.poolChangeBasis;
            }
        } else if (poolSize <= this.poolIncrementBoundHigh) {
            this.poolDecrement = this.poolIncrement = this.poolChangeBasis * 4;
            if (poolSize == this.poolIncrementBoundMedium + this.poolChangeBasis * 2) {
                this.poolDecrement = this.poolChangeBasis * 2;
            }
        } else if (poolSize <= this.poolIncrementBoundExtraHigh) {
            this.poolDecrement = this.poolIncrement = this.poolChangeBasis * 8;
            if (poolSize == this.poolIncrementBoundHigh + this.poolChangeBasis * 4) {
                this.poolDecrement = this.poolChangeBasis * 4;
            }
        } else {
            this.poolDecrement = this.poolIncrement = this.poolChangeBasis * 16;
            if (poolSize == this.poolIncrementBoundExtraHigh + this.poolChangeBasis * 8) {
                this.poolDecrement = this.poolChangeBasis * 8;
            }
        }
        if ((poolIncrementMin != 1 || this.poolIncrementMax != this.POOL_INCREMENT_MAX_DEFAULT) && poolIncrementMin <= this.poolIncrementMax) {
            this.poolIncrement = Math.max(this.poolIncrement, poolIncrementMin);
            this.poolDecrement = this.poolIncrement = Math.min(this.poolIncrement, this.poolIncrementMax);
        }
        if (poolSize + this.poolIncrement > this.maxThreads) {
            if (poolSize == this.maxThreads) {
                this.poolDecrement = this.maxThreadsPoolDecrement;
            } else {
                this.poolIncrement = this.maxThreads - poolSize;
            }
        }
        if (poolSize + this.poolIncrement == this.maxThreads) {
            this.maxThreadsPoolDecrement = this.poolIncrement;
        }
        if (poolSize - this.poolDecrement < this.currentMinimumPoolSize && poolSize > this.currentMinimumPoolSize) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"poolDecrement vs currentMinimumPoolSize check", (Object[])new Object[]{" poolSize " + poolSize + " , poolDecrement: " + this.poolDecrement + ", coreThreads: " + this.coreThreads + " , currentMinimumPoolSize: " + this.currentMinimumPoolSize});
            }
            this.poolDecrement = poolSize - this.currentMinimumPoolSize;
        }
    }

    private boolean checkTargetPoolSize(int poolSize) {
        boolean poolSizeCheckFailed = false;
        if (poolSize != this.targetPoolSize) {
            poolSizeCheckFailed = true;
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"targetPoolSize check", (Object[])new Object[]{" poolSize " + poolSize + " != targetPoolSize " + this.targetPoolSize});
            }
            ++this.consecutiveTargetPoolSizeWrong;
            if (this.consecutiveTargetPoolSizeWrong >= 3) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"consecutiveTargetPoolSize check", (Object[])new Object[]{" consecutiveTargetPoolSizeWrong " + this.consecutiveTargetPoolSizeWrong + " exceeds threshold " + 3 + ", calling setPoolSize(targetPoolSize)"});
                }
                if (this.targetPoolSize < poolSize) {
                    this.setPoolIncrementDecrement(this.targetPoolSize);
                    this.targetPoolSize = this.targetPoolSize + this.poolIncrement <= this.maxThreads ? (this.targetPoolSize += this.poolIncrement) : this.maxThreads;
                }
                this.setPoolSize(this.targetPoolSize);
                this.consecutiveTargetPoolSizeWrong = 0;
            }
        } else {
            this.consecutiveTargetPoolSizeWrong = 0;
        }
        return poolSizeCheckFailed;
    }

    private void reportSystemProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n coreThreads: ").append(String.format("%6d", this.coreThreads));
        sb.append(" maxThreads: ").append(String.format("%6d", this.maxThreads));
        sb.append(" startupPoolSize: ").append(String.format("%6d", startupPoolSize));
        sb.append(" startupHangCpuUtilThreshold: ").append(String.format("%6d", startupHangCpuUtilThreshold));
        sb.append("\n interval: ").append(String.format("%6d", interval));
        sb.append(" hangInterval: ").append(String.format("%6d", hangInterval));
        sb.append(" compareRange: ").append(String.format("%6d", compareRange));
        sb.append(" highCpu: ").append(String.format("%4d", highCpu));
        sb.append("\n tputRatioPruneLevel: ").append(String.format("%2.2f", tputRatioPruneLevel));
        sb.append(" poolTputRatioHigh: ").append(String.format("%2.2f", poolTputRatioHigh));
        sb.append(" poolTputRatioLow: ").append(String.format("%2.2f", poolTputRatioLow));
        sb.append(" compareSpanRatioMultiplier: ").append(String.format("%3d", compareSpanRatioMultiplier));
        sb.append("\n growScoreFilterLevel: ").append(String.format("%2.2f", growScoreFilterLevel));
        sb.append(" shrinkScoreFilterLevel: ").append(String.format("%2.2f", shrinkScoreFilterLevel));
        sb.append(" growShrinkDiffFilter: ").append(String.format("%2.2f", growShrinkDiffFilter));
        sb.append(" dataAgePruneLevel: ").append(String.format("%2.2f", dataAgePruneLevel));
        sb.append(" compareSpanPruneMultiplier: ").append(String.format("%3d", compareSpanPruneMultiplier));
        sb.append("\n poolIncrementMin: ").append(String.format("%3d", poolIncrementMin));
        sb.append(" poolIncrementMax: ").append(String.format("%4d", this.poolIncrementMax));
        sb.append(" poolIncrementBoundLow: ").append(String.format("%4d", this.poolIncrementBoundLow));
        sb.append(" poolIncrementBoundMedium: ").append(String.format("%4d", this.poolIncrementBoundMedium));
        sb.append(" minimumDesiredPoolSizeAdjustments : ").append(String.format("%4d", minimumDesiredPoolSizeAdjustments));
        sb.append("\n resetDistroStdDevEwmaRatio: ").append(String.format("%2.2f", resetDistroStdDevEwmaRatio));
        sb.append(" resetDistroNewTputEwmaRatio: ").append(String.format("%2.2f", resetDistroNewTputEwmaRatio));
        sb.append(" resetDistroConsecutiveOutliers: ").append(String.format("%2.2f", resetDistroConsecutiveOutliers));
        Tr.event((TraceComponent)tc, (String)"Initial config settings:", (Object[])new Object[]{sb});
    }

    private static final String getSystemProperty(final String propName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 741276333193848807L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty(propName);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.ThreadPoolController$1", 1.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
            }
        });
    }

    synchronized void introspect(PrintWriter out) {
        String INDENT = "  ";
        out.println(this.getClass().getName());
        out.println("  coreThreads = " + this.coreThreads);
        out.println("  maxThreads = " + this.maxThreads);
        out.println("  currentMinimumPoolSize = " + this.currentMinimumPoolSize);
        out.println("  interval = " + interval);
        out.println("  compareRange = " + compareRange);
        out.println("  NUMBER_CPUS = " + this.numberCpus);
        out.println("  controllerCycle = " + this.controllerCycle);
        out.println("  poolChangeBasis = " + this.poolChangeBasis);
        out.println("  poolIncrement = " + this.poolIncrement);
        out.println("  poolDecrement = " + this.poolDecrement);
        out.println("  poolIncrementMax = " + this.poolIncrementMax);
        out.println("  poolIncrementMin = " + poolIncrementMin);
        out.println("  targetPoolSize = " + this.targetPoolSize);
        out.println("  consecutiveTargetPoolSizeWrong = " + this.consecutiveTargetPoolSizeWrong);
        out.println("  highCpu = " + highCpu);
        out.println("  lowTputThreadsRatio = " + lowTputThreadsRatio);
        out.println("  dataAgePruneLevel = " + dataAgePruneLevel);
        out.println("  growScoreFilterLevel = " + growScoreFilterLevel);
        out.println("  shrinkScoreFilterLevel = " + shrinkScoreFilterLevel);
        out.println("  growShrinkDiffFilter = " + growShrinkDiffFilter);
        out.println("  resetDistroStdDevEwmaRatio = " + resetDistroStdDevEwmaRatio);
        out.println("  resetDistroNewTputEwmaRatio = " + resetDistroNewTputEwmaRatio);
        out.println("  resetDistroConsecutiveOutliers = " + resetDistroConsecutiveOutliers);
        out.println("  paused = " + this.paused);
        out.println("  hangIntervalCounter = " + this.hangIntervalCounter);
        out.println("  poolSizeWhenHangDetected = " + this.poolSizeWhenHangDetected);
        out.println("  lastAction = " + (Object)((Object)this.lastAction));
        out.println("  lastTimerPop = " + this.lastTimerPop);
        out.println("  previousCompleted = " + this.previousCompleted);
        out.println("  consecutiveIdleCount = " + this.consecutiveIdleCount);
        out.println("  consecutiveNoAdjustment = " + this.consecutiveNoAdjustment);
        out.println("  consecutiveOutlierAfterAdjustment = " + this.consecutiveOutlierAfterAdjustment);
        out.println("  consecutiveQueueEmptyCount = " + this.consecutiveQueueEmptyCount);
        out.println("  threadPool");
        out.println("    poolSize = " + this.threadPool.getPoolSize());
        out.println("    queueDepth = " + this.queueDepth);
        out.println("    activeCount = " + this.threadPool.getActiveCount());
        out.println("    corePoolSize = " + this.threadPool.getCorePoolSize());
        out.println("    maxPoolSize = " + this.threadPool.getMaximumPoolSize());
        out.println("    largestPoolSize = " + this.threadPool.getLargestPoolSize());
        out.println("    completedTaskCount = " + this.threadPool.getCompletedTaskCount());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        initialStartupCompleted = false;
        String tpcStartupPoolSize = ThreadPoolController.getSystemProperty("tpcStartupPoolSize");
        if (tpcStartupPoolSize == null) {
            startupPoolSize = 6;
        } else {
            int cfgStartupPoolSize = Integer.parseInt(tpcStartupPoolSize);
            if (cfgStartupPoolSize == -1) {
                initialStartupCompleted = true;
                startupPoolSize = -1;
            } else {
                startupPoolSize = Math.max(4, cfgStartupPoolSize);
            }
        }
        String tpcStartupHangCpuUtilThreshold = ThreadPoolController.getSystemProperty("tpcStartupHangCpuUtilThreshold");
        startupHangCpuUtilThreshold = tpcStartupHangCpuUtilThreshold == null ? 10 : Integer.parseInt(tpcStartupHangCpuUtilThreshold);
        String tpcStartupHangControllerCyclesSkip = ThreadPoolController.getSystemProperty("tpcStartupHangControllerCyclesSkip");
        startupHangControllerCyclesSkip = tpcStartupHangControllerCyclesSkip == null ? 2 : Integer.parseInt(tpcStartupHangControllerCyclesSkip);
        String tpcResetDistroStdDevEwmaRatio = ThreadPoolController.getSystemProperty("tpcResetDistroStdDevEwmaRatio");
        resetDistroStdDevEwmaRatio = tpcResetDistroStdDevEwmaRatio == null ? 0.1 : Double.parseDouble(tpcResetDistroStdDevEwmaRatio);
        String tpcResetDistroNewTputEwmaRatio = ThreadPoolController.getSystemProperty("tpcResetDistroNewTputEwmaRatio");
        resetDistroNewTputEwmaRatio = tpcResetDistroNewTputEwmaRatio == null ? 0.5 : Double.parseDouble(tpcResetDistroNewTputEwmaRatio);
        String tpcResetDistroConsecutiveOutliers = ThreadPoolController.getSystemProperty("tpcResetDistroConsecutiveOutliers");
        resetDistroConsecutiveOutliers = tpcResetDistroConsecutiveOutliers == null ? 5.0 : (double)Integer.parseInt(tpcResetDistroConsecutiveOutliers);
        String tpcMinimumDesiredPoolSizeAdjustments = ThreadPoolController.getSystemProperty("tpcMinimumDesiredPoolSizeAdjustments");
        minimumDesiredPoolSizeAdjustments = tpcMinimumDesiredPoolSizeAdjustments == null ? 10 : Integer.parseInt(tpcMinimumDesiredPoolSizeAdjustments);
        String tpcTputRatioPruneLevel = ThreadPoolController.getSystemProperty("tpcTputRatioPruneLevel");
        tputRatioPruneLevel = tpcTputRatioPruneLevel == null ? 5.0 : Double.parseDouble(tpcTputRatioPruneLevel);
        String tpcPoolTputRatioHigh = ThreadPoolController.getSystemProperty("tpcPoolTputRatioHigh");
        poolTputRatioHigh = tpcPoolTputRatioHigh == null ? 5.0 : Double.parseDouble(tpcPoolTputRatioHigh);
        String tpcPoolTputRatioLow = ThreadPoolController.getSystemProperty("tpcPoolTputRatioLow");
        poolTputRatioLow = tpcPoolTputRatioLow == null ? 3.0 : Double.parseDouble(tpcPoolTputRatioLow);
        String tpcCompareSpanRatioMultiplier = ThreadPoolController.getSystemProperty("tpcCompareSpanRatioMultiplier");
        compareSpanRatioMultiplier = tpcCompareSpanRatioMultiplier == null ? 2 : Integer.parseInt(tpcCompareSpanRatioMultiplier);
        String tpcGrowScorePruneLevel = ThreadPoolController.getSystemProperty("tpcGrowScorePruneLevel");
        growScoreFilterLevel = tpcGrowScorePruneLevel == null ? 0.5 : Double.parseDouble(tpcGrowScorePruneLevel);
        String tpcShrinkScorePruneLevel = ThreadPoolController.getSystemProperty("tpcShrinkScorePruneLevel");
        shrinkScoreFilterLevel = tpcShrinkScorePruneLevel == null ? 0.5 : Double.parseDouble(tpcShrinkScorePruneLevel);
        String tpcGrowShrinkDiffFilter = ThreadPoolController.getSystemProperty("tpcGrowShrinkDiffFilter");
        growShrinkDiffFilter = tpcGrowShrinkDiffFilter == null ? 0.25 : Double.parseDouble(tpcGrowShrinkDiffFilter);
        String tpcPoolIncrementMin = ThreadPoolController.getSystemProperty("tpcPoolIncrementMin");
        poolIncrementMin = tpcPoolIncrementMin == null ? 1 : Integer.parseInt(tpcPoolIncrementMin);
        String tpcHighCpu = ThreadPoolController.getSystemProperty("tpcHighCpu");
        highCpu = tpcHighCpu == null ? 90 : Integer.parseInt(tpcHighCpu);
        String tpcLowTputThreadsRatio = ThreadPoolController.getSystemProperty("tpcLowTputThreadsRatio");
        lowTputThreadsRatio = tpcLowTputThreadsRatio == null ? 1.0 : Double.parseDouble(tpcLowTputThreadsRatio);
        String tpcActiveThreadsGrowthRatio = ThreadPoolController.getSystemProperty("tpcActiveThreadsGrowthRatio");
        activeThreadsGrowthRatio = tpcActiveThreadsGrowthRatio == null ? 0.75 : Double.parseDouble(tpcActiveThreadsGrowthRatio);
        String tpcDataAgePruneLevel = ThreadPoolController.getSystemProperty("tpcDataAgePruneLevel");
        dataAgePruneLevel = tpcDataAgePruneLevel == null ? 5.0 : Double.parseDouble(tpcDataAgePruneLevel);
        String tpcCompareSpanPruneMultiplier = ThreadPoolController.getSystemProperty("tpcCompareSpanPruneMultiplier");
        compareSpanPruneMultiplier = tpcCompareSpanPruneMultiplier == null ? 2 : Integer.parseInt(tpcCompareSpanPruneMultiplier);
        String tpcInterval = ThreadPoolController.getSystemProperty("tpcInterval");
        interval = tpcInterval == null ? 1500L : (long)Integer.parseInt(tpcInterval);
        String tpcHangInterval = ThreadPoolController.getSystemProperty("tpcHangInterval");
        hangInterval = tpcHangInterval == null ? 750L : (long)Integer.parseInt(tpcHangInterval);
        String tpcCompareRange = ThreadPoolController.getSystemProperty("tpcCompareRange");
        compareRange = tpcCompareRange == null ? 4 : Integer.parseInt(tpcCompareRange);
        String tpcDeepQueueMultiple = ThreadPoolController.getSystemProperty("tpcDeepQueueMultiple");
        deepQueueMultiple = tpcDeepQueueMultiple == null ? 4 : Integer.parseInt(tpcDeepQueueMultiple);
        String tpcDeepQueuePoolIncrementMultiple = ThreadPoolController.getSystemProperty("tpcDeepQueuePoolIncrementMultiple");
        deepQueuePoolIncrementMultiple = tpcDeepQueuePoolIncrementMultiple == null ? 4 : Integer.parseInt(tpcDeepQueuePoolIncrementMultiple);
        String tpcConsecutiveDeepQueueThreshold = ThreadPoolController.getSystemProperty("tpcConsecutiveDeepQueueThreshold");
        consecutiveDeepQueueThreshold = tpcConsecutiveDeepQueueThreshold == null ? 5 : Integer.parseInt(tpcConsecutiveDeepQueueThreshold);
        df = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.US));
        MAX_OUTLIER_AFTER_CHANGE_BEFORE_RESET = compareRange * 2 + 2;
    }

    static enum LastAction {
        NONE,
        GROW,
        SHRINK,
        PAUSE;

    }
}

