/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.LaunchException;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.KernelUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.osgi.framework.Version;

public class BootstrapManifest {
    static final String BUNDLE_VERSION = "Bundle-Version";
    static final String JAR_PROTOCOL = "jar";
    static final String SYSTEM_PKG_PREFIX = "OSGI-OPT/websphere/system-packages_";
    static final String SYSTEM_PKG_SUFFIX = ".properties";
    static final String MANIFEST_EXPORT_PACKAGE = "Export-Package";
    private static BootstrapManifest instance = null;
    private final Attributes manifestAttributes;
    private final boolean libertyBoot;

    public static BootstrapManifest readBootstrapManifest(boolean libertyBoot) throws IOException {
        BootstrapManifest manifest = instance;
        if (manifest == null) {
            manifest = instance = new BootstrapManifest(libertyBoot);
        }
        return manifest;
    }

    public static void dispose() {
        instance = null;
    }

    protected BootstrapManifest() throws IOException {
        this(false);
    }

    protected BootstrapManifest(boolean libertyBoot) throws IOException {
        this.libertyBoot = libertyBoot;
        this.manifestAttributes = libertyBoot ? BootstrapManifest.getLibertyBootAttributes() : BootstrapManifest.getAttributesFromBootstrapJar();
    }

    private static Attributes getAttributesFromBootstrapJar() throws IOException {
        Attributes attributes;
        JarFile jf = null;
        try {
            jf = new JarFile(KernelUtils.getBootstrapJar());
            Manifest mf = jf.getManifest();
            attributes = mf.getMainAttributes();
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Utils.tryToClose(jf);
                throw throwable;
            }
        }
        Utils.tryToClose(jf);
        return attributes;
    }

    private static Attributes getLibertyBootAttributes() {
        JarFile jf = BootstrapManifest.getLibertBootJarFile();
        try {
            Manifest mf = jf.getManifest();
            Attributes attributes = mf.getMainAttributes();
            return attributes;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            Utils.tryToClose(jf);
        }
    }

    private static JarFile getLibertBootJarFile() {
        return BootstrapManifest.getJarFile(BootstrapManifest.class.getResource(BootstrapManifest.class.getSimpleName() + ".class"));
    }

    private static JarFile getJarFile(URL url) {
        if (JAR_PROTOCOL.equals(url.getProtocol())) {
            try {
                URLConnection conn = url.openConnection();
                if (conn instanceof JarURLConnection) {
                    return ((JarURLConnection)conn).getJarFile();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("No jar file found: " + url, e);
            }
        }
        throw new IllegalArgumentException("Not a jar URL: " + url);
    }

    private JarFile getBootJar() throws IOException {
        return this.libertyBoot ? BootstrapManifest.getLibertBootJarFile() : new JarFile(KernelUtils.getBootstrapJar());
    }

    public String getBundleVersion() {
        return this.manifestAttributes.getValue(BUNDLE_VERSION);
    }

    private String calculateSystemPackages(String javaVersion) {
        try {
            javaVersion = javaVersion.split("\\.")[0];
            int version = Integer.parseInt(javaVersion);
            if (version < 9) {
                return null;
            }
            Method classGetModule = Class.class.getMethod("getModule", new Class[0]);
            Class<?> moduleLayerClass = Class.forName("java.lang.ModuleLayer");
            Method boot = moduleLayerClass.getMethod("boot", new Class[0]);
            Method modules = moduleLayerClass.getMethod("modules", new Class[0]);
            Class<?> moduleClass = Class.forName("java.lang.Module");
            Method getDescriptor = moduleClass.getMethod("getDescriptor", new Class[0]);
            Class<?> moduleDescriptorClass = Class.forName("java.lang.module.ModuleDescriptor");
            Method exports = moduleDescriptorClass.getMethod("exports", new Class[0]);
            Method isAutomatic = moduleDescriptorClass.getMethod("isAutomatic", new Class[0]);
            Method packagesMethod = moduleDescriptorClass.getMethod("packages", new Class[0]);
            Class<?> exportsClass = Class.forName("java.lang.module.ModuleDescriptor$Exports");
            Method isQualified = exportsClass.getMethod("isQualified", new Class[0]);
            Method source = exportsClass.getMethod("source", new Class[0]);
            Object bootLayer = boot.invoke(null, new Object[0]);
            Set bootModules = (Set)modules.invoke(bootLayer, new Object[0]);
            Object thisModule = classGetModule.invoke(this.getClass(), new Object[0]);
            TreeSet<String> packages = new TreeSet<String>();
            for (Object m : bootModules) {
                if (m.equals(thisModule)) continue;
                Object descriptor = getDescriptor.invoke(m, new Object[0]);
                if (((Boolean)isAutomatic.invoke(descriptor, new Object[0])).booleanValue()) {
                    packages.addAll((Set)packagesMethod.invoke(descriptor, new Object[0]));
                    continue;
                }
                for (Object export : (Set)exports.invoke(descriptor, new Object[0])) {
                    String pkg = (String)source.invoke(export, new Object[0]);
                    if (((Boolean)isQualified.invoke(export, new Object[0])).booleanValue()) continue;
                    packages.add(pkg);
                }
            }
            packages.add("javax.xml.soap");
            packages.add("com.ibm.tools.attach");
            packages.add("com.ibm.security.jgss");
            packages.add("com.ibm.security.auth.module");
            packages.add("com.ibm.security.auth.callback");
            StringBuilder result = new StringBuilder();
            for (String pkg : packages) {
                if (result.length() != 0) {
                    result.append(',').append(' ');
                }
                result.append(pkg);
                result.append("; ibm-api-type=spec");
                if (!"javax.transaction.xa".equals(pkg)) continue;
                result.append("; javax.transaction=JavaSE; mandatory:=javax.transaction");
            }
            return result.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void prepSystemPackages(BootstrapConfig bootProps) {
        String packages = bootProps.get("org.osgi.framework.system.packages.extra");
        String syspackages = bootProps.get("org.osgi.framework.system.packages");
        String mPackages = this.manifestAttributes.getValue(MANIFEST_EXPORT_PACKAGE);
        if (mPackages != null) {
            String string = packages = packages == null ? mPackages : packages + "," + mPackages;
            if (packages != null) {
                bootProps.put("org.osgi.framework.system.packages.extra", packages);
            }
        }
        if (syspackages == null) {
            String javaVersion = System.getProperty("java.version", "1.6.0");
            int index = javaVersion.indexOf(95);
            index = index == -1 ? javaVersion.indexOf(45) : index;
            javaVersion = index == -1 ? javaVersion : javaVersion.substring(0, index);
            String calculatedPackages = this.calculateSystemPackages(javaVersion);
            if (calculatedPackages != null) {
                bootProps.put("org.osgi.framework.system.packages", calculatedPackages);
                return;
            }
            String pkgListFileName = SYSTEM_PKG_PREFIX + javaVersion + SYSTEM_PKG_SUFFIX;
            JarFile jarFile = null;
            try {
                jarFile = this.getBootJar();
                List<Object> systemPackageFileNames = new ArrayList();
                Enumeration<JarEntry> bootstrapJarEntries = jarFile.entries();
                while (bootstrapJarEntries.hasMoreElements()) {
                    JarEntry entry = bootstrapJarEntries.nextElement();
                    if (entry == null || !entry.getName().startsWith(SYSTEM_PKG_PREFIX) || !entry.getName().endsWith(SYSTEM_PKG_SUFFIX)) continue;
                    systemPackageFileNames.add(entry.getName());
                }
                int numNames = systemPackageFileNames.size();
                if (numNames != 0) {
                    int indexOfPackageFileToUse;
                    if (numNames > 1) {
                        Collections.sort(systemPackageFileNames, new Comparator<String>(){

                            @Override
                            public int compare(String name1, String name2) {
                                Version oneVersion = this.getVersion(name1);
                                Version twoVersion = this.getVersion(name2);
                                return twoVersion.compareTo(oneVersion);
                            }

                            private Version getVersion(String name) {
                                String version = name.substring(BootstrapManifest.SYSTEM_PKG_PREFIX.length(), name.length());
                                version = version.substring(0, version.indexOf(BootstrapManifest.SYSTEM_PKG_SUFFIX, 0));
                                return new Version(version);
                            }
                        });
                    }
                    if ((indexOfPackageFileToUse = systemPackageFileNames.indexOf(pkgListFileName)) < 0 && javaVersion.indexOf(46) > 0) {
                        String genericPkgListFileName = SYSTEM_PKG_PREFIX + javaVersion.split("\\.")[0] + SYSTEM_PKG_SUFFIX;
                        indexOfPackageFileToUse = systemPackageFileNames.indexOf(genericPkgListFileName);
                    }
                    if (indexOfPackageFileToUse < 0) {
                        indexOfPackageFileToUse = 0;
                    }
                    systemPackageFileNames = systemPackageFileNames.subList(indexOfPackageFileToUse, numNames);
                } else {
                    systemPackageFileNames = Arrays.asList(pkgListFileName);
                }
                syspackages = this.getMergedSystemProperties(jarFile, systemPackageFileNames);
                if (syspackages != null) {
                    bootProps.put("org.osgi.framework.system.packages", syspackages);
                }
            }
            catch (IOException ioe) {
                throw new LaunchException("Unable to find or read specified properties file; " + pkgListFileName, MessageFormat.format(BootstrapConstants.messages.getString("error.unknownException"), ioe.toString()), ioe);
            }
            finally {
                Utils.tryToClose(jarFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMergedSystemProperties(JarFile jarFile, List<String> pkgListFileNames) throws IOException {
        String packages = null;
        for (String pkgListFileName : pkgListFileNames) {
            ZipEntry propFile = jarFile.getEntry(pkgListFileName);
            if (propFile != null) {
                Properties properties = new Properties();
                InputStream is = jarFile.getInputStream(propFile);
                try {
                    properties.load(is);
                    String loadedPackages = properties.getProperty("org.osgi.framework.system.packages");
                    if (loadedPackages == null) continue;
                    packages = packages == null ? loadedPackages : packages + "," + loadedPackages;
                    continue;
                }
                finally {
                    Utils.tryToClose(is);
                    continue;
                }
            }
            throw new IOException("Unable to find specified properties file; " + pkgListFileName);
        }
        return packages;
    }
}

