/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.reporting.internal;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CVEServiceClient {
    private static final TraceComponent tc = Tr.register(CVEServiceClient.class, (String)"cveReporting", (String)"io.openliberty.reporting.internal.resources.CVEReporting");
    static final long serialVersionUID = -2371128326036558151L;

    public JSONObject retrieveCVEData(Map<String, String> data, String urlLink) throws IOException {
        String jsonData = this.buildJsonString(data);
        JSONObject json = new JSONObject();
        if (!urlLink.startsWith("https")) {
            throw new MalformedURLException("Invalid protocol, expected https");
        }
        URL url = new URL(urlLink);
        HttpsURLConnection connection = CVEServiceClient.getConnection(url);
        if (connection != null) {
            CVEServiceClient.sendData(connection, jsonData);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)jsonData, (Object[])new Object[0]);
        }
        InputStreamReader reader = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);
        try {
            json = JSONObject.parse((Reader)reader);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.reporting.internal.CVEServiceClient", (String)"70", (Object)this, (Object[])new Object[]{data, urlLink});
            try {
                ((Reader)reader).close();
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)"io.openliberty.reporting.internal.CVEServiceClient", (String)"70", (Object)this, (Object[])new Object[]{data, urlLink});
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((Reader)reader).close();
        return json;
    }

    private static HttpsURLConnection getConnection(URL url) throws IOException {
        HttpsURLConnection connection = null;
        connection = (HttpsURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "application/json");
        connection.setDoOutput(true);
        return connection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void sendData(HttpsURLConnection connection, String jsonData) throws ConnectException, IOException {
        OutputStream os = connection.getOutputStream();
        try {
            byte[] input = jsonData.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
            if (os == null) return;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.reporting.internal.CVEServiceClient", (String)"108", null, (Object[])new Object[]{connection, jsonData});
            if (os == null) throw throwable;
            try {
                os.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)"io.openliberty.reporting.internal.CVEServiceClient", (String)"108", null, (Object[])new Object[]{connection, jsonData});
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        os.close();
    }

    protected String buildJsonString(Map<String, String> data) {
        if (data.isEmpty()) {
            return "{}";
        }
        StringBuilder jsonData = new StringBuilder("{");
        for (String key : data.keySet()) {
            if ("features".equals(key) || "iFixes".equals(key)) {
                jsonData.append("\"").append(key).append("\": [");
                if (data.get(key).length() > 0) {
                    String[] featuresOrIFixes;
                    for (String featureOrIfix : featuresOrIFixes = data.get(key).split(",")) {
                        jsonData.append("\"").append(featureOrIfix).append("\", ");
                    }
                    jsonData.setLength(jsonData.length() - 2);
                }
                jsonData.append("], ");
                continue;
            }
            jsonData.append("\"").append(key).append("\": \"").append(data.get(key)).append("\", ");
        }
        jsonData.setLength(jsonData.length() - 2);
        jsonData.append("}");
        return jsonData.toString();
    }
}

