/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallLicense;
import com.ibm.ws.install.internal.ConfigParser;
import com.ibm.ws.install.internal.ExceptionUtils;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.Product;
import com.ibm.ws.install.internal.asset.SubsytemEntry;
import com.ibm.ws.install.repository.download.RepositoryDownloadUtil;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.feature.internal.HashUtils;
import com.ibm.ws.kernel.feature.internal.subsystem.SubsystemFeatureDefinitionImpl;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import com.ibm.ws.kernel.provisioning.ProductExtension;
import com.ibm.ws.kernel.provisioning.ProductExtensionInfo;
import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.common.enums.Visibility;
import com.ibm.ws.repository.connections.DirectoryRepositoryConnection;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.exceptions.RepositoryBadDataException;
import com.ibm.ws.repository.exceptions.RepositoryResourceException;
import com.ibm.ws.repository.resources.AttachmentResource;
import com.ibm.ws.repository.resources.EsaResource;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.SampleResource;
import com.ibm.ws.repository.transport.client.JSONAssetConverter;
import com.ibm.ws.repository.transport.model.Asset;
import com.ibm.ws.repository.transport.model.WlpInformation;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import wlp.lib.extract.SelfExtractor;

public class InstallUtils {
    private static final Logger logger = Logger.getLogger("com.ibm.ws.install");
    private static final int LINE_WRAP_COLUMNS = 72;
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    public static boolean isOptional = true;
    public static final String SERVER_DIR_NAME = "servers";
    public static final String SERVER_XML = "server.xml";
    public static final List<String> ALL_EDITIONS = Arrays.asList("BASE", "LIBERTY_CORE", "DEVELOPERS", "EXPRESS", "ND", "ZOS");
    public static final String DEFAULT_TO_EXTENSION = "default";
    private static boolean isServerXmlInstallation = false;
    private static Set<String> serverFeatures = new HashSet<String>();

    public static final File getServersDir() {
        return new File(Utils.getUserDir(), SERVER_DIR_NAME);
    }

    public static final boolean isFileInInstallDirectory(File file) throws IOException {
        return null != file && file.getCanonicalPath().startsWith(Utils.getInstallDir().getCanonicalPath());
    }

    public static boolean serverExists(String serverName) {
        return new File(InstallUtils.getServersDir(), serverName).isDirectory();
    }

    public static void close(Closeable toClose) {
        if (toClose != null) {
            try {
                toClose.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(ZipFile zip) {
        if (zip != null) {
            try {
                zip.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void delete(List<File> files) {
        ArrayList<File> directories = new ArrayList<File>();
        for (File f : files) {
            if (f.isFile()) {
                logger.log(Level.FINEST, "Deleteing file " + f.getAbsolutePath());
                InstallUtils.delete(f);
                continue;
            }
            directories.add(f);
        }
        for (File d : directories) {
            logger.log(Level.FINEST, "Deleteing directory " + d.getAbsolutePath());
            InstallUtils.deleteDirectory(d);
        }
    }

    public static void getAllFiles(File dir, List<File> fileList) {
        if (dir != null && dir.exists()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                if (file.isDirectory()) {
                    InstallUtils.getAllFiles(file, fileList);
                    continue;
                }
                if (!file.isFile()) continue;
                fileList.add(file);
            }
        }
    }

    public static boolean deleteDirectory(File directory) {
        if (directory.isDirectory()) {
            File[] files = directory.listFiles();
            if (null != files) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        InstallUtils.deleteDirectory(file);
                        continue;
                    }
                    if (file.delete()) continue;
                    logger.log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_CANNOT_DELETE_FILE", file.getAbsolutePath()));
                    file.deleteOnExit();
                }
            }
            return directory.delete();
        }
        return false;
    }

    public static boolean mkdirs(List<File> installedFiles, File file) {
        boolean result = true;
        if (!file.exists() && (result = InstallUtils.mkdirs(installedFiles, file.getParentFile()))) {
            if (file.mkdir()) {
                if (installedFiles != null) {
                    installedFiles.add(file);
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    public static boolean setLastModifiedTime(File f, long time) {
        return f.setLastModified(time);
    }

    public static DateFormat getDateFormat() {
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 2);
        if (formatter instanceof SimpleDateFormat) {
            SimpleDateFormat sdFormatter = (SimpleDateFormat)formatter;
            String pattern = sdFormatter.toPattern();
            int patternLength = pattern.length();
            int endOfSecsIndex = pattern.lastIndexOf(115) + 1;
            String newPattern = pattern.substring(0, endOfSecsIndex) + ":SSS z";
            if (endOfSecsIndex < patternLength) {
                newPattern = newPattern + pattern.substring(endOfSecsIndex, patternLength);
            }
            newPattern = newPattern.replace('h', 'H');
            newPattern = newPattern.replace('K', 'H');
            newPattern = newPattern.replace('k', 'H');
            newPattern = newPattern.replace('a', ' ');
            newPattern = newPattern.trim();
            sdFormatter.applyPattern(newPattern);
            formatter = sdFormatter;
        } else {
            formatter = new SimpleDateFormat("yy.MM.dd HH:mm:ss:SSS z");
        }
        return formatter;
    }

    public static void fixLogger(PrintWriter log, String fixID, String message) {
        Date d = new Date();
        String dateString = InstallUtils.getDateFormat().format(d);
        log.println("[" + dateString + "] " + fixID + " " + message);
        log.flush();
    }

    public static File download(File installTempDir, RepositoryResource resource) throws IOException, RepositoryBackendException, RepositoryResourceException, InstallException {
        if (!installTempDir.exists()) {
            installTempDir.mkdir();
        }
        File targetFile = null;
        if (resource.getType().equals((Object)ResourceType.FEATURE)) {
            targetFile = File.createTempFile("feature", ".esa", installTempDir);
        } else if (resource.getType().equals((Object)ResourceType.IFIX)) {
            targetFile = File.createTempFile("ifix", ".jar", installTempDir);
        } else if (resource.getType().equals((Object)ResourceType.PRODUCTSAMPLE)) {
            targetFile = File.createTempFile("sample", ".jar", installTempDir);
        } else if (resource.getType().equals((Object)ResourceType.OPENSOURCE)) {
            targetFile = File.createTempFile("osi", ".jar", installTempDir);
        } else {
            return null;
        }
        try {
            new InputStreamFileWriter(resource.getMainAttachment().getInputStream()).writeToFile(targetFile);
        }
        catch (RepositoryBadDataException e) {
            InstallUtils.delete(targetFile);
            throw e;
        }
        catch (RepositoryBackendException e) {
            InstallUtils.delete(targetFile);
            throw e;
        }
        catch (RepositoryResourceException e) {
            InstallUtils.delete(targetFile);
            throw e;
        }
        InstallUtils.validateDownloaded(targetFile, resource);
        return targetFile;
    }

    public static void download(URL url, File targetFile) throws IOException {
        InstallUtils.download(url.openStream(), targetFile);
    }

    public static void download(InputStream is, File targetFile) throws IOException {
        new InputStreamFileWriter(is).writeToFile(targetFile);
    }

    public static boolean deleteZipEntry(File zipFile, Set<String> files) throws IOException {
        File tempFile = File.createTempFile(zipFile.getName(), null);
        InstallUtils.delete(tempFile);
        if (!zipFile.renameTo(tempFile)) {
            return false;
        }
        byte[] buf = new byte[1024];
        ZipInputStream zin = new ZipInputStream(new FileInputStream(tempFile));
        ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(zipFile));
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            boolean toBeDeleted = false;
            for (String f : files) {
                if (!f.equals(entry.getName())) continue;
                toBeDeleted = true;
                break;
            }
            if (!toBeDeleted) {
                int len;
                ZipEntry newEntry = new ZipEntry(entry.getName());
                newEntry.setTime(entry.getTime());
                zout.putNextEntry(newEntry);
                while ((len = zin.read(buf)) > 0) {
                    zout.write(buf, 0, len);
                }
            }
            entry = zin.getNextEntry();
        }
        InstallUtils.close(zin);
        InstallUtils.close(zout);
        InstallUtils.delete(tempFile);
        return true;
    }

    public static String getRelativePath(File baseDir, File file) {
        String installRoot = baseDir.getAbsolutePath().replace("\\", "/");
        String fileRelativePath = file.getAbsolutePath().replace("\\", "/");
        fileRelativePath = fileRelativePath.replace(installRoot + "/", "");
        return fileRelativePath;
    }

    public static String getFileContents(File file) throws IOException {
        if (file != null) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            byte[] s = null;
            s = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(s);
            randomAccessFile.close();
            return new String(s);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateFingerprint(File baseDir) throws IOException {
        java.io.FileWriter fw = null;
        try {
            File f = new File(baseDir, "lib/versions/service.fingerprint");
            fw = new java.io.FileWriter(f, false);
            String data = "" + System.nanoTime();
            fw.append(data);
        }
        catch (Throwable throwable) {
            InstallUtils.close(fw);
            throw throwable;
        }
        InstallUtils.close(fw);
    }

    public static File canRename(List<File> files) {
        for (File f : files) {
            if (f.renameTo(f)) continue;
            return f;
        }
        return null;
    }

    public static boolean canRename(File file) {
        return !file.exists() || file.renameTo(file);
    }

    public static void isFileLocked(String msgKey, String fix, File f) throws InstallException {
        if (!InstallUtils.canRename(f)) {
            for (int i = 0; i < 3; ++i) {
                try {
                    Thread.sleep(1000L);
                    logger.log(Level.FINEST, "Slept a second for the system to unlock " + f.getAbsolutePath());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!InstallUtils.canRename(f)) continue;
                return;
            }
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(msgKey, fix, f.getAbsolutePath()));
        }
    }

    public static boolean isFileSame(File targetFile, String symbolicName, Version version, String inputChecksum) {
        String targetFileName = targetFile.getAbsolutePath();
        if ((targetFileName = targetFileName.replace("\\", "/")).contains("/lib/features/l10n/") || targetFileName.contains("/lafiles/") || targetFileName.contains("/checksums/")) {
            return true;
        }
        if (inputChecksum != null) {
            try {
                String fileMD5 = HashUtils.getFileMD5String((File)targetFile);
                return fileMD5.equals(inputChecksum);
            }
            catch (IOException e) {
                logger.log(Level.FINEST, "Failed to get md5 for " + targetFile.getAbsolutePath(), e);
            }
        }
        return false;
    }

    public static File download(RepositoryResource resource, File targetDirectory) throws IOException, RepositoryResourceException, RepositoryBackendException, InstallException {
        File targetFile = null;
        String name = null;
        if (resource.getType().equals((Object)ResourceType.FEATURE)) {
            name = ((EsaResource)resource).getProvideFeature();
            targetFile = new File(targetDirectory, name + ".esa");
        } else if (resource.getType().equals((Object)ResourceType.IFIX)) {
            name = resource.getName();
            targetFile = new File(targetDirectory, name + ".jar");
        } else {
            return null;
        }
        if (targetFile.exists()) {
            throw new InstallException(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.file.exists", targetFile), 25);
        }
        new InputStreamFileWriter(resource.getMainAttachment().getInputStream()).writeToFile(targetFile);
        InstallUtils.validateDownloaded(targetFile, resource);
        return targetFile;
    }

    public static Collection<String> getShortNames(Map<String, ProvisioningFeatureDefinition> installedFeatures, Collection<String> featureNames) {
        ArrayList<String> shortNames = new ArrayList<String>(featureNames.size());
        for (String featureName : featureNames) {
            String shortFeatureName = null;
            for (ProvisioningFeatureDefinition pfd : installedFeatures.values()) {
                String ibmShortName = InstallUtils.getShortName(pfd);
                if (ibmShortName == null || !ibmShortName.equalsIgnoreCase(featureName)) continue;
                shortFeatureName = ibmShortName;
                break;
            }
            shortNames.add(shortFeatureName == null ? featureName : shortFeatureName);
        }
        return shortNames;
    }

    public static void wordWrap(StringBuffer sb, String line, String indentStr) {
        if (line.length() == 0) {
            return;
        }
        String indent = "";
        int begin = 0;
        while (begin < line.length()) {
            int tryEnd;
            int end;
            if (begin + 72 >= line.length()) {
                sb.append(indent);
                sb.append(line.substring(begin));
                sb.append("\n");
                break;
            }
            for (end = tryEnd = Math.min(line.length(), begin + 72); end > begin && !Character.isWhitespace(line.charAt(end - 1)); --end) {
            }
            while (end > begin && Character.isWhitespace(line.charAt(end - 1))) {
                --end;
            }
            if (end == begin) {
                for (end = tryEnd; end < line.length() && !Character.isWhitespace(line.charAt(end)); ++end) {
                }
            }
            sb.append(indent);
            sb.append(line.substring(begin, end));
            sb.append("\n");
            indent = indentStr;
            for (begin = end; begin < line.length() && Character.isWhitespace(line.charAt(begin)); ++begin) {
            }
        }
    }

    public static String getShortName(ProvisioningFeatureDefinition fd) {
        String prefix;
        String shortName = fd.getIbmShortName();
        if (shortName != null) {
            return shortName;
        }
        shortName = fd.getHeader("IBM-ShortName");
        if (shortName != null) {
            return shortName;
        }
        String symbolicName = fd.getSymbolicName();
        if (symbolicName.startsWith(prefix = "com.ibm.websphere.appserver.")) {
            return symbolicName.substring(prefix.length());
        }
        return null;
    }

    public static Set<String> getFeatures(String serverXml, String xml, Set<String> visitedServerXmls) throws IOException {
        Path realServerXml;
        HttpURLConnection conn;
        boolean isUrl;
        ArrayList<String> newLocations;
        HashSet<String> features;
        block22: {
            features = new HashSet<String>();
            newLocations = new ArrayList<String>();
            isUrl = false;
            conn = null;
            realServerXml = null;
            try {
                URL url = new URL(serverXml);
                conn = (HttpURLConnection)url.openConnection();
                isUrl = true;
            }
            catch (MalformedURLException malf) {
                realServerXml = Paths.get(serverXml, new String[0]).normalize();
                if (!visitedServerXmls.contains(realServerXml.toString())) break block22;
                return features;
            }
        }
        try (InputStream is = isUrl ? conn.getInputStream() : Files.newInputStream(realServerXml, new OpenOption[0]);){
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            Element element = doc.getDocumentElement();
            NodeList childs = doc.getChildNodes();
            HashMap<String, String> varMap = new HashMap<String, String>();
            NodeList varList = element.getElementsByTagName("variable");
            for (int j = 0; j < varList.getLength(); ++j) {
                Node vl = varList.item(j);
                Element vlElement = (Element)vl;
                String varName = vlElement.getAttribute("name");
                String varVal = vlElement.getAttribute("value").isEmpty() ? vlElement.getAttribute("defaultValue") : vlElement.getAttribute("value");
                varMap.put(varName, varVal);
            }
            ConfigParser cp = new ConfigParser(realServerXml, varMap);
            NodeList includeList = element.getElementsByTagName("include");
            for (int i = 0; i < includeList.getLength(); ++i) {
                File f;
                Node il = includeList.item(i);
                Element ilElement = (Element)il;
                String location = ilElement.getAttribute("location");
                if (ilElement.getAttribute("optional").equals("false") || ilElement.getAttribute("optional").isEmpty()) {
                    isOptional = false;
                }
                if (!(f = new File(location)).isAbsolute()) {
                    if (!isUrl && location.contains("${")) {
                        location = cp.resolvePath(location);
                    } else {
                        String string = location = isUrl ? location : new File(realServerXml.getParent().toFile(), location).getCanonicalPath();
                    }
                }
                if (newLocations.contains(location) || visitedServerXmls.contains(location)) continue;
                newLocations.add(location);
            }
            NodeList fmList = element.getElementsByTagName("featureManager");
            for (int i = 0; i < fmList.getLength(); ++i) {
                Node fm = fmList.item(i);
                Element fmElement = (Element)fm;
                NodeList fList = fmElement.getElementsByTagName("feature");
                for (int j = 0; j < fList.getLength(); ++j) {
                    Node f = fList.item(j);
                    features.add(f.getTextContent().trim());
                }
            }
        }
        catch (Exception e) {
            if (!isOptional) {
                logger.log(Level.WARNING, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INVALID_SERVER_XML", xml, e.getMessage()));
            }
            logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INVALID_SERVER_XML", xml, e.getMessage()));
        }
        visitedServerXmls.add(isUrl ? serverXml : realServerXml.toString());
        for (String filepath : newLocations) {
            Path path = Paths.get(filepath, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                features.addAll(InstallUtils.getFeatures(path.toString(), path.getFileName().toString(), visitedServerXmls));
                continue;
            }
            if (isOptional) {
                logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INVALID_SERVER_XML", path));
                continue;
            }
            logger.log(Level.WARNING, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INVALID_SERVER_XML", path));
        }
        return features;
    }

    public static String getFeatureListOutput(Collection<String> featureList) {
        StringBuffer sb = new StringBuffer();
        for (String output : featureList) {
            sb.append(output + " ");
        }
        return sb.toString().trim();
    }

    public static void validateProductMatches(ProvisioningFeatureDefinition fd, File installDir) throws InstallException {
        String appliesToHeader = fd.getHeader("IBM-AppliesTo");
        List productMatchers = SelfExtractor.parseAppliesTo((String)appliesToHeader);
        String errMsg = ExceptionUtils.validateProductMatches(fd.getFeatureName(), productMatchers, installDir, false);
        if (!errMsg.isEmpty()) {
            throw ExceptionUtils.create(errMsg, 29);
        }
    }

    public static String getFeatureName(File esaFile) throws InstallException {
        if (!esaFile.exists()) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INSTALL_ESA_FILE_NOTEXIST", esaFile.getAbsolutePath()), 20);
        }
        if (esaFile.isDirectory()) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_DEPOLY_DIRECTORY", esaFile.getAbsolutePath()), 20);
        }
        try {
            SubsystemFeatureDefinitionImpl featureDefinition;
            String featureName;
            ZipFile zip = new ZipFile(esaFile);
            SubsytemEntry subsystemEntry = new SubsytemEntry(zip);
            ZipEntry zipEntry = subsystemEntry.getSubsystemEntry();
            if (zipEntry != null && (featureName = (featureDefinition = new SubsystemFeatureDefinitionImpl("usr", zip.getInputStream(zipEntry))).getSymbolicName()) != null && !featureName.isEmpty()) {
                InstallUtils.validateProductMatches((ProvisioningFeatureDefinition)featureDefinition, Utils.getInstallDir());
                return featureName;
            }
        }
        catch (IOException e) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INVALID_LOCAL_ESA", esaFile.getAbsolutePath()), 25);
        }
        throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INVALID_LOCAL_ESA", esaFile.getAbsolutePath()), 20);
    }

    public static boolean contains(Collection<RepositoryResource> mrList, RepositoryResource massiveResource) {
        for (RepositoryResource mr : mrList) {
            if (!(massiveResource instanceof EsaResource && mr instanceof EsaResource ? ((EsaResource)mr).getProvideFeature().equals(((EsaResource)massiveResource).getProvideFeature()) : massiveResource instanceof SampleResource && mr instanceof SampleResource && ((SampleResource)mr).getShortName().equalsIgnoreCase(((SampleResource)massiveResource).getShortName()))) continue;
            return true;
        }
        return false;
    }

    public static void log(List<? extends RepositoryResource> mrList) {
        for (RepositoryResource repositoryResource : mrList) {
            ResourceType type = repositoryResource.getType();
            String logMsg = type + ": ";
            if (ResourceType.FEATURE.equals((Object)type)) {
                logMsg = logMsg + ((EsaResource)repositoryResource).getProvideFeature();
            } else if (ResourceType.PRODUCTSAMPLE.equals((Object)type) || ResourceType.OPENSOURCE.equals((Object)type)) {
                logMsg = logMsg + ((SampleResource)repositoryResource).getShortName();
            }
            try {
                logMsg = logMsg + " is from " + repositoryResource.getRepositoryConnection().getRepositoryLocation();
                logMsg = logMsg + " at " + repositoryResource.getMainAttachment().getURL();
            }
            catch (Exception e) {
                logMsg = logMsg + " failed to get main attachment url: " + e.getMessage();
            }
            logger.log(Level.FINEST, logMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (Exception exception) {}
            }
            if (destination != null) {
                try {
                    destination.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void delete(final File f) {
        if (f != null && f.exists()) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (!f.delete()) {
                        logger.log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_CANNOT_DELETE_FILE", f.getAbsolutePath()));
                        f.deleteOnExit();
                    }
                    return null;
                }
            });
        }
    }

    public static FileInputStream getFileIputStream(final File file) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getCause();
        }
    }

    public static long getFileLength(final File file) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() throws FileNotFoundException {
                    return file.length();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getCause();
        }
    }

    public static URL getNewURL(final String string) throws MalformedURLException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws MalformedURLException {
                    return new URL(string);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (MalformedURLException)e.getCause();
        }
    }

    public static String getSystemProperty(final String string) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string);
            }
        });
    }

    public static boolean isFileExist(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        });
    }

    public static boolean isFileDirectory(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.isDirectory();
            }
        });
    }

    public static boolean mkDirs(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.mkdirs();
            }
        });
    }

    public static String[] list(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                return file.list();
            }
        });
    }

    public static File[] listFiles(final File f) {
        return AccessController.doPrivileged(new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return f.listFiles();
            }
        });
    }

    public static ZipFile createZipFile(final File f) throws ZipException, IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ZipFile>(){

                @Override
                public ZipFile run() throws IOException {
                    return new ZipFile(f);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof ZipException) {
                throw (ZipException)e.getCause();
            }
            throw (IOException)e.getCause();
        }
    }

    public static String getResourceId(RepositoryResource resource) {
        String shortName;
        if (resource instanceof EsaResource) {
            EsaResource esa = (EsaResource)resource;
            String shortName2 = esa.getShortName();
            if (shortName2 != null) {
                return shortName2;
            }
            return esa.getProvideFeature();
        }
        if (resource instanceof SampleResource && (shortName = ((SampleResource)resource).getShortName()) != null) {
            return shortName;
        }
        return resource.getName();
    }

    public static String getResourceName(RepositoryResource resource) {
        if (resource instanceof EsaResource) {
            EsaResource esa = (EsaResource)resource;
            if (esa.getVisibility() == Visibility.INSTALL) {
                return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("ADDON_ASSET", new Object[0]);
            }
            return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("FEATURE_ASSET", new Object[0]);
        }
        if (resource instanceof SampleResource) {
            if (resource.getType() == ResourceType.PRODUCTSAMPLE) {
                return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("SAMPLE_ASSET", new Object[0]);
            }
            if (resource.getType() == ResourceType.OPENSOURCE) {
                return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("OPENSOURCE_ASSET", new Object[0]);
            }
        }
        return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("GENERAL_ASSET", new Object[0]);
    }

    public static void validateDownloaded(File f, RepositoryResource installResource) throws InstallException {
        if (f == null || !f.exists() || installResource == null) {
            return;
        }
        String rSHA256 = installResource.getMainAttachmentSHA256();
        logger.log(Level.FINEST, "Resource SHA256: " + rSHA256);
        if (rSHA256 != null) {
            String fSHA256 = null;
            try {
                fSHA256 = HashUtils.getFileSHA256String((File)f);
            }
            catch (IOException e) {
                String msgKey = null;
                if (installResource.getType().equals((Object)ResourceType.FEATURE)) {
                    msgKey = "ERROR_INVALID_ESA";
                } else if (installResource.getType().equals((Object)ResourceType.IFIX)) {
                    msgKey = "ERROR_INVALID_IFIX";
                } else if (installResource.getType().equals((Object)ResourceType.PRODUCTSAMPLE)) {
                    msgKey = "ERROR_INVALID_SAMPLE";
                } else if (installResource.getType().equals((Object)ResourceType.OPENSOURCE)) {
                    msgKey = "ERROR_INVALID_OPENSOURCE";
                }
                if (msgKey == null) {
                    logger.log(Level.FINEST, "Invalid unknown asset: " + InstallUtils.getResourceId(installResource));
                }
                throw ExceptionUtils.createByKey(e, msgKey, InstallUtils.getResourceId(installResource));
            }
            logger.log(Level.FINEST, "Downloaded file SHA256: " + fSHA256);
            if (!rSHA256.equals(fSHA256)) {
                throw ExceptionUtils.createByKey("ERROR_DOWNLOADED_ASSET_INVALID_CHECKSUM", InstallUtils.getResourceId(installResource), InstallUtils.getResourceName(installResource));
            }
        }
    }

    public static boolean isResourceExistsInDirectory(RepositoryResource installResource, File repoDir, String mainAttachmentName, String jsonFileName) {
        String type = installResource.getType().getURLForType();
        String version = RepositoryDownloadUtil.getProductVersion(installResource);
        File assetDir = new File(new File(repoDir, type), version);
        File mainFile = new File(assetDir, mainAttachmentName);
        File jsonFile = new File(assetDir, jsonFileName);
        logger.log(Level.FINEST, "isResourceExistsInDirectory mainFile " + mainFile.getAbsolutePath() + (mainFile.exists() ? " exists" : " does not exist"));
        logger.log(Level.FINEST, "isResourceExistsInDirectory jsonFile " + jsonFile.getAbsolutePath() + (jsonFile.exists() ? " exists" : " does not exist"));
        if (!mainFile.exists() || !jsonFile.exists()) {
            return false;
        }
        String rSHA256 = installResource.getMainAttachmentSHA256();
        logger.log(Level.FINEST, "isResourceExistsInDirectory remote resource SHA256: " + rSHA256);
        if (rSHA256 == null) {
            return true;
        }
        try {
            Asset asset = JSONAssetConverter.readValue((InputStream)InstallUtils.getFileIputStream(jsonFile));
            WlpInformation info = asset.getWlpInformation();
            String fSHA256 = info.getMainAttachmentSHA256();
            logger.log(Level.FINEST, "isResourceExistsInDirectory SHA256 from local json: " + fSHA256);
            if (fSHA256 == null) {
                fSHA256 = HashUtils.getFileSHA256String((File)mainFile);
                logger.log(Level.FINEST, "isResourceExistsInDirectory SHA256 from local main: " + fSHA256);
            }
            return rSHA256.equals(fSHA256);
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "isResourceExistsInDirectory failed to compare checksums", e);
            return true;
        }
    }

    public static boolean isURL(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            logger.log(Level.FINEST, "The string " + url + " is not an url.", e);
            return false;
        }
    }

    public static boolean isDirectoryBasedRepository(RepositoryResource installResource) {
        RepositoryConnection connection = installResource.getRepositoryConnection();
        return connection instanceof DirectoryRepositoryConnection;
    }

    public static File getFileDirectoryBasedRepository(RepositoryResource installResource) throws InstallException {
        RepositoryConnection connection = installResource.getRepositoryConnection();
        if (connection instanceof DirectoryRepositoryConnection) {
            String mainAttachmentName;
            AttachmentResource mainAttachment = null;
            try {
                mainAttachment = installResource.getMainAttachment();
            }
            catch (Exception e) {
                logger.log(Level.FINEST, "Failed to get main attachment for " + installResource.getName(), e);
                return null;
            }
            if (mainAttachment != null && (mainAttachmentName = mainAttachment.getName()) != null) {
                DirectoryRepositoryConnection dirRepoConnection = (DirectoryRepositoryConnection)connection;
                String type = installResource.getType().getURLForType();
                String version = RepositoryDownloadUtil.getProductVersion(installResource);
                String repoDir = dirRepoConnection.getRepositoryLocation();
                File assetDir = new File(new File(repoDir, type), version);
                File mainFile = new File(assetDir, mainAttachmentName);
                logger.log(Level.FINEST, "getFileDirectoryBasedRepository mainFile " + mainFile.getAbsolutePath() + (mainFile.exists() ? " exists" : " does not exist"));
                if (mainFile.exists()) {
                    InstallUtils.validateDownloaded(mainFile, installResource);
                    return mainFile;
                }
            }
        }
        return null;
    }

    public static String getEditionName(File installRoot, String editionCode) {
        String editionCodeUpperCase = editionCode.toUpperCase();
        if (editionCodeUpperCase.equals("OPEN") || editionCodeUpperCase.equals("OPEN_WEB")) {
            editionCodeUpperCase = new Product(installRoot).getProductEdition().toUpperCase();
        }
        return InstallUtils.getEditionName(editionCodeUpperCase);
    }

    public static String getEditionName(String editionCode) {
        String editionCodeUpperCase = editionCode.toUpperCase();
        if (editionCodeUpperCase.equals("BASE")) {
            return "Base";
        }
        if (editionCodeUpperCase.equals("BASE_ILAN")) {
            return "(ILAN)";
        }
        if (editionCodeUpperCase.equals("DEVELOPERS")) {
            return "for Developers";
        }
        if (editionCodeUpperCase.equals("EXPRESS")) {
            return "- Express";
        }
        if (editionCodeUpperCase.equals("EARLY_ACCESS")) {
            return "Early Access";
        }
        if (editionCodeUpperCase.equals("LIBERTY_CORE")) {
            return "Liberty Core";
        }
        if (editionCodeUpperCase.equals("ND")) {
            return "Network Deployment";
        }
        if (editionCodeUpperCase.equals("ZOS")) {
            return "z/OS";
        }
        if (editionCodeUpperCase.equals("LIBERTY")) {
            return "Base";
        }
        if (editionCodeUpperCase.startsWith("LIBERTY ")) {
            return editionCode.substring("LIBERTY ".length());
        }
        return editionCode;
    }

    public static boolean containsIgnoreCase(Collection<String> assetNames, String name) {
        for (String assetName : assetNames) {
            if (!assetName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private static void putAssetToMap(Map<String, Collection<String>> assetsMap, String key, String value) {
        Collection<String> assets = assetsMap.get(key);
        if (assets == null) {
            assets = new ArrayList<String>();
            assetsMap.put(key, assets);
        }
        assets.add(value);
    }

    private static boolean isValidExtension(String extensionId) {
        if ("usr".equalsIgnoreCase(extensionId)) {
            return true;
        }
        List extensions = ProductExtension.getProductExtensions();
        if (extensions != null) {
            for (ProductExtensionInfo extension : extensions) {
                if (!extension.getProductID().equals(extensionId)) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<String, Collection<String>> getAssetsMap(Collection<String> assetNames, boolean download) throws InstallException {
        HashMap<String, Collection<String>> assetsMap = new HashMap<String, Collection<String>>();
        for (String assetName : assetNames) {
            if (assetName.contains(":")) {
                String[] asset = assetName.split(":", 2);
                String target = asset[0].trim();
                String aName = asset[1].trim();
                if (target.isEmpty()) {
                    if (aName.isEmpty()) {
                        logger.log(Level.FINEST, ": is an invalid asset name and is ignored.");
                        continue;
                    }
                    InstallUtils.putAssetToMap(assetsMap, DEFAULT_TO_EXTENSION, assetName);
                    continue;
                }
                if (aName.isEmpty()) {
                    logger.log(Level.FINEST, assetName + " is an invalid asset name and is ignored.");
                    continue;
                }
                if (!download && !InstallUtils.isValidExtension(target)) {
                    throw ExceptionUtils.createByKey("ERROR_EXTENSION_FROM_ASSETID_NOT_FOUND", aName, target);
                }
                InstallUtils.putAssetToMap(assetsMap, target, aName);
                continue;
            }
            InstallUtils.putAssetToMap(assetsMap, DEFAULT_TO_EXTENSION, assetName);
        }
        return assetsMap;
    }

    public static String toExtension(String target, String defaultTarget) {
        if (target.equalsIgnoreCase(DEFAULT_TO_EXTENSION)) {
            return defaultTarget;
        }
        return target;
    }

    public static Set<InstallLicense> getLicenseToAccept(Set<InstallLicense> featureLicenses) throws ProductInfoParseException, DuplicateProductInfoException, ProductInfoReplaceException {
        Set<InstallLicense> licensesToAccept = featureLicenses;
        boolean isNDRuntime = false;
        for (ProductInfo productInfo : ProductInfo.getAllProductInfo().values()) {
            if (!"com.ibm.websphere.appserver".equals(productInfo.getId()) || !"ND".equals(productInfo.getEdition())) continue;
            isNDRuntime = true;
            break;
        }
        Iterator<InstallLicense> iterator = licensesToAccept.iterator();
        while (iterator.hasNext()) {
            InstallLicense license = iterator.next();
            if (license == null || !license.getId().startsWith("https://www.eclipse.org/legal/epl-") && !license.getId().equals("http://www.ibm.com/licenses/wlp-featureterms-v1") && (!isNDRuntime || !license.getId().equals("http://www.ibm.com/licenses/wlp-featureterms-restricted-v1"))) continue;
            iterator.remove();
        }
        return licensesToAccept;
    }

    public static void setServerXmlInstallTrue() {
        isServerXmlInstallation = true;
    }

    public static boolean isServerXmlInstall() {
        return isServerXmlInstallation;
    }

    public static class InputStreamFileWriter
    implements FileWriter {
        private final InputStream inputStream;
        private final String charsetName;

        public InputStreamFileWriter(InputStream inputStream) {
            this(inputStream, null);
        }

        public InputStreamFileWriter(InputStream inputStream, String charsetName) {
            this.inputStream = inputStream;
            this.charsetName = null == charsetName || charsetName.isEmpty() ? null : charsetName;
        }

        @Override
        public void writeToFile(File fileToWrite) throws IOException {
            if (null == this.charsetName) {
                this.write(fileToWrite);
            } else {
                this.writeAndConvertFile(fileToWrite, null);
            }
        }

        @Override
        public void writeToFile(File fileToWrite, String charsetName) throws IOException {
            if (null != charsetName && !charsetName.isEmpty()) {
                this.writeAndConvertFile(fileToWrite, charsetName);
            } else {
                this.writeToFile(fileToWrite);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void write(final File fileToWrite) throws IOException {
            FileOutputStream fOut = null;
            try {
                int len;
                try {
                    fOut = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                        @Override
                        public FileOutputStream run() throws FileNotFoundException {
                            return new FileOutputStream(fileToWrite);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new IOException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNABLE_TO_CREATE_FILE", fileToWrite.getAbsolutePath()), e);
                }
                byte[] buffer = new byte[4096];
                while ((len = this.inputStream.read(buffer)) != -1) {
                    fOut.write(buffer, 0, len);
                }
                fOut.close();
                this.inputStream.close();
            }
            catch (Throwable throwable) {
                InstallUtils.close(fOut);
                InstallUtils.close(this.inputStream);
                throw throwable;
            }
            InstallUtils.close(fOut);
            InstallUtils.close(this.inputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeAndConvertFile(File fileToWrite, String toCharsetName) throws IOException {
            OutputStreamWriter fWriter = null;
            BufferedReader bReader = null;
            try {
                int read;
                fWriter = null == toCharsetName ? new OutputStreamWriter(new FileOutputStream(fileToWrite)) : new OutputStreamWriter((OutputStream)new FileOutputStream(fileToWrite), toCharsetName);
                bReader = null == this.charsetName ? new BufferedReader(new InputStreamReader(this.inputStream)) : new BufferedReader(new InputStreamReader(this.inputStream, this.charsetName));
                char[] buf = new char[4096];
                while ((read = bReader.read(buf)) != -1) {
                    ((Writer)fWriter).write(buf, 0, read);
                }
            }
            catch (Throwable throwable) {
                InstallUtils.close(fWriter);
                InstallUtils.close(bReader);
                throw throwable;
            }
            InstallUtils.close(fWriter);
            InstallUtils.close(bReader);
        }
    }

    public static class InstallCommandConsole
    implements CommandConsole {
        public boolean isInputStreamAvailable() {
            return false;
        }

        public String readMaskedText(String prompt) {
            return null;
        }

        public String readText(String prompt) {
            return null;
        }

        public void printInfoMessage(String message) {
        }

        public void printlnInfoMessage(String message) {
        }

        public void printErrorMessage(String errorMessage) {
        }

        public void printlnErrorMessage(String errorMessage) {
        }
    }

    public static class OutputStreamCopier
    implements Runnable {
        private final InputStream in;
        private final StringBuffer output;

        public OutputStreamCopier(InputStream in, StringBuffer output) {
            this.in = in;
            this.output = output;
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
                while ((line = reader.readLine()) != null) {
                    this.output.append(line);
                    this.output.append("\n");
                }
            }
            catch (IOException ex) {
                throw new Error(ex);
            }
        }
    }

    public static interface FileWriter {
        public void writeToFile(File var1) throws IOException;

        public void writeToFile(File var1, String var2) throws IOException;
    }
}

