/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.cmdline;

import com.ibm.ws.install.InstallKernel;
import com.ibm.ws.install.InstallKernelFactory;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.kernel.boot.cmdline.ActionHandler;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.feature.internal.cmdline.ReturnCode;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import wlp.lib.extract.SelfExtract;

public class ExeUninstallAction
implements ActionHandler {
    public ReturnCode handleTask(PrintStream stdout, PrintStream stderr, Arguments args) {
        InstallLogUtils.getInstallLogger().log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_STABILIZING_FEATUREMANAGER", "uninstall") + "\n");
        HashSet featureRaw = new HashSet(args.getPositionalArguments());
        ArrayList<String> features = new ArrayList<String>();
        for (String s : featureRaw) {
            String[] temp = s.split(",");
            features.addAll(Arrays.asList(temp));
        }
        String cmdLineOption = args.getOption("noprompts");
        boolean noInteractive = cmdLineOption != null && (cmdLineOption.isEmpty() || Boolean.valueOf(cmdLineOption) != false);
        cmdLineOption = args.getOption("force");
        boolean forceUninstall = cmdLineOption != null && (cmdLineOption.isEmpty() || Boolean.valueOf(cmdLineOption) != false);
        InstallKernel installKernel = InstallKernelFactory.getInstance();
        if (forceUninstall && features.size() > 1) {
            InstallLogUtils.getInstallLogger().log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INVALID_NUMBER_OF_FEATURES_FORCE_UNINSTALL", new Object[0]));
            return ReturnCode.BAD_ARGUMENT;
        }
        try {
            if (forceUninstall) {
                installKernel.uninstallFeaturePrereqChecking(features.get(0), true, forceUninstall);
            } else {
                installKernel.uninstallFeaturePrereqChecking(features);
            }
            if (!noInteractive && !SelfExtract.getResponse((String)InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("TOOL_UNININSTALL_FEATURE_CONFIRMATION", new Object[0]), (String)"", (String)"Xx")) {
                return ReturnCode.OK;
            }
            if (forceUninstall) {
                installKernel.uninstallFeature(features.get(0), forceUninstall);
            } else {
                installKernel.uninstallFeature(features);
            }
        }
        catch (Exception e) {
            InstallLogUtils.getInstallLogger().log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNINSTALL_FEATURE_INVALID_META_DATA", InstallUtils.getFeatureListOutput(features)), e);
            InstallLogUtils.getInstallLogger().log(Level.SEVERE, e.getMessage(), e);
            return ReturnCode.RUNTIME_EXCEPTION;
        }
        InstallLogUtils.getInstallLogger().log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("TOOL_UNINSTALL_FEATURE_OK", InstallUtils.getFeatureListOutput(features)).replaceAll("CWWKF1350I:", "").trim());
        return ReturnCode.OK;
    }
}

