/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.bouncycastle.internal.asn1.cms.GCMParameters;
import org.bouncycastle.jcajce.provider.symmetric.util.GcmSpecUtil;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;

public class JceAEADCipherUtil {
    static void setUpAeadCipher(Cipher cipher, SecretKey secretKey, int n, byte[] byArray, int n2, byte[] byArray2) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (GcmSpecUtil.gcmSpecExtractable()) {
            AlgorithmParameterSpec algorithmParameterSpec;
            try {
                algorithmParameterSpec = GcmSpecUtil.extractGcmSpec(new GCMParameters(byArray, (n2 + 7) / 8).toASN1Primitive());
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException(invalidParameterSpecException.getMessage());
            }
            cipher.init(n, (Key)secretKey, algorithmParameterSpec);
            cipher.updateAAD(byArray2);
        } else {
            AEADParameterSpec aEADParameterSpec = new AEADParameterSpec(byArray, n2, byArray2);
            cipher.init(n, (Key)secretKey, (AlgorithmParameterSpec)aEADParameterSpec);
        }
    }
}

