/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.jmx.service;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public final class VirtualMachineHelper {
    public static String getPID() {
        return PIDHolder.PID;
    }

    public static Object getVirtualMachine() {
        if (VirtualMachineHelper.getPID() == null) {
            return null;
        }
        Object vm = VirtualMachineHolder.virtualMachine;
        if (vm != null) {
            return vm;
        }
        RuntimeException exception = VirtualMachineHolder.error;
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    public static Method getRemoteDumpMethod() {
        if (VirtualMachineHelper.getPID() == null) {
            return null;
        }
        Method dumpMethod = VirtualMachineHolder.remoteDataDumpMethod;
        if (dumpMethod != null) {
            return dumpMethod;
        }
        RuntimeException exception = VirtualMachineHolder.error;
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    private static final class PIDHolder {
        static final String PID;

        private PIDHolder() {
        }

        static {
            String pid = null;
            String name = ManagementFactory.getRuntimeMXBean().getName();
            int index = name.indexOf(64);
            if (index >= 0 && !(pid = name.substring(0, index)).matches("[0-9]+")) {
                pid = null;
            }
            PID = pid;
        }
    }

    private static final class VirtualMachineHolder {
        static final Object virtualMachine;
        static final Method remoteDataDumpMethod;
        static final RuntimeException error;

        private VirtualMachineHolder() {
        }

        private static File getToolsJar() {
            String javaHome = System.getProperty("java.home");
            File file = new File(javaHome, "../lib/tools.jar");
            if (!file.exists() && !(file = new File(javaHome, "lib/tools.jar")).exists()) {
                return null;
            }
            return file;
        }

        static {
            ClassLoader toolsClassLoader;
            File toolsJar = VirtualMachineHolder.getToolsJar();
            if (toolsJar == null) {
                toolsClassLoader = VirtualMachineHelper.class.getClassLoader();
            } else {
                try {
                    toolsClassLoader = new URLClassLoader(new URL[]{toolsJar.getAbsoluteFile().toURI().toURL()});
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            Object vm = null;
            Method dumpMethod = null;
            RuntimeException ex = null;
            try {
                Class<?> vmClass = toolsClassLoader.loadClass("com.sun.tools.attach.VirtualMachine");
                Method attachMethod = vmClass.getMethod("attach", String.class);
                vm = attachMethod.invoke(null, VirtualMachineHelper.getPID());
                dumpMethod = vm.getClass().getMethod("remoteDataDump", Object[].class);
            }
            catch (ClassNotFoundException vmClass) {
            }
            catch (Exception e) {
                ex = new RuntimeException(e);
            }
            virtualMachine = vm;
            remoteDataDumpMethod = dumpMethod;
            error = ex == null ? null : new RuntimeException(ex);
        }
    }
}

