/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.cds;

import com.ibm.oti.shared.HelperAlreadyDefinedException;
import com.ibm.oti.shared.Shared;
import com.ibm.oti.shared.SharedClassHelperFactory;
import com.ibm.oti.shared.SharedClassURLHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.osgi.internal.cds.CDSBundleFile;
import org.eclipse.osgi.internal.cds.CDSHookConfigurator;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.hookregistry.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.eclipse.osgi.internal.hookregistry.HookRegistry;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.internal.loader.classpath.ClasspathEntry;
import org.eclipse.osgi.internal.loader.classpath.ClasspathManager;
import org.eclipse.osgi.internal.loader.classpath.FragmentClasspath;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.ContentProvider;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapper;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapperChain;

public class CDSHookImpls
extends ClassLoaderHook
implements BundleFileWrapperFactoryHook {
    private static SharedClassHelperFactory factory = Shared.getSharedClassHelperFactory();
    private final Debug debug;

    public CDSHookImpls(Debug debug) {
        this.debug = debug;
    }

    private static CDSBundleFile getCDSBundleFile(BundleFile bundleFile) {
        if (bundleFile instanceof BundleFileWrapperChain) {
            return ((BundleFileWrapperChain)bundleFile).getWrappedType(CDSBundleFile.class);
        }
        return null;
    }

    @Override
    public void recordClassDefine(String name, Class<?> clazz, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        if (null == clazz) {
            CDSHookConfigurator.print(this.debug, () -> "No class to store: " + name);
            return;
        }
        if (!this.hasMagicClassNumber(classbytes)) {
            CDSHookConfigurator.print(this.debug, () -> "Class was already stored: " + name);
            return;
        }
        CDSBundleFile cdsFile = CDSHookImpls.getCDSBundleFile(classpathEntry.getBundleFile());
        if (null == cdsFile) {
            CDSHookConfigurator.print(this.debug, () -> "No CDSBundleFile for class: " + name);
            return;
        }
        try {
            byte[] originalClassBytes = entry.getBytes();
            if (originalClassBytes != classbytes) {
                boolean modified = false;
                modified = originalClassBytes.length == classbytes.length ? !Arrays.equals(classbytes, originalClassBytes) : true;
                if (modified) {
                    CDSHookConfigurator.print(this.debug, () -> "class bytes have changed, cannot store.");
                    return;
                }
            }
        }
        catch (IOException e) {
            return;
        }
        if (null == cdsFile.getURL()) {
            return;
        }
        SharedClassURLHelper urlHelper = cdsFile.getURLHelper();
        if (urlHelper == null) {
            CDSBundleFile hostBundleFile = CDSHookImpls.getCDSBundleFile(manager.getGeneration().getBundleFile());
            if (null != hostBundleFile) {
                urlHelper = hostBundleFile.getURLHelper();
            }
            if (null != urlHelper) {
                cdsFile.setURLHelper(urlHelper);
            }
        }
        if (null != urlHelper) {
            boolean successStore = urlHelper.storeSharedClass(null, cdsFile.getURL(), clazz);
            CDSHookConfigurator.print(this.debug, () -> successStore ? "Stored class: " + name : "Failed to store class: " + name);
            cdsFile.setPrimed(true);
        } else {
            CDSHookConfigurator.print(this.debug, () -> "No helper found to store class: " + name);
        }
    }

    private boolean hasMagicClassNumber(byte[] classbytes) {
        if (classbytes == null || classbytes.length < 4) {
            return false;
        }
        return (classbytes[0] & 0xCA) == 202 && (classbytes[1] & 0xFE) == 254 && (classbytes[2] & 0xBA) == 186 && (classbytes[3] & 0xBE) == 190;
    }

    @Override
    public void classLoaderCreated(ModuleClassLoader classLoader) {
        if (factory == null) {
            return;
        }
        try {
            SharedClassURLHelper urlHelper = factory.getURLHelper((ClassLoader)classLoader);
            boolean minimizeUpdateChecks = urlHelper.setMinimizeUpdateChecks();
            CDSBundleFile hostFile = CDSHookImpls.getCDSBundleFile(classLoader.getClasspathManager().getGeneration().getBundleFile());
            if (hostFile != null) {
                hostFile.setURLHelper(urlHelper);
                if (minimizeUpdateChecks) {
                    hostFile.setPrimed(true);
                }
            }
            ClasspathManager cpManager = classLoader.getClasspathManager();
            for (ClasspathEntry entry : cpManager.getHostClasspathEntries()) {
                CDSBundleFile cdsBundleFile = CDSHookImpls.getCDSBundleFile(entry.getBundleFile());
                if (cdsBundleFile == null) continue;
                cdsBundleFile.setURLHelper(urlHelper);
                if (!minimizeUpdateChecks) continue;
                cdsBundleFile.setPrimed(true);
            }
            for (FragmentClasspath fragCP : cpManager.getFragmentClasspaths()) {
                for (ClasspathEntry entry : fragCP.getEntries()) {
                    CDSBundleFile cdsBundleFile = CDSHookImpls.getCDSBundleFile(entry.getBundleFile());
                    if (cdsBundleFile == null) continue;
                    cdsBundleFile.setURLHelper(urlHelper);
                    if (!minimizeUpdateChecks) continue;
                    cdsBundleFile.setPrimed(true);
                }
            }
        }
        catch (HelperAlreadyDefinedException helperAlreadyDefinedException) {
            // empty catch block
        }
    }

    @Override
    public boolean addClassPathEntry(ArrayList<ClasspathEntry> cpEntries, String cp, ClasspathManager hostmanager, BundleInfo.Generation sourceGeneration) {
        CDSBundleFile sourceFile;
        CDSBundleFile hostFile = CDSHookImpls.getCDSBundleFile(hostmanager.getGeneration().getBundleFile());
        if (hostFile != (sourceFile = CDSHookImpls.getCDSBundleFile(sourceGeneration.getBundleFile())) && null != hostFile && null != sourceFile) {
            SharedClassURLHelper urlHelper = hostFile.getURLHelper();
            sourceFile.setURLHelper(urlHelper);
            sourceFile.setPrimed(hostFile.getPrimed());
        }
        return false;
    }

    @Override
    public BundleFileWrapper wrapBundleFile(BundleFile bundleFile, BundleInfo.Generation generation, boolean base) {
        CDSBundleFile newBundleFile;
        if (generation.getContentType() == ContentProvider.Type.CONNECT) {
            return null;
        }
        if (!base && generation.getBundleInfo().getBundleId() != 0L) {
            SharedClassURLHelper urlHelper = null;
            BundleFile baseFile = generation.getBundleFile();
            if ((baseFile = CDSHookImpls.getCDSBundleFile(baseFile)) != null) {
                urlHelper = ((CDSBundleFile)baseFile).getURLHelper();
            }
            newBundleFile = new CDSBundleFile(bundleFile, this.debug, urlHelper);
        } else {
            newBundleFile = new CDSBundleFile(bundleFile, this.debug);
        }
        return newBundleFile;
    }

    void registerHooks(HookRegistry hookRegistry) {
        if (!Shared.isSharingEnabled()) {
            return;
        }
        hookRegistry.addClassLoaderHook(this);
        hookRegistry.addBundleFileWrapperFactoryHook(this);
    }
}

