/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver.internal.kernel;

import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import com.ibm.ws.repository.common.enums.FilterableAttribute;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.connections.ProductDefinition;
import com.ibm.ws.repository.connections.RepositoryConnectionList;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.resolver.internal.kernel.KernelResolverEsa;
import com.ibm.ws.repository.resources.ApplicableToProduct;
import com.ibm.ws.repository.resources.EsaResource;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.internal.RepositoryResourceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Version;

public class KernelResolverRepository
implements FeatureResolver.Repository {
    private Collection<ProvisioningFeatureDefinition> allFeatureCache;
    private final Map<String, List<ProvisioningFeatureDefinition>> symbolicNameToFeature = new HashMap<String, List<ProvisioningFeatureDefinition>>();
    private final Map<String, String> publicNameToSymbolicName = new HashMap<String, String>();
    private final List<ProvisioningFeatureDefinition> autoFeatures = new ArrayList<ProvisioningFeatureDefinition>();
    private final Map<String, Version> symbolicNameToPreferredVersion = new HashMap<String, Version>();
    private final Map<String, List<ApplicableToProduct>> nameToNonApplicableResources = new HashMap<String, List<ApplicableToProduct>>();
    private final Collection<ProductDefinition> productDefinitions;
    private final RepositoryConnectionList repositoryConnection;

    public KernelResolverRepository(Collection<ProductDefinition> productDefinitions, RepositoryConnectionList repositoryConnection) {
        this.repositoryConnection = repositoryConnection;
        this.productDefinitions = productDefinitions == null ? Collections.emptyList() : productDefinitions;
    }

    public void addFeatures(Collection<? extends EsaResource> esas) {
        for (EsaResource esaResource : esas) {
            this.addFeature(esaResource);
        }
    }

    public void addFeature(EsaResource esa) {
        KernelResolverEsa resolverEsa = new KernelResolverEsa(esa);
        this.addFeature(resolverEsa);
    }

    public void addInstalledFeatures(Collection<? extends ProvisioningFeatureDefinition> features) {
        for (ProvisioningFeatureDefinition provisioningFeatureDefinition : features) {
            this.addFeature(provisioningFeatureDefinition);
        }
    }

    public void addFeature(ProvisioningFeatureDefinition feature) {
        String symbolicName = feature.getSymbolicName();
        List features = this.symbolicNameToFeature.computeIfAbsent(symbolicName, useName -> new ArrayList());
        if (KernelResolverRepository.containsInstalledFeatures(features)) {
            return;
        }
        if (!(feature instanceof KernelResolverEsa)) {
            features.clear();
        } else if (KernelResolverRepository.containsDuplicate(features, feature)) {
            return;
        }
        features.add(feature);
        if (features.size() > 1) {
            Collections.sort(features, KernelResolverRepository::compare);
        }
        this.publicNameToSymbolicName.put(feature.getFeatureName().toLowerCase(), symbolicName);
        if (feature.getVisibility() == Visibility.PUBLIC || feature.getVisibility() == Visibility.INSTALL) {
            this.publicNameToSymbolicName.put(symbolicName.toLowerCase(), symbolicName);
            if (feature.getIbmShortName() != null) {
                this.publicNameToSymbolicName.put(feature.getIbmShortName().toLowerCase(), symbolicName);
            }
        }
        if (feature.isAutoFeature()) {
            this.autoFeatures.add(feature);
        }
        this.allFeatureCache = null;
    }

    private static int compare(ProvisioningFeatureDefinition o1, ProvisioningFeatureDefinition o2) {
        Version v1 = o1.getVersion();
        Version v2 = o2.getVersion();
        if (v1 == null) {
            if (v2 == null) {
                return 0;
            }
            return 1;
        }
        if (v2 == null) {
            return -1;
        }
        return -v1.compareTo(v2);
    }

    public Collection<ProvisioningFeatureDefinition> getAutoFeatures() {
        return Collections.unmodifiableList(this.autoFeatures);
    }

    public List<String> getConfiguredTolerates(String featureName) {
        return Collections.emptyList();
    }

    public List<ProvisioningFeatureDefinition> getFeatures() {
        int numFeatures = 0;
        for (List<ProvisioningFeatureDefinition> features : this.symbolicNameToFeature.values()) {
            numFeatures += features.size();
        }
        ArrayList<ProvisioningFeatureDefinition> allFeatures = new ArrayList<ProvisioningFeatureDefinition>(numFeatures);
        for (List<ProvisioningFeatureDefinition> features : this.symbolicNameToFeature.values()) {
            allFeatures.addAll(features);
        }
        return allFeatures;
    }

    public List<ProvisioningFeatureDefinition> select(FeatureResolver.Selector<ProvisioningFeatureDefinition> selector) {
        if (selector == null) {
            return this.getFeatures();
        }
        ArrayList<ProvisioningFeatureDefinition> selected = new ArrayList<ProvisioningFeatureDefinition>();
        for (List<ProvisioningFeatureDefinition> features : this.symbolicNameToFeature.values()) {
            for (ProvisioningFeatureDefinition feature : features) {
                if (!selector.test((Object)feature)) continue;
                selected.add(feature);
            }
        }
        return selected;
    }

    public ProvisioningFeatureDefinition getFeature(String featureName) {
        ProvisioningFeatureDefinition feature = this.getCachedFeature(featureName);
        if (feature == null) {
            this.cacheFeaturesForName(featureName);
            feature = this.getCachedFeature(featureName);
        }
        return feature;
    }

    private ProvisioningFeatureDefinition getCachedFeature(String featureName) {
        List<ProvisioningFeatureDefinition> featureList = this.symbolicNameToFeature.get(featureName);
        if (featureList == null && (featureName = this.publicNameToSymbolicName.get(featureName.toLowerCase())) != null) {
            featureList = this.symbolicNameToFeature.get(featureName);
        }
        if (featureList == null || featureList.isEmpty()) {
            return null;
        }
        return this.getPreferredVersion(featureName, featureList);
    }

    private void cacheFeaturesForName(String featureName) {
        if (this.nameToNonApplicableResources.containsKey(featureName)) {
            return;
        }
        if (this.repositoryConnection != null) {
            ArrayList<ApplicableToProduct> nonApplicable = new ArrayList<ApplicableToProduct>();
            for (RepositoryResource resource : this.getResourcesForName(featureName)) {
                if (!this.isApplicable(resource)) {
                    nonApplicable.add((ApplicableToProduct)resource);
                    continue;
                }
                if (resource.getType() != ResourceType.FEATURE) continue;
                this.addFeature((EsaResource)resource);
            }
            this.nameToNonApplicableResources.put(featureName, nonApplicable);
        }
    }

    private List<RepositoryResource> getResourcesForName(String resourceName) {
        ArrayList<RepositoryResource> results = new ArrayList<RepositoryResource>();
        try {
            results.addAll(this.repositoryConnection.getMatchingEsas(FilterableAttribute.SYMBOLIC_NAME, resourceName));
            results.addAll(this.repositoryConnection.getMatchingEsas(FilterableAttribute.LOWER_CASE_SHORT_NAME, resourceName.toLowerCase()));
            results.addAll(this.repositoryConnection.getMatchingSamples(FilterableAttribute.LOWER_CASE_SHORT_NAME, resourceName.toLowerCase()));
        }
        catch (RepositoryBackendException repositoryBackendException) {
            // empty catch block
        }
        return results;
    }

    private boolean isApplicable(RepositoryResource resource) {
        if (resource instanceof ApplicableToProduct && ((ApplicableToProduct)resource).getAppliesTo() == null) {
            return true;
        }
        return ((RepositoryResourceImpl)resource).doesResourceMatch(this.productDefinitions, null);
    }

    public Collection<ApplicableToProduct> getNonApplicableResourcesForName(String resourceName) {
        List<ApplicableToProduct> result = this.nameToNonApplicableResources.get(resourceName);
        if (result == null) {
            this.cacheFeaturesForName(resourceName);
            result = this.nameToNonApplicableResources.get(resourceName);
        }
        if (result == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableList(result);
    }

    public Collection<ProvisioningFeatureDefinition> getAllFeatures() {
        if (this.allFeatureCache == null) {
            ArrayList<ProvisioningFeatureDefinition> preferred = new ArrayList<ProvisioningFeatureDefinition>();
            this.symbolicNameToFeature.forEach((symbolicName, features) -> preferred.add(this.getPreferredVersion((String)symbolicName, (List<ProvisioningFeatureDefinition>)features)));
            this.allFeatureCache = preferred;
        }
        return this.allFeatureCache;
    }

    public void setPreferredVersion(String featureName, String version) {
        if (!this.symbolicNameToFeature.containsKey(featureName)) {
            featureName = this.publicNameToSymbolicName.get(featureName);
        }
        if (featureName != null) {
            try {
                Version v = Version.parseVersion((String)version);
                this.symbolicNameToPreferredVersion.put(featureName, v);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void clearPreferredVersions() {
        this.symbolicNameToPreferredVersion.clear();
    }

    private ProvisioningFeatureDefinition getPreferredVersion(String symbolicName, List<ProvisioningFeatureDefinition> featureList) {
        Version preferredVersion = this.symbolicNameToPreferredVersion.get(symbolicName);
        ProvisioningFeatureDefinition result = null;
        if (preferredVersion != null) {
            for (ProvisioningFeatureDefinition feature : featureList) {
                if (!preferredVersion.equals((Object)feature.getVersion())) continue;
                result = feature;
                break;
            }
        }
        if (result == null) {
            result = featureList.iterator().next();
        }
        return result;
    }

    private static boolean containsInstalledFeatures(List<ProvisioningFeatureDefinition> features) {
        for (ProvisioningFeatureDefinition feature : features) {
            if (feature instanceof KernelResolverEsa) continue;
            return true;
        }
        return false;
    }

    private static boolean containsDuplicate(List<ProvisioningFeatureDefinition> features, ProvisioningFeatureDefinition f1) {
        for (ProvisioningFeatureDefinition f2 : features) {
            if (!KernelResolverRepository.isDuplicate(f1, f2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDuplicate(ProvisioningFeatureDefinition f1, ProvisioningFeatureDefinition f2) {
        String f1Sym = f1.getSymbolicName();
        String f2Sym = f2.getSymbolicName();
        if (f1Sym == null ? f2Sym != null : f2Sym == null || !f1Sym.equals(f2Sym)) {
            return false;
        }
        Version f1Version = f1.getVersion();
        Version f2Version = f2.getVersion();
        if (f1Version == null) {
            return f2Version == null;
        }
        return f2Version != null && f1Version.equals((Object)f2Version);
    }
}

