/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.internal.classloader;

import com.ibm.ws.kernel.internal.classloader.DirectoryResourceEntry;
import com.ibm.ws.kernel.internal.classloader.JarFileClassLoader;
import com.ibm.ws.kernel.internal.classloader.ResourceEntry;
import com.ibm.ws.kernel.internal.classloader.ResourceHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Manifest;

public class DirectoryResourceHandler
implements ResourceHandler {
    private final File directory;
    private final String directoryPath;
    private URL url;
    private boolean manifestLoaded;
    private Manifest manifest;

    public DirectoryResourceHandler(File directory) {
        this.directory = directory;
        this.directoryPath = DirectoryResourceHandler.getCanonicalPath(directory);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public ResourceEntry getEntry(String name) {
        File file = new File(this.directory, name);
        if (file.exists() && DirectoryResourceHandler.getCanonicalPath(file).startsWith(this.directoryPath)) {
            return new DirectoryResourceEntry(this, file);
        }
        return null;
    }

    @Override
    public URL toURL() {
        if (this.url == null) {
            this.url = JarFileClassLoader.toURL(this.directory);
        }
        return this.url;
    }

    @Override
    public Manifest getManifest() throws IOException {
        if (!this.manifestLoaded) {
            File file = new File(this.directory, "META-INF/MANIFEST.MF");
            if (file.exists()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    this.manifest = new Manifest(in);
                }
                catch (Throwable throwable) {
                    JarFileClassLoader.close(in);
                    throw throwable;
                }
                JarFileClassLoader.close(in);
            }
            this.manifestLoaded = true;
        }
        return this.manifest;
    }

    @Override
    public Set<String> getClassPackages() {
        HashSet<String> packages = new HashSet<String>();
        StringBuilder sb = new StringBuilder();
        DirectoryResourceHandler.getPackages(this.directory, packages, sb);
        return packages;
    }

    private static void getPackages(File directory, Set<String> packages, StringBuilder sb) {
        File[] files = directory.listFiles();
        int builderLength = sb.length();
        String packageName = null;
        for (File file : files) {
            if (file.isDirectory()) {
                if (builderLength != 0) {
                    sb.append('.');
                }
                sb.append(file.getName());
                DirectoryResourceHandler.getPackages(file, packages, sb);
                sb.setLength(builderLength);
                continue;
            }
            if (packageName != null || !file.getName().endsWith(".class")) continue;
            packageName = sb.toString();
            packages.add(packageName);
        }
    }

    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

