/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.provisioning;

import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.provisioning.ContentBasedLocalBundleRepository;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class BundleRepositoryRegistry {
    private static boolean allUseMsgs = true;
    private static String cacheServerName = null;
    private static boolean isClient = false;
    protected static final HashMap<String, BundleRepositoryHolder> repositoryHolders = new HashMap();

    public static synchronized void initializeDefaults(String serverName, boolean useMsgs) {
        allUseMsgs = useMsgs;
        cacheServerName = serverName;
        BundleRepositoryRegistry.addBundleRepository(Utils.getInstallDir().getAbsolutePath(), "");
        BundleRepositoryRegistry.addBundleRepository(new File(Utils.getUserDir(), "/extension/").getAbsolutePath(), "usr");
    }

    public static synchronized void initializeDefaults(String processName, boolean useMsgs, boolean isClient) {
        BundleRepositoryRegistry.isClient = isClient;
        BundleRepositoryRegistry.initializeDefaults(processName, useMsgs);
    }

    public static synchronized void addBundleRepository(String installDir, String featureType) {
        BundleRepositoryHolder bundleRepositoryHolder = new BundleRepositoryHolder(installDir, cacheServerName, featureType);
        if (!repositoryHolders.containsKey(featureType)) {
            repositoryHolders.put(featureType, bundleRepositoryHolder);
        }
    }

    public static synchronized ContentBasedLocalBundleRepository getInstallBundleRepository() {
        BundleRepositoryHolder bh = repositoryHolders.get("");
        return bh == null ? null : bh.getBundleRepository();
    }

    public static ContentBasedLocalBundleRepository getUsrInstallBundleRepository() {
        BundleRepositoryHolder bh = repositoryHolders.get("usr");
        return bh == null ? null : bh.getBundleRepository();
    }

    public static synchronized BundleRepositoryHolder getRepositoryHolder(String featureType) {
        return repositoryHolders.get(featureType);
    }

    public static synchronized void disposeAll() {
        for (BundleRepositoryHolder holder : repositoryHolders.values()) {
            holder.dispose();
        }
    }

    public static synchronized Collection<String> keys() {
        return new ArrayList<String>(repositoryHolders.keySet());
    }

    public static synchronized Collection<BundleRepositoryHolder> holders() {
        return new ArrayList<BundleRepositoryHolder>(repositoryHolders.values());
    }

    public static synchronized boolean isEmpty() {
        return repositoryHolders.isEmpty();
    }

    public static class BundleRepositoryHolder {
        protected final File installDir;
        protected final File cacheFile;
        protected final String featureType;
        protected ContentBasedLocalBundleRepository bundleRepository;

        private BundleRepositoryHolder(String installDir, String serverName, String featureType) {
            this.installDir = new File(installDir);
            this.cacheFile = serverName == null ? null : new File(Utils.getServerOutputDir(serverName, isClient), "workarea/platform/bundle/" + featureType + ".cache");
            this.featureType = featureType;
        }

        public ContentBasedLocalBundleRepository getBundleRepository() {
            if (this.bundleRepository == null) {
                this.bundleRepository = new ContentBasedLocalBundleRepository(this.installDir, this.cacheFile, allUseMsgs);
            }
            return this.bundleRepository;
        }

        void dispose() {
            if (this.bundleRepository != null) {
                this.bundleRepository.dispose();
                this.bundleRepository = null;
            }
        }

        public String getInstallDir() {
            return this.installDir.getAbsolutePath();
        }

        public String getFeatureType() {
            return this.featureType;
        }
    }
}

