/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resources.internal;

import com.ibm.ws.repository.common.enums.DisplayPolicy;
import com.ibm.ws.repository.common.enums.DownloadPolicy;
import com.ibm.ws.repository.common.enums.FilterPredicate;
import com.ibm.ws.repository.common.enums.FilterableAttribute;
import com.ibm.ws.repository.common.enums.InstallPolicy;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.common.enums.Visibility;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.exceptions.RepositoryResourceCreationException;
import com.ibm.ws.repository.exceptions.RepositoryResourceNoConnectionException;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.internal.ExtendedMatchingData;
import com.ibm.ws.repository.resources.internal.Link;
import com.ibm.ws.repository.resources.internal.RepositoryResourceImpl;
import com.ibm.ws.repository.resources.internal.RepositoryResourceMatchingData;
import com.ibm.ws.repository.resources.writeable.EsaResourceWritable;
import com.ibm.ws.repository.transport.model.AppliesToFilterInfo;
import com.ibm.ws.repository.transport.model.Asset;
import com.ibm.ws.repository.transport.model.JavaSEVersionRequirements;
import com.ibm.ws.repository.transport.model.RequireFeatureWithTolerates;
import com.ibm.ws.repository.transport.model.WlpInformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class EsaResourceImpl
extends RepositoryResourceImpl
implements EsaResourceWritable {
    public EsaResourceImpl(RepositoryConnection repoConnection) {
        this(repoConnection, null);
    }

    public EsaResourceImpl(RepositoryConnection repoConnection, Asset ass) {
        super(repoConnection, ass);
        if (ass == null) {
            this.setType(ResourceType.FEATURE);
            this.setDownloadPolicy(DownloadPolicy.INSTALLER);
            this.setInstallPolicy(InstallPolicy.MANUAL);
        }
    }

    @Override
    public void setProvideFeature(String feature) {
        if (this._asset.getWlpInformation().getProvideFeature() != null) {
            this._asset.getWlpInformation().setProvideFeature(null);
        }
        this._asset.getWlpInformation().addProvideFeature(feature);
    }

    @Override
    public String getProvideFeature() {
        Collection<String> provideFeatures = this._asset.getWlpInformation().getProvideFeature();
        if (provideFeatures == null || provideFeatures.isEmpty()) {
            return null;
        }
        return provideFeatures.iterator().next();
    }

    private Collection<String> createEnablesQuery() {
        ArrayList<String> query = null;
        Collection<String> requiredFeatures = this.getRequireFeature();
        if (requiredFeatures != null) {
            query = new ArrayList<String>();
            for (String required : requiredFeatures) {
                String temp = "wlpInformation.provideFeature=" + required;
                String version = this.findVersion();
                if (version != null) {
                    temp = temp + "&wlpInformation.appliesToFilterInfo.minVersion.value=";
                    temp = temp + version;
                }
                temp = temp + "&type=";
                temp = temp + this.getType().getValue();
                query.add(temp);
            }
        }
        return query;
    }

    private String findVersion() {
        WlpInformation wlp = this._asset.getWlpInformation();
        if (wlp == null) {
            return null;
        }
        Collection<AppliesToFilterInfo> filterInfo = wlp.getAppliesToFilterInfo();
        if (filterInfo == null) {
            return null;
        }
        for (AppliesToFilterInfo filter : filterInfo) {
            if (filter.getMinVersion() == null) continue;
            return filter.getMinVersion().getValue();
        }
        return null;
    }

    private Collection<String> createEnabledByQuery() {
        ArrayList<String> query = new ArrayList<String>();
        String temp = "";
        temp = "wlpInformation.requireFeature=";
        temp = temp + this.getProvideFeature();
        String version = this.findVersion();
        if (version != null) {
            temp = temp + "&wlpInformation.appliesToFilterInfo.minVersion.value=";
            temp = temp + version;
        }
        temp = temp + "&type=";
        temp = temp + this.getType().getValue();
        query.add(temp);
        return query;
    }

    private Collection<String> createSupersededByQuery() {
        Collection<String> supersededBy = this._asset.getWlpInformation().getSupersededBy();
        ArrayList<String> query = null;
        if (supersededBy != null) {
            query = new ArrayList<String>();
            for (String feature : supersededBy) {
                StringBuilder b = new StringBuilder();
                b.append("wlpInformation.shortName=");
                b.append(feature);
                b.append("&wlpInformation.appliesToFilterInfo.minVersion.value=");
                String version = this.findVersion();
                if (version != null) {
                    b.append(version);
                    b.append("&type=com.ibm.websphere.Feature");
                }
                query.add(b.toString());
            }
        }
        return query;
    }

    private Collection<String> createSupersedesQuery() {
        String shortName = this._asset.getWlpInformation().getShortName();
        if (shortName != null) {
            StringBuilder b = new StringBuilder();
            b.append("wlpInformation.supersededBy=");
            b.append(shortName);
            String version = this.findVersion();
            if (version != null) {
                b.append("&wlpInformation.appliesToFilterInfo.minVersion.value=");
                b.append(version);
            }
            return Arrays.asList(b.toString());
        }
        return null;
    }

    private void addVersionDisplayString() {
        WlpInformation wlp = this._asset.getWlpInformation();
        JavaSEVersionRequirements reqs = wlp.getJavaSEVersionRequirements();
        if (reqs == null) {
            return;
        }
        String minVersion = reqs.getMinVersion();
        if (minVersion == null) {
            return;
        }
        String minJava21 = "Java SE 21, Java SE 22";
        String minJava17 = "Java SE 17, Java SE 21, Java SE 22";
        String minJava11 = "Java SE 11, Java SE 17, Java SE 21, Java SE 22";
        String minJava8 = "Java SE 8, Java SE 11, Java SE 17, Java SE 21, Java SE 22";
        if (minVersion.equals("1.6.0") || minVersion.equals("1.7.0") || minVersion.equals("1.8.0")) {
            reqs.setVersionDisplayString(minJava8);
            return;
        }
        if (minVersion.startsWith("9.") || minVersion.startsWith("10.") || minVersion.startsWith("11.")) {
            reqs.setVersionDisplayString(minJava11);
            return;
        }
        if (minVersion.startsWith("12.") || minVersion.startsWith("13.") || minVersion.startsWith("14.") || minVersion.startsWith("15.") || minVersion.startsWith("16.") || minVersion.startsWith("17.")) {
            reqs.setVersionDisplayString(minJava17);
            return;
        }
        if (minVersion.startsWith("18.") || minVersion.startsWith("19.") || minVersion.startsWith("20.") || minVersion.startsWith("21.")) {
            reqs.setVersionDisplayString(minJava21);
            return;
        }
        throw new AssertionError((Object)("Unrecognized java version: " + minVersion));
    }

    private Collection<String> createSupersededByOptionalQuery() {
        Collection<String> supersededByOptional = this._asset.getWlpInformation().getSupersededByOptional();
        ArrayList<String> query = null;
        if (supersededByOptional != null) {
            query = new ArrayList<String>();
            for (String feature : supersededByOptional) {
                StringBuilder b = new StringBuilder();
                b.append("wlpInformation.shortName=");
                b.append(feature);
                b.append("&wlpInformation.appliesToFilterInfo.minVersion.value=");
                String version = this.findVersion();
                if (version != null) {
                    b.append(version);
                    b.append("&type=com.ibm.websphere.Feature");
                }
                query.add(b.toString());
            }
        }
        return query;
    }

    private Link makeLink(String label, String linkLabelProperty, Collection<String> query, String linkLabelPrefix, String linkLabelSuffix) {
        Link link = this.makeLink(label, linkLabelProperty, query);
        link.setLinkLabelPrefix(linkLabelPrefix);
        link.setLinkLabelSuffix(linkLabelSuffix);
        return link;
    }

    private Link makeLink(String label, String linkLabelProperty, Collection<String> query) {
        Link link = new Link();
        link.setLabel(label);
        link.setLinkLabelProperty(linkLabelProperty);
        link.setQuery(query);
        return link;
    }

    private Collection<Link> createLinks() {
        ArrayList<Link> links = new ArrayList<Link>();
        Collection<String> enablesQuery = this.createEnablesQuery();
        links.add(this.makeLink("Features that this feature enables", "name", enablesQuery));
        Collection<String> enabledByQuery = this.createEnabledByQuery();
        links.add(this.makeLink("Features that enable this feature", "name", enabledByQuery));
        Collection<String> supersedesQuery = this.createSupersedesQuery();
        links.add(this.makeLink("Features that this feature supersedes", "name", supersedesQuery));
        Collection<String> supersededByQuery = this.createSupersededByQuery();
        links.add(this.makeLink("Features that supersede this feature", "name", supersededByQuery));
        Collection<String> supersededByOptionalQuery = this.createSupersededByOptionalQuery();
        links.add(this.makeLink("Features that supersede this feature", "name", supersededByOptionalQuery, null, " (optional)"));
        return links;
    }

    @Override
    public void updateGeneratedFields(boolean performEditionChecking) throws RepositoryResourceCreationException {
        super.updateGeneratedFields(performEditionChecking);
        this.setLinks(this.createLinks());
        this.addVersionDisplayString();
    }

    @Override
    public Collection<AppliesToFilterInfo> getAppliesToFilterInfo() {
        return this._asset.getWlpInformation().getAppliesToFilterInfo();
    }

    @Override
    public RepositoryResourceMatchingData createMatchingData() {
        ExtendedMatchingData matchingData = new ExtendedMatchingData();
        matchingData.setType(this.getType());
        try {
            List<AppliesToFilterInfo> atfi = this.generateAppliesToFilterInfoList(false);
            matchingData.setAtfi(atfi);
        }
        catch (RepositoryResourceCreationException repositoryResourceCreationException) {
            // empty catch block
        }
        matchingData.setVersion(this.getVersion());
        matchingData.setProvideFeature(this.getProvideFeature());
        return matchingData;
    }

    @Override
    protected Collection<? extends RepositoryResource> getPotentiallyMatchingResources() throws RepositoryBackendException, RepositoryResourceNoConnectionException {
        Collection<RepositoryResource> resources = this.getProvideFeature() != null ? this.getAndCheckRepositoryConnection().getMatchingResources(FilterPredicate.areEqual(FilterableAttribute.TYPE, (Object)this.getType()), FilterPredicate.areEqual(FilterableAttribute.SYMBOLIC_NAME, this.getProvideFeature())) : this.getAndCheckRepositoryConnection().getMatchingResources(FilterPredicate.areEqual(FilterableAttribute.TYPE, (Object)this.getType()));
        return resources;
    }

    @Override
    protected void copyFieldsFrom(RepositoryResourceImpl fromResource, boolean includeAttachmentInfo) {
        super.copyFieldsFrom(fromResource, includeAttachmentInfo);
        EsaResourceImpl esaRes = (EsaResourceImpl)fromResource;
        this.setAppliesTo(esaRes.getAppliesTo());
        this.setWebDisplayPolicy(esaRes.getWebDisplayPolicy());
        this.setInstallPolicy(esaRes.getInstallPolicy());
        this.setLinks(esaRes.getLinks());
        this.setProvideFeature(esaRes.getProvideFeature());
        this.setProvisionCapability(esaRes.getProvisionCapability());
        this.setRequireFeatureWithTolerates(esaRes.getRequireFeatureWithTolerates());
        this.setVisibility(esaRes.getVisibility());
        this.setShortName(esaRes.getShortName());
        this.setVanityURL(esaRes.getVanityURL());
        this.setSingleton(esaRes.getSingleton());
        this.setIBMInstallTo(esaRes.getIBMInstallTo());
    }

    @Override
    protected String getNameForVanityUrl() {
        return this.getProvideFeature();
    }

    public void setLinks(Collection<Link> links) {
        ArrayList<com.ibm.ws.repository.transport.model.Link> attachmentLinks = new ArrayList<com.ibm.ws.repository.transport.model.Link>();
        for (Link link : links) {
            attachmentLinks.add(link.getLink());
        }
        this._asset.getWlpInformation().setLinks(attachmentLinks);
    }

    public Collection<Link> getLinks() {
        Collection<com.ibm.ws.repository.transport.model.Link> attachmentLinks = this._asset.getWlpInformation().getLinks();
        ArrayList<Link> links = new ArrayList<Link>();
        for (com.ibm.ws.repository.transport.model.Link link : attachmentLinks) {
            links.add(new Link(link));
        }
        return links;
    }

    @Override
    public void addRequireFeature(String requiredFeatureSymbolicName) {
        this.copyRequireFeatureToRequireFeatureWithTolerates();
        this._asset.getWlpInformation().addRequireFeature(requiredFeatureSymbolicName);
        this.removeRequireFeatureWithToleratesIfExists(requiredFeatureSymbolicName);
        RequireFeatureWithTolerates newFeature = new RequireFeatureWithTolerates();
        newFeature.setFeature(requiredFeatureSymbolicName);
        newFeature.setTolerates(Collections.emptySet());
        this._asset.getWlpInformation().addRequireFeatureWithTolerates(newFeature);
    }

    @Override
    public void addRequireFeatureWithTolerates(String feature, Collection<String> tolerates) {
        WlpInformation wlp = this._asset.getWlpInformation();
        this.copyRequireFeatureToRequireFeatureWithTolerates();
        wlp.addRequireFeature(feature);
        this.removeRequireFeatureWithToleratesIfExists(feature);
        RequireFeatureWithTolerates newFeature = new RequireFeatureWithTolerates();
        newFeature.setFeature(feature);
        newFeature.setTolerates(tolerates);
        wlp.addRequireFeatureWithTolerates(newFeature);
    }

    private void removeRequireFeatureWithToleratesIfExists(String feature) {
        Collection<RequireFeatureWithTolerates> rfwt = this._asset.getWlpInformation().getRequireFeatureWithTolerates();
        if (rfwt != null) {
            for (RequireFeatureWithTolerates toCheck : rfwt) {
                if (!toCheck.getFeature().equals(feature)) continue;
                rfwt.remove(toCheck);
                return;
            }
        }
    }

    private void copyRequireFeatureToRequireFeatureWithTolerates() {
        Collection<RequireFeatureWithTolerates> rfwt = this._asset.getWlpInformation().getRequireFeatureWithTolerates();
        if (rfwt != null) {
            return;
        }
        Collection<String> requireFeature = this._asset.getWlpInformation().getRequireFeature();
        if (requireFeature == null) {
            return;
        }
        HashSet<RequireFeatureWithTolerates> newOne = new HashSet<RequireFeatureWithTolerates>();
        for (String feature : requireFeature) {
            RequireFeatureWithTolerates newFeature = new RequireFeatureWithTolerates();
            newFeature.setFeature(feature);
            newFeature.setTolerates(Collections.emptyList());
            newOne.add(newFeature);
        }
        this._asset.getWlpInformation().setRequireFeatureWithTolerates(newOne);
    }

    @Override
    public void addRequireFix(String fix) {
        this._asset.getWlpInformation().addRequireFix(fix);
    }

    @Override
    public Collection<String> getRequireFix() {
        return this._asset.getWlpInformation().getRequireFix();
    }

    @Override
    public void setRequireFeature(Collection<String> feats) {
        HashSet<RequireFeatureWithTolerates> set = null;
        if (feats != null) {
            set = new HashSet<RequireFeatureWithTolerates>();
            for (String feat : feats) {
                RequireFeatureWithTolerates feature = new RequireFeatureWithTolerates();
                feature.setFeature(feat);
                feature.setTolerates(Collections.emptySet());
                set.add(feature);
            }
        }
        this._asset.getWlpInformation().setRequireFeatureWithTolerates(set);
        this._asset.getWlpInformation().setRequireFeature(feats);
    }

    @Override
    public void setRequireFeatureWithTolerates(Map<String, Collection<String>> features) {
        HashSet<RequireFeatureWithTolerates> set = null;
        HashSet<String> collection = null;
        if (features != null) {
            set = new HashSet<RequireFeatureWithTolerates>();
            collection = new HashSet<String>();
            for (Map.Entry<String, Collection<String>> foo : features.entrySet()) {
                RequireFeatureWithTolerates feature = new RequireFeatureWithTolerates();
                feature.setFeature(foo.getKey());
                feature.setTolerates(foo.getValue());
                set.add(feature);
                collection.add(foo.getKey());
            }
        }
        this._asset.getWlpInformation().setRequireFeatureWithTolerates(set);
        this._asset.getWlpInformation().setRequireFeature(collection);
    }

    @Override
    public Collection<String> getRequireFeature() {
        return this._asset.getWlpInformation().getRequireFeature();
    }

    @Override
    public Map<String, Collection<String>> getRequireFeatureWithTolerates() {
        Collection<RequireFeatureWithTolerates> rfwt = this._asset.getWlpInformation().getRequireFeatureWithTolerates();
        if (rfwt != null) {
            HashMap<String, Collection<String>> rv = new HashMap<String, Collection<String>>();
            for (RequireFeatureWithTolerates feature : rfwt) {
                rv.put(feature.getFeature(), feature.getTolerates());
            }
            return rv;
        }
        Collection<String> rf = this._asset.getWlpInformation().getRequireFeature();
        if (rf != null) {
            HashMap<String, Collection<String>> rv = new HashMap<String, Collection<String>>();
            for (String feature : rf) {
                rv.put(feature, Collections.emptyList());
            }
            return rv;
        }
        return null;
    }

    @Override
    public void addSupersededBy(String feature) {
        this._asset.getWlpInformation().addSupersededBy(feature);
    }

    @Override
    public Collection<String> getSupersededBy() {
        return this._asset.getWlpInformation().getSupersededBy();
    }

    @Override
    public void addSupersededByOptional(String feature) {
        this._asset.getWlpInformation().addSupersededByOptional(feature);
    }

    @Override
    public Collection<String> getSupersededByOptional() {
        return this._asset.getWlpInformation().getSupersededByOptional();
    }

    @Override
    public Visibility getVisibility() {
        return this._asset.getWlpInformation().getVisibility();
    }

    @Override
    public void setVisibility(Visibility vis) {
        this._asset.getWlpInformation().setVisibility(vis);
    }

    @Override
    public void setShortName(String shortName) {
        this._asset.getWlpInformation().setShortName(shortName);
    }

    @Override
    public String getShortName() {
        return this._asset.getWlpInformation().getShortName();
    }

    @Override
    public String getLowerCaseShortName() {
        return this._asset.getWlpInformation().getLowerCaseShortName();
    }

    @Override
    public void setAppliesTo(String appliesTo) {
        this._asset.getWlpInformation().setAppliesTo(appliesTo);
    }

    @Override
    public String getAppliesTo() {
        return this._asset.getWlpInformation().getAppliesTo();
    }

    @Override
    public void setWebDisplayPolicy(DisplayPolicy policy) {
        this._asset.getWlpInformation().setWebDisplayPolicy(policy);
    }

    @Override
    public DisplayPolicy getWebDisplayPolicy() {
        if (this._asset.getWlpInformation() == null) {
            return null;
        }
        return this._asset.getWlpInformation().getWebDisplayPolicy();
    }

    @Override
    public String getProvisionCapability() {
        return this._asset.getWlpInformation().getProvisionCapability();
    }

    @Override
    public void setProvisionCapability(String provisionCapability) {
        this._asset.getWlpInformation().setProvisionCapability(provisionCapability);
    }

    @Override
    public InstallPolicy getInstallPolicy() {
        if (this._asset.getWlpInformation() == null) {
            return null;
        }
        return this._asset.getWlpInformation().getInstallPolicy();
    }

    @Override
    public void setInstallPolicy(InstallPolicy policy) {
        this._asset.getWlpInformation().setInstallPolicy(policy);
    }

    @Override
    public void setJavaSEVersionRequirements(String minimum, String maximum, Collection<String> rawBundleRequirements) {
        JavaSEVersionRequirements reqs = new JavaSEVersionRequirements();
        reqs.setMinVersion(minimum);
        reqs.setMaxVersion(maximum);
        reqs.setRawRequirements(rawBundleRequirements);
        this._asset.getWlpInformation().setJavaSEVersionRequirements(reqs);
    }

    public JavaSEVersionRequirements getJavaSEVersionRequirements() {
        return this._asset.getWlpInformation().getJavaSEVersionRequirements();
    }

    @Override
    public String getSingleton() {
        return this._asset.getWlpInformation().getSingleton();
    }

    @Override
    public boolean isSingleton() {
        return Boolean.valueOf(this.getSingleton());
    }

    @Override
    public void setSingleton(String singleton) {
        this._asset.getWlpInformation().setSingleton(singleton);
    }

    @Override
    public String getIBMInstallTo() {
        return this._asset.getWlpInformation().getIbmInstallTo();
    }

    @Override
    public void setIBMInstallTo(String ibmInstallTo) {
        this._asset.getWlpInformation().setIbmInstallTo(ibmInstallTo);
    }
}

