/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChecksumsManager {
    private static final Logger logger = Logger.getLogger("com.ibm.ws.install");
    private final Map<File, ChecksumData> checksumsMap = new HashMap<File, ChecksumData>();

    public void updateChecksums() {
        for (Map.Entry<File, ChecksumData> entry : this.checksumsMap.entrySet()) {
            this.updateChecksums(entry.getKey(), entry.getValue());
        }
    }

    private void getCheckSumFiles(File checksumDir, final Collection<File> checksumFiles) {
        checksumDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                boolean accepted = pathname.getName().toLowerCase().endsWith(".cs");
                if (accepted) {
                    checksumFiles.add(pathname);
                }
                return accepted;
            }
        });
    }

    public void updateChecksums(File featureDir, ChecksumData checksumData) {
        ArrayList<File> csFiles = new ArrayList<File>();
        File featureChecksumsDir = new File(featureDir, "checksums");
        this.getCheckSumFiles(featureChecksumsDir, csFiles);
        File libFeaturesChecksumsDir = new File(Utils.getInstallDir(), "lib/features/checksums");
        if (libFeaturesChecksumsDir.getAbsoluteFile().equals(featureChecksumsDir.getAbsoluteFile())) {
            File libPlatformChecksumsDir = new File(Utils.getInstallDir(), "lib/platform/checksums");
            this.getCheckSumFiles(libPlatformChecksumsDir, csFiles);
        }
        Properties existingChecksums = this.initChecksumProps(checksumData.existingChecksums);
        for (File file : csFiles) {
            Properties csprops = ChecksumsManager.loadChecksumFile(file);
            boolean modified = false;
            for (Map.Entry<Object, Object> csEntry : csprops.entrySet()) {
                Object k = csEntry.getKey();
                if (checksumData.newChecksums.containsKey(k)) {
                    Object newChecksum = checksumData.newChecksums.get(k);
                    if (!csEntry.getValue().equals(newChecksum)) {
                        csprops.put(k, newChecksum);
                        modified = true;
                    }
                }
                if (checksumData.isIgnoredCSFile(file) || !existingChecksums.containsKey(k)) continue;
                existingChecksums.put(k, csEntry.getValue());
            }
            if (!modified) continue;
            ChecksumsManager.saveChecksumFile(file, csprops, " for new checksum.");
        }
        for (Map.Entry entry : checksumData.existingChecksums.entrySet()) {
            String f = (String)entry.getKey();
            File csFile = new File(featureChecksumsDir, f + ".cs");
            if (!csFile.exists()) continue;
            Properties csprops = ChecksumsManager.loadChecksumFile(csFile);
            boolean modified = false;
            for (String s : (Set)entry.getValue()) {
                String cs;
                if (!csprops.containsKey(s) || !existingChecksums.containsKey(s) || (cs = (String)existingChecksums.get(s)) == null || cs.isEmpty()) continue;
                csprops.put(s, cs);
                modified = true;
            }
            if (!modified) continue;
            ChecksumsManager.saveChecksumFile(csFile, csprops, " for exising checksum.");
        }
    }

    private Properties initChecksumProps(Map<String, Set<String>> useOldChecksums) {
        Properties checksumProps = new Properties();
        for (Set<String> set : useOldChecksums.values()) {
            for (String s : set) {
                checksumProps.put(s, "");
            }
        }
        return checksumProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadChecksumFile(File csFile) {
        FileInputStream csis = null;
        Properties csprops = new Properties();
        try {
            csis = new FileInputStream(csFile);
            csprops.load(csis);
        }
        catch (IOException e) {
            try {
                logger.log(Level.FINEST, "Failed to load the checksum file: " + csFile.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                InstallUtils.close(csis);
                throw throwable;
            }
            InstallUtils.close(csis);
        }
        InstallUtils.close(csis);
        return csprops;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveChecksumFile(File csFile, Properties csprops, String reason) {
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(csFile);
            csprops.store(fOut, null);
            logger.log(Level.FINEST, "Successfully updated the checksum file " + csFile.getAbsolutePath() + reason);
        }
        catch (Exception e) {
            try {
                logger.log(Level.FINEST, "Failed to save checksum file " + csFile.getAbsolutePath() + reason, e);
            }
            catch (Throwable throwable) {
                InstallUtils.close(fOut);
                throw throwable;
            }
            InstallUtils.close(fOut);
        }
        InstallUtils.close(fOut);
    }

    public void registerNewChecksums(File featureDir, String fileName, String checksum) {
        ChecksumData checksums = this.checksumsMap.get(featureDir);
        if (checksums == null) {
            checksums = new ChecksumData();
            this.checksumsMap.put(featureDir, checksums);
        }
        checksums.registerNewChecksums(fileName, checksum);
    }

    public void registerExistingChecksums(File featureDir, String symbolicName, String fileName) {
        ChecksumData checksums = this.checksumsMap.get(featureDir);
        if (checksums == null) {
            checksums = new ChecksumData();
            this.checksumsMap.put(featureDir, checksums);
        }
        checksums.registerExistingChecksums(symbolicName, fileName);
    }

    private static class ChecksumData {
        Properties newChecksums = new Properties();
        Map<String, Set<String>> existingChecksums = new HashMap<String, Set<String>>();

        ChecksumData() {
        }

        void registerNewChecksums(String fileName, String checksum) {
            this.newChecksums.put(fileName, checksum);
        }

        void registerExistingChecksums(String symbolicName, String fileName) {
            Set<String> checksums = this.existingChecksums.get(symbolicName);
            if (checksums == null) {
                checksums = new HashSet<String>();
                this.existingChecksums.put(symbolicName, checksums);
            }
            checksums.add(fileName);
        }

        boolean isIgnoredCSFile(File csFile) {
            for (String symbolicName : this.existingChecksums.keySet()) {
                String csFileName = csFile.getName();
                if (!csFileName.equals(symbolicName + ".cs")) continue;
                return true;
            }
            return false;
        }
    }
}

