/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.cmdline;

import com.ibm.ws.kernel.boot.cmdline.LaunchManifest;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.provisioning.ProductExtension;
import com.ibm.ws.kernel.provisioning.ProductExtensionInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public class ExtensionUtils {
    private static final String EXTENSION_DIR = "bin/tools/extensions/";
    private static final String USER_EXTENSION_DIR = "usr/extension/bin/tools/extensions/";

    static List<LaunchManifest.RequiredBundle> findExtensionBundles(String extension) throws IOException {
        List<File> dirs = ExtensionUtils.listToolExtensionDirectories(extension);
        List<LaunchManifest.RequiredBundle> list = ExtensionUtils.findExtensionBundles(dirs);
        return list;
    }

    private static List<File> listToolExtensionDirectories(String extension) {
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(new File(Utils.getInstallDir(), EXTENSION_DIR + extension));
        dirs.add(new File(Utils.getInstallDir(), USER_EXTENSION_DIR + extension));
        List<File> extDirs = ExtensionUtils.listProductExtensionDirectories();
        for (File extDir : extDirs) {
            dirs.add(new File(extDir, EXTENSION_DIR + extension));
        }
        return dirs;
    }

    static List<File> listProductExtensionDirectories() {
        ArrayList<File> dirs = new ArrayList<File>();
        for (ProductExtensionInfo info : ProductExtension.getProductExtensions()) {
            String loc = info.getLocation();
            if (loc == null) continue;
            File extensionDir = new File(info.getLocation());
            if (!extensionDir.isAbsolute()) {
                File parentDir = Utils.getInstallDir().getParentFile();
                extensionDir = new File(parentDir, info.getLocation());
            }
            dirs.add(extensionDir);
        }
        return dirs;
    }

    private static List<LaunchManifest.RequiredBundle> findExtensionBundles(List<File> dirs) throws IOException {
        ArrayList<LaunchManifest.RequiredBundle> list = new ArrayList<LaunchManifest.RequiredBundle>();
        for (File dir : dirs) {
            File[] files;
            if (!dir.exists() || (files = dir.listFiles()) == null) continue;
            for (File file : files) {
                String bundles;
                if (file.isDirectory() || !file.getName().toLowerCase().endsWith(".jar") || (bundles = ExtensionUtils.getRequiredBundles(file)) == null) continue;
                list.addAll(LaunchManifest.parseRequireBundle(bundles));
            }
        }
        return list;
    }

    private static String getRequiredBundles(File file) throws IOException {
        JarFile jar = new JarFile(file);
        Attributes attr = jar.getManifest().getMainAttributes();
        jar.close();
        return attr.getValue("Require-Bundle");
    }
}

