/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.internal.util.BaseXML;
import com.ibm.ws.kernel.feature.internal.util.LazySupplierImpl;
import com.ibm.ws.kernel.feature.internal.util.VerifyData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class VerifyXML
extends BaseXML {
    public static final EnumMap<VerifyData.ResultData, String> resultTags;
    public static final Map<String, VerifyData.ResultData> tagResults;
    static final long serialVersionUID = -6434895642565885672L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static void writeDurations(File file, List<LazySupplierImpl<VerifyData.VerifyCase>> cases) throws Exception {
        FileWriter fW = new FileWriter(file, false);
        try {
            PrintWriter pW = new PrintWriter(fW);
            try {
                VerifyXML.writeDurations(pW, cases);
                pW.close();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML", (String)"59", null, (Object[])new Object[]{file, cases});
                try {
                    pW.close();
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML", (String)"59", null, (Object[])new Object[]{file, cases});
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML", (String)"59", null, (Object[])new Object[]{file, cases});
            try {
                fW.close();
            }
            catch (Throwable throwable3) {
                FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML", (String)"59", null, (Object[])new Object[]{file, cases});
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        fW.close();
    }

    public static void writeDurations(PrintWriter output, List<LazySupplierImpl<VerifyData.VerifyCase>> cases) throws Exception {
        StringBuilder lineBuilder = new StringBuilder();
        for (LazySupplierImpl<VerifyData.VerifyCase> caseSupplier : cases) {
            VerifyData.VerifyCase verifyCase = caseSupplier.getSupplied();
            if (verifyCase == null) continue;
            long durationNs = verifyCase.durationNs;
            long ns = durationNs % 1000000000L;
            long s = (durationNs - ns) / 1000000000L;
            String nsText = Long.toString(ns);
            String sText = Long.toString(s);
            lineBuilder.append(verifyCase.name);
            lineBuilder.append(' ');
            lineBuilder.append(sText);
            lineBuilder.append('.');
            lineBuilder.append(BaseXML.gap(ns));
            lineBuilder.append(nsText);
            lineBuilder.append(' ');
            lineBuilder.append('s');
            output.println(lineBuilder);
            lineBuilder.setLength(0);
        }
    }

    public static void writeCases(PrintStream output, final List<? extends VerifyData.VerifyCase> cases) throws Exception {
        VerifyXML.write(output, new BaseXML.FailableConsumer<PrintWriter, Exception>(){
            static final long serialVersionUID = -2731492888116545358L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void accept(PrintWriter pW) throws Exception {
                VerifyXMLWriter xW = new VerifyXMLWriter(pW);
                try {
                    xW.writeCases(cases);
                }
                finally {
                    xW.flush();
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML$1", 1.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        });
    }

    public static void write(File file, final List<LazySupplierImpl<VerifyData.VerifyCase>> cases) throws Exception {
        VerifyXML.write(file, new BaseXML.FailableConsumer<PrintWriter, Exception>(){
            static final long serialVersionUID = 5791046774806887097L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void accept(PrintWriter pW) throws Exception {
                VerifyXMLWriter xW = new VerifyXMLWriter(pW);
                try {
                    xW.write(cases);
                }
                finally {
                    xW.flush();
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML$2", 2.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        });
    }

    public static void write(PrintStream output, final VerifyData verifyData) throws Exception {
        VerifyXML.write(output, new BaseXML.FailableConsumer<PrintWriter, Exception>(){
            static final long serialVersionUID = -847742271455214804L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void accept(PrintWriter pW) throws Exception {
                VerifyXMLWriter xW = new VerifyXMLWriter(pW);
                try {
                    xW.write(verifyData);
                }
                finally {
                    xW.flush();
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML$3", 3.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        });
    }

    public static void write(File file, final VerifyData verifyData) throws Exception {
        VerifyXML.write(file, new BaseXML.FailableConsumer<PrintWriter, Exception>(){
            static final long serialVersionUID = -2992174917993917946L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void accept(PrintWriter pW) throws Exception {
                VerifyXMLWriter xW = new VerifyXMLWriter(pW);
                try {
                    xW.write(verifyData);
                }
                finally {
                    xW.flush();
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML$4", 4.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        });
    }

    private static void put(EnumMap<VerifyData.ResultData, String> useTags, Map<String, VerifyData.ResultData> useResults, VerifyData.ResultData dataType, String tag) {
        useTags.put(dataType, tag);
        useResults.put(tag, dataType);
    }

    public static VerifyData read(File file) throws Exception {
        VerifyContentHandler contentHandler = new VerifyContentHandler();
        VerifyErrorHandler errorHandler = new VerifyErrorHandler(System.out);
        BaseXML.read(file, contentHandler, errorHandler);
        return contentHandler.verifyData;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML", VerifyXML.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        EnumMap<VerifyData.ResultData, String> useTags = new EnumMap<VerifyData.ResultData, String>(VerifyData.ResultData.class);
        HashMap<String, VerifyData.ResultData> useResults = new HashMap<String, VerifyData.ResultData>();
        VerifyXML.put(useTags, useResults, VerifyData.ResultData.PLATFORM_RESOLVED, "resolved-platform");
        VerifyXML.put(useTags, useResults, VerifyData.ResultData.PLATFORM_MISSING, "missing-platform");
        VerifyXML.put(useTags, useResults, VerifyData.ResultData.PLATFORM_DUPLICATE, "duplicate-platform");
        VerifyXML.put(useTags, useResults, VerifyData.ResultData.FEATURE_VERSIONLESS_RESOLVED, "resolved-versionless");
        VerifyXML.put(useTags, useResults, VerifyData.ResultData.FEATURE_VERSIONLESS_NO_PLATFORM, "no-platform-versionless");
        VerifyXML.put(useTags, useResults, VerifyData.ResultData.FEATURE_RESOLVED, "resolved-feature");
        VerifyXML.put(useTags, useResults, VerifyData.ResultData.FEATURE_MISSING, "missing-feature");
        VerifyXML.put(useTags, useResults, VerifyData.ResultData.FEATURE_NON_PUBLIC, "non-public-feature");
        VerifyXML.put(useTags, useResults, VerifyData.ResultData.FEATURE_WRONG_PROCESS, "wrong-process-feature");
        VerifyXML.put(useTags, useResults, VerifyData.ResultData.FEATURE_CONFLICT, "conflict-feature");
        resultTags = useTags;
        tagResults = useResults;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class VerifyContentHandler
    extends BaseXML.BaseContentHandler {
        private VerifyData verifyData;
        private VerifyData.VerifyCase verifyCase;
        static final long serialVersionUID = -1655975981726484688L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private void startData() {
            this.verifyData = new VerifyData();
        }

        private void endData() {
        }

        private void startCase() {
            this.verifyCase = this.verifyData.addCase();
        }

        private void endCase() {
            this.verifyCase = null;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            boolean whitespaceOnly = false;
            if (this.pushElement(qName, "cases", null)) {
                this.startData();
                whitespaceOnly = true;
            } else if (this.pushElement(qName, "case", "cases")) {
                this.startCase();
                whitespaceOnly = true;
            } else if (!(this.pushElement(qName, "name", "case") || this.pushElement(qName, "description", "case") || this.pushElement(qName, "duration", "case"))) {
                if (this.pushElement(qName, "input", "case")) {
                    whitespaceOnly = true;
                } else if (!(this.pushElement(qName, "multiple", "input") || this.pushElement(qName, "kernel", "input") || this.pushElement(qName, "root", "input") || this.pushElement(qName, "platform", "input") || this.pushElement(qName, "environment", "input"))) {
                    if (this.pushElement(qName, "output", "case")) {
                        whitespaceOnly = true;
                    } else if (!this.pushElement(qName, "resolved", "output")) {
                        boolean isResultElement = false;
                        for (String tag : resultTags.values()) {
                            if (!this.pushElement(qName, tag, "output")) continue;
                            isResultElement = true;
                            break;
                        }
                        if (!isResultElement) {
                            super.startElement(uri, localName, qName, atts);
                        }
                    }
                }
            }
            this.pushBuilder(whitespaceOnly);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String elementText = this.popBuilder();
            String oldLast = this.popElement();
            if (oldLast.equals("cases")) {
                this.endData();
            } else if (oldLast.equals("case")) {
                this.endCase();
            } else if (oldLast.equals("name")) {
                this.verifyCase.name = elementText;
            } else if (oldLast.equals("description")) {
                this.verifyCase.description = elementText;
            } else if (oldLast.equals("duration")) {
                this.verifyCase.durationNs = this.parseSAsNS(elementText);
            } else if (!oldLast.equals("input")) {
                if (oldLast.contentEquals("multiple")) {
                    this.verifyCase.input.setMultiple();
                } else if (oldLast.equals("kernel")) {
                    this.verifyCase.input.addKernel(elementText);
                } else if (oldLast.equals("root")) {
                    this.verifyCase.input.addRoot(elementText);
                } else if (oldLast.equals("platform")) {
                    this.verifyCase.input.addPlatform(elementText);
                } else if (oldLast.equals("environment")) {
                    this.putEnvironment(elementText);
                } else if (!oldLast.equals("output")) {
                    if (oldLast.equals("resolved")) {
                        this.verifyCase.output.addResolved(elementText);
                    } else {
                        boolean isResultTag = false;
                        for (String tag : resultTags.values()) {
                            if (!oldLast.equals(tag)) continue;
                            if (tag.equals("resolved-versionless")) {
                                this.putVersionless(elementText);
                            } else {
                                this.verifyCase.output.add(tagResults.get(tag), elementText);
                            }
                            isResultTag = true;
                            break;
                        }
                        if (!isResultTag) {
                            super.endElement(uri, localName, qName);
                        }
                    }
                }
            }
        }

        private void putEnvironment(String elementText) {
            String value;
            String name;
            int sepOffset = elementText.indexOf(61);
            if (sepOffset == -1) {
                name = elementText;
                value = "";
            } else {
                name = elementText.substring(0, sepOffset);
                value = elementText.substring(sepOffset + 1);
            }
            this.verifyCase.input.putEnvironment(name, value);
        }

        private void putVersionless(String elementText) {
            String value;
            String name;
            int sepOffset = elementText.indexOf(61);
            if (sepOffset == -1) {
                name = elementText;
                value = "";
            } else {
                name = elementText.substring(0, sepOffset);
                value = elementText.substring(sepOffset + 1);
                if (value.equals("null")) {
                    value = null;
                }
            }
            this.verifyCase.output.putVersionlessResolved(name, value);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML$VerifyContentHandler", VerifyContentHandler.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class VerifyErrorHandler
    extends BaseXML.BaseErrorHandler {
        static final long serialVersionUID = -6449634859531195176L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public VerifyErrorHandler(PrintStream printer) {
            super(printer);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML$VerifyErrorHandler", VerifyErrorHandler.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class VerifyXMLWriter
    extends BaseXML.BaseXMLWriter {
        static final long serialVersionUID = 5040704455366592136L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public VerifyXMLWriter(PrintWriter pW) {
            super(pW);
        }

        public void write(VerifyData verifyData) {
            this.openElement("cases");
            this.upIndent();
            for (VerifyData.VerifyCase verifyCase : verifyData.cases) {
                this.write(verifyCase);
            }
            this.downIndent();
            this.closeElement("cases");
        }

        public void writeCases(List<? extends VerifyData.VerifyCase> cases) throws Exception {
            this.openElement("cases");
            this.upIndent();
            for (VerifyData.VerifyCase verifyCase : cases) {
                this.write(verifyCase);
            }
            this.downIndent();
            this.closeElement("cases");
        }

        public void write(List<LazySupplierImpl<VerifyData.VerifyCase>> cases) throws Exception {
            this.openElement("cases");
            this.upIndent();
            for (LazySupplierImpl<VerifyData.VerifyCase> verifyCase : cases) {
                this.write(verifyCase.supply());
            }
            this.downIndent();
            this.closeElement("cases");
        }

        public void write(VerifyData.VerifyCase verifyCase) {
            this.openElement("case");
            this.upIndent();
            this.printElement("name", verifyCase.name);
            this.printElement("description", verifyCase.description);
            this.write(verifyCase.input);
            this.write(verifyCase.output);
            this.downIndent();
            this.closeElement("case");
        }

        public void write(VerifyData.VerifyInput verifyInput) {
            this.openElement("input");
            this.upIndent();
            if (verifyInput.isMultiple) {
                this.printElement("multiple");
            }
            for (String string : verifyInput.kernel) {
                this.printElement("kernel", string);
            }
            for (String string : verifyInput.roots) {
                this.printElement("root", string);
            }
            for (String string : verifyInput.platforms) {
                this.printElement("platform", string);
            }
            for (Map.Entry entry : verifyInput.envMap.entrySet()) {
                this.printElement("environment", (String)entry.getKey() + '=' + (String)entry.getValue());
            }
            this.downIndent();
            this.closeElement("input");
        }

        public void write(VerifyData.VerifyOutput verifyOutput) {
            this.openElement("output");
            this.upIndent();
            for (String feature : verifyOutput.kernelOnly) {
                this.printElement("kernelOnly", feature);
            }
            for (String feature : verifyOutput.kernelBlocked) {
                this.printElement("kernelBlocked", feature);
            }
            for (VerifyData.ResultData dataType : VerifyData.ResultData.values()) {
                String elementTag = resultTags.get((Object)dataType);
                if (dataType != VerifyData.ResultData.FEATURE_VERSIONLESS_RESOLVED) {
                    for (String value : verifyOutput.get(dataType)) {
                        this.printElement(elementTag, value);
                    }
                    continue;
                }
                Map<String, String> versionlessResolved = verifyOutput.getVersionlessResolved();
                for (Map.Entry<String, String> resolvedEntry : versionlessResolved.entrySet()) {
                    String value = resolvedEntry.getKey() + '=' + resolvedEntry.getValue();
                    this.printElement(elementTag, value);
                }
            }
            this.downIndent();
            this.closeElement("output");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML$VerifyXMLWriter", VerifyXMLWriter.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }
}

