/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.bci;

import com.ibm.ws.ras.instrument.internal.bci.AbstractTracingRasClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter;
import com.ibm.ws.ras.instrument.internal.bci.RasMethodAdapter;
import com.ibm.ws.ras.instrument.internal.main.LibertyTracePreprocessInstrumentation;
import com.ibm.ws.ras.instrument.internal.model.ClassInfo;
import com.ibm.ws.ras.instrument.internal.model.FieldInfo;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class LibertyTracingClassAdapter
extends AbstractTracingRasClassAdapter {
    public static final Type TR_TYPE = Type.getObjectType((String)"com/ibm/websphere/ras/Tr");
    public static final Type TRACE_COMPONENT_TYPE = Type.getObjectType((String)"com/ibm/websphere/ras/TraceComponent");
    private static final String DEFAULT_TRACE_COMPONENT_FIELD_NAME = "$$$tc$$$";
    private final FieldInfo declaredLoggerField;
    private final FieldInfo traceComponentField;
    private boolean traceComponentAlreadyDefined;
    private final boolean onlyInstrumentPreprocessed;
    List<LibertyTracingMethodAdapter> createdMethodAdapters = new ArrayList<LibertyTracingMethodAdapter>();
    public static final boolean ONLY_INSTRUMENT_PREPROCESSED = true;

    public LibertyTracingClassAdapter(ClassVisitor visitor, ClassInfo classInfo, LibertyTracePreprocessInstrumentation.ClassTraceInfo traceInfo, boolean throwComputeFrames, boolean onlyInstrumentPreprocessed) {
        super(visitor, classInfo, traceInfo, throwComputeFrames);
        this.declaredLoggerField = classInfo != null ? classInfo.getDeclaredLoggerField() : null;
        FieldInfo traceField = null;
        boolean traceFieldDefined = false;
        if (this.declaredLoggerField != null && this.declaredLoggerField.getFieldDescriptor().equals(TRACE_COMPONENT_TYPE.getDescriptor())) {
            traceField = this.declaredLoggerField;
            traceFieldDefined = true;
        }
        if (traceField == null) {
            traceField = new FieldInfo(DEFAULT_TRACE_COMPONENT_FIELD_NAME, TRACE_COMPONENT_TYPE.getDescriptor());
        }
        this.traceComponentField = traceField;
        this.traceComponentAlreadyDefined = traceFieldDefined;
        this.onlyInstrumentPreprocessed = onlyInstrumentPreprocessed;
    }

    public LibertyTracingClassAdapter(ClassVisitor visitor, ClassInfo classInfo, LibertyTracePreprocessInstrumentation.ClassTraceInfo traceInfo, boolean onlyInstrumentPreprocessed) {
        this(visitor, classInfo, traceInfo, false, onlyInstrumentPreprocessed);
    }

    public LibertyTracingClassAdapter(ClassVisitor visitor, LibertyTracePreprocessInstrumentation.ClassTraceInfo info, boolean onlyInstrumentPreprocessed) {
        this(visitor, null, info, false, onlyInstrumentPreprocessed);
    }

    public LibertyTracingClassAdapter(ClassVisitor visitor, boolean onlyInstrumentPreprocessed) {
        this(visitor, null, null, false, onlyInstrumentPreprocessed);
    }

    public LibertyTracingClassAdapter(ClassVisitor visitor, boolean throwComputeFrames, boolean onlyInstrumentPreprocessed) {
        this(visitor, null, null, throwComputeFrames, onlyInstrumentPreprocessed);
    }

    public LibertyTracingClassAdapter(ClassVisitor visitor, ClassInfo classInfo) {
        this(visitor, classInfo, null, false, false);
    }

    @Override
    public RasMethodAdapter createRasMethodAdapter(MethodVisitor mv, int access, String name, String descriptor, String signature, String[] exceptions) {
        if (this.onlyInstrumentPreprocessed && super.getTraceObjectAnnotationFieldName() == null) {
            return null;
        }
        if (this.onlyInstrumentPreprocessed && !super.getTraceObjectAnnotationFieldType().equals((Object)TRACE_COMPONENT_TYPE)) {
            return null;
        }
        LibertyTracingMethodAdapter methodAdapter = new LibertyTracingMethodAdapter(this, mv, access, name, descriptor, signature, exceptions);
        this.createdMethodAdapters.add(methodAdapter);
        return methodAdapter;
    }

    @Override
    public String getTraceObjectFieldName() {
        String fieldName = super.getTraceObjectAnnotationFieldName();
        if (fieldName != null && super.getTraceObjectAnnotationFieldType().equals((Object)TRACE_COMPONENT_TYPE)) {
            this.traceComponentAlreadyDefined = true;
            return fieldName;
        }
        return this.traceComponentField.getFieldName();
    }

    @Override
    protected void ensureTraceObjectFieldAnnotated() {
        if (!this.onlyInstrumentPreprocessed) {
            super.ensureTraceObjectFieldAnnotated();
        }
    }

    @Override
    public Type getTraceObjectFieldType() {
        return TRACE_COMPONENT_TYPE;
    }

    @Override
    public boolean isTraceObjectFieldDefinitionRequired() {
        if (this.onlyInstrumentPreprocessed) {
            return false;
        }
        return !this.traceComponentAlreadyDefined;
    }

    @Override
    public boolean isTraceObjectFieldInitializationRequired() {
        return this.isTraceObjectFieldDefinitionRequired();
    }

    @Override
    public boolean isStaticInitializerRequired() {
        return !this.onlyInstrumentPreprocessed;
    }

    public boolean isClassModified() {
        if (this.isStaticInitializerRequired()) {
            return true;
        }
        if (this.isTraceObjectFieldDefinitionRequired()) {
            return true;
        }
        if (this.isTraceObjectFieldInitializationRequired()) {
            return true;
        }
        for (LibertyTracingMethodAdapter methodAdapter : this.createdMethodAdapters) {
            if (!methodAdapter.isModifiedMethod()) continue;
            return true;
        }
        return false;
    }

    public boolean isTraceComponentAlreadyDefined() {
        return this.traceComponentAlreadyDefined;
    }
}

