/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.asset;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallLicense;
import com.ibm.ws.install.internal.ExceptionUtils;
import com.ibm.ws.install.internal.InstallLicenseImpl;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.asset.ESABaseAsset;
import com.ibm.ws.install.internal.asset.SubsytemEntry;
import com.ibm.ws.install.repository.FeatureAsset;
import com.ibm.ws.install.repository.FeatureCollectionAsset;
import com.ibm.ws.kernel.feature.internal.cmdline.ThirdPartyLicenseProvider;
import com.ibm.ws.kernel.feature.internal.subsystem.SubsystemFeatureDefinitionImpl;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.common.enums.Visibility;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.resources.AttachmentResource;
import com.ibm.ws.repository.resources.EsaResource;
import com.ibm.ws.repository.resources.RepositoryResource;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import wlp.lib.extract.LicenseProvider;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.ZipLicenseProvider;

public class ESAAsset
extends ESABaseAsset
implements FeatureAsset,
FeatureCollectionAsset {
    private EsaResource esaResource = null;

    public ESAAsset(String id, String featureName, String repoType, File assetFile, boolean isTemporary) throws ZipException, IOException {
        super(id, featureName, repoType, assetFile, isTemporary);
    }

    public ESAAsset(File assetFile, String repoType, boolean isTemporary) throws ZipException, IOException {
        super(assetFile, repoType, isTemporary);
    }

    public ESAAsset(String id, String featureName, String repoType, EsaResource esaResource) throws ZipException, IOException {
        super(id, featureName, repoType, null, true);
        this.esaResource = esaResource;
        this.featureName = esaResource.getProvideFeature();
        this.shortName = esaResource.getShortName();
    }

    @Override
    protected ResourceBundle getResourceBundle(Locale locale) {
        try {
            ZipEntry entry = this.getEntry("OSGI-INF/l10n/subsystem_" + locale.getLanguage() + ".properties");
            if (entry == null) {
                entry = this.getEntry("OSGI-INF/l10n/subsystem.properties");
            }
            if (entry != null) {
                return new PropertyResourceBundle(this.getInputStream(entry));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected LicenseProvider createLicenseProvider(String licenseAgreementPrefix, String licenseInformationPrefix, String subsystemLicenseType) {
        if (licenseInformationPrefix == null) {
            LicenseProvider lp = ZipLicenseProvider.createInstance((ZipFile)this.zip, (String)licenseAgreementPrefix);
            if (lp != null) {
                return lp;
            }
        } else {
            ReturnCode licenseReturnCode = ZipLicenseProvider.buildInstance((ZipFile)this.zip, (String)licenseAgreementPrefix, (String)licenseInformationPrefix);
            if (licenseReturnCode == ReturnCode.OK) {
                return ZipLicenseProvider.getInstance();
            }
        }
        if (subsystemLicenseType != null && subsystemLicenseType.length() > 0) {
            return new ThirdPartyLicenseProvider(this.featureDefinition.getFeatureName(), subsystemLicenseType);
        }
        return null;
    }

    public ZipFile getZip() {
        return this.zip;
    }

    public Enumeration<? extends ZipEntry> getZipEntries() {
        return this.zip.entries();
    }

    @Override
    public long size() {
        if (this.esaResource == null) {
            return null != this.getAsset() ? this.getAsset().length() : super.size();
        }
        return this.esaResource.getMainAttachmentSize();
    }

    @Override
    public String getDisplayName(Locale locale) {
        if (this.esaResource == null) {
            return super.getDisplayName(locale);
        }
        return this.esaResource.getName();
    }

    @Override
    public String getDisplayName() {
        if (this.esaResource == null) {
            return super.getDisplayName();
        }
        return this.esaResource.getName();
    }

    @Override
    public String getDescription(Locale locale) {
        if (this.esaResource == null) {
            return super.getDescription(locale);
        }
        return this.esaResource.getShortDescription();
    }

    @Override
    public String getDescription() {
        if (this.esaResource == null) {
            return super.getDescription();
        }
        return this.esaResource.getShortDescription();
    }

    @Override
    public InstallLicense getLicense(Locale locale) {
        if (this.esaResource == null) {
            return super.getLicense(locale);
        }
        if (this.licenseMap == null) {
            this.licenseMap = new HashMap();
        }
        if (this.licenseMap.containsKey(locale)) {
            return (InstallLicense)this.licenseMap.get(locale);
        }
        try {
            AttachmentResource la = this.esaResource.getLicenseAgreement(locale);
            AttachmentResource li = this.esaResource.getLicenseInformation(locale);
            AttachmentResource enLi = locale.getLanguage().equalsIgnoreCase("en") ? null : this.esaResource.getLicenseInformation(Locale.ENGLISH);
            String licenseId = this.esaResource.getLicenseId();
            if (licenseId != null && !licenseId.isEmpty()) {
                InstallLicenseImpl ili = new InstallLicenseImpl(licenseId, this.esaResource.getLicenseType(), la, li, enLi);
                ili.addFeature(this.esaResource.getProvideFeature());
                this.licenseMap.put(locale, ili);
                return ili;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public InstallLicense getLicense() {
        return this.getLicense(Locale.ENGLISH);
    }

    @Override
    public String getProvideFeature() {
        if (this.esaResource == null) {
            return super.getProvideFeature();
        }
        return this.esaResource.getProvideFeature();
    }

    @Override
    public Collection<String> getRequireFeature() {
        if (this.esaResource == null) {
            return super.getRequireFeature();
        }
        return this.esaResource.getRequireFeature();
    }

    @Override
    public boolean isPublic() {
        if (this.esaResource == null) {
            return super.isPublic();
        }
        return this.esaResource.getVisibility() == Visibility.PUBLIC || this.esaResource.getVisibility() == Visibility.INSTALL;
    }

    @Override
    public boolean isAddon() {
        if (this.esaResource == null) {
            return super.isAddon();
        }
        return this.esaResource.getVisibility() == Visibility.INSTALL;
    }

    @Override
    public RepositoryResource getRepositoryResource() {
        return this.esaResource;
    }

    @Override
    public void download(File installTempDir) throws InstallException {
        if (this.esaResource == null) {
            return;
        }
        this.asset = this.download(installTempDir, (RepositoryResource)this.esaResource);
        if (this.asset != null) {
            Visibility v;
            if (this.esaResource.getType().equals((Object)ResourceType.FEATURE) && ((v = this.esaResource.getVisibility()).equals((Object)Visibility.PUBLIC) || v.equals((Object)Visibility.INSTALL))) {
                logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_DOWNLOAD_SUCCESS", this.esaResource.getName()));
            }
            try {
                this.zip = new ZipFile(this.asset);
                this.subsystemEntry = new SubsytemEntry(this.zip);
                ZipEntry subsystemEntry = this.subsystemEntry.getSubsystemEntry();
                if (subsystemEntry != null) {
                    this.featureDefinition = new SubsystemFeatureDefinitionImpl(this.getRepoType(this.repoType), this.zip.getInputStream(subsystemEntry));
                }
            }
            catch (Exception e) {
                throw ExceptionUtils.createFailedToDownload((RepositoryResource)this.esaResource, e, installTempDir);
            }
        }
    }

    @Override
    public void cleanup() {
        if (this.esaResource == null) {
            return;
        }
        this.delete();
        this.zip = null;
        this.asset = null;
        this.subsystemEntry = null;
        this.featureDefinition = null;
    }
}

