/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import com.ibm.websphere.logging.hpel.reader.RepositoryPointer;
import com.ibm.ws.logging.hpel.DeserializerException;
import com.ibm.ws.logging.hpel.LogFileReader;
import com.ibm.ws.logging.hpel.LogRecordSerializer;
import com.ibm.ws.logging.hpel.impl.LogFileReaderImpl;
import com.ibm.ws.logging.hpel.impl.LogRecordBrowser;
import com.ibm.ws.logging.hpel.impl.LogRepositoryBrowserImpl;
import com.ibm.ws.logging.object.hpel.RepositoryLogRecordImpl;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class OneLogFileRecordIterator
implements Iterator<RepositoryLogRecord> {
    private static final String BUNDLE_NAME = "com.ibm.ws.logging.hpel.resources.HpelMessages";
    private static final String className = OneLogFileRecordIterator.class.getName();
    private static final Logger logger = Logger.getLogger(className, "com.ibm.ws.logging.hpel.resources.HpelMessages");
    final File file;
    private final long max;
    private LogRecordSerializer formatter = null;
    private final LogRecordBrowser.IInternalRecordFilter recFilter;
    Properties header = null;
    protected final LogFileReader reader;
    private RepositoryLogRecordImpl nextRecord = null;
    private static final LogFileReader DUMMY_READER = new LogFileReader(){

        @Override
        public void close() throws IOException {
        }

        @Override
        public long getFilePointer() throws IOException {
            return 0L;
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public long length() throws IOException {
            return 0L;
        }

        @Override
        public void readFully(byte[] buffer, int off, int len) throws IOException {
            throw new EOFException();
        }

        @Override
        public int readLength() throws IOException {
            return 0;
        }

        @Override
        public void seek(long pos) throws IOException {
            throw new EOFException();
        }
    };

    OneLogFileRecordIterator(File file, long max, LogRecordBrowser.IInternalRecordFilter recFilter) {
        this.file = file;
        this.max = max;
        this.recFilter = recFilter;
        LogFileReader tmpReader = null;
        try {
            tmpReader = this.createNewReader(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (tmpReader == null) {
            this.reader = DUMMY_READER;
            this.header = null;
            return;
        }
        this.reader = tmpReader;
        try {
            this.header = this.readHeaderRecord(true);
        }
        catch (IOException ex) {
            logger.logp(Level.SEVERE, className, "OneLogFileRecordIterator", "HPEL_NoHeaderRecordInFileHead", new String[]{file.getAbsolutePath(), ex.getMessage()});
            try {
                this.header = this.findAndReadHeaderRecord(true);
            }
            catch (IOException ex2) {
                try {
                    this.header = this.readHeaderRecord(false);
                }
                catch (IOException ex3) {
                    try {
                        this.header = this.findAndReadHeaderRecord(false);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    this.rewindToMessageRecord();
                }
                catch (IOException ex3) {
                    logger.logp(Level.SEVERE, className, "OneLogFileRecordIterator", "HPEL_NoRecordsInFile", file.getAbsolutePath());
                    this.close();
                    return;
                }
            }
        }
        this.setPositionByMin();
    }

    private Properties readHeaderRecord(boolean forward) throws IOException {
        int tailSize;
        byte[] buffer;
        int headerSize;
        long position;
        long fileSize = this.reader.length();
        if (forward) {
            position = 0L;
            headerSize = this.reader.readLength();
            if (headerSize < 0 || fileSize < (long)(headerSize + 8)) {
                throw new IOException("Header size is incorrect");
            }
            buffer = new byte[headerSize];
            this.reader.readFully(buffer, 0, headerSize);
            tailSize = this.reader.readLength();
        } else {
            this.reader.seek(fileSize - 4L);
            tailSize = this.reader.readLength();
            if (tailSize < 0 || fileSize < (long)(tailSize + 8)) {
                throw new IOException("Header size is incorrect");
            }
            position = fileSize - (long)tailSize - 8L;
            this.reader.seek(position);
            headerSize = this.reader.readLength();
            buffer = new byte[tailSize];
            this.reader.readFully(buffer, 0, tailSize);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
        for (LogRecordSerializer current : LogRepositoryBrowserImpl.KNOWN_FORMATTERS) {
            try {
                Properties result;
                bais.reset();
                DataInputStream input = new DataInputStream(bais);
                if (0 != current.getType(input) || (result = current.deserializeFileHeader(input)) == null) continue;
                this.formatter = current;
                if (headerSize != tailSize) {
                    logger.logp(Level.WARNING, className, "readHeaderRecord", "HPEL_InconsistencyInHeaderRecordSize", new Object[]{Integer.toString(tailSize), Long.toString(position), Integer.toString(headerSize), this.file.getAbsolutePath()});
                }
                return result;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new IOException("No formatter can read header record.");
    }

    private Properties findAndReadHeaderRecord(boolean forward) throws IOException {
        long fileSize = this.reader.length();
        for (LogRecordSerializer current : LogRepositoryBrowserImpl.KNOWN_FORMATTERS) {
            try {
                Properties result;
                long position;
                if (forward) {
                    this.reader.seek(0L);
                    position = this.seekToNextRecord(current);
                } else {
                    this.reader.seek(fileSize);
                    position = this.seekToPrevRecord(current);
                }
                int headerSize = this.reader.readLength();
                if (headerSize < 0 || fileSize < position + (long)headerSize + 8L) {
                    throw new IOException("Header size is incorrect");
                }
                DataInputStream input = this.readRecord(headerSize);
                int tailSize = this.reader.readLength();
                if (0 != current.getType(input) || (result = current.deserializeFileHeader(input)) == null) continue;
                this.formatter = current;
                if (headerSize != tailSize) {
                    logger.logp(Level.WARNING, className, "findAndReadHeaderRecord", "HPEL_InconsistencyInHeaderRecordSize", new Object[]{Integer.toString(tailSize), Long.toString(position), Integer.toString(headerSize), this.file.getAbsolutePath()});
                }
                return result;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new IOException("No formatter can read header record.");
    }

    private void rewindToMessageRecord() throws IOException {
        LogRecordSerializer[] logRecordSerializerArray;
        if (this.formatter == null) {
            logRecordSerializerArray = LogRepositoryBrowserImpl.KNOWN_FORMATTERS;
        } else {
            LogRecordSerializer[] logRecordSerializerArray2 = new LogRecordSerializer[1];
            logRecordSerializerArray = logRecordSerializerArray2;
            logRecordSerializerArray2[0] = this.formatter;
        }
        block4: for (LogRecordSerializer current : logRecordSerializerArray) {
            long position = 0L;
            long fileSize = this.reader.length();
            while (position + 8L < fileSize) {
                block10: {
                    try {
                        this.reader.seek(position);
                        position = this.seekToNextRecord(current);
                        int recSize = this.reader.readLength();
                        if (recSize <= 0 || position + (long)recSize + 8L >= fileSize) break block10;
                        DataInputStream input = this.readRecord(recSize);
                        int tailSize = this.reader.readLength();
                        if (1 == current.getType(input)) {
                            this.formatter = current;
                            this.reader.seek(position);
                            if (recSize != tailSize) {
                                logger.logp(Level.WARNING, className, "rewindToMessageRecord", "HPEL_InconsistencyInLogRecordSize", new Object[]{Integer.toString(tailSize), Long.toString(position), Integer.toString(recSize), this.file.getAbsolutePath()});
                            }
                            return;
                        }
                    }
                    catch (DeserializerException recSize) {
                    }
                    catch (EOFException recSize) {
                    }
                    catch (IOException ex3) {
                        continue block4;
                    }
                }
                position += 5L;
            }
        }
        throw new IOException("No formatter can find a message record.");
    }

    protected boolean verifyMin(RepositoryLogRecordImpl record) {
        return true;
    }

    public boolean setPosition(long position) {
        try {
            long fileSize = this.reader.length();
            if (fileSize > position) {
                this.reader.seek(position);
                return true;
            }
            logger.logp(Level.SEVERE, className, "setPosition", "HPEL_OffsetBeyondFileSize", new Object[]{this.file, position, fileSize});
        }
        catch (IOException ex) {
            logger.logp(Level.SEVERE, className, "setPosition", "HPEL_ErrorSettingFileOffset", new Object[]{this.file, position, ex.getMessage()});
        }
        return false;
    }

    public long getPosition() {
        try {
            return this.reader.getFilePointer();
        }
        catch (IOException ex) {
            logger.logp(Level.SEVERE, className, "getPosition", "HPEL_ErrorReadingFileOffset", new Object[]{this.file, ex.getMessage()});
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean setPositionByMin() {
        long min = this.getPosition();
        if (min < 0L) {
            return false;
        }
        try {
            long nextPosition;
            long max = this.reader.length();
            int recSize = this.reader.readLength();
            if (recSize < 0 || min + (long)recSize + 8L > max) {
                boolean bl = false;
                return bl;
            }
            DataInputStream input = this.readRecord(recSize);
            if (1 != this.formatter.getType(input)) {
                boolean bl = false;
                return bl;
            }
            RepositoryLogRecordImpl record = this.formatter.deserializeLogTime(input);
            if (this.verifyMin(record)) {
                boolean bl = true;
                return bl;
            }
            this.reader.seek(max);
            max = nextPosition = this.seekToPrevRecord(this.formatter);
            do {
                if ((recSize = this.reader.readLength()) < 0 || nextPosition + (long)recSize + 8L > max) {
                    max = nextPosition;
                } else {
                    input = this.readRecord(recSize);
                    if (1 != this.formatter.getType(input)) {
                        max = nextPosition;
                    } else {
                        record = this.formatter.deserializeLogTime(input);
                        if (this.verifyMin(record)) {
                            max = nextPosition;
                        } else {
                            min = nextPosition + (long)recSize + 8L;
                        }
                    }
                }
                this.reader.seek((min + max) / 2L);
            } while ((nextPosition = this.seekToNextRecord(this.formatter)) < max);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            logger.logp(Level.SEVERE, className, "setPositionBySeq", "Error to set position in {0} by min condition: ", new Object[]{this.file, ex.getMessage()});
            logger.logp(Level.SEVERE, className, "setPositionBySeq", ex.getLocalizedMessage(), ex);
            return false;
        }
        finally {
            try {
                this.reader.seek(min);
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public boolean hasNext() {
        if (this.nextRecord == null) {
            this.nextRecord = this.getNext(-1L);
        }
        return this.nextRecord != null;
    }

    public RepositoryLogRecord findNext(long refSequenceNumber) {
        if (this.nextRecord == null) {
            this.nextRecord = this.getNext(refSequenceNumber);
        }
        if (this.nextRecord == null || refSequenceNumber >= 0L && refSequenceNumber < this.nextRecord.getInternalSeqNumber()) {
            return null;
        }
        RepositoryLogRecordImpl result = this.nextRecord;
        this.nextRecord = null;
        return result;
    }

    private RepositoryLogRecordImpl getNext(long refSequenceNumber) {
        while (this.reader.isOpen()) {
            block17: {
                int recSize = -1;
                long position = -1L;
                try {
                    long fileSize = this.reader.length();
                    position = this.reader.getFilePointer();
                    DataInputStream input = null;
                    boolean hasEyeCatcher = false;
                    RepositoryLogRecordImpl result = null;
                    do {
                        int tailSize;
                        if (refSequenceNumber >= 0L && result != null && refSequenceNumber < result.getInternalSeqNumber()) {
                            return null;
                        }
                        result = null;
                        if (recSize > 0) {
                            position += (long)(recSize + 8);
                        }
                        if (position + 8L >= fileSize) break;
                        recSize = this.reader.readLength();
                        if (recSize < 0 || (long)recSize > fileSize - position - 8L) {
                            long nextPosition;
                            try {
                                this.reader.seek(position + 5L);
                                nextPosition = this.seekToNextRecord(this.formatter);
                                hasEyeCatcher = true;
                            }
                            catch (IOException ex) {
                                nextPosition = this.reader.length();
                            }
                            this.reader.seek(nextPosition - 4L);
                            tailSize = this.reader.readLength();
                            if (tailSize < 0 || (long)tailSize > fileSize - position - 8L) {
                                if (!hasEyeCatcher) break;
                                logger.logp(Level.WARNING, className, "hasNext", "HPEL_ErrorReadingLogRecordDoSkip", new Object[]{Long.toString(position), Long.toString(nextPosition - position), this.file.getAbsolutePath()});
                                break;
                            }
                            this.reader.seek(position + 4L);
                            input = this.readRecord(tailSize);
                        } else {
                            input = this.readRecord(recSize);
                        }
                        tailSize = this.reader.readLength();
                        if (recSize != tailSize) {
                            logger.logp(Level.WARNING, className, "hasNext", "HPEL_InconsistencyInLogRecordSize", new Object[]{Integer.toString(tailSize), Long.toString(position), Integer.toString(recSize), this.file.getAbsolutePath()});
                        }
                        if (1 != this.formatter.getType(input)) break;
                        result = this.formatter.deserializeLogTime(input);
                        if (this.max >= 0L && this.max < result.getMillis()) {
                            result = null;
                            break;
                        }
                        result.setRepositoryPointer(this.getPointer(this.file, position));
                    } while (!this.verifyMin(result) || !this.recFilter.filterAccepts(this.formatter, input, result));
                    if (result != null) {
                        return result;
                    }
                    if (hasEyeCatcher) {
                        continue;
                    }
                }
                catch (IOException ex) {
                    logger.logp(Level.SEVERE, className, "hasNext", "HPEL_ErrorReadingLogRecord", new String[]{this.file.getAbsolutePath(), ex instanceof EOFException ? "EOF" : ex.getMessage()});
                    if (position <= 0L) break block17;
                    try {
                        this.reader.seek(position + 5L);
                        position = this.seekToNextRecord(this.formatter);
                        continue;
                    }
                    catch (IOException ex2) {
                        logger.logp(Level.SEVERE, className, "hasNext", "HPEL_ErrorSkippingFailedLogRecord", new String[]{this.file.getAbsolutePath(), ex2 instanceof EOFException ? "EOF" : ex2.getMessage()});
                    }
                }
            }
            this.close();
        }
        return null;
    }

    @Override
    public RepositoryLogRecord next() {
        if (!this.reader.isOpen() || this.nextRecord == null && !this.hasNext()) {
            return null;
        }
        RepositoryLogRecordImpl result = this.nextRecord;
        this.nextRecord = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Method is not applicable to this class");
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isDone() {
        return !this.reader.isOpen();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private DataInputStream readRecord(int recSize) throws IOException {
        byte[] buffer = new byte[recSize];
        this.reader.readFully(buffer, 0, recSize);
        return new DataInputStream(new ByteArrayInputStream(buffer));
    }

    public long seekToNextRecord(LogRecordSerializer formatter) throws IOException {
        int location;
        long fileSize = this.reader.length();
        long position = this.reader.getFilePointer();
        int len = 0;
        int offset = 0;
        byte[] buffer = new byte[2048];
        do {
            if (offset > 0) {
                position += (long)(len - offset);
                for (int i = 0; i < offset; ++i) {
                    buffer[i] = buffer[buffer.length - offset + i];
                }
            }
            if (position + (long)formatter.getEyeCatcherSize() > fileSize) {
                throw new IOException("No eyeCatcher found in the rest of the file.");
            }
            len = position + (long)buffer.length <= fileSize ? buffer.length : (int)(fileSize - position);
            this.reader.readFully(buffer, offset, len - offset);
            if (offset != 0) continue;
            offset = formatter.getEyeCatcherSize() - 1;
        } while ((location = formatter.findFirstEyeCatcher(buffer, 0, len)) < 0);
        this.reader.seek(position += (long)(location - 4));
        return position;
    }

    public long seekToPrevRecord(LogRecordSerializer formatter) throws IOException {
        int location;
        long position = this.reader.getFilePointer();
        byte[] buffer = new byte[2048];
        int offset = 0;
        int len = 0;
        do {
            if (position <= (long)(formatter.getEyeCatcherSize() + 3)) {
                throw new IOException("No eyeCatcher found in the rest of the file.");
            }
            len = position > (long)buffer.length ? buffer.length : (int)position;
            position -= (long)len;
            if (offset > 0) {
                for (int i = 0; i < offset; ++i) {
                    buffer[len - offset + i] = buffer[i];
                }
            }
            this.reader.seek(position);
            this.reader.readFully(buffer, 0, len - offset);
            if (offset != 0) continue;
            offset = formatter.getEyeCatcherSize() - 1;
        } while ((location = formatter.findLastEyeCatcher(buffer, 0, len)) < 0);
        this.reader.seek(position += (long)(location - 4));
        return position;
    }

    protected LogFileReader createNewReader(File file) throws IOException {
        return new LogFileReaderImpl(file);
    }

    protected LogFileReader createNewReader(LogFileReader other) throws IOException {
        if (other instanceof LogFileReaderImpl) {
            return new LogFileReaderImpl((LogFileReaderImpl)other);
        }
        throw new IOException("Instance of the " + other.getClass().getName() + " is not clonable by " + OneLogFileRecordIterator.class.getName() + ".");
    }

    protected abstract RepositoryPointer getPointer(File var1, long var2);
}

