/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.connections;

import com.ibm.ws.repository.common.enums.FilterPredicate;
import com.ibm.ws.repository.common.enums.FilterableAttribute;
import com.ibm.ws.repository.common.enums.LicenseType;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.common.enums.Visibility;
import com.ibm.ws.repository.connections.ProductDefinition;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.connections.RestRepositoryConnection;
import com.ibm.ws.repository.connections.internal.AbstractRepositoryConnection;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.resources.AdminScriptResource;
import com.ibm.ws.repository.resources.ConfigSnippetResource;
import com.ibm.ws.repository.resources.EsaResource;
import com.ibm.ws.repository.resources.IfixResource;
import com.ibm.ws.repository.resources.ProductResource;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.SampleResource;
import com.ibm.ws.repository.resources.ToolResource;
import com.ibm.ws.repository.resources.internal.ProductResourceImpl;
import com.ibm.ws.repository.resources.internal.RepositoryResourceImpl;
import com.ibm.ws.repository.resources.internal.ResourceCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class RepositoryConnectionList
extends ArrayList<RepositoryConnection> {
    private static final long serialVersionUID = -4525841713558054978L;
    private String _userAgent;

    public RepositoryConnectionList() {
    }

    public RepositoryConnectionList(List<? extends RepositoryConnection> list) {
        this.addAll(list);
    }

    public RepositoryConnectionList(RepositoryConnection repoConnection) {
        this.add(repoConnection);
    }

    @Override
    public boolean add(RepositoryConnection repoConnection) {
        boolean ret = super.add(repoConnection);
        if (repoConnection instanceof RestRepositoryConnection) {
            ((RestRepositoryConnection)repoConnection).setUserAgent(this._userAgent);
        }
        return ret;
    }

    public String getUserAgent() {
        return this._userAgent;
    }

    public void setUserAgent(String userAgent) {
        this._userAgent = userAgent;
        for (RepositoryConnection repoConnection : this) {
            if (!(repoConnection instanceof RestRepositoryConnection)) continue;
            ((RestRepositoryConnection)repoConnection).setUserAgent(this._userAgent);
        }
    }

    private <T extends RepositoryResource> Collection<T> cycleThroughRepositories(RepositoryInvoker<T> invoker) throws RepositoryBackendException {
        return this.performCycle(invoker, new ResourceCollector(ResourceCollector.DuplicatePolicy.FORBID_DUPLICATES));
    }

    private <T extends RepositoryResource> Collection<T> cycleThroughRepositoriesWithDupes(RepositoryInvoker<T> invoker) throws RepositoryBackendException {
        return this.performCycle(invoker, new ResourceCollector(ResourceCollector.DuplicatePolicy.ALLOW_DUPLICATES));
    }

    private <T extends RepositoryResource> Collection<T> performCycle(RepositoryInvoker<T> invoker, ResourceCollector<T> resources) throws RepositoryBackendException {
        if (this.size() == 1) {
            return invoker.performActionOnRepository((RepositoryConnection)this.get(0));
        }
        for (RepositoryConnection repoConnection : this) {
            Collection<T> reses = invoker.performActionOnRepository(repoConnection);
            for (RepositoryResource res : reses) {
                resources.add(res);
            }
        }
        return resources.getResourceCollection();
    }

    public Collection<EsaResource> findMatchingEsas(String searchString, ProductDefinition definition, Visibility visible) throws RepositoryException {
        Collection<? extends RepositoryResource> resources = this.findResources(searchString, Collections.singleton(definition), Collections.singleton(ResourceType.FEATURE), visible);
        return resources;
    }

    public Collection<EsaResource> getMatchingEsas(ProductDefinition definition) throws RepositoryBackendException {
        Collection<? extends RepositoryResource> ret = this.getResources(Collections.singleton(definition), Collections.singleton(ResourceType.FEATURE), null).get((Object)ResourceType.FEATURE);
        if (ret == null) {
            ret = Collections.emptySet();
        }
        return ret;
    }

    public Collection<EsaResource> getMatchingEsas(ProductDefinition definition, Visibility visible) throws RepositoryBackendException {
        Collection<? extends RepositoryResource> ret = this.getResources(Collections.singleton(definition), Collections.singleton(ResourceType.FEATURE), visible).get((Object)ResourceType.FEATURE);
        if (ret == null) {
            ret = Collections.emptySet();
        }
        return ret;
    }

    public Collection<ProductResource> getMatchingAddons(ProductDefinition definition) throws RepositoryBackendException {
        Collection<? extends RepositoryResource> addonList = this.getAllResources(ResourceType.ADDON);
        ArrayList<ProductResource> matchedAddons = new ArrayList<ProductResource>();
        for (ProductResourceImpl productResourceImpl : addonList) {
            if (productResourceImpl.matches(definition) != RepositoryResourceImpl.MatchResult.MATCHED) continue;
            matchedAddons.add(productResourceImpl);
        }
        return matchedAddons;
    }

    public Collection<EsaResource> getMatchingEsas(final FilterableAttribute attribute, final String identifier) throws RepositoryBackendException {
        Collection<EsaResource> resources = this.cycleThroughRepositories(new RepositoryInvoker<EsaResource>(){

            @Override
            public Collection<EsaResource> performActionOnRepository(RepositoryConnection connection) throws RepositoryBackendException {
                return connection.getMatchingEsas(attribute, identifier);
            }
        });
        return resources;
    }

    public Collection<SampleResource> getMatchingSamples(final FilterableAttribute attribute, final String identifier) throws RepositoryBackendException {
        Collection<SampleResource> resources = this.cycleThroughRepositories(new RepositoryInvoker<SampleResource>(){

            @Override
            public Collection<SampleResource> performActionOnRepository(RepositoryConnection connection) throws RepositoryBackendException {
                return connection.getMatchingSamples(attribute, identifier);
            }
        });
        return resources;
    }

    public Collection<SampleResource> getMatchingSamples(ProductDefinition definition) throws RepositoryBackendException {
        ArrayList<ResourceType> types = new ArrayList<ResourceType>();
        types.add(ResourceType.OPENSOURCE);
        types.add(ResourceType.PRODUCTSAMPLE);
        Map<ResourceType, Collection<? extends RepositoryResource>> resourceMap = this.getResources(Collections.singleton(definition), types, null);
        ArrayList<SampleResource> samples = new ArrayList<SampleResource>();
        for (Collection<? extends RepositoryResource> sampleResource : resourceMap.values()) {
            samples.addAll(sampleResource);
        }
        return samples;
    }

    public Collection<RepositoryResource> getMatchingResources(final FilterPredicate ... predicates) throws RepositoryBackendException {
        Collection<RepositoryResource> resources = this.cycleThroughRepositories(new RepositoryInvoker<RepositoryResource>(){

            @Override
            public Collection<RepositoryResource> performActionOnRepository(RepositoryConnection connection) throws RepositoryBackendException {
                return connection.getMatchingResources(predicates);
            }
        });
        return resources;
    }

    public Collection<? extends RepositoryResource> getAllResources() throws RepositoryBackendException {
        Collection<RepositoryResource> resources = this.cycleThroughRepositories(new RepositoryInvoker<RepositoryResource>(){

            @Override
            public Collection<RepositoryResource> performActionOnRepository(RepositoryConnection connection) throws RepositoryBackendException {
                return connection.getAllResources();
            }
        });
        return resources;
    }

    public Collection<? extends RepositoryResource> getAllResourcesWithDupes() throws RepositoryBackendException {
        Collection<RepositoryResource> resources = this.cycleThroughRepositoriesWithDupes(new RepositoryInvoker<RepositoryResource>(){

            @Override
            public Collection<RepositoryResource> performActionOnRepository(RepositoryConnection connection) throws RepositoryBackendException {
                return connection.getAllResourcesWithDupes();
            }
        });
        return resources;
    }

    public Collection<? extends RepositoryResource> getAllResources(final ResourceType type) throws RepositoryBackendException {
        Collection<RepositoryResource> resources = this.cycleThroughRepositories(new RepositoryInvoker<RepositoryResource>(){

            @Override
            public Collection<RepositoryResource> performActionOnRepository(RepositoryConnection connection) throws RepositoryBackendException {
                return connection.getAllResources(type);
            }
        });
        return resources;
    }

    public Collection<? extends RepositoryResource> getAllResourcesWithDupes(final ResourceType type) throws RepositoryBackendException {
        Collection<RepositoryResource> resources = this.cycleThroughRepositoriesWithDupes(new RepositoryInvoker<RepositoryResource>(){

            @Override
            public Collection<RepositoryResource> performActionOnRepository(RepositoryConnection connection) throws RepositoryBackendException {
                return connection.getAllResourcesWithDupes(type);
            }
        });
        return resources;
    }

    public Collection<? extends RepositoryResource> getAllResources(LicenseType licenseType, ResourceType type) throws RepositoryBackendException {
        Collection<? extends RepositoryResource> allResources = this.getAllResources(type);
        if (licenseType != null) {
            ArrayList<RepositoryResource> licensedResources = new ArrayList<RepositoryResource>();
            for (RepositoryResource repositoryResource : this.getAllResources(type)) {
                if (!licenseType.equals((Object)repositoryResource.getLicenseType())) continue;
                licensedResources.add(repositoryResource);
            }
            return licensedResources;
        }
        return allResources;
    }

    public Collection<AdminScriptResource> getAllAdminScripts() throws RepositoryBackendException {
        return this.getAllResources(ResourceType.ADMINSCRIPT);
    }

    public Collection<ConfigSnippetResource> getAllConfigSnippets() throws RepositoryBackendException {
        return this.getAllResources(ResourceType.CONFIGSNIPPET);
    }

    public Collection<EsaResource> getAllFeatures() throws RepositoryBackendException {
        return this.getAllResources(ResourceType.FEATURE);
    }

    public Collection<EsaResource> getAllFeatures(LicenseType licenseType) throws RepositoryBackendException {
        return this.getAllResources(licenseType, ResourceType.FEATURE);
    }

    public Collection<IfixResource> getAllIfixes() throws RepositoryBackendException {
        return this.getAllResources(ResourceType.IFIX);
    }

    public Collection<ProductResource> getAllProducts() throws RepositoryBackendException {
        HashSet<ResourceType> types = new HashSet<ResourceType>();
        types.add(ResourceType.INSTALL);
        types.add(ResourceType.ADDON);
        Map<ResourceType, Collection<? extends RepositoryResource>> productMap = this.getResources(Collections.emptySet(), types, null);
        ArrayList<ProductResource> products = new ArrayList<ProductResource>();
        for (Collection<? extends RepositoryResource> productResources : productMap.values()) {
            products.addAll(productResources);
        }
        return products;
    }

    public Collection<ProductResourceImpl> getAllProducts(LicenseType licenseType) throws RepositoryBackendException {
        Collection<? extends RepositoryResource> product = this.getAllResources(licenseType, ResourceType.INSTALL);
        Collection<? extends RepositoryResource> addons = this.getAllResources(licenseType, ResourceType.ADDON);
        product.addAll(addons);
        return product;
    }

    public Collection<SampleResource> getAllSamples() throws RepositoryBackendException {
        HashSet<ResourceType> types = new HashSet<ResourceType>();
        types.add(ResourceType.PRODUCTSAMPLE);
        types.add(ResourceType.OPENSOURCE);
        Map<ResourceType, Collection<? extends RepositoryResource>> sampleMap = this.getResources(Collections.emptySet(), types, null);
        ArrayList<? extends RepositoryResource> samples = new ArrayList<RepositoryResource>();
        for (Collection<? extends RepositoryResource> sampleResources : sampleMap.values()) {
            samples.addAll(sampleResources);
        }
        return Collections.unmodifiableCollection(samples);
    }

    public Collection<ToolResource> getAllTools() throws RepositoryBackendException {
        return this.getAllResources(ResourceType.TOOL);
    }

    public Collection<ToolResource> getAllTools(LicenseType licenseType) throws RepositoryBackendException {
        return this.getAllResources(licenseType, ResourceType.TOOL);
    }

    public <T extends RepositoryResourceImpl> T getResourceWithVanityRelativeURL(String vanityRelativeURL) throws RepositoryBackendException {
        Collection<? extends RepositoryResource> resources = this.getAllResources();
        for (RepositoryResourceImpl repositoryResourceImpl : resources) {
            if (!repositoryResourceImpl.getVanityURL().equals(vanityRelativeURL)) continue;
            return (T)repositoryResourceImpl;
        }
        return null;
    }

    public Collection<RepositoryResourceImpl> getAllResourcesWithVanityRelativeURL(String vanityRelativeURL) throws RepositoryBackendException {
        ResourceCollector<RepositoryResourceImpl> hits = new ResourceCollector<RepositoryResourceImpl>(ResourceCollector.DuplicatePolicy.ALLOW_DUPLICATES);
        Collection<? extends RepositoryResource> resources = this.getAllResources();
        for (RepositoryResourceImpl repositoryResourceImpl : resources) {
            if (!repositoryResourceImpl.getVanityURL().equals(vanityRelativeURL)) continue;
            hits.add(repositoryResourceImpl);
        }
        return hits.getResourceCollection();
    }

    public Map<ResourceType, Collection<? extends RepositoryResource>> getResources(Collection<ProductDefinition> productDefinitions, Collection<ResourceType> types, Visibility visibility) throws RepositoryBackendException {
        if (this.size() == 1) {
            return ((RepositoryConnection)this.get(0)).getResources(productDefinitions, types, visibility);
        }
        HashMap<ResourceType, ResourceCollector<? extends RepositoryResource>> combinedMap = new HashMap<ResourceType, ResourceCollector<? extends RepositoryResource>>();
        for (RepositoryConnection connection : this) {
            AbstractRepositoryConnection conn = (AbstractRepositoryConnection)connection;
            Map<ResourceType, Collection<? extends RepositoryResource>> singleRepo = conn.getResources(productDefinitions, types, visibility);
            for (Map.Entry<ResourceType, Collection<? extends RepositoryResource>> entry : singleRepo.entrySet()) {
                Collection<? extends RepositoryResource> singleType = entry.getValue();
                ResourceCollector<? extends RepositoryResource> overallType = (ResourceCollector<? extends RepositoryResource>)combinedMap.get((Object)entry.getKey());
                if (overallType == null) {
                    overallType = new ResourceCollector<RepositoryResource>(ResourceCollector.DuplicatePolicy.FORBID_DUPLICATES);
                    combinedMap.put(entry.getKey(), overallType);
                }
                overallType.addAll(singleType);
            }
        }
        HashMap<ResourceType, Collection<? extends RepositoryResource>> returnMap = new HashMap<ResourceType, Collection<? extends RepositoryResource>>();
        for (Map.Entry entry : combinedMap.entrySet()) {
            returnMap.put((ResourceType)((Object)entry.getKey()), ((ResourceCollector)entry.getValue()).getResourceCollection());
        }
        return returnMap;
    }

    public Collection<? extends RepositoryResource> findResources(final String searchTerm, final Collection<ProductDefinition> productDefinitions, final Collection<ResourceType> types, final Visibility visibility) throws RepositoryBackendException {
        return this.cycleThroughRepositories(new RepositoryInvoker<RepositoryResource>(){

            @Override
            public Collection<RepositoryResource> performActionOnRepository(RepositoryConnection connection) throws RepositoryBackendException {
                return connection.findResources(searchTerm, productDefinitions, types, visibility);
            }
        });
    }

    private static interface RepositoryInvoker<T extends RepositoryResource> {
        public Collection<T> performActionOnRepository(RepositoryConnection var1) throws RepositoryBackendException;
    }
}

