/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.transport.client;

import com.ibm.ws.repository.transport.client.AbstractRepositoryClient;
import com.ibm.ws.repository.transport.client.DirectoryUtils;
import com.ibm.ws.repository.transport.client.JSONAssetConverter;
import com.ibm.ws.repository.transport.exceptions.BadVersionException;
import com.ibm.ws.repository.transport.exceptions.RequestFailureException;
import com.ibm.ws.repository.transport.model.Asset;
import com.ibm.ws.repository.transport.model.Attachment;
import com.ibm.ws.repository.transport.model.WlpInformation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class LooseFileClient
extends AbstractRepositoryClient {
    private final Collection<File> assets;

    public LooseFileClient(Collection<File> assets) {
        this.assets = assets;
    }

    @Override
    public void checkRepositoryStatus() throws IOException {
        for (File f : this.assets) {
            if (f.exists()) continue;
            throw new FileNotFoundException("Could not find " + f + " in the LooseFileRepository");
        }
    }

    @Override
    public Collection<Asset> getAllAssets() throws IOException, RequestFailureException {
        ArrayList<Asset> allAssets = new ArrayList<Asset>();
        for (File f : this.assets) {
            try {
                allAssets.add(this.getAsset(f));
            }
            catch (BadVersionException badVersionException) {}
        }
        return allAssets;
    }

    @Override
    public Asset getAsset(String assetId) throws IOException, BadVersionException, RequestFailureException {
        return this.getAsset(new File(assetId));
    }

    @Override
    public InputStream getAttachment(Asset asset, Attachment attachment) throws IOException, BadVersionException, RequestFailureException {
        throw new UnsupportedOperationException("Loose config repositories do not support attachments");
    }

    protected Asset getAsset(File asset) throws IOException, BadVersionException, RequestFailureException {
        Asset ass = this.readJson(asset);
        ass.set_id(asset.getAbsolutePath());
        WlpInformation wlpInfo = ass.getWlpInformation();
        if (wlpInfo == null) {
            wlpInfo = new WlpInformation();
            ass.setWlpInformation(wlpInfo);
        }
        if (wlpInfo.getAppliesToFilterInfo() == null) {
            wlpInfo.setAppliesToFilterInfo(Collections.emptyList());
        }
        return ass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Asset readJson(File asset) throws IOException, BadVersionException {
        try (FileInputStream fis = null;){
            Asset ass;
            fis = DirectoryUtils.createFileInputStream(asset);
            Asset asset2 = ass = JSONAssetConverter.readValue(fis);
            return asset2;
        }
    }
}

