/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.interfaces.DHKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParametersHolder;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPPad;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.Arrays;

public class JcePublicKeyDataDecryptorFactoryBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private OperatorHelper contentHelper = new OperatorHelper(new DefaultJcaJceHelper());
    private JceAEADUtil aeadHelper = new JceAEADUtil(this.contentHelper);
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();
    private JcaKeyFingerprintCalculator fingerprintCalculator = new JcaKeyFingerprintCalculator();

    public JcePublicKeyDataDecryptorFactoryBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        this.contentHelper = this.helper;
        this.aeadHelper = new JceAEADUtil(this.contentHelper);
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        this.contentHelper = this.helper;
        this.aeadHelper = new JceAEADUtil(this.contentHelper);
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setContentProvider(Provider provider) {
        this.contentHelper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.aeadHelper = new JceAEADUtil(this.contentHelper);
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setContentProvider(String string) {
        this.contentHelper = new OperatorHelper(new NamedJcaJceHelper(string));
        this.aeadHelper = new JceAEADUtil(this.contentHelper);
        return this;
    }

    private int getExpectedPayloadSize(PrivateKey privateKey) {
        if (privateKey instanceof DHKey) {
            DHKey dHKey = (DHKey)((Object)privateKey);
            return (dHKey.getParams().getP().bitLength() + 7) / 8;
        }
        if (privateKey instanceof RSAKey) {
            RSAKey rSAKey = (RSAKey)((Object)privateKey);
            return (rSAKey.getModulus().bitLength() + 7) / 8;
        }
        return -1;
    }

    public PublicKeyDataDecryptorFactory build(final PrivateKey privateKey) {
        return new PublicKeyDataDecryptorFactory(){
            final int expectedPayLoadSize;
            {
                this.expectedPayLoadSize = JcePublicKeyDataDecryptorFactoryBuilder.this.getExpectedPayloadSize(privateKey);
            }

            @Override
            public byte[] recoverSessionData(int n, byte[][] byArray) throws PGPException {
                if (n == 18 || n == 25 || n == 26) {
                    throw new PGPException("ECDH requires use of PGPPrivateKey for decryption");
                }
                return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(n, privateKey, this.expectedPayLoadSize, byArray);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.contentHelper.createDataDecryptor(bl, n, byArray);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.aeadHelper.createOpenPgpV5DataDecryptor(aEADEncDataPacket, pGPSessionKey);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.aeadHelper.createOpenPgpV6DataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
            }
        };
    }

    public PublicKeyDataDecryptorFactory build(final PGPPrivateKey pGPPrivateKey) {
        return new PublicKeyDataDecryptorFactory(){

            @Override
            public byte[] recoverSessionData(int n, byte[][] byArray) throws PGPException {
                if (n == 18) {
                    return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(JcePublicKeyDataDecryptorFactoryBuilder.this.keyConverter, pGPPrivateKey, byArray);
                }
                if (n == 25) {
                    return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(JcePublicKeyDataDecryptorFactoryBuilder.this.keyConverter, pGPPrivateKey, byArray[0], 32, "X25519withSHA256HKDF", 7, EdECObjectIdentifiers.id_X25519, "X25519");
                }
                if (n == 26) {
                    return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(JcePublicKeyDataDecryptorFactoryBuilder.this.keyConverter, pGPPrivateKey, byArray[0], 56, "X448withSHA512HKDF", 9, EdECObjectIdentifiers.id_X448, "X448");
                }
                PrivateKey privateKey = JcePublicKeyDataDecryptorFactoryBuilder.this.keyConverter.getPrivateKey(pGPPrivateKey);
                int n2 = JcePublicKeyDataDecryptorFactoryBuilder.this.getExpectedPayloadSize(privateKey);
                return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(n, privateKey, n2, byArray);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.contentHelper.createDataDecryptor(bl, n, byArray);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.aeadHelper.createOpenPgpV5DataDecryptor(aEADEncDataPacket, pGPSessionKey);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.aeadHelper.createOpenPgpV6DataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
            }
        };
    }

    private byte[] decryptSessionData(JcaPGPKeyConverter jcaPGPKeyConverter, PGPPrivateKey pGPPrivateKey, byte[][] byArray) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPrivateKey.getPublicKeyPacket();
        byte[] byArray2 = byArray[0];
        int n = (((byArray2[0] & 0xFF) << 8) + (byArray2[1] & 0xFF) + 7) / 8;
        if (2 + n + 1 > byArray2.length) {
            throw new PGPException("encoded length out of range");
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 2, byArray3, 0, n);
        int n2 = byArray2[n + 2] & 0xFF;
        if (2 + n + 1 + n2 > byArray2.length) {
            throw new PGPException("encoded length out of range");
        }
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray2, 2 + n + 1, byArray4, 0, n2);
        try {
            Object object;
            Object object2;
            PublicKey publicKey;
            String string;
            ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
            if (eCDHPublicBCPGKey.getCurveOID().equals(CryptlibObjectIdentifiers.curvey25519)) {
                string = RFC6637Utils.getXDHAlgorithm(publicKeyPacket);
                if (byArray3.length != 33 || 64 != byArray3[0]) {
                    throw new IllegalArgumentException("Invalid Curve25519 public key");
                }
                publicKey = this.getPublicKey(byArray3, EdECObjectIdentifiers.id_X25519, 1);
            } else {
                object2 = ECNamedCurveTable.getByOIDLazy(eCDHPublicBCPGKey.getCurveOID());
                object = ((X9ECParametersHolder)object2).getCurve().decodePoint(byArray3);
                string = RFC6637Utils.getAgreementAlgorithm(publicKeyPacket);
                publicKey = jcaPGPKeyConverter.getPublicKey(new PGPPublicKey(new PublicKeyPacket(18, new Date(), new ECDHPublicBCPGKey(eCDHPublicBCPGKey.getCurveOID(), (ECPoint)object, (int)eCDHPublicBCPGKey.getHashAlgorithm(), (int)eCDHPublicBCPGKey.getSymmetricKeyAlgorithm())), this.fingerprintCalculator));
            }
            object2 = RFC6637Utils.createUserKeyingMaterial(publicKeyPacket, this.fingerprintCalculator);
            object = this.getSessionKey(jcaPGPKeyConverter, pGPPrivateKey, string, publicKey, eCDHPublicBCPGKey.getSymmetricKeyAlgorithm(), byArray4, (AlgorithmParameterSpec)new UserKeyingMaterialSpec((byte[])object2));
            return PGPPad.unpadSessionData(object.getEncoded());
        }
        catch (Exception exception) {
            throw new PGPException("error decrypting session data: " + exception.getMessage(), exception);
        }
    }

    private byte[] decryptSessionData(JcaPGPKeyConverter jcaPGPKeyConverter, PGPPrivateKey pGPPrivateKey, byte[] byArray, int n, String string, int n2, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2) throws PGPException {
        try {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            int n3 = byArray[n] & 0xFF;
            if (n + 1 + n3 > byArray.length) {
                throw new PGPException("encoded length out of range");
            }
            byte[] byArray3 = new byte[n3 - 1];
            System.arraycopy(byArray, n + 2, byArray3, 0, byArray3.length);
            PublicKey publicKey = this.getPublicKey(byArray2, aSN1ObjectIdentifier, 0);
            Key key = this.getSessionKey(jcaPGPKeyConverter, pGPPrivateKey, string, publicKey, n2, byArray3, (AlgorithmParameterSpec)JcaJcePGPUtil.getHybridValueParameterSpecWithPrepend(byArray2, pGPPrivateKey.getPublicKeyPacket(), string2));
            n2 = byArray[n + 1] & 0xFF;
            return Arrays.concatenate(new byte[]{(byte)n2}, key.getEncoded());
        }
        catch (Exception exception) {
            throw new PGPException("error decrypting session data: " + exception.getMessage(), exception);
        }
    }

    private Key getSessionKey(JcaPGPKeyConverter jcaPGPKeyConverter, PGPPrivateKey pGPPrivateKey, String string, PublicKey publicKey, int n, byte[] byArray, AlgorithmParameterSpec algorithmParameterSpec) throws PGPException, GeneralSecurityException {
        PrivateKey privateKey = jcaPGPKeyConverter.getPrivateKey(pGPPrivateKey);
        Key key = JcaJcePGPUtil.getSecret(this.helper, publicKey, RFC6637Utils.getKeyEncryptionOID(n).getId(), string, algorithmParameterSpec, privateKey);
        Cipher cipher = this.helper.createKeyWrapper(n);
        cipher.init(4, key);
        return cipher.unwrap(byArray, "Session", 3);
    }

    private PublicKey getPublicKey(byte[] byArray, ASN1ObjectIdentifier aSN1ObjectIdentifier, int n) throws PGPException, GeneralSecurityException, IOException {
        KeyFactory keyFactory = this.helper.createKeyFactory("XDH");
        return keyFactory.generatePublic(new X509EncodedKeySpec(new SubjectPublicKeyInfo(new AlgorithmIdentifier(aSN1ObjectIdentifier), Arrays.copyOfRange(byArray, n, byArray.length)).getEncoded()));
    }

    private void updateWithMPI(Cipher cipher, int n, byte[] byArray) {
        if (n > 0) {
            if (byArray.length - 2 > n) {
                cipher.update(byArray, 3, byArray.length - 3);
            } else {
                if (n > byArray.length - 2) {
                    cipher.update(new byte[n - (byArray.length - 2)]);
                }
                cipher.update(byArray, 2, byArray.length - 2);
            }
        } else {
            cipher.update(byArray, 2, byArray.length - 2);
        }
    }

    private byte[] decryptSessionData(int n, PrivateKey privateKey, int n2, byte[][] byArray) throws PGPException {
        Cipher cipher = this.helper.createPublicKeyCipher(n);
        try {
            cipher.init(2, privateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("error setting asymmetric cipher", invalidKeyException);
        }
        if (n == 2 || n == 1) {
            this.updateWithMPI(cipher, n2, byArray[0]);
        } else {
            this.updateWithMPI(cipher, n2, byArray[0]);
            this.updateWithMPI(cipher, n2, byArray[1]);
        }
        try {
            return cipher.doFinal();
        }
        catch (Exception exception) {
            throw new PGPException("exception decrypting session data", exception);
        }
    }
}

