/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.admin.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.config.admin.ConfigID;
import com.ibm.ws.config.admin.ConfigurationDictionary;
import com.ibm.ws.config.admin.ExtendedConfiguration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ConfigurationStorageHelper {
    private static final TraceComponent tc = Tr.register(ConfigurationStorageHelper.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    public static final byte VERSION = 0;
    private static final byte BYTE = 0;
    private static final byte SHORT = 1;
    private static final byte BOOLEAN = 2;
    private static final byte CHAR = 3;
    private static final byte DOUBLE = 4;
    private static final byte LONG = 5;
    private static final byte FLOAT = 6;
    private static final byte INTEGER = 7;
    private static final byte STRING = 8;
    private static final byte PROTECTED_STRING = 9;
    private static final byte COLLECTION = 10;
    private static final byte MAP = 11;
    private static final byte ARRAY = 12;
    private static final byte ONERROR = 13;
    private static final byte NULL = 14;
    private static final byte OBJECT = 15;
    private static final byte LONG_STRING = 16;
    private static final byte LONG_PROTECTED_STRING = 17;
    private final int version;
    private String location;
    private final Dictionary<String, ?> readOnlyProps;
    private final Set<String> uniqueVars;
    private final Set<ConfigID> references;
    private static final int MAX_LENGTH = 65535;
    static final long serialVersionUID = -2028079922834930000L;

    private static boolean isValidVersion(int version) {
        if (version != 0) {
            Tr.warning((TraceComponent)tc, (String)("Unsupported configuration storage version [ " + version + " ]: The version should be [ " + 0 + " ]"), (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    public int getVersion() {
        return this.version;
    }

    public String getLocation() {
        return this.location;
    }

    public Dictionary<String, ?> getReadOnlyProps() {
        return this.readOnlyProps;
    }

    public Set<String> getUniqueVars() {
        return this.uniqueVars;
    }

    public Set<ConfigID> getReferences() {
        return this.references;
    }

    public ConfigurationStorageHelper() {
        this.version = 0;
        this.location = null;
        this.readOnlyProps = new ConfigurationDictionary();
        this.uniqueVars = new HashSet<String>();
        this.references = new HashSet<ConfigID>();
    }

    @FFDCIgnore(value={IllegalStateException.class})
    private static ConfigurationStorageHelper newWriteHelper(ExtendedConfiguration config) {
        try {
            Dictionary<String, Object> readOnlyProps = config.getReadOnlyProperties();
            if (readOnlyProps == null) {
                return null;
            }
            return new ConfigurationStorageHelper(config, readOnlyProps);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    private ConfigurationStorageHelper(ExtendedConfiguration config, Dictionary<String, ?> readOnlyProps) {
        this(config.getBundleLocation(), readOnlyProps, config.getUniqueVariables(), config.getReferences());
    }

    public ConfigurationStorageHelper(String location, Dictionary<String, ?> readOnlyProps, Set<String> uniqueVars, Set<ConfigID> references) {
        this.version = 0;
        this.location = location;
        this.readOnlyProps = readOnlyProps;
        this.uniqueVars = uniqueVars;
        this.references = references;
    }

    public <K, C> void storeConfiguration(ConfigStorageConsumer<K, C> consumer, Map<K, C> storage) {
        C config = consumer.consumeConfigData(this.location, this.uniqueVars, this.references, (ConfigurationDictionary)this.readOnlyProps);
        storage.put(consumer.getKey(config), config);
    }

    public static <K, C> Map<K, C> load(File configFile, ConfigStorageConsumer<K, C> consumer) throws IOException {
        HashMap storage = new HashMap();
        FileInputStream fis = new FileInputStream(configFile);
        try {
            BufferedInputStream bis = new BufferedInputStream(fis);
            try {
                DataInputStream dis;
                block13: {
                    dis = new DataInputStream(bis);
                    try {
                        byte version = dis.readByte();
                        if (!ConfigurationStorageHelper.isValidVersion(version)) break block13;
                        int numConfigs = dis.readInt();
                        for (int i = 0; i < numConfigs; ++i) {
                            ConfigurationStorageHelper helper = new ConfigurationStorageHelper();
                            helper.load(dis);
                            helper.storeConfiguration(consumer, storage);
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.admin.internal.ConfigurationStorageHelper", (String)"335", null, (Object[])new Object[]{configFile, consumer});
                        try {
                            dis.close();
                        }
                        catch (Throwable throwable2) {
                            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.config.admin.internal.ConfigurationStorageHelper", (String)"335", null, (Object[])new Object[]{configFile, consumer});
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                dis.close();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.admin.internal.ConfigurationStorageHelper", (String)"335", null, (Object[])new Object[]{configFile, consumer});
                try {
                    bis.close();
                }
                catch (Throwable throwable3) {
                    FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.config.admin.internal.ConfigurationStorageHelper", (String)"335", null, (Object[])new Object[]{configFile, consumer});
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            bis.close();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.admin.internal.ConfigurationStorageHelper", (String)"335", null, (Object[])new Object[]{configFile, consumer});
            try {
                fis.close();
            }
            catch (Throwable throwable4) {
                FFDCFilter.processException((Throwable)throwable4, (String)"com.ibm.ws.config.admin.internal.ConfigurationStorageHelper", (String)"335", null, (Object[])new Object[]{configFile, consumer});
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        fis.close();
        return storage;
    }

    protected void load(DataInputStream dis) throws IOException {
        this.location = (String)ConfigurationStorageHelper.readObject(dis);
        int len = dis.readInt();
        for (int i = 0; i < len; ++i) {
            this.uniqueVars.add(dis.readUTF());
        }
        len = dis.readInt();
        ArrayList<ConfigID> ids = new ArrayList<ConfigID>();
        int i = 0;
        int j = 0;
        int cursor = 0;
        while (i < len + cursor) {
            if (cursor == 0) {
                cursor = dis.readInt();
                j = 0;
            }
            String id = (String)ConfigurationStorageHelper.readObject(dis);
            String configPid = dis.readUTF();
            String child = (String)ConfigurationStorageHelper.readObject(dis);
            int parentId = dis.readInt();
            ConfigID parent = null;
            if (parentId > -1) {
                parent = (ConfigID)ids.get(parentId);
            }
            ConfigID thisId = new ConfigID(parent, configPid, id, child);
            ids.add(thisId);
            if (j == cursor) {
                len += cursor;
                cursor = 0;
                this.references.add(thisId);
            }
            ++i;
            ++j;
        }
        ConfigurationStorageHelper.readMapInternal(dis, ConfigurationStorageHelper.toMapOrDictionary(this.readOnlyProps));
    }

    public static void store(File configFile, Collection<? extends ExtendedConfiguration> configs) throws IOException {
        FileOutputStream fos = new FileOutputStream(configFile, false);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            try {
                DataOutputStream dos = new DataOutputStream(bos);
                try {
                    dos.writeByte(0);
                    ArrayList<ConfigurationStorageHelper> helpers = new ArrayList<ConfigurationStorageHelper>(configs.size());
                    for (ExtendedConfiguration extendedConfiguration : configs) {
                        ConfigurationStorageHelper helper = ConfigurationStorageHelper.newWriteHelper(extendedConfiguration);
                        if (helper == null) continue;
                        helpers.add(helper);
                    }
                    dos.writeInt(helpers.size());
                    for (ConfigurationStorageHelper configurationStorageHelper : helpers) {
                        configurationStorageHelper.store(dos);
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.admin.internal.ConfigurationStorageHelper", (String)"405", null, (Object[])new Object[]{configFile, configs});
                    try {
                        dos.close();
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.config.admin.internal.ConfigurationStorageHelper", (String)"405", null, (Object[])new Object[]{configFile, configs});
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                dos.close();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.admin.internal.ConfigurationStorageHelper", (String)"405", null, (Object[])new Object[]{configFile, configs});
                try {
                    bos.close();
                }
                catch (Throwable throwable3) {
                    FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.config.admin.internal.ConfigurationStorageHelper", (String)"405", null, (Object[])new Object[]{configFile, configs});
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            bos.close();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.admin.internal.ConfigurationStorageHelper", (String)"405", null, (Object[])new Object[]{configFile, configs});
            try {
                fos.close();
            }
            catch (Throwable throwable4) {
                FFDCFilter.processException((Throwable)throwable4, (String)"com.ibm.ws.config.admin.internal.ConfigurationStorageHelper", (String)"405", null, (Object[])new Object[]{configFile, configs});
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        fos.close();
    }

    protected void store(DataOutputStream dos) throws IOException {
        this.writeObject(dos, this.location);
        if (this.uniqueVars != null) {
            dos.writeInt(this.uniqueVars.size());
            for (String var : this.uniqueVars) {
                dos.writeUTF(var);
            }
        } else {
            dos.writeInt(0);
        }
        if (this.references != null) {
            dos.writeInt(this.references.size());
            int count = 0;
            HashMap<ConfigID, Integer> writtenConfigIds = new HashMap<ConfigID, Integer>();
            for (ConfigID id : this.references) {
                count = this.writeConfigID(dos, id, count, 0, writtenConfigIds);
            }
        } else {
            dos.writeInt(0);
        }
        this.writeMapInternal(dos, ConfigurationStorageHelper.toMapOrDictionary(this.readOnlyProps));
    }

    public static void readMap(DataInputStream dis, MapIterable props) throws IOException {
        byte version = dis.readByte();
        if (ConfigurationStorageHelper.isValidVersion(version)) {
            ConfigurationStorageHelper.readMapInternal(dis, props);
        }
    }

    private static void readMapInternal(DataInputStream dis, MapIterable props) throws IOException {
        int size = dis.readInt();
        for (int i = 0; i < size; ++i) {
            String key = dis.readUTF();
            Object value = ConfigurationStorageHelper.readMapValue(dis);
            props.put(key, value);
        }
    }

    private static Object readMapValue(DataInputStream dis) throws IOException {
        Object value;
        byte type = dis.readByte();
        if (type == 10) {
            value = ConfigurationStorageHelper.readCollection(dis);
        } else if (type == 12) {
            value = ConfigurationStorageHelper.readArray(dis);
        } else if (type == 11) {
            HashMap map = new HashMap();
            value = map;
            ConfigurationStorageHelper.readMapInternal(dis, ConfigurationStorageHelper.toMapOrDictionary(map));
        } else if (type == 15) {
            value = ConfigurationStorageHelper.readObject(dis);
        } else {
            throw new IllegalArgumentException("Unsupported map value type: " + type);
        }
        return value;
    }

    private static Object readArray(DataInputStream dis) throws IOException {
        Object[] value;
        boolean primitive = dis.readBoolean();
        byte type = dis.readByte();
        int size = dis.readInt();
        if (type == 0) {
            value = primitive ? ConfigurationStorageHelper.readPByteArray(dis, size) : (byte[])ConfigurationStorageHelper.readByteArray(dis, size);
        } else if (type == 1) {
            value = primitive ? ConfigurationStorageHelper.readPShortArray(dis, size) : (short[])ConfigurationStorageHelper.readShortArray(dis, size);
        } else if (type == 2) {
            value = primitive ? ConfigurationStorageHelper.readPBooleanArray(dis, size) : (boolean[])ConfigurationStorageHelper.readBooleanArray(dis, size);
        } else if (type == 3) {
            value = primitive ? ConfigurationStorageHelper.readCharArray(dis, size) : (char[])ConfigurationStorageHelper.readCharacterArray(dis, size);
        } else if (type == 4) {
            value = primitive ? ConfigurationStorageHelper.readPDoubleArray(dis, size) : (double[])ConfigurationStorageHelper.readDoubleArray(dis, size);
        } else if (type == 5) {
            value = primitive ? ConfigurationStorageHelper.readPLongArray(dis, size) : (long[])ConfigurationStorageHelper.readLongArray(dis, size);
        } else if (type == 6) {
            value = primitive ? ConfigurationStorageHelper.readPFloatArray(dis, size) : (float[])ConfigurationStorageHelper.readFloatArray(dis, size);
        } else if (type == 7) {
            value = primitive ? ConfigurationStorageHelper.readIntArray(dis, size) : (int[])ConfigurationStorageHelper.readIntegerArray(dis, size);
        } else if (type == 8) {
            value = ConfigurationStorageHelper.readStringArray(dis, size);
        } else if (type == 9) {
            value = ConfigurationStorageHelper.readProtectedStringArray(dis, size);
        } else if (type == 13) {
            value = ConfigurationStorageHelper.readOnErrorArray(dis, size);
        } else {
            throw new IllegalArgumentException("Unsupported type for array: " + type);
        }
        return value;
    }

    private static byte[] readPByteArray(DataInputStream dis, int size) throws IOException {
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = dis.readByte();
        }
        return result;
    }

    private static Byte[] readByteArray(DataInputStream dis, int size) throws IOException {
        Byte[] result = new Byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (Byte)ConfigurationStorageHelper.readObject(dis);
        }
        return result;
    }

    private static short[] readPShortArray(DataInputStream dis, int size) throws IOException {
        short[] result = new short[size];
        for (int i = 0; i < size; ++i) {
            result[i] = dis.readShort();
        }
        return result;
    }

    private static Short[] readShortArray(DataInputStream dis, int size) throws IOException {
        Short[] result = new Short[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (Short)ConfigurationStorageHelper.readObject(dis);
        }
        return result;
    }

    private static boolean[] readPBooleanArray(DataInputStream dis, int size) throws IOException {
        boolean[] result = new boolean[size];
        for (int i = 0; i < size; ++i) {
            result[i] = dis.readBoolean();
        }
        return result;
    }

    private static Boolean[] readBooleanArray(DataInputStream dis, int size) throws IOException {
        Boolean[] result = new Boolean[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (Boolean)ConfigurationStorageHelper.readObject(dis);
        }
        return result;
    }

    private static char[] readCharArray(DataInputStream dis, int size) throws IOException {
        char[] result = new char[size];
        for (int i = 0; i < size; ++i) {
            result[i] = dis.readChar();
        }
        return result;
    }

    private static Character[] readCharacterArray(DataInputStream dis, int size) throws IOException {
        Character[] result = new Character[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (Character)ConfigurationStorageHelper.readObject(dis);
        }
        return result;
    }

    private static double[] readPDoubleArray(DataInputStream dis, int size) throws IOException {
        double[] result = new double[size];
        for (int i = 0; i < size; ++i) {
            result[i] = dis.readDouble();
        }
        return result;
    }

    private static Double[] readDoubleArray(DataInputStream dis, int size) throws IOException {
        Double[] result = new Double[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (Double)ConfigurationStorageHelper.readObject(dis);
        }
        return result;
    }

    private static long[] readPLongArray(DataInputStream dis, int size) throws IOException {
        long[] result = new long[size];
        for (int i = 0; i < size; ++i) {
            result[i] = dis.readLong();
        }
        return result;
    }

    private static Long[] readLongArray(DataInputStream dis, int size) throws IOException {
        Long[] result = new Long[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (Long)ConfigurationStorageHelper.readObject(dis);
        }
        return result;
    }

    private static float[] readPFloatArray(DataInputStream dis, int size) throws IOException {
        float[] result = new float[size];
        for (int i = 0; i < size; ++i) {
            result[i] = dis.readFloat();
        }
        return result;
    }

    private static Float[] readFloatArray(DataInputStream dis, int size) throws IOException {
        Float[] result = new Float[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (Float)ConfigurationStorageHelper.readObject(dis);
        }
        return result;
    }

    private static int[] readIntArray(DataInputStream dis, int size) throws IOException {
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = dis.readInt();
        }
        return result;
    }

    private static Integer[] readIntegerArray(DataInputStream dis, int size) throws IOException {
        Integer[] result = new Integer[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (Integer)ConfigurationStorageHelper.readObject(dis);
        }
        return result;
    }

    private static String[] readStringArray(DataInputStream dis, int size) throws IOException {
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (String)ConfigurationStorageHelper.readObject(dis);
        }
        return result;
    }

    private static SerializableProtectedString[] readProtectedStringArray(DataInputStream dis, int size) throws IOException {
        SerializableProtectedString[] result = new SerializableProtectedString[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (SerializableProtectedString)ConfigurationStorageHelper.readObject(dis);
        }
        return result;
    }

    private static OnErrorUtil.OnError[] readOnErrorArray(DataInputStream dis, int size) throws IOException {
        OnErrorUtil.OnError[] result = new OnErrorUtil.OnError[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (OnErrorUtil.OnError)ConfigurationStorageHelper.readObject(dis);
        }
        return result;
    }

    private static Collection<?> readCollection(DataInputStream dis) throws IOException {
        ArrayList<Object> result = new ArrayList<Object>();
        int len = dis.readInt();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                result.add(ConfigurationStorageHelper.readObject(dis));
            }
        }
        return result;
    }

    private static Object readObject(DataInputStream dis) throws IOException {
        byte type = dis.readByte();
        switch (type) {
            case 14: {
                return null;
            }
            case 0: {
                return dis.readByte();
            }
            case 1: {
                return dis.readShort();
            }
            case 2: {
                return dis.readBoolean();
            }
            case 3: {
                return Character.valueOf(dis.readChar());
            }
            case 4: {
                return dis.readDouble();
            }
            case 5: {
                return dis.readLong();
            }
            case 6: {
                return Float.valueOf(dis.readFloat());
            }
            case 7: {
                return dis.readInt();
            }
            case 8: {
                return dis.readUTF();
            }
            case 16: {
                return ConfigurationStorageHelper.readLongString(dis);
            }
            case 9: {
                return new SerializableProtectedString(dis.readUTF().toCharArray());
            }
            case 17: {
                return new SerializableProtectedString(ConfigurationStorageHelper.readLongProtectedString(dis).toCharArray());
            }
            case 13: {
                return OnErrorUtil.OnError.values()[dis.readInt()];
            }
        }
        throw new IllegalArgumentException("Unsupported object type: " + type);
    }

    public static void writeMap(DataOutputStream dos, MapIterable map) throws IOException {
        dos.writeByte(0);
        ConfigurationStorageHelper helper = new ConfigurationStorageHelper();
        helper.writeMapInternal(dos, map);
    }

    private void writeMapInternal(DataOutputStream dos, MapIterable map) throws IOException {
        if (map == null) {
            dos.writeInt(-1);
            return;
        }
        dos.writeInt(map.size());
        for (Map.Entry<String, Object> entry : map) {
            dos.writeUTF(entry.getKey());
            Object obj = entry.getValue();
            if (obj instanceof Collection) {
                dos.writeByte(10);
                Collection data = (Collection)obj;
                dos.writeInt(data.size());
                for (Object colObj : data) {
                    this.writeObject(dos, colObj);
                }
                continue;
            }
            if (obj instanceof Map) {
                dos.writeByte(11);
                this.writeMapInternal(dos, ConfigurationStorageHelper.toMapOrDictionary(obj));
                continue;
            }
            if (obj != null && obj.getClass().isArray()) {
                dos.writeByte(12);
                Class<?> arrayType = obj.getClass();
                arrayType = arrayType.getComponentType();
                dos.writeBoolean(arrayType.isPrimitive());
                this.writeArrayType(dos, arrayType);
                int len = Array.getLength(obj);
                dos.writeInt(len);
                for (int i = 0; i < len; ++i) {
                    if (arrayType.isPrimitive()) {
                        this.writePrimitive(dos, Array.get(obj, i));
                        continue;
                    }
                    this.writeObject(dos, Array.get(obj, i));
                }
                continue;
            }
            dos.writeByte(15);
            this.writeObject(dos, obj);
        }
    }

    public static MapIterable toMapOrDictionary(Object obj) {
        if (obj instanceof Dictionary) {
            return new DictionaryMapIterableImpl((Dictionary)obj);
        }
        if (obj instanceof Map) {
            return new MapIterableImpl((Map)obj);
        }
        return null;
    }

    private void writeArrayType(DataOutputStream dos, Class<?> type) throws IOException {
        if (type == Byte.class || type == Byte.TYPE) {
            dos.writeByte(0);
        } else if (type == Short.class || type == Short.TYPE) {
            dos.writeByte(1);
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            dos.writeByte(2);
        } else if (type == Character.class || type == Character.TYPE) {
            dos.writeByte(3);
        } else if (type == Double.class || type == Double.TYPE) {
            dos.writeByte(4);
        } else if (type == Long.class || type == Long.TYPE) {
            dos.writeByte(5);
        } else if (type == Float.class || type == Float.TYPE) {
            dos.writeByte(6);
        } else if (type == Integer.class || type == Integer.TYPE) {
            dos.writeByte(7);
        } else if (type == String.class) {
            dos.writeByte(8);
        } else if (type == SerializableProtectedString.class) {
            dos.writeByte(9);
        } else if (type == OnErrorUtil.OnError.class) {
            dos.writeByte(13);
        } else {
            throw new IllegalArgumentException("Unsupported object type: " + type.getName());
        }
    }

    private void writePrimitive(DataOutputStream dos, Object obj) throws IOException {
        if (obj instanceof Byte) {
            dos.writeByte(((Byte)obj).byteValue());
        } else if (obj instanceof Short) {
            dos.writeShort(((Short)obj).shortValue());
        } else if (obj instanceof Boolean) {
            dos.writeBoolean((Boolean)obj);
        } else if (obj instanceof Character) {
            dos.writeChar(((Character)obj).charValue());
        } else if (obj instanceof Double) {
            dos.writeDouble((Double)obj);
        } else if (obj instanceof Long) {
            dos.writeLong((Long)obj);
        } else if (obj instanceof Float) {
            dos.writeFloat(((Float)obj).floatValue());
        } else if (obj instanceof Integer) {
            dos.writeInt((Integer)obj);
        } else {
            throw new IllegalArgumentException("Unsupported object type: " + String.valueOf(obj));
        }
    }

    private void writeObject(DataOutputStream dos, Object obj) throws IOException {
        if (obj == null) {
            dos.writeByte(14);
            return;
        }
        Class<?> type = obj.getClass();
        if (type == Byte.class) {
            dos.writeByte(0);
            dos.writeByte(((Byte)obj).byteValue());
        } else if (type == Short.class) {
            dos.writeByte(1);
            dos.writeShort(((Short)obj).shortValue());
        } else if (type == Boolean.class) {
            dos.writeByte(2);
            dos.writeBoolean((Boolean)obj);
        } else if (type == Character.class) {
            dos.writeByte(3);
            dos.writeChar(((Character)obj).charValue());
        } else if (type == Double.class) {
            dos.writeByte(4);
            dos.writeDouble((Double)obj);
        } else if (type == Long.class) {
            dos.writeByte(5);
            dos.writeLong((Long)obj);
        } else if (type == Float.class) {
            dos.writeByte(6);
            dos.writeFloat(((Float)obj).floatValue());
        } else if (type == Integer.class) {
            dos.writeByte(7);
            dos.writeInt((Integer)obj);
        } else if (type == String.class) {
            this.writeString(dos, (String)obj);
        } else if (type == SerializableProtectedString.class) {
            this.writeProtectedString(dos, (SerializableProtectedString)obj);
        } else if (type == OnErrorUtil.OnError.class) {
            dos.writeByte(13);
            dos.writeInt(((OnErrorUtil.OnError)obj).ordinal());
        } else {
            throw new IllegalArgumentException("Unsupported object type: " + type.getName());
        }
    }

    private int writeConfigID(DataOutputStream dos, ConfigID id, int count, int depth, Map<ConfigID, Integer> writtenConfigIds) throws IOException {
        ConfigID parent = id.getParent();
        int parentIndex = -1;
        if (parent != null) {
            Integer index = writtenConfigIds.get(id.getParent());
            parentIndex = index == null ? (count = this.writeConfigID(dos, parent, count, depth + 1, writtenConfigIds)) : index;
        } else {
            dos.writeInt(depth);
        }
        this.writeObject(dos, id.getId());
        dos.writeUTF(id.getPid());
        this.writeObject(dos, id.getChildAttribute());
        dos.writeInt(parentIndex - 1);
        return count + 1;
    }

    private final void writeString(DataOutputStream dos, String str) throws IOException {
        if (ConfigurationStorageHelper.isShort(str)) {
            dos.writeByte(8);
            dos.writeUTF(str);
        } else {
            byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
            dos.writeByte(16);
            dos.writeInt(bytes.length);
            dos.write(bytes);
        }
    }

    @Trivial
    private final void writeProtectedString(DataOutputStream dos, SerializableProtectedString str) throws IOException {
        String rawStr = new String(str.getChars());
        if (ConfigurationStorageHelper.isShort(rawStr)) {
            dos.writeByte(9);
            dos.writeUTF(rawStr);
        } else {
            byte[] bytes = rawStr.getBytes(StandardCharsets.UTF_8);
            dos.writeByte(17);
            dos.writeInt(bytes.length);
            dos.write(bytes);
        }
    }

    private static boolean isShort(String str) {
        return str.length() < 21845;
    }

    private static String readLongString(DataInputStream dis) throws IOException {
        int length = dis.readInt();
        byte[] strBytes = new byte[length];
        dis.readFully(strBytes);
        return new String(strBytes, StandardCharsets.UTF_8);
    }

    @Trivial
    private static String readLongProtectedString(DataInputStream dis) throws IOException {
        int length = dis.readInt();
        byte[] strBytes = new byte[length];
        dis.readFully(strBytes);
        return new String(strBytes, StandardCharsets.UTF_8);
    }

    public static interface ConfigStorageConsumer<K, C> {
        public C consumeConfigData(String var1, Set<String> var2, Set<ConfigID> var3, ConfigurationDictionary var4);

        public K getKey(C var1);
    }

    public static interface MapIterable
    extends Iterable<Map.Entry<String, Object>> {
        public int size();

        @Override
        public Iterator<Map.Entry<String, Object>> iterator();

        public void put(String var1, Object var2);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class DictionaryMapIterableImpl
    implements MapIterable {
        protected final Dictionary<String, Object> dict;
        static final long serialVersionUID = -5955045502770621460L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public DictionaryMapIterableImpl(Dictionary<String, Object> dict) {
            this.dict = dict;
        }

        @Override
        public int size() {
            return this.dict.size();
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new MyIterator();
        }

        @Override
        public void put(String name, Object val) {
            this.dict.put(name, val);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.admin.internal.ConfigurationStorageHelper$DictionaryMapIterableImpl", DictionaryMapIterableImpl.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
        }

        @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
        @InjectedFFDC
        @TraceOptions
        public class MyIterator
        implements Iterator<Map.Entry<String, Object>> {
            Enumeration<String> keys;
            static final long serialVersionUID = 9071076507878889811L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public MyIterator() {
                this.keys = DictionaryMapIterableImpl.this.dict.keys();
            }

            @Override
            public boolean hasNext() {
                return this.keys.hasMoreElements();
            }

            @Override
            public Map.Entry<String, Object> next() {
                String key = this.keys.nextElement();
                return new AbstractMap.SimpleEntry<String, Object>(key, DictionaryMapIterableImpl.this.dict.get(key));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.admin.internal.ConfigurationStorageHelper$DictionaryMapIterableImpl$MyIterator", MyIterator.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class MapIterableImpl
    implements MapIterable {
        private final Map<String, Object> map;
        static final long serialVersionUID = 2578047118420425273L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public MapIterableImpl(Map<String, Object> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return this.map.entrySet().iterator();
        }

        @Override
        public void put(String name, Object val) {
            this.map.put(name, val);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.admin.internal.ConfigurationStorageHelper$MapIterableImpl", MapIterableImpl.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
        }
    }
}

