/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.server.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.Introspector;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.felix.service.command.Descriptor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={Object.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"osgi.command.scope=kernel", "osgi.command.function=inspect", "service.vendor=IBM"})
public class InspectCommand {
    static final long serialVersionUID = -7433047539498526641L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void inspect() {
        this.displayUsage();
    }

    @Descriptor(value="Lists or invokes the known introspections available in this server.")
    public void inspect(String arg) {
        switch (arg.toLowerCase()) {
            case "-h": 
            case "--help": 
            case "help": {
                this.displayUsage();
                return;
            }
            case "-l": 
            case "--list": 
            case "list": {
                Introspectors.INTROSPECTORS.listAll();
                return;
            }
        }
        Introspectors.INTROSPECTORS.findAndRun(arg);
    }

    @Descriptor(value="Describes or invokes the known introspections available in this server.")
    public void inspect(String arg, String introspector) {
        switch (arg.toLowerCase()) {
            case "-h": 
            case "--help": 
            case "help": {
                Introspectors.INTROSPECTORS.findAndDescribe(introspector);
                return;
            }
            case "-r": 
            case "--run": 
            case "run": {
                Introspectors.INTROSPECTORS.findAndRun(introspector);
                return;
            }
        }
        throw new RuntimeException("error: unknown option '" + arg + "' to inspect command");
    }

    private void displayUsage() {
        System.out.println("usage: inspect [-h|--help|help]");
        System.out.println("       Print this usage message.");
        System.out.println();
        System.out.println("usage: inspect -h|--help|help <introspector>");
        System.out.println("       Describe the named introspector.");
        System.out.println();
        System.out.println("usage: inspect -l|--list|list");
        System.out.println("       List available introspectors.");
        System.out.println();
        System.out.println("usage: inspect [-r|--run|run] <introspector>");
        System.out.println("       Run the named introspection.");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.server.internal.InspectCommand", InspectCommand.class, null, null);
    }

    static enum Introspectors {
        INTROSPECTORS;


        void listAll() {
            System.out.println("Available introspections: ");
            TreeSet set = new TreeSet();
            this.forEach("retrieve introspector name", i -> set.add("\t" + i.getIntrospectorName()), new Predicate[0]);
            set.forEach(System.out::println);
        }

        void findAndDescribe(String name) {
            int num = this.forEach("describe introspector", this::describe, i -> Objects.equals(name, i.getIntrospectorName()));
            if (0 == num) {
                throw new RuntimeException("error: could not find an introspector with name '" + name + "'");
            }
        }

        void findAndRun(String name) {
            int num = this.forEach("run introspector", this::run, i -> Objects.equals(name, i.getIntrospectorName()));
            if (0 == num) {
                throw new RuntimeException("error: could not find an introspector with name '" + name + "'");
            }
        }

        private void describe(Introspector ii) {
            System.out.println(ii.getIntrospectorName());
            System.out.println(ii.getIntrospectorName().replaceAll(".", "="));
            System.out.println(ii.getIntrospectorDescription());
            System.out.println();
            System.out.println();
        }

        private void run(Introspector i) throws Exception {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                i.introspect(pw);
                pw.flush();
            }
            System.out.println(sw);
        }

        @SafeVarargs
        private final int forEach(String desc, IntrospectorAction action, Predicate<Introspector> ... filters) {
            Collection refs;
            int count = 0;
            BundleContext ctx = FrameworkUtil.getBundle(Introspectors.class).getBundleContext();
            try {
                refs = ctx.getServiceReferences(Introspector.class, null);
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException("error: unable to retrieve introspector service references", e);
            }
            Throwable cause = null;
            for (ServiceReference rrr : refs) {
                try {
                    Introspector svc;
                    block18: {
                        svc = (Introspector)ctx.getService(rrr);
                        try {
                            if (Stream.of(filters).anyMatch(f -> !f.test(svc))) {
                            }
                            break block18;
                        }
                        catch (Exception e) {
                            System.err.println("error: failed to match introspector of type " + svc.getClass());
                            e.printStackTrace();
                            cause = Introspectors.chain(cause, e);
                        }
                        continue;
                    }
                    try {
                        AutoCloseable ungetter = () -> ctx.ungetService(rrr);
                        try {
                            try {
                                action.actOn(svc);
                                ++count;
                            }
                            catch (Exception e) {
                                System.err.println("error: failed to " + desc + " for service of type " + svc.getClass());
                                cause = Introspectors.chain(cause, e);
                            }
                        }
                        finally {
                            if (ungetter == null) continue;
                            ungetter.close();
                        }
                    }
                    catch (Exception e) {
                        System.err.println("error: problem occurred while ungetting service of type " + svc.getClass());
                        cause = Introspectors.chain(cause, e);
                    }
                }
                catch (Exception e) {
                    System.err.println("error: unable to retrieve service of type " + rrr.getClass().getName());
                    e.printStackTrace();
                    cause = Introspectors.chain(cause, e);
                }
            }
            if (null == cause) {
                return count;
            }
            throw new RuntimeException(cause);
        }

        private static Throwable chain(Throwable prev, Throwable next) {
            if (null == prev) {
                return next;
            }
            prev.addSuppressed(next);
            return prev;
        }

        private static interface IntrospectorAction {
            public void actOn(Introspector var1) throws Exception;
        }
    }
}

