/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.checkpoint.internal.openj9;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.checkpoint.internal.CheckpointImpl;
import io.openliberty.checkpoint.internal.criu.CheckpointFailedException;
import io.openliberty.checkpoint.internal.criu.ExecuteCRIU;
import java.io.File;
import java.nio.file.Path;
import org.eclipse.openj9.criu.CRIUSupport;
import org.eclipse.openj9.criu.JVMCRIUException;
import org.eclipse.openj9.criu.JVMCheckpointException;
import org.eclipse.openj9.criu.JVMRestoreException;
import org.eclipse.openj9.criu.SystemCheckpointException;
import org.eclipse.openj9.criu.SystemRestoreException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ExecuteCRIU_OpenJ9
implements ExecuteCRIU {
    private final CheckpointImpl checkpointImpl;
    static final long serialVersionUID = 3196496503811502156L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ExecuteCRIU_OpenJ9(CheckpointImpl checkpointImpl) {
        this.checkpointImpl = checkpointImpl;
    }

    @Override
    @FFDCIgnore(value={JVMCheckpointException.class, SystemCheckpointException.class, JVMRestoreException.class, SystemRestoreException.class, JVMCRIUException.class})
    public void dump(Runnable prepare, Runnable restore, File imageDir, String logFileName, File workDir, File envProps, boolean unprivileged) throws CheckpointFailedException {
        CRIUSupport criuSupport = this.getCRIUSupport(imageDir.toPath());
        criuSupport.registerPreCheckpointHook(prepare);
        criuSupport.registerPostRestoreHook(restore);
        criuSupport.setShellJob(true);
        criuSupport.setFileLocks(true);
        criuSupport.setLogFile(logFileName);
        criuSupport.setWorkDir(workDir.toPath());
        criuSupport.setTCPEstablished(true);
        criuSupport.registerRestoreEnvFile(envProps.toPath());
        this.setCheckpointLogLevel(criuSupport);
        criuSupport.setUnprivileged(unprivileged);
        try {
            criuSupport.checkpointJVM();
        }
        catch (JVMCheckpointException e) {
            throw new CheckpointFailedException(CheckpointFailedException.Type.JVM_CHECKPOINT_FAILED, e.getMessage(), e);
        }
        catch (SystemCheckpointException e) {
            throw new CheckpointFailedException(CheckpointFailedException.Type.SYSTEM_CHECKPOINT_FAILED, e.getMessage(), e);
        }
        catch (JVMRestoreException e) {
            throw new CheckpointFailedException(CheckpointFailedException.Type.JVM_RESTORE_FAILED, e.getMessage(), e);
        }
        catch (SystemRestoreException e) {
            throw new CheckpointFailedException(CheckpointFailedException.Type.SYSTEM_RESTORE_FAILED, e.getMessage(), e);
        }
        catch (JVMCRIUException e) {
            throw new CheckpointFailedException(this.checkpointImpl.getUnknownType(), e.getMessage(), e);
        }
    }

    @FFDCIgnore(value={Throwable.class})
    private CRIUSupport getCRIUSupport(Path path) {
        try {
            return CRIUSupport.getCRIUSupport().setImageDir(path);
        }
        catch (Throwable t) {
            return new CRIUSupport(path);
        }
    }

    private void setCheckpointLogLevel(CRIUSupport criuSupport) {
        String logLevelProp = System.getProperty("io.openliberty.checkpoint.criu.loglevel");
        if (logLevelProp != null) {
            int logLevel = Integer.valueOf(logLevelProp);
            criuSupport.setLogLevel(logLevel);
        }
    }

    @Override
    public void checkpointSupported() throws CheckpointFailedException {
        if (CRIUSupport.isCRIUSupportEnabled()) {
            return;
        }
        throw new CheckpointFailedException(CheckpointFailedException.Type.UNSUPPORTED_DISABLED_IN_JVM, CRIUSupport.getErrorMessage(), null);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.checkpoint.internal.openj9.ExecuteCRIU_OpenJ9", ExecuteCRIU_OpenJ9.class, null, null);
    }
}

