/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.utility.tasks;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.ws.crypto.ltpakeyutil.LTPAKeyFileUtility;
import com.ibm.ws.security.utility.IFileUtility;
import com.ibm.ws.security.utility.SecurityUtilityReturnCodes;
import com.ibm.ws.security.utility.tasks.BaseCommandTask;
import com.ibm.ws.security.utility.utils.ConsoleWrapper;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CreateLTPAKeysTask
extends BaseCommandTask {
    static final String SLASH = String.valueOf(File.separatorChar);
    static final String DEFAULT_LTPA_KEY_FILE = "ltpa.keys";
    static final String ARG_PASSWORD = "--password";
    static final String ARG_SERVER = "--server";
    static final String ARG_FILE = "--file";
    private static final List<String> BETA_ARG_TABLE = new ArrayList<String>();
    private static final List<String> BETA_OPTS = BETA_ARG_TABLE.stream().map(s -> s.startsWith("--") ? s.substring(2) : s).collect(Collectors.toList());
    private final LTPAKeyFileUtility ltpaKeyFileUtil;
    private final IFileUtility fileUtility;
    protected ConsoleWrapper stdin;
    protected PrintStream stdout;
    private static final List<Set<String>> EXCLUSIVE_ARGUMENTS = Arrays.asList(new HashSet<String>(Arrays.asList("--passwordKey", "--passwordBase64Key", "--aesConfigFile")), new HashSet<String>(Arrays.asList("--server", "--file")));

    public CreateLTPAKeysTask(LTPAKeyFileUtility ltpaKeyFileUtil, IFileUtility fileUtility, String scriptName) {
        super(scriptName);
        this.ltpaKeyFileUtil = ltpaKeyFileUtil;
        this.fileUtility = fileUtility;
    }

    @Override
    public String getTaskName() {
        return "createLTPAKeys";
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("createLTPAKeys.desc", true, new Object[0]);
    }

    @Override
    public String getTaskHelp() {
        return this.getTaskHelp("createLTPAKeys.desc", "createLTPAKeys.usage.options", "createLTPAKeys.required-key.", "createLTPAKeys.required-desc.", "createLTPAKeys.option-key", "createLTPAKeys.option-desc", null, null, this.scriptName);
    }

    @Override
    boolean isKnownArgument(String arg) {
        return arg.equals(ARG_SERVER) || arg.equals(ARG_PASSWORD) || arg.equals("--passwordEncoding") || arg.equals("--passwordKey") || arg.equals(ARG_FILE) || arg.equals("--passwordBase64Key") || arg.equals("--aesConfigFile");
    }

    @Override
    void checkRequiredArguments(String[] args) {
        String message = "";
        if (args.length < 2) {
            message = CreateLTPAKeysTask.getMessage("insufficientArgs", new Object[0]);
        }
        boolean passwordFound = false;
        for (String arg : args) {
            String key = arg.split("=")[0];
            if (!key.equals(ARG_PASSWORD)) continue;
            passwordFound = true;
        }
        if (!passwordFound) {
            message = message + " " + CreateLTPAKeysTask.getMessage("missingArg", ARG_PASSWORD);
        }
        if (!message.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    private String getArgumentValue(String arg, String[] args, String defalt) {
        return this.getArgumentValue(arg, args, defalt, ARG_PASSWORD, this.stdin, this.stdout);
    }

    @Override
    public SecurityUtilityReturnCodes handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws Exception {
        this.stdin = stdin;
        this.stdout = stdout;
        this.validateArgumentList(args, Arrays.asList(ARG_PASSWORD));
        String path = this.getArgumentValue(ARG_FILE, args, DEFAULT_LTPA_KEY_FILE);
        String serverName = this.getArgumentValue(ARG_SERVER, args, null);
        if (serverName != null) {
            String usrServers = this.fileUtility.getServersDirectory();
            String serverDir = usrServers + serverName + SLASH;
            if (!this.fileUtility.exists(serverDir)) {
                usrServers = this.fileUtility.resolvePath(usrServers);
                stdout.println(CreateLTPAKeysTask.getMessage("createLTPAKeys.abort", new Object[0]));
                stdout.println(CreateLTPAKeysTask.getMessage("serverNotFound", serverName, usrServers));
                return SecurityUtilityReturnCodes.ERR_SERVER_NOT_FOUND;
            }
            String location = serverDir + "resources" + SLASH + "security" + SLASH + DEFAULT_LTPA_KEY_FILE;
            File fLocation = new File(location = this.fileUtility.resolvePath(location));
            if (!this.fileUtility.createParentDirectory(stdout, fLocation)) {
                stdout.println(CreateLTPAKeysTask.getMessage("createLTPAKeys.abort", new Object[0]));
                stdout.println(CreateLTPAKeysTask.getMessage("file.requiredDirNotCreated", location));
                return SecurityUtilityReturnCodes.ERR_PATH_CANNOT_BE_CREATED;
            }
            path = location;
        }
        if (this.fileUtility.exists(path)) {
            stdout.println(CreateLTPAKeysTask.getMessage("createLTPAKeys.abort", new Object[0]));
            stdout.println(CreateLTPAKeysTask.getMessage("createLTPAKeys.fileExists", path));
            return SecurityUtilityReturnCodes.ERR_FILE_EXISTS;
        }
        HashMap<String, String> argMap = new HashMap<String, String>();
        String password = this.getArgumentValue(ARG_PASSWORD, args, null);
        String encoding = this.getArgumentValue("--passwordEncoding", args, PasswordUtil.getDefaultEncoding());
        String key = this.getArgumentValue("--passwordKey", args, null);
        argMap.put("--passwordKey", key);
        String base64Key = this.getArgumentValue("--passwordBase64Key", args, null);
        argMap.put("--passwordBase64Key", base64Key);
        String aesConfigFile = this.getArgumentValue("--aesConfigFile", args, null);
        argMap.put("--aesConfigFile", aesConfigFile);
        Map<String, String> props = BaseCommandTask.convertToProperties(argMap, stdout);
        String encodedPassword = PasswordUtil.encode((String)password, (String)encoding, props);
        String xmlSnippet = serverName != null ? "    <ltpa keysPassword=\"" + encodedPassword + "\" />" : "    <ltpa keysPassword=\"" + encodedPassword + "\" keysFileName=\"" + path + "\" />";
        this.ltpaKeyFileUtil.createLTPAKeysFile(path, password.getBytes());
        stdout.println(CreateLTPAKeysTask.getMessage("createLTPAKeys.createdFile", path, xmlSnippet));
        return SecurityUtilityReturnCodes.OK;
    }

    @Override
    protected List<String> getBetaOptions() {
        return BETA_OPTS;
    }

    @Override
    protected List<Set<String>> getExclusiveArguments() {
        return EXCLUSIVE_ARGUMENTS;
    }
}

