/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.internal.QueueItem;
import com.ibm.ws.threading.internal.ReduceableSemaphore;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConcurrentPriorityBlockingQueue<T>
extends AbstractQueue<T>
implements BlockingQueue<T> {
    final Head<T> expeditedHead;
    final AtomicReference<Node<T>> expeditedTail = new AtomicReference();
    final NonExpeditedHead<T> nonExpeditedHead;
    final AtomicReference<Node<T>> nonExpeditedTail = new AtomicReference();
    final ReduceableSemaphore size = new ReduceableSemaphore(0, false);
    final AtomicReference<Head<T>> currentHead = new AtomicReference();
    final FirstAction<T, Node<T>> GET_FIRST_NODE = GetFirstNode.INSTANCE;
    private final FirstAction<T, T> GET_FIRST_ITEM = GetFirstItem.INSTANCE;
    private final FirstAction<T, T> REMOVE_FIRST_ITEM = RemoveFirstItem.INSTANCE;
    static final long serialVersionUID = 4173819056441280021L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ConcurrentPriorityBlockingQueue() {
        Node<Object> nonExNode = new Node<Object>(null);
        this.nonExpeditedHead = new NonExpeditedHead<Object>(nonExNode);
        this.nonExpeditedTail.set(nonExNode);
        this.currentHead.set(this.nonExpeditedHead);
        Node<Object> exNode = new Node<Object>(null);
        exNode.next.set(this.nonExpeditedHead);
        this.expeditedHead = new ExpeditedHead<Object>(exNode);
        this.expeditedTail.set(exNode);
    }

    @Override
    public boolean add(T e) {
        return this.offer(e);
    }

    @Override
    public boolean contains(Object item) {
        NonExpeditedHead<T> end;
        Head<T> head;
        if (item == null) {
            return false;
        }
        if (item instanceof QueueItem && ((QueueItem)item).isExpedited()) {
            if (this.currentHead.get() == this.nonExpeditedHead) {
                return false;
            }
            head = this.expeditedHead;
            end = this.nonExpeditedHead;
        } else {
            head = this.nonExpeditedHead;
            end = null;
        }
        Node<T> current = this.getFirstWithAction(head, end, this.GET_FIRST_NODE);
        while (current != null) {
            Object element = current.get();
            if (element != null && item.equals(element)) {
                return true;
            }
            current = this.getNext(current, head, end);
        }
        return false;
    }

    private Node<T> getNext(Node<T> current, Head<T> head, Node<T> end) {
        Node next = current.next.get();
        return current == next ? head.getFirst() : (next != end ? next : null);
    }

    @Override
    public int drainTo(Collection<? super T> col) {
        T item;
        if (col == null) {
            throw new NullPointerException();
        }
        if (col == this) {
            throw new IllegalArgumentException();
        }
        int count = 0;
        while ((item = this.poll()) != null) {
            col.add(item);
            ++count;
        }
        return count;
    }

    @Override
    public int drainTo(Collection<? super T> col, int maxElements) {
        T item;
        int count;
        if (col == null) {
            throw new NullPointerException();
        }
        if (col == this) {
            throw new IllegalArgumentException();
        }
        for (count = 0; count < maxElements && (item = this.poll()) != null; ++count) {
            col.add(item);
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.size.availablePermits() <= 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new QueueIterator();
    }

    @Override
    public boolean offer(T item) {
        Node<T> startingTail;
        NonExpeditedHead<T> end;
        Head<T> head;
        AtomicReference<Node<T>> tail;
        if (item == null) {
            throw new NullPointerException();
        }
        Node<T> newTail = new Node<T>(item);
        if (item instanceof QueueItem && ((QueueItem)item).isExpedited()) {
            if (this.currentHead.get() == this.nonExpeditedHead) {
                this.currentHead.compareAndSet(this.nonExpeditedHead, this.expeditedHead);
            }
            tail = this.expeditedTail;
            head = this.expeditedHead;
            end = this.nonExpeditedHead;
            newTail.next.set(this.nonExpeditedHead);
        } else {
            tail = this.nonExpeditedTail;
            head = this.nonExpeditedHead;
            end = null;
        }
        Node<T> currentTail = startingTail = tail.get();
        while (true) {
            Node<T> possibleNewTail;
            Node currentTailNext;
            if ((currentTailNext = currentTail.next.get()) == end) {
                if (!currentTail.next.compareAndSet(end, newTail)) continue;
                this.size.release();
                if (currentTail != startingTail) {
                    tail.compareAndSet(startingTail, newTail);
                }
                return true;
            }
            if (currentTail == currentTailNext) {
                possibleNewTail = tail.get();
                currentTail = startingTail != possibleNewTail ? possibleNewTail : head.getFirst();
                startingTail = possibleNewTail;
                continue;
            }
            if (currentTail == startingTail) {
                currentTail = currentTailNext;
                continue;
            }
            possibleNewTail = tail.get();
            currentTail = startingTail != possibleNewTail ? possibleNewTail : currentTailNext;
            startingTail = possibleNewTail;
        }
    }

    @Override
    public boolean offer(T item, long time, TimeUnit timeout) throws InterruptedException {
        return this.offer(item);
    }

    @Override
    public T peek() {
        Head<T> head = this.currentHead.get();
        return this.getFirstWithAction(head, null, this.GET_FIRST_ITEM);
    }

    @Override
    public T poll() {
        while (this.size.tryAcquire()) {
            Head<T> head = this.currentHead.get();
            T first = this.getFirstWithAction(head, null, this.REMOVE_FIRST_ITEM);
            if (first != null) {
                return first;
            }
            this.size.release();
            Thread.yield();
        }
        return null;
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        long start = System.nanoTime();
        long remain = timeout = unit.toNanos(timeout);
        while (remain >= 0L && this.size.tryAcquire(remain, TimeUnit.NANOSECONDS)) {
            Head<T> head = this.currentHead.get();
            T first = this.getFirstWithAction(head, null, this.REMOVE_FIRST_ITEM);
            if (first != null) {
                return first;
            }
            this.size.release();
            Thread.yield();
            remain = timeout - (System.nanoTime() - start);
        }
        return null;
    }

    @Override
    public void put(T item) throws InterruptedException {
        this.offer(item);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public boolean remove(Object item) {
        if (item == null) {
            return false;
        }
        if (item instanceof QueueItem && ((QueueItem)item).isExpedited()) {
            if (this.currentHead.get() == this.nonExpeditedHead) {
                return false;
            }
            head /* !! */  = this.expeditedHead;
            end = this.nonExpeditedHead;
        } else {
            head /* !! */  = this.nonExpeditedHead;
            end = null;
        }
        prev = null;
        next = null;
        current = this.getFirstWithAction(head /* !! */ , end, this.GET_FIRST_NODE);
        while (current != null) {
            removed = false;
            element = current.get();
            if (element == null) ** GOTO lbl22
            if (!item.equals(element)) {
                next = this.getNext(current, head /* !! */ , end);
            } else {
                removed = current.compareAndSet(element, null);
lbl22:
                // 2 sources

                next = this.getNext(current, head /* !! */ , end);
                if (prev != null && next != null) {
                    prev.next.compareAndSet(current, next);
                }
                if (removed) {
                    this.size.reducePermits(1);
                    return true;
                }
            }
            prev = current;
            current = next;
        }
        return false;
    }

    @Override
    public final int size() {
        int s = this.size.availablePermits();
        return s < 0 ? 0 : s;
    }

    @Override
    public T take() throws InterruptedException {
        while (true) {
            this.size.acquire();
            Head<T> head = this.currentHead.get();
            T first = this.getFirstWithAction(head, null, this.REMOVE_FIRST_ITEM);
            if (first != null) {
                return first;
            }
            this.size.release();
            Thread.yield();
        }
    }

    <F> F getFirstWithAction(Head<T> head, Node<T> end, FirstAction<T, F> firstAction) {
        NonExpeditedHead<T> firstActionEnd;
        Node<T> first;
        Node<T> current = first = head.getFirst();
        NonExpeditedHead<T> nonExpeditedHead = firstActionEnd = head == this.expeditedHead ? this.nonExpeditedHead : null;
        F returnVal;
        while ((returnVal = firstAction.apply(current, head, firstActionEnd, first)) == null) {
            Node next = current.next.get();
            if (next == firstActionEnd) {
                firstAction.updateFirst(head, first, current);
                if (firstActionEnd == end) {
                    return null;
                }
                head = this.nonExpeditedHead;
                current = first = head.getFirst();
                firstActionEnd = null;
                continue;
            }
            if (current == next) {
                current = first = head.getFirst();
                continue;
            }
            current = next;
        }
        return returnVal;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.size.availablePermits()).append(' ');
        Iterator<T> it = this.iterator();
        if (!it.hasNext()) {
            b.append("[]");
        } else {
            b.append('[');
            int i = 0;
            while (true) {
                ++i;
                b.append(it.next());
                if (!it.hasNext()) {
                    b.append(']');
                    break;
                }
                if (i == 100) {
                    b.append(", ...]");
                    break;
                }
                b.append(", ");
            }
        }
        return b.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.ConcurrentPriorityBlockingQueue", ConcurrentPriorityBlockingQueue.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class Node<T>
    extends AtomicReference<T> {
        private static final long serialVersionUID = 1L;
        final AtomicReference<Node<T>> next = new AtomicReference();
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        Node(T element) {
            super.set(element);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.ConcurrentPriorityBlockingQueue$Node", Node.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
        }
    }

    private static interface Head<T> {
        public Node<T> getFirst();

        public boolean compareAndSetFirst(Node<T> var1, Node<T> var2);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class GetFirstNode<T>
    extends FirstAction<T, Node<T>> {
        static final GetFirstNode INSTANCE;
        static final long serialVersionUID = 5627958974558504451L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private GetFirstNode() {
        }

        @Override
        public Node<T> apply(Node<T> current, Head<T> head, Node<T> end, Node<T> currentFirst) {
            Object item = current.get();
            if (item == null) {
                return null;
            }
            this.updateFirst(head, currentFirst, current);
            return current;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.ConcurrentPriorityBlockingQueue$GetFirstNode", GetFirstNode.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
            INSTANCE = new GetFirstNode();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static abstract class FirstAction<T, R> {
        static final long serialVersionUID = 3104379317023388012L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private FirstAction() {
        }

        abstract R apply(Node<T> var1, Head<T> var2, Node<T> var3, Node<T> var4);

        final void updateFirst(Head<T> head, Node<T> currentFirst, Node<T> newFirst) {
            if (currentFirst != newFirst && head.compareAndSetFirst(currentFirst, newFirst)) {
                currentFirst.next.set(currentFirst);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.ConcurrentPriorityBlockingQueue$FirstAction", FirstAction.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class GetFirstItem<T>
    extends FirstAction<T, T> {
        static GetFirstItem INSTANCE;
        static final long serialVersionUID = 4989581431736327865L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private GetFirstItem() {
        }

        @Override
        public T apply(Node<T> current, Head<T> head, Node<T> end, Node<T> currentFirst) {
            Object item = current.get();
            if (item != null) {
                this.updateFirst(head, currentFirst, current);
            }
            return (T)item;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.ConcurrentPriorityBlockingQueue$GetFirstItem", GetFirstItem.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
            INSTANCE = new GetFirstItem();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class RemoveFirstItem<T>
    extends FirstAction<T, T> {
        static final RemoveFirstItem INSTANCE;
        static final long serialVersionUID = 4898164114239604575L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private RemoveFirstItem() {
        }

        @Override
        public T apply(Node<T> current, Head<T> head, Node<T> end, Node<T> currentFirst) {
            Object item = current.get();
            if (item == null || !current.compareAndSet(item, null)) {
                return null;
            }
            if (current != currentFirst) {
                Node next = current.next.get();
                Node<T> newFirst = next == end ? current : next;
                this.updateFirst(head, currentFirst, newFirst);
            }
            return (T)item;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.ConcurrentPriorityBlockingQueue$RemoveFirstItem", RemoveFirstItem.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
            INSTANCE = new RemoveFirstItem();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class NonExpeditedHead<T>
    extends Node<T>
    implements Head<T> {
        private static final long serialVersionUID = 1L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        NonExpeditedHead(Node<T> first) {
            super(null);
            this.next.set(first);
        }

        @Override
        public Node<T> getFirst() {
            return (Node)this.next.get();
        }

        @Override
        public boolean compareAndSetFirst(Node<T> oldFirst, Node<T> newFirst) {
            return this.next.compareAndSet(oldFirst, newFirst);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.ConcurrentPriorityBlockingQueue$NonExpeditedHead", NonExpeditedHead.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ExpeditedHead<T>
    extends AtomicReference<Node<T>>
    implements Head<T> {
        private static final long serialVersionUID = 1L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ExpeditedHead(Node<T> first) {
            this.set(first);
        }

        @Override
        public Node<T> getFirst() {
            return (Node)this.get();
        }

        @Override
        public boolean compareAndSetFirst(Node<T> oldFirst, Node<T> newFirst) {
            return this.compareAndSet(oldFirst, newFirst);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.ConcurrentPriorityBlockingQueue$ExpeditedHead", ExpeditedHead.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class QueueIterator
    implements Iterator<T> {
        Node<T> current = null;
        Node<T> next = null;
        T nextItem = null;
        Head<T> head;
        Node<T> end;
        static final long serialVersionUID = -3604280312157438637L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        QueueIterator() {
            this.head = ConcurrentPriorityBlockingQueue.this.currentHead.get();
            this.end = this.head == ConcurrentPriorityBlockingQueue.this.expeditedHead ? ConcurrentPriorityBlockingQueue.this.nonExpeditedHead : null;
            this.calculateNext();
        }

        private T calculateNext() {
            this.current = this.next;
            Node nextCandidate = this.next == null ? ConcurrentPriorityBlockingQueue.this.getFirstWithAction(this.head, this.end, ConcurrentPriorityBlockingQueue.this.GET_FIRST_NODE) : ConcurrentPriorityBlockingQueue.this.getNext(this.next, this.head, this.end);
            while (true) {
                Object item;
                boolean doReturn = true;
                if (nextCandidate == null) {
                    if (this.head == ConcurrentPriorityBlockingQueue.this.expeditedHead) {
                        this.head = ConcurrentPriorityBlockingQueue.this.nonExpeditedHead;
                        this.end = null;
                        nextCandidate = ConcurrentPriorityBlockingQueue.this.getFirstWithAction(this.head, this.end, ConcurrentPriorityBlockingQueue.this.GET_FIRST_NODE);
                        continue;
                    }
                    item = null;
                } else {
                    item = nextCandidate.get();
                    boolean bl = doReturn = item != null;
                }
                if (doReturn) {
                    this.next = nextCandidate;
                    Object returnVal = this.nextItem;
                    this.nextItem = item;
                    return returnVal;
                }
                nextCandidate = ConcurrentPriorityBlockingQueue.this.getNext(nextCandidate, this.head, this.end);
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            return this.calculateNext();
        }

        @Override
        public void remove() {
            Node node = this.current;
            if (node == null) {
                throw new IllegalStateException();
            }
            Object prevItem = node.get();
            if (prevItem != null && node.compareAndSet(prevItem, null)) {
                ConcurrentPriorityBlockingQueue.this.size.reducePermits(1);
            }
            this.current = null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.ConcurrentPriorityBlockingQueue$QueueIterator", QueueIterator.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
        }
    }
}

