/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.boot.internal.KernelUtils;
import com.ibm.ws.kernel.feature.ServerStarted;
import com.ibm.ws.kernel.service.util.AvailableProcessorsListener;
import com.ibm.ws.kernel.service.util.CpuInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.ThreadQuiesce;
import com.ibm.ws.threading.internal.BoundedBuffer;
import com.ibm.ws.threading.internal.ConcurrentPriorityBlockingQueue;
import com.ibm.ws.threading.internal.ProcessorAwareQueue;
import com.ibm.ws.threading.internal.QueueItem;
import com.ibm.ws.threading.internal.ThreadFactoryImpl;
import com.ibm.ws.threading.internal.ThreadPoolController;
import com.ibm.wsspi.threading.ExecutorServiceTaskInterceptor;
import com.ibm.wsspi.threading.WSExecutorService;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.threading", configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"}, service={ExecutorService.class, WSExecutorService.class})
public final class ExecutorServiceImpl
implements WSExecutorService,
ThreadQuiesce,
AvailableProcessorsListener {
    private static final TraceComponent tc = Tr.register(ExecutorServiceImpl.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
    ThreadPoolExecutor threadPool = null;
    ThreadPoolController threadPoolController = null;
    String poolName = null;
    static final int MINIMUM_POOL_SIZE = 4;
    static final int MINIMUM_QUIESCE_TIMEOUT = 30;
    protected int quiesceTimeout = 30;
    Map<String, Object> componentConfig = null;
    boolean interceptorsActive = false;
    Set<ExecutorServiceTaskInterceptor> interceptors = new CopyOnWriteArraySet<ExecutorServiceTaskInterceptor>();
    ThreadFactory threadFactory = null;
    private boolean serverStopping = false;
    public static boolean isBeta = Boolean.valueOf(System.getProperty("com.ibm.ws.beta.edition"));
    public static final boolean useBoundedBuffer = Boolean.valueOf(System.getProperty("io.openliberty.threading.useBoundedBuffer", "true"));
    protected final Phaser phaser = new Phaser(1);
    static final long serialVersionUID = -7954740273890058045L;

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected synchronized void setServerStarted(ServerStarted serverStarted) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)": server start complete.", (Object[])new Object[0]);
        }
        this.threadPoolController.startupCompleted();
    }

    @Trivial
    protected void unsetServerStarted(ServerStarted serverStarted) {
    }

    @Override
    public int getQuiesceTimeout() {
        return this.quiesceTimeout;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected synchronized void setInterceptor(ExecutorServiceTaskInterceptor interceptor) {
        this.interceptors.add(interceptor);
        this.interceptorsActive = true;
    }

    protected synchronized void unsetInterceptor(ExecutorServiceTaskInterceptor interceptor) {
        this.interceptors.remove(interceptor);
        if (this.interceptors.size() == 0) {
            this.interceptorsActive = false;
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, target="(com.ibm.ws.threading.defaultExecutorThreadFactory=true)")
    protected void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        this.createExecutor();
    }

    protected void unsetThreadFactory(ThreadFactory threadFactory) {
        if (this.threadFactory == threadFactory) {
            threadFactory = null;
            this.createExecutor();
        }
    }

    @Activate
    protected void activate(Map<String, Object> componentConfig) {
        CpuInfo.addAvailableProcessorsListener((AvailableProcessorsListener)this);
        this.componentConfig = componentConfig;
        this.createExecutor();
    }

    @Modified
    protected void modified(Map<String, Object> componentConfig) {
        this.componentConfig = componentConfig;
        this.createExecutor();
    }

    @Deactivate
    protected void deactivate(int reason) {
        CpuInfo.removeAvailableProcessorsListener((AvailableProcessorsListener)this);
        this.threadPoolController.deactivate();
        this.softShutdown(this.threadPool);
        this.componentConfig = null;
    }

    @Trivial
    ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    private synchronized void createExecutor() {
        BlockingQueue<Runnable> queue;
        if (this.componentConfig == null) {
            return;
        }
        if (this.threadPoolController != null) {
            this.threadPoolController.deactivate();
        }
        ThreadPoolExecutor oldPool = this.threadPool;
        this.poolName = (String)this.componentConfig.get("name");
        String threadGroupName = this.poolName + " Thread Group";
        int coreThreads = Integer.parseInt(String.valueOf(this.componentConfig.get("coreThreads")));
        int maxThreads = Integer.parseInt(String.valueOf(this.componentConfig.get("maxThreads")));
        if (isBeta) {
            String quiesceTimeoutString = (String)this.componentConfig.get("quiesceTimeout");
            try {
                this.quiesceTimeout = Integer.valueOf(KernelUtils.parseDuration((String)quiesceTimeoutString, (TimeUnit)TimeUnit.SECONDS));
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.threading.internal.ExecutorServiceImpl", (String)"248", (Object)this, (Object[])new Object[0]);
                Tr.warning((TraceComponent)tc, (String)"CWWKE1206.quiesce.timeout.not.valid", (Object[])new Object[]{quiesceTimeoutString});
            }
        }
        if (maxThreads <= 0) {
            maxThreads = Integer.MAX_VALUE;
        }
        if (coreThreads < 0) {
            coreThreads = 2 * CpuInfo.getAvailableProcessors().get();
        }
        if (this.quiesceTimeout < 30) {
            this.quiesceTimeout = 30;
        }
        coreThreads = Math.max(4, Math.min(coreThreads, maxThreads));
        maxThreads = Math.max(coreThreads, maxThreads);
        BlockingQueue<Runnable> workQueue = useBoundedBuffer ? new BoundedBuffer<Runnable>(Runnable.class, 1000, 1000) : new ConcurrentPriorityBlockingQueue();
        ExpandPolicy rejectedExecutionHandler = new ExpandPolicy(workQueue, this);
        if (this.threadPool != null && (queue = this.threadPool.getQueue()) instanceof ProcessorAwareQueue) {
            ((ProcessorAwareQueue)((Object)queue)).removeFromAvailableProcessors();
        }
        this.threadPool = new ThreadPoolExecutor(coreThreads, maxThreads, 0L, TimeUnit.MILLISECONDS, workQueue, this.threadFactory != null ? this.threadFactory : new ThreadFactoryImpl(this.poolName, threadGroupName), rejectedExecutionHandler);
        this.threadPoolController = new ThreadPoolController(this.threadPool);
        if (oldPool != null) {
            this.softShutdown(oldPool);
        }
    }

    @Trivial
    private static ClassLoader getContextClassLoader(Thread thread) {
        if (System.getSecurityManager() == null) {
            return thread.getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> thread.getContextClassLoader());
    }

    @Trivial
    private static void setContextClassLoaderIfChanged(final Thread thread, final ClassLoader beforeContextCL) {
        if (System.getSecurityManager() == null) {
            ClassLoader afterContextCL = thread.getContextClassLoader();
            if (beforeContextCL != afterContextCL) {
                thread.setContextClassLoader(beforeContextCL);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Reset leaked context class loader " + afterContextCL + " on thread " + thread.getName()), (Object[])new Object[0]);
                }
            }
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = -479386624138354250L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                @Trivial
                public Void run() {
                    ClassLoader afterContextCL = thread.getContextClassLoader();
                    if (beforeContextCL != afterContextCL) {
                        thread.setContextClassLoader(beforeContextCL);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Reset leaked context class loader " + afterContextCL + " on thread " + thread.getName()), (Object[])new Object[0]);
                        }
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.ExecutorServiceImpl$1", 1.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
                }
            });
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.threadPoolController.resumeIfPaused();
        return this.threadPool.awaitTermination(timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.threadPoolController.resumeIfPaused();
        return this.threadPool.invokeAll(this.interceptorsActive ? this.wrap(tasks) : tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        this.threadPoolController.resumeIfPaused();
        return this.threadPool.invokeAll(this.interceptorsActive ? this.wrap(tasks) : tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        this.threadPoolController.resumeIfPaused();
        return this.threadPool.invokeAny(this.interceptorsActive ? this.wrap(tasks) : tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.threadPoolController.resumeIfPaused();
        return this.threadPool.invokeAny(this.interceptorsActive ? this.wrap(tasks) : tasks, timeout, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.threadPool.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.threadPool.isTerminated();
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.threadPoolController.resumeIfPaused();
        return this.threadPool.submit(this.createWrappedCallable(task));
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.threadPoolController.resumeIfPaused();
        return this.threadPool.submit(this.createWrappedRunnable(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.threadPoolController.resumeIfPaused();
        return this.threadPool.submit(this.createWrappedRunnable(task), result);
    }

    @Override
    public void execute(Runnable command) {
        this.threadPoolController.resumeIfPaused();
        this.threadPool.execute(this.createWrappedRunnable(command));
    }

    @Override
    public void executeGlobal(Runnable command) {
        this.threadPoolController.resumeIfPaused();
        this.threadPool.execute(this.createWrappedRunnable(command));
    }

    void executeWithoutInterceptors(Runnable proxy) {
        this.threadPoolController.resumeIfPaused();
        this.threadPool.execute(proxy);
    }

    @Trivial
    public int getPoolSize() {
        return this.threadPool.getPoolSize();
    }

    @Trivial
    public int getActiveCount() {
        return this.threadPool.getActiveCount();
    }

    @Trivial
    public String getPoolName() {
        return this.poolName;
    }

    private void softShutdown(ThreadPoolExecutor oldThreadPool) {
        oldThreadPool.setKeepAliveTime(0L, TimeUnit.SECONDS);
        oldThreadPool.setCorePoolSize(0);
    }

    private Runnable createWrappedRunnable(Runnable in) {
        Runnable r;
        Runnable runnable = r = this.interceptorsActive ? this.wrap(in) : in;
        if (this.serverStopping) {
            return r;
        }
        return new RunnableWrapper(r);
    }

    Runnable wrap(Runnable r) {
        Iterator<ExecutorServiceTaskInterceptor> i = this.interceptors.iterator();
        while (i.hasNext()) {
            r = i.next().wrap(r);
        }
        return r;
    }

    private <T> Callable<T> createWrappedCallable(Callable<T> in) {
        Callable<T> c;
        Callable<T> callable = c = this.interceptorsActive ? this.wrap(in) : in;
        if (this.serverStopping) {
            return c;
        }
        return new CallableWrapper<T>(c);
    }

    <T> Callable<T> wrap(Callable<T> c) {
        Iterator<ExecutorServiceTaskInterceptor> i = this.interceptors.iterator();
        while (i.hasNext()) {
            c = i.next().wrap(c);
        }
        return c;
    }

    private <T> Collection<? extends Callable<T>> wrap(Collection<? extends Callable<T>> tasks) {
        ArrayList<Callable<T>> wrappedTasks = new ArrayList<Callable<T>>();
        Iterator<Callable<T>> i = tasks.iterator();
        while (i.hasNext()) {
            Callable<T> c = this.wrap(i.next());
            if (this.serverStopping) {
                wrappedTasks.add(c);
                continue;
            }
            wrappedTasks.add(new CallableWrapper<T>(c));
        }
        return wrappedTasks;
    }

    @Override
    @FFDCIgnore(value={TimeoutException.class})
    public boolean quiesceThreads() {
        this.serverStopping = true;
        try {
            this.phaser.arriveAndDeregister();
            this.phaser.awaitAdvanceInterruptibly(0, this.quiesceTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.threading.internal.ExecutorServiceImpl", (String)"630", (Object)this, (Object[])new Object[0]);
            return false;
        }
        catch (TimeoutException e) {
            return false;
        }
        return true;
    }

    @Override
    public int getActiveThreads() {
        int count = this.phaser.getUnarrivedParties();
        if (this.serverStopping) {
            return count;
        }
        return count - 1;
    }

    @Override
    public boolean quiesceStarted() {
        return this.serverStopping;
    }

    public void setAvailableProcessors(int availableProcessors) {
        int coreThreads;
        if (this.componentConfig != null && (coreThreads = Integer.parseInt(String.valueOf(this.componentConfig.get("coreThreads")))) < 0) {
            this.createExecutor();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class ExpandPolicy
    implements RejectedExecutionHandler {
        public BlockingQueue<Runnable> workQueue;
        public WSExecutorService exService;
        static final long serialVersionUID = 1949647378661211917L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ExpandPolicy(BlockingQueue<Runnable> workQueue2, WSExecutorService exService) {
            this.workQueue = workQueue2;
            this.exService = exService;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (e.isShutdown()) {
                throw new RejectedExecutionException("Task " + r.toString() + " rejected from " + e.toString());
            }
            if (this.workQueue instanceof BoundedBuffer) {
                if (r instanceof QueueItem && ((QueueItem)((Object)r)).isExpedited()) {
                    ((BoundedBuffer)this.workQueue).expandExpedited(1000);
                } else {
                    ((BoundedBuffer)this.workQueue).expand(1000);
                }
            }
            this.exService.execute(r);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.ExecutorServiceImpl$ExpandPolicy", ExpandPolicy.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class RunnableWrapper
    implements Runnable {
        private final Runnable wrappedTask;
        static final long serialVersionUID = -7476978939648089495L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        RunnableWrapper(Runnable r) {
            this.wrappedTask = r;
        }

        @Override
        public void run() {
            ExecutorServiceImpl.this.phaser.register();
            Thread currentThread = Thread.currentThread();
            ClassLoader beforeContextCL = ExecutorServiceImpl.getContextClassLoader(currentThread);
            try {
                this.wrappedTask.run();
            }
            finally {
                ExecutorServiceImpl.setContextClassLoaderIfChanged(currentThread, beforeContextCL);
                ExecutorServiceImpl.this.phaser.arriveAndDeregister();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.ExecutorServiceImpl$RunnableWrapper", RunnableWrapper.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class CallableWrapper<T>
    implements Callable<T> {
        private final Callable<T> callable;
        static final long serialVersionUID = -8044016492297280479L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        CallableWrapper(Callable<T> c) {
            this.callable = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            ExecutorServiceImpl.this.phaser.register();
            Thread currentThread = Thread.currentThread();
            ClassLoader beforeContextCL = ExecutorServiceImpl.getContextClassLoader(currentThread);
            try {
                T t = this.callable.call();
                return t;
            }
            finally {
                ExecutorServiceImpl.setContextClassLoaderIfChanged(currentThread, beforeContextCL);
                ExecutorServiceImpl.this.phaser.arriveAndDeregister();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.ExecutorServiceImpl$CallableWrapper", CallableWrapper.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
        }
    }
}

