/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.config.admin.ConfigID;
import com.ibm.ws.config.xml.internal.BaseConfiguration;
import com.ibm.ws.config.xml.internal.ConfigElement;
import com.ibm.ws.config.xml.internal.ConfigMergeException;
import com.ibm.ws.config.xml.internal.FactoryElement;
import com.ibm.ws.config.xml.internal.MetaTypeRegistry;
import com.ibm.ws.config.xml.internal.SimpleElement;
import com.ibm.ws.config.xml.internal.SingletonElement;
import com.ibm.ws.config.xml.internal.XMLConfigParser;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ServerConfiguration
extends BaseConfiguration {
    private static final TraceComponent tc = Tr.register(ServerConfiguration.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    protected BaseConfiguration defaultConfiguration;
    static final long serialVersionUID = 7414098309658288123L;

    public void setDefaultConfiguration(BaseConfiguration defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public BaseConfiguration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    @Override
    void getDefaultConfigurationNames(Set<String> names) {
        if (this.defaultConfiguration != null) {
            this.defaultConfiguration.getConfigurationNames(names);
        }
    }

    @Override
    boolean defaultConfigurationHasId(String pid) {
        if (this.defaultConfiguration == null) {
            return false;
        }
        return this.defaultConfiguration.hasId(pid);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isDropinsEnabled() {
        String dropinsEnabledValue;
        SingletonElement configElement;
        boolean dropinsEnabled = true;
        try {
            configElement = this.getSingleton("applicationMonitor", null);
        }
        catch (ConfigMergeException configMergeException) {
            void e;
            FFDCFilter.processException((Throwable)configMergeException, (String)"com.ibm.ws.config.xml.internal.ServerConfiguration", (String)"74", (Object)this, (Object[])new Object[0]);
            e.getStackTrace();
            return false;
        }
        if (configElement != null && (dropinsEnabledValue = (String)configElement.getAttribute("dropinsEnabled")) != null && dropinsEnabledValue.equals("false")) {
            dropinsEnabled = false;
        }
        return dropinsEnabled;
    }

    public Set<String> getSingletonNames() {
        HashSet<String> singletons = new HashSet<String>();
        this.getSingletonNames(singletons);
        if (this.defaultConfiguration != null) {
            this.defaultConfiguration.getSingletonNames(singletons);
        }
        return singletons;
    }

    public Set<String> getFactoryNames() {
        HashSet<String> factories = new HashSet<String>();
        this.getFactoryNames(factories);
        if (this.defaultConfiguration != null) {
            this.defaultConfiguration.getFactoryNames(factories);
        }
        return factories;
    }

    @Override
    public SingletonElement getSingleton(String pid, String alias) throws ConfigMergeException {
        List<SimpleElement> elements = this.getSingletonElements(pid, alias);
        if (elements.isEmpty()) {
            if (this.defaultConfiguration == null) {
                return null;
            }
            return this.defaultConfiguration.getSingleton(pid, alias, false);
        }
        List<SimpleElement> defaults = Collections.emptyList();
        if (this.defaultConfiguration != null) {
            defaults = this.defaultConfiguration.getSingletonElements(pid, alias);
        }
        if (defaults.isEmpty()) {
            SingletonElement merged = new SingletonElement(elements, pid);
            return merged;
        }
        Iterator iter = defaults.iterator();
        while (iter.hasNext()) {
            if (((SimpleElement)iter.next()).mergeBehavior != XMLConfigParser.MergeBehavior.MERGE_WHEN_MISSING) continue;
            iter.remove();
        }
        SingletonElement merged = new SingletonElement(defaults, pid);
        merged.merge(elements);
        return merged;
    }

    @Override
    public FactoryElement getFactoryInstance(String pid, String alias, String id) throws ConfigMergeException {
        List<SimpleElement> elements = this.getFactoryElements(pid, alias, id);
        if (elements.isEmpty()) {
            if (this.defaultConfiguration == null) {
                return null;
            }
            return this.defaultConfiguration.getFactoryInstance(pid, alias, id, false);
        }
        if (this.defaultConfiguration != null) {
            List<SimpleElement> defaults = this.defaultConfiguration.getFactoryElements(pid, alias, id);
            if (defaults.isEmpty()) {
                return new FactoryElement(elements, pid, id);
            }
            FactoryElement merged = new FactoryElement(defaults, pid, id);
            merged.merge(elements);
            return merged;
        }
        return new FactoryElement(elements, pid, id);
    }

    @Override
    Map<ConfigID, List<SimpleElement>> defaultConfigurationFactories(String pid, String alias, String defaultId) {
        if (this.defaultConfiguration == null) {
            return Collections.emptyMap();
        }
        Map<ConfigID, List<SimpleElement>> retVal = this.defaultConfiguration.getAllFactoryElements(pid, alias, defaultId);
        return retVal == null ? Collections.emptyMap() : retVal;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("configurations: ").append(this.configurationMap);
        if (this.defaultConfiguration != null) {
            builder.append(" default configurations: ").append(this.defaultConfiguration);
        }
        return builder.toString();
    }

    public List<ConfigElement> getNestedInstances(MetaTypeRegistry.RegistryEntry re) throws ConfigMergeException {
        return this.getNestedInstances(re, new HashSet<MetaTypeRegistry.RegistryEntry>());
    }

    private List<ConfigElement> getNestedInstances(MetaTypeRegistry.RegistryEntry re, final Set<MetaTypeRegistry.RegistryEntry> visited) throws ConfigMergeException {
        String pid = re.getPid();
        ArrayList<ConfigElement> retVal = new ArrayList<ConfigElement>();
        for (MetaTypeRegistry.RegistryEntry test = re; test != null; test = test.getExtendedRegistryEntry()) {
            for (MetaTypeRegistry.PidReference parentRef : test.getReferencingEntries()) {
                final HashSet<ConfigElement> parentInstances = new HashSet<ConfigElement>();
                MetaTypeRegistry.RegistryEntry parentEntry = parentRef.getReferencingEntry();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Looking for instances of {0} nested under {1}", (Object[])new Object[]{pid, parentEntry});
                }
                if (parentEntry.isSingleton()) {
                    if (!visited.contains(parentEntry)) {
                        SingletonElement element;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Getting singleton instances of {0} using alias {1}", (Object[])new Object[]{parentEntry, parentEntry.getAlias()});
                        }
                        if ((element = this.getSingleton(parentEntry.getPid(), parentEntry.getAlias())) != null) {
                            parentInstances.add(element);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"About to look for nested instances of parentPID {0}. Current parentInstances size: {1}", (Object[])new Object[]{parentEntry, parentInstances.size()});
                        }
                        visited.add(parentEntry);
                        parentInstances.addAll(this.getNestedInstances(parentEntry, visited));
                    }
                } else {
                    ConfigMergeException e;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Getting factory instances of {0} using alias {1}", (Object[])new Object[]{parentEntry, parentEntry.getAlias()});
                    }
                    if ((e = parentEntry.traverseHierarchyWithRootPreOrder(new MetaTypeRegistry.EntryAction<ConfigMergeException>(){
                        private ConfigMergeException e;
                        static final long serialVersionUID = 95668339829132313L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public boolean entry(MetaTypeRegistry.RegistryEntry registryEntry) {
                            if (!visited.contains(registryEntry)) {
                                visited.add(registryEntry);
                                try {
                                    Map parentFactoryInstances = ServerConfiguration.this.getFactoryInstancesUsingDefaultId(registryEntry.getPid(), registryEntry.getAlias(), registryEntry.getDefaultId());
                                    parentInstances.addAll(parentFactoryInstances.values());
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"About to look for nested instances of parentPID {0}. Current parentInstances size: {1}", (Object[])new Object[]{registryEntry, parentInstances.size()});
                                    }
                                    parentInstances.addAll(ServerConfiguration.this.getNestedInstances(registryEntry, visited));
                                }
                                catch (ConfigMergeException parentFactoryInstances) {
                                    void e;
                                    FFDCFilter.processException((Throwable)parentFactoryInstances, (String)"com.ibm.ws.config.xml.internal.ServerConfiguration$1", (String)"248", (Object)this, (Object[])new Object[]{registryEntry});
                                    this.e = e;
                                    return false;
                                }
                            }
                            return true;
                        }

                        @Override
                        public ConfigMergeException getResult() {
                            return this.e;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.ServerConfiguration$1", 1.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
                        }
                    })) != null) {
                        throw e;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Finished looking for nested instances of parentPID {0}. Current parentInstances size: {1}", (Object[])new Object[]{parentEntry, parentInstances.size()});
                }
                for (ConfigElement parent : parentInstances) {
                    ConfigElement child;
                    Object o2;
                    List children;
                    Object attr;
                    String alias;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Examing parent instance {0}", (Object[])new Object[]{parent});
                    }
                    if (parentRef.isParentFirst()) {
                        alias = re.getEffectiveAD(parentRef.getAccessor());
                        attr = parent.getAttribute(alias);
                        if (attr == null || !(attr instanceof List)) continue;
                        children = (List)attr;
                        for (Object o2 : children) {
                            if (!(o2 instanceof ConfigElement)) continue;
                            child = (ConfigElement)o2;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Found child {0} for parent {1} using alias {2}", (Object[])new Object[]{child, parent, alias});
                                Tr.debug((TraceComponent)tc, (String)"Creating NestedConfigElement with registry entry ", (Object[])new Object[]{re});
                            }
                            retVal.add(new NestedConfigElement(child, parent, re));
                        }
                        continue;
                    }
                    alias = parentRef.getAccessor();
                    if (!pid.equals(alias) && (attr = parent.getAttribute(alias)) != null && attr instanceof List) {
                        children = (List)attr;
                        for (int i = 0; i < children.size(); ++i) {
                            o2 = children.get(i);
                            if (!(o2 instanceof ConfigElement)) continue;
                            child = (ConfigElement)o2;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Found child {0} for parent {1} using alias {2}", (Object[])new Object[]{child, parent, alias});
                                Tr.debug((TraceComponent)tc, (String)"Creating NestedConfigElement with registry entry ", (Object[])new Object[]{parentEntry});
                            }
                            retVal.add(new NestedConfigElement(child, parent, parentEntry));
                        }
                    }
                    if ((attr = parent.getAttribute(pid)) == null || !(attr instanceof List)) continue;
                    children = (List)attr;
                    for (int i = 0; i < children.size(); ++i) {
                        o2 = children.get(i);
                        if (!(o2 instanceof ConfigElement)) continue;
                        child = (ConfigElement)o2;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Found child {0} for parent {1} using pid {2}", (Object[])new Object[]{child, parent, pid});
                            Tr.debug((TraceComponent)tc, (String)"Creating NestedConfigElement with registry entry ", (Object[])new Object[]{parentEntry});
                        }
                        if (!parent.isSimple()) continue;
                        if (parentEntry.isFactory()) {
                            retVal.add(new FactoryElement((SimpleElement)parent, -1, parentEntry));
                            continue;
                        }
                        retVal.add(new SingletonElement((SimpleElement)parent, parentEntry.getPid()));
                    }
                }
            }
        }
        return retVal;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class NestedConfigElement
    extends ConfigElement {
        private final ConfigElement parent;
        private final MetaTypeRegistry.RegistryEntry parentRegistryEntry;
        private final String id;
        static final long serialVersionUID = -6377134655986571715L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public NestedConfigElement(ConfigElement child, ConfigElement parent, MetaTypeRegistry.RegistryEntry parentEntry) {
            super(child);
            this.id = child.getId();
            this.parent = parent;
            this.parentRegistryEntry = parentEntry;
        }

        @Override
        public ConfigElement getParent() {
            return this.parent;
        }

        public MetaTypeRegistry.RegistryEntry getParentRegistryEntry() {
            return this.parentRegistryEntry;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean isSimple() {
            return true;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.ServerConfiguration$NestedConfigElement", NestedConfigElement.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
        }
    }
}

