/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallLicense;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import wlp.lib.extract.SelfExtract;
import wlp.lib.extract.SelfExtractUtils;

public class LicenseUpgradeUtility {
    private final String productId;
    private final String productOwner;
    private final String productVersion;
    private final String productName;
    private final String productReplaces;
    private final String productInstallType;
    private final String productEdition;
    private final String productLicenseType;
    private final String wlpDir;
    private final List<String> features;
    private final boolean acceptLicense;
    Set<InstallLicense> featureLicenses = Collections.emptySet();
    private static final String UNSPECIFIED_LICENSE_TYPE = "UNSPECIFIED";
    final String WEBSPHERE_PROPERTIES_FILE_DIR = "/lib/versions/";
    final String WEBSPHERE_TAGS_DIR = "/lib/versions/tags/";
    final String WEBSPHERE_PROPERTIES_FILE_NAME = "WebsphereApplicationServer.properties";
    final String WEBSPHERE_LICENSE_FILE_DIR = "/lafiles/com.ibm.websphere.appserver/";
    final String OL_LICENSE_FILE_DIR = "/lafiles/io.openliberty/";
    final String OL_LICENSE = "LICENSE";
    final String OL_NOTICES = "NOTICES";
    final String OL_TAG_PREFIX = "openliberty";
    private String name;
    private final String programName;
    private static final String PROGRAM_NAME = "Program Name (Program Number):";
    private static final String LA_PREFIX = "LA_";
    private static final String LI_PREFIX = "LI_";

    public LicenseUpgradeUtility(LicenseUpgradeUtilityBuilder builder) {
        this.productId = builder.productId;
        this.productOwner = builder.productOwner;
        this.productVersion = builder.productVersion;
        this.productName = builder.productName != null ? builder.productName : "Websphere Application Server";
        this.productReplaces = builder.productReplaces != null ? builder.productReplaces : "io.openliberty";
        this.productInstallType = builder.productInstallType;
        this.productEdition = builder.productEdition;
        this.productLicenseType = builder.productLicenseType;
        this.name = null;
        this.programName = null;
        this.wlpDir = builder.wlpDir != null ? builder.wlpDir : Utils.getInstallDir().getAbsolutePath();
        this.features = builder.features;
        this.acceptLicense = builder.acceptLicense;
    }

    public void generateWebspherePropertiesFile() {
        String propertiesDir = this.wlpDir + "/lib/versions/" + "WebsphereApplicationServer.properties";
        Properties prop = new Properties();
        FileInputStream input = null;
        try (FileOutputStream os = new FileOutputStream(propertiesDir);){
            input = new FileInputStream(propertiesDir);
            prop.load(input);
            prop.setProperty("com.ibm.websphere.productId", this.productId);
            prop.setProperty("com.ibm.websphere.productReplaces", this.productReplaces);
            prop.setProperty("com.ibm.websphere.productOwner", this.productOwner);
            prop.setProperty("com.ibm.websphere.productVersion", this.productVersion);
            prop.setProperty("com.ibm.websphere.productNane", this.productName);
            prop.setProperty("com.ibm.websphere.productInstallType", this.productInstallType);
            prop.setProperty("com.ibm.websphere.productEdition", this.productEdition);
            prop.setProperty("com.ibm.websphere.productLicense", this.productLicenseType);
            prop.store(os, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean handleLicenses(String featureList) throws InstallException {
        if (this.acceptLicense) {
            return true;
        }
        Locale def = Locale.getDefault();
        String laFilePath = this.getLicenseFilePath(def, true);
        String liFilePath = this.getLicenseFilePath(def, false);
        this.processLicense(liFilePath);
        if (laFilePath == null || liFilePath == null) {
            System.out.println("unable to find license files in folder: " + this.wlpDir + "/lafiles/com.ibm.websphere.appserver/");
        }
        return this.handleLicenseAcceptance(laFilePath, liFilePath, featureList);
    }

    private String getLicenseFilePath(Locale desiredLocale, boolean isAgreement) {
        String result = null;
        Locale desiredLanguage = new Locale(desiredLocale.getLanguage());
        File folder = new File(this.wlpDir + "/lafiles/com.ibm.websphere.appserver/");
        File[] listOfFiles = folder.listFiles();
        String enFilePath = "";
        for (int i = 0; i < listOfFiles.length; ++i) {
            String[] locSplit;
            if (!listOfFiles[i].isFile()) continue;
            String filename = listOfFiles[i].getName();
            String filepath = this.wlpDir + "/lafiles/com.ibm.websphere.appserver/" + filename;
            if (isAgreement) {
                if (!filename.startsWith(LA_PREFIX)) continue;
                String loca = filename.replace(LA_PREFIX, "");
                Locale locla = new Locale(loca);
                if (loca.contains("_")) {
                    locSplit = loca.split("_");
                    locla = new Locale(locSplit[0], locSplit[1]);
                }
                if (locla.equals(desiredLocale)) {
                    return filepath;
                }
                if (locla.equals(desiredLanguage)) {
                    result = filepath;
                    continue;
                }
                if (!locla.equals(Locale.ENGLISH)) continue;
                enFilePath = filepath;
                continue;
            }
            if (!filename.startsWith(LI_PREFIX)) continue;
            String loci = filename.replace(LI_PREFIX, "");
            Locale locli = new Locale(loci);
            if (loci.contains("_")) {
                locSplit = loci.split("_");
                locli = new Locale(locSplit[0], locSplit[1]);
            }
            if (locli.equals(desiredLocale)) {
                return filepath;
            }
            if (locli.equals(desiredLanguage)) {
                result = filepath;
                continue;
            }
            if (!locli.equals(Locale.ENGLISH)) continue;
            enFilePath = filepath;
        }
        if (result == null && !enFilePath.isEmpty()) {
            return enFilePath;
        }
        return result;
    }

    private boolean handleLicenseAcceptance(String laFilePath, String liFilePath, String featureList) {
        SelfExtract.wordWrappedOut((String)SelfExtract.format((String)"licenseStatement", (Object[])new Object[]{featureList, this.name}));
        System.out.println();
        return this.obtainLicenseAgreement(laFilePath, liFilePath);
    }

    private boolean obtainLicenseAgreement(String laFilePath, String liFilePath) {
        boolean view = SelfExtract.getResponse((String)SelfExtract.format((String)"promptAgreement"), (String)"", (String)"xX");
        if (view) {
            SelfExtract.wordWrappedOut((String)this.getStrFromFile(laFilePath));
            System.out.println();
        }
        if (view = SelfExtract.getResponse((String)SelfExtract.format((String)"promptInfo"), (String)"", (String)"xX")) {
            SelfExtract.wordWrappedOut((String)this.getStrFromFile(liFilePath));
            System.out.println();
        }
        System.out.println();
        SelfExtract.wordWrappedOut((String)SelfExtract.format((String)"licenseOptionDescription"));
        System.out.println();
        boolean accept = SelfExtract.getResponse((String)SelfExtract.format((String)"licensePrompt", (Object[])new Object[]{"[1]", "[2]"}), (String)"1", (String)"2");
        System.out.println();
        return accept;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStrFromFile(String filePath) {
        File file = new File(filePath);
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = null;
        try {
            String line;
            FileInputStream is = new FileInputStream(file);
            reader = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_16));
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            SelfExtractUtils.tryToClose((Reader)reader);
        }
        catch (IOException e) {
            String string = "";
            return string;
        }
        finally {
            SelfExtractUtils.tryToClose(reader);
        }
        return sb.toString();
    }

    private void processLicense(String filePath) throws InstallException {
        File file = new File(filePath);
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = null;
        try {
            String line;
            FileInputStream is = new FileInputStream(file);
            reader = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_16));
            boolean isProgramName = false;
            int firstTenLinesCounter = 0;
            while ((line = reader.readLine()) != null) {
                if (firstTenLinesCounter >= 6) continue;
                if (line.contains("License Agreement")) {
                    this.name = line.replaceFirst("\\d\\.", "").trim();
                }
                ++firstTenLinesCounter;
            }
        }
        catch (IOException e) {
            try {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_FAILED_TO_READ_LICENSE", filePath));
            }
            catch (Throwable throwable) {
                SelfExtractUtils.tryToClose(reader);
                throw throwable;
            }
        }
        SelfExtractUtils.tryToClose((Reader)reader);
    }

    public void handleOLLicense() throws InstallException {
        File oldLicense = new File(this.wlpDir + File.separator + "LICENSE");
        File oldNotices = new File(this.wlpDir + File.separator + "NOTICES");
        File laDir = new File(this.wlpDir + "/lafiles/io.openliberty/");
        laDir.mkdirs();
        oldLicense.renameTo(new File(this.wlpDir + "/lafiles/io.openliberty/" + "LICENSE"));
        oldNotices.renameTo(new File(this.wlpDir + "/lafiles/io.openliberty/" + "NOTICES"));
        File tagsFolder = new File(this.wlpDir + "/lib/versions/tags/");
        File[] listOfFiles = tagsFolder.listFiles();
        for (int i = 0; i < listOfFiles.length; ++i) {
            if (!listOfFiles[i].getName().toLowerCase().contains("openliberty")) continue;
            listOfFiles[i].delete();
        }
    }

    public static class LicenseUpgradeUtilityBuilder {
        String productId;
        String productOwner;
        String productVersion;
        String productName;
        String productReplaces;
        String productInstallType;
        String productEdition;
        String productLicenseType;
        String wlpDir;
        Boolean acceptLicense;
        List<String> features;

        public LicenseUpgradeUtilityBuilder setProductId(String productId) {
            this.productId = productId;
            return this;
        }

        public LicenseUpgradeUtilityBuilder setProductOwner(String productOwner) {
            this.productOwner = productOwner;
            return this;
        }

        public LicenseUpgradeUtilityBuilder setProductVersion(String productVersion) {
            this.productVersion = productVersion;
            return this;
        }

        public LicenseUpgradeUtilityBuilder setProductName(String productName) {
            this.productName = productName;
            return this;
        }

        public LicenseUpgradeUtilityBuilder setProductReplaces(String productReplaces) {
            this.productReplaces = productReplaces;
            return this;
        }

        public LicenseUpgradeUtilityBuilder setProductInstallType(String productInstallType) {
            this.productInstallType = productInstallType;
            return this;
        }

        public LicenseUpgradeUtilityBuilder setProductEdition(String productEdition) {
            this.productEdition = productEdition;
            return this;
        }

        public LicenseUpgradeUtilityBuilder setProductLicenseType(String productLicenseType) {
            this.productLicenseType = productLicenseType;
            return this;
        }

        public LicenseUpgradeUtilityBuilder setWlpDir(String wlpDir) {
            this.wlpDir = wlpDir;
            return this;
        }

        public LicenseUpgradeUtilityBuilder setFeatures(List<String> features) {
            this.features = features;
            return this;
        }

        public LicenseUpgradeUtilityBuilder setAcceptLicense(Boolean acceptLicense) {
            this.acceptLicense = acceptLicense;
            return this;
        }

        public LicenseUpgradeUtility build() {
            return new LicenseUpgradeUtility(this);
        }
    }
}

