/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi;

import com.ibm.ws.collector.manager.buffer.BufferManagerImpl;
import com.ibm.ws.logging.source.LogSource;
import com.ibm.ws.logging.source.TraceSource;
import com.ibm.ws.logging.utils.CollectorManagerPipelineUtils;
import com.ibm.wsspi.collector.manager.BufferManager;
import com.ibm.wsspi.collector.manager.CollectorManager;
import com.ibm.wsspi.collector.manager.Handler;
import com.ibm.wsspi.collector.manager.Source;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class CollectorManagerPipelineConfigurator {
    private BundleContext bundleContext = null;
    private CollectorManagerPipelineUtils collectorMgrPipelineUtils = null;
    private final ServiceListener collectorManagerListener = new ServiceListener(){

        public void serviceChanged(ServiceEvent event) {
            switch (event.getType()) {
                case 1: {
                    CollectorManagerPipelineConfigurator.this.setCollectorManagerPipeline((ServiceReference<CollectorManager>)event.getServiceReference());
                    break;
                }
                case 4: {
                    CollectorManagerPipelineConfigurator.this.unsetCollectorManagerHandler((ServiceReference<CollectorManager>)event.getServiceReference());
                    break;
                }
            }
        }
    };

    public CollectorManagerPipelineConfigurator(BundleContext context) {
        this.collectorMgrPipelineUtils = CollectorManagerPipelineUtils.getInstance();
        this.bundleContext = context;
        try {
            this.bundleContext.addServiceListener(this.collectorManagerListener, "(objectClass=com.ibm.wsspi.collector.manager.CollectorManager)");
            this.processInitialCollectorManagerServices();
        }
        catch (InvalidSyntaxException ise) {
            throw new RuntimeException(ise);
        }
    }

    private Dictionary<String, String> returnSourceServiceProps() {
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
        ((Dictionary)serviceProperties).put("service.vendor", "IBM");
        ((Dictionary)serviceProperties).put("id", "ANALYTICSLOGSOURCE");
        return serviceProperties;
    }

    private Dictionary<String, String> returnConduitServiceProps(String sourceName) {
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
        ((Dictionary)serviceProperties).put("source", sourceName);
        return serviceProperties;
    }

    private Dictionary<String, String> returnHandlerServiceProps() {
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
        ((Dictionary)serviceProperties).put("service.vendor", "IBM");
        return serviceProperties;
    }

    protected void setCollectorManagerPipeline(ServiceReference<CollectorManager> ref) {
        Handler consoleLoghandler;
        LogSource logSource = this.collectorMgrPipelineUtils.getLogSource();
        TraceSource traceSource = this.collectorMgrPipelineUtils.getTraceSource();
        BufferManagerImpl logConduit = this.collectorMgrPipelineUtils.getLogConduit();
        BufferManagerImpl traceConduit = this.collectorMgrPipelineUtils.getTraceConduit();
        this.bundleContext.registerService(BufferManager.class.getName(), (Object)logConduit, this.returnConduitServiceProps(logSource.getSourceName()));
        this.bundleContext.registerService(BufferManager.class.getName(), (Object)traceConduit, this.returnConduitServiceProps(traceSource.getSourceName()));
        this.bundleContext.registerService(new String[]{Source.class.getName()}, (Object)logSource, this.returnSourceServiceProps());
        this.bundleContext.registerService(new String[]{Source.class.getName()}, (Object)traceSource, this.returnSourceServiceProps());
        Handler messageLoghandler = this.collectorMgrPipelineUtils.getMessageLogHandler();
        if (messageLoghandler != null) {
            this.bundleContext.registerService(Handler.class.getName(), (Object)messageLoghandler, this.returnHandlerServiceProps());
        }
        if ((consoleLoghandler = this.collectorMgrPipelineUtils.getConsoleLogHandler()) != null) {
            this.bundleContext.registerService(Handler.class.getName(), (Object)consoleLoghandler, this.returnHandlerServiceProps());
        }
    }

    protected void unsetCollectorManagerHandler(ServiceReference<CollectorManager> ref) {
    }

    protected void processInitialCollectorManagerServices() throws InvalidSyntaxException {
        ServiceReference[] servRefs = this.bundleContext.getServiceReferences(CollectorManager.class.getName(), null);
        if (servRefs != null) {
            for (ServiceReference servRef : servRefs) {
                this.setCollectorManagerPipeline((ServiceReference<CollectorManager>)servRef);
            }
        }
    }
}

