/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ws.ffdc.DiagnosticModuleRegistrationFailureException;
import com.ibm.ws.ffdc.IncidentStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;

public class DiagnosticModule {
    public static final String DEBUG_DM_PROPERTY = "com.ibm.ws.ffdc.debugDiagnosticModule";
    public static final String FFDC_DUMP_PREFIX = "ffdcdump";
    public static final String FFDC_DUMP_DEFAULT_PREFIX = "ffdcdumpdefault";
    static final Class<?>[] FFDC_DUMP_PARAMS = new Class[]{Throwable.class, IncidentStream.class, Object.class, Object[].class, String.class};
    static Boolean debugDiagnosticModules = null;
    private boolean initialized;
    private final List<Method> _dumpDefaultMethods = new ArrayList<Method>();
    private final List<Method> _dumpMethods = new ArrayList<Method>();
    private final List<String> _directives = new ArrayList<String>();
    private final ThreadLocal<Boolean> _continueProcessing = new ThreadLocal();

    final void init() throws DiagnosticModuleRegistrationFailureException {
        Method[] methods;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        for (Method method : methods = this.getClass().getMethods()) {
            String name = method.getName().toLowerCase();
            if (!name.startsWith(FFDC_DUMP_PREFIX)) continue;
            Class<?>[] params = method.getParameterTypes();
            if (params.length == FFDC_DUMP_PARAMS.length) {
                boolean allOK = true;
                for (int i = 0; i < params.length && allOK; ++i) {
                    allOK = params[i] == FFDC_DUMP_PARAMS[i];
                }
                if (allOK) {
                    this._directives.add(method.getName());
                    if (name.startsWith(FFDC_DUMP_DEFAULT_PREFIX)) {
                        this._dumpDefaultMethods.add(method);
                        continue;
                    }
                    this._dumpMethods.add(method);
                    continue;
                }
                if (!DiagnosticModule.makeNoise()) continue;
                throw new DiagnosticModuleRegistrationFailureException("Error: " + method + " starts with " + FFDC_DUMP_DEFAULT_PREFIX + " but does not conform to the signature.  Method skipped!");
            }
            if (!DiagnosticModule.makeNoise()) continue;
            throw new DiagnosticModuleRegistrationFailureException("Error: " + method + " starts with " + FFDC_DUMP_DEFAULT_PREFIX + " but does not conform to the signature.  Method skipped!");
        }
    }

    public String[] getDirectives() {
        return this._directives.toArray(new String[0]);
    }

    public final boolean dumpComponentData(String[] input_directives, Throwable ex, IncidentStream ffdcis, Object callerThis, Object[] catcherObjects, String sourceId, String[] callStack) {
        this.startProcessing();
        try {
            ffdcis.writeLine("==> Performing default dump from " + this.getClass().getName() + " ", new Date());
            for (Method m : this._dumpDefaultMethods) {
                this.invokeDiagnosticMethod(m, ex, ffdcis, callerThis, catcherObjects, sourceId);
                if (this.continueProcessing()) continue;
                break;
            }
            if (input_directives != null && input_directives.length > 0) {
                ffdcis.writeLine("==> Performing custom/other dump from " + this.getClass().getName() + " ", new Date());
                this.getDataForDirectives(input_directives, ex, ffdcis, callerThis, catcherObjects, sourceId);
            }
            ffdcis.writeLine("==> Dump complete for " + this.getClass().getName() + " ", new Date());
        }
        catch (Throwable th) {
            ffdcis.writeLine("==> Dump did not complete for " + this.getClass().getName() + " ", new Date());
        }
        return this.finishProcessing();
    }

    public final void getDataForDirectives(String[] directives, Throwable ex, IncidentStream ffdcis, Object callerThis, Object[] catcherObjects, String sourceId) {
        if (directives == null || directives.length <= 0 || !this.continueProcessing()) {
            return;
        }
        for (String s : directives) {
            String sName = s.toLowerCase();
            for (Method m : this._dumpMethods) {
                String mName = m.getName().toLowerCase();
                if (!mName.equals(sName)) continue;
                this.invokeDiagnosticMethod(m, ex, ffdcis, callerThis, catcherObjects, sourceId);
                break;
            }
            if (!this.continueProcessing()) break;
        }
    }

    private final void invokeDiagnosticMethod(Method m, Throwable ex, IncidentStream ffdcis, Object callerThis, Object[] catcherObjects, String sourceId) {
        try {
            m.invoke((Object)this, ex, ffdcis, callerThis, catcherObjects, sourceId);
            ffdcis.writeLine("+ Data for directive [" + m.getName().substring(FFDC_DUMP_PREFIX.length()) + "] obtained.", "");
        }
        catch (Throwable t) {
            ffdcis.writeLine("Error while processing directive [" + m.getName().substring(FFDC_DUMP_PREFIX.length()) + "] !!!", t);
        }
    }

    public final boolean validate() {
        if (DiagnosticModule.makeNoise()) {
            System.out.println("This method is NOT intended to be called from the runtime");
            System.out.println("but is provided as part of unit test for diagnostic modules");
            try {
                this.init();
                System.out.println("default directives on the diagnostic module : ");
                ListIterator<Method> im = this._dumpDefaultMethods.listIterator();
                while (im.hasNext()) {
                    System.out.println("\t" + im.next());
                }
                System.out.println("ffdc methods on the diagnostic module : ");
                im = this._dumpMethods.listIterator();
                while (im.hasNext()) {
                    System.out.println("\t" + im.next());
                }
            }
            catch (DiagnosticModuleRegistrationFailureException dmfailed) {
                System.out.println("Diagnostic Module failed to register: " + dmfailed);
                dmfailed.printStackTrace();
                return false;
            }
            catch (Throwable th) {
                System.out.println("Some unknown failure occured: " + th);
                th.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private boolean continueProcessing() {
        Boolean currentValue = this._continueProcessing.get();
        if (currentValue != null) {
            return currentValue;
        }
        return true;
    }

    private final void startProcessing() {
        this._continueProcessing.set(Boolean.TRUE);
    }

    private final boolean finishProcessing() {
        Boolean currentValue = this._continueProcessing.get();
        this._continueProcessing.remove();
        return currentValue;
    }

    public final void stopProcessingException() {
        this._continueProcessing.set(Boolean.FALSE);
    }

    private static final boolean makeNoise() {
        if (debugDiagnosticModules == null) {
            debugDiagnosticModules = Boolean.getBoolean(DEBUG_DM_PROPERTY);
        }
        return debugDiagnosticModules;
    }
}

