/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.equinox.log.SynchronousLogListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogLevel;

public class TrOSGiLogForwarder
implements SynchronousLogListener,
SynchronousBundleListener {
    private static final TraceComponent _tc = Tr.register(TrOSGiLogForwarder.class, (String)"osgilogging", (String)"com.ibm.ws.logging.internal.osgi.resources.OSGiMessages");
    public static final int LOG_EVENT = -5;
    private static final Object COULD_NOT_OBTAIN_LOCK_EXCEPTION = "Could not obtain lock";
    private static final String COULD_NOT_GET_SERVICE_FROM_REF = "could not get service from ref";
    private static final String COULD_NOT_OBTAIN_ALL_REQ_DEPS = "could not obtain all required dependencies";
    private static final String SERVICE_NOT_AVAILABLE = "service not available from service registry for servicereference";
    private static final String CANNOT_BE_CALLED_ON_NULL_OBJECT = "cannot be called on null object";
    private final Map<Bundle, OSGiTraceComponent> traceComponents = new ConcurrentHashMap<Bundle, OSGiTraceComponent>();
    final ThreadLocal<Boolean> currentlyLogging = new ThreadLocal();

    public TrOSGiLogForwarder() {
        LogEntry.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OSGiTraceComponent getTraceComponent(Bundle b) {
        OSGiTraceComponent tc = this.traceComponents.get(b);
        if (tc != null) {
            return tc;
        }
        Map<Bundle, OSGiTraceComponent> map = this.traceComponents;
        synchronized (map) {
            tc = this.traceComponents.get(b);
            if (tc == null) {
                String ffdcMe;
                String bsn = b.getSymbolicName();
                long id = b.getBundleId();
                if (bsn == null) {
                    bsn = "osgi-bundle";
                    ffdcMe = bsn + "-" + id;
                } else {
                    ffdcMe = bsn + "-" + b.getVersion();
                }
                String logName = id + "-" + bsn;
                ArrayList<String> groups = new ArrayList<String>(5);
                groups.add(bsn);
                String groupHeader = (String)b.getHeaders("").get("WS-TraceGroup");
                if (groupHeader != null) {
                    groups.add(groupHeader);
                }
                groups.add("logservice");
                groups.add("OSGi.Events");
                if (b.getBundleId() == 0L) {
                    groups.addAll(this.getEquinoxTraceGroups(b));
                }
                tc = new OSGiTraceComponent(logName, this.getClass(), groups.toArray(new String[0]), ffdcMe);
                this.traceComponents.put(b, tc);
                TrConfigurator.registerTraceComponent((TraceComponent)tc);
                if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)("Created OSGiTraceComponent: " + (Object)((Object)tc)), (Object[])new Object[0]);
                }
            }
            return tc;
        }
    }

    private Collection<String> getEquinoxTraceGroups(Bundle b) {
        Properties options = new Properties();
        try {
            options.load(b.getResource(".options").openStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return options.stringPropertyNames();
    }

    public void logged(LogEntry le) {
        if (this.currentlyLogging.get() == Boolean.TRUE) {
            return;
        }
        this.currentlyLogging.set(Boolean.TRUE);
        try {
            this.loggedImpl(le);
        }
        finally {
            this.currentlyLogging.set(null);
        }
    }

    private void loggedImpl(LogEntry logEntry) {
        boolean isAnyTraceEnabled = TraceComponent.isAnyTracingEnabled();
        Bundle b = logEntry.getBundle();
        if (b == null) {
            return;
        }
        OSGiTraceComponent tc = this.getTraceComponent(b);
        try {
            if (logEntry.getLogLevel() != LogLevel.ERROR && logEntry.getLoggerName() != null && logEntry.getLoggerName().startsWith("Events.")) {
                if (isAnyTraceEnabled && tc.isEventEnabled()) {
                    Tr.event((Object)b, (TraceComponent)tc, (String)logEntry.getMessage(), (Object[])this.getObjects(logEntry, false));
                }
                return;
            }
            switch (logEntry.getLogLevel()) {
                default: {
                    Tr.audit((TraceComponent)tc, (String)"OSGI_AUDIT_MSG", (Object[])this.getObjects(logEntry, true));
                    break;
                }
                case DEBUG: {
                    Tr.debug((Object)b, (TraceComponent)tc, (String)logEntry.getMessage(), (Object[])this.getObjects(logEntry, false));
                    break;
                }
                case INFO: {
                    if (this.shouldBeLogged(logEntry, tc)) {
                        Tr.info((TraceComponent)tc, (String)"OSGI_MSG001", (Object[])this.getObjects(logEntry, true));
                    }
                    break;
                }
                case WARN: {
                    if (this.shouldBeLogged(logEntry, tc)) {
                        Tr.warning((TraceComponent)tc, (String)"OSGI_WARNING_MSG", (Object[])this.getObjects(logEntry, true));
                    }
                    break;
                }
                case ERROR: {
                    Throwable t = logEntry.getException();
                    if (t instanceof BundleException && t.getMessage() != null && t.getCause() == null) {
                        Tr.error((TraceComponent)tc, (String)"OSGI_BUNDLE_EXCEPTION", (Object[])new Object[]{t.getMessage()});
                        break;
                    }
                    if (this.shouldBeLogged(t, tc, logEntry)) {
                        Tr.error((TraceComponent)tc, (String)"OSGI_ERROR_MSG", (Object[])this.getObjects(logEntry, true));
                    }
                    break;
                }
                case TRACE: {
                    Tr.dump((TraceComponent)tc, (String)logEntry.getMessage(), (Object[])this.getObjects(logEntry, false));
                    break;
                }
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)tc.getFfdcMe(), (String)"log", (Object)logEntry);
        }
    }

    Object[] getObjects(LogEntry logEntry, boolean translatedMsg) {
        Object event;
        Throwable t;
        ServiceReference sr;
        String loggerName;
        ArrayList<Object> list = new ArrayList<Object>(5);
        if (translatedMsg && logEntry.getMessage() != null) {
            list.add(logEntry.getMessage());
        }
        if (!translatedMsg && (loggerName = logEntry.getLoggerName()) != null) {
            list.add(String.format("LoggerName:%s", loggerName));
        }
        if ((sr = logEntry.getServiceReference()) != null) {
            String sString = String.format("ServiceRef:%s(id=%s, pid=%s)", Arrays.asList((String[])sr.getProperty("objectClass")), sr.getProperty("service.id"), sr.getProperty("service.pid"));
            list.add(sString);
        }
        if ((t = logEntry.getException()) != null) {
            list.add(t);
        }
        if ((event = ((ExtendedLogEntry)logEntry).getContext()) instanceof EventObject) {
            String sString = String.format("Event:%s", event.toString());
            list.add(sString);
        }
        if (translatedMsg) {
            while (list.size() < 4) {
                list.add("");
            }
        }
        return list.toArray();
    }

    private boolean shouldBeLogged(Throwable t, OSGiTraceComponent tc, LogEntry logEntry) {
        while (t != null) {
            if (t instanceof IllegalStateException && COULD_NOT_OBTAIN_LOCK_EXCEPTION.equals(t.getMessage())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"DS could not obtain a lock. This is not an error, but may indicate high system load", (Object[])this.getObjects(logEntry, false));
                }
                return false;
            }
            t = t.getCause();
        }
        return true;
    }

    public void bundleChanged(BundleEvent e) {
        if (e.getType() == 16) {
            this.traceComponents.remove(e.getBundle());
        }
    }

    private boolean shouldBeLogged(LogEntry logEntry, OSGiTraceComponent tc) {
        String message = logEntry.getMessage().toLowerCase();
        if (message.contains(COULD_NOT_GET_SERVICE_FROM_REF) || message.contains(COULD_NOT_OBTAIN_ALL_REQ_DEPS) || message.contains(SERVICE_NOT_AVAILABLE) || message.contains(CANNOT_BE_CALLED_ON_NULL_OBJECT)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("This is not an error, but may indicate high system load - " + logEntry.getMessage()), (Object[])this.getObjects(logEntry, false));
            }
            return false;
        }
        return true;
    }

    static final class OSGiTraceComponent
    extends TraceComponent {
        private final String ffdcMe;

        protected OSGiTraceComponent(String logName, Class<?> aClass, String[] groups, String ffdcMe) {
            super("LogService-" + logName, aClass, groups, "com.ibm.ws.logging.internal.osgi.resources.OSGiMessages");
            this.ffdcMe = ffdcMe;
        }

        public String getFfdcMe() {
            return this.ffdcMe;
        }
    }
}

