/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.AppForceRestart;
import com.ibm.ws.kernel.feature.FeatureDefinition;
import com.ibm.ws.kernel.feature.FeatureProvisioner;
import com.ibm.ws.kernel.feature.FixManager;
import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.ServerReadyStatus;
import com.ibm.ws.kernel.feature.ServerStarted;
import com.ibm.ws.kernel.feature.ServerStartedPhase2;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.BundleInstallOriginBundleListener;
import com.ibm.ws.kernel.feature.internal.BundleInstallStatus;
import com.ibm.ws.kernel.feature.internal.BundleLifecycleStatus;
import com.ibm.ws.kernel.feature.internal.BundleList;
import com.ibm.ws.kernel.feature.internal.EEValue;
import com.ibm.ws.kernel.feature.internal.FeatureResolverImpl;
import com.ibm.ws.kernel.feature.internal.InitialProvisioningListener;
import com.ibm.ws.kernel.feature.internal.PackageInspectorImpl;
import com.ibm.ws.kernel.feature.internal.Provisioner;
import com.ibm.ws.kernel.feature.internal.RestrictedFeatureRespository;
import com.ibm.ws.kernel.feature.internal.ServerContentHelper;
import com.ibm.ws.kernel.feature.internal.ServerFeaturesHelper;
import com.ibm.ws.kernel.feature.internal.ShutdownHookManager;
import com.ibm.ws.kernel.feature.internal.StartLevelFrameworkListener;
import com.ibm.ws.kernel.feature.internal.VersionValue;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository;
import com.ibm.ws.kernel.feature.internal.subsystem.KernelFeatureDefinitionImpl;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import com.ibm.ws.kernel.launch.service.FrameworkReady;
import com.ibm.ws.kernel.launch.service.ProductExtensionServiceFingerprint;
import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.kernel.provisioning.LibertyBootRuntime;
import com.ibm.ws.kernel.provisioning.ProductExtension;
import com.ibm.ws.kernel.provisioning.ProductExtensionInfo;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.kernel.service.util.ResolutionReportHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.update.RuntimeUpdateManager;
import com.ibm.ws.runtime.update.RuntimeUpdateNotification;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import com.ibm.wsspi.kernel.service.utils.TimestampUtils;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={FixManager.class, FeatureProvisioner.class, FrameworkReady.class, ManagedService.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "service.pid=com.ibm.ws.kernel.feature"})
public class FeatureManager
implements FixManager,
FeatureProvisioner,
FrameworkReady,
ManagedService {
    private static final String ME = FeatureManager.class.getName();
    private static final TraceComponent tc = Tr.register(FeatureManager.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
    private static final String CFG_KEY_ACTIVE_FEATURES = "feature";
    private static final String CFG_KEY_PLATFORMS = "platform";
    public static final String EE_COMPATIBLE_NAME = "eeCompatible";
    static final String INSTALLED_BUNDLE_CACHE = "platform/feature.bundles.cache";
    static final String FEATURE_DEF_CACHE_FILE = "platform/feature.cache";
    static final String FEATURE_FIX_CACHE_FILE = "feature.fix.cache";
    static final int FEATURE_FIX_CACHE_VERSION = 1;
    static final String FEATURE_TEST_FIXES = "IBM-Test-Fixes";
    static final String FEATURE_INTERIM_FIXES = "IBM-Interim-Fixes";
    static final String FEATURE_PRODUCT_EXTENSIONS_INSTALL = "com.ibm.websphere.productInstall";
    static final String FEATURE_PRODUCT_EXTENSIONS_FILE_EXTENSION = ".properties";
    static final String PRODUCT_INFO_STRING_OPEN_LIBERTY = "Open Liberty";
    private static String platformEnvironmentVariable = System.getenv("PREFERRED_PLATFORM_VERSIONS");
    static final FeatureResolver featureResolver = new FeatureResolverImpl();
    private static Version JAVA_MAJOR_VERSION = new Version(JavaInfo.majorVersion(), 0, 0);
    static final Collection<String> ALLOWED_ON_ALL_FEATURES = Arrays.asList("com.ibm.websphere.appserver.timedexit-1.0", "com.ibm.websphere.appserver.osgiConsole-1.0");
    static final Collection<String> ALL_ALLOWED_ON_CLIENT_FEATURES;
    static final String featureGroup = "feature";
    static final String featureGroupUsr = "feature:usr";
    static final String bundleGroup = "bundle";
    protected final ConcurrentLinkedQueue<FeatureChange> featureChanges;
    BundleContext bundleContext;
    protected volatile WsLocationAdmin locationService = null;
    protected ExecutorService executorService = null;
    protected VariableRegistry variableRegistry = null;
    protected RuntimeUpdateManager runtimeUpdateManager = null;
    protected EventAdmin eventAdminService = null;
    private RegionDigraph digraph = null;
    protected final ReentrantLock iAmUpdater;
    protected FrameworkStartLevel fwStartLevel;
    protected final InitialProvisioningListener initialProvisioningLatch = new InitialProvisioningListener();
    private static final AtomicLong featureUpdateNumber;
    protected OnErrorUtil.OnError onError;
    private final String CONFIG_PACKAGE_SERVER_CONFLICT = "package.server.conflict";
    private Set<String> packageServerConflict = null;
    protected FeatureRepository featureRepository;
    protected BundleList bundleCache;
    protected volatile ProvisioningMode provisioningMode;
    protected KernelFeaturesHolder kernelFeaturesHolder;
    protected final PackageInspectorImpl packageInspector;
    protected final ShutdownHookManager shutdownHook;
    private BundleListener bundleOriginsListener = null;
    private EnumSet<ProcessType> supportedProcessTypes = null;
    private String processTypeString = null;
    private volatile boolean deactivated;
    private volatile LibertyBootRuntime libertyBoot;
    private FrameworkWiring frameworkWiring;
    private final Set<String> iFixSet = new CopyOnWriteArraySet<String>();
    private final Set<String> tFixSet = new CopyOnWriteArraySet<String>();
    private final AtomicBoolean fixLock = new AtomicBoolean(false);
    @Reference
    private volatile List<ServerReadyStatus> serverReadyChecks;
    static final long serialVersionUID = -6868847374276192058L;

    public FeatureManager() {
        this.featureChanges = new ConcurrentLinkedQueue();
        this.iAmUpdater = new ReentrantLock();
        this.packageInspector = new PackageInspectorImpl();
        this.shutdownHook = new ShutdownHookManager();
        this.shutdownHook.addShutdownHook();
        this.shutdownHook.addListener(this.initialProvisioningLatch);
    }

    @Activate
    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        this.setSupportedProcessTypes(componentContext);
        this.bundleContext = componentContext.getBundleContext();
        Bundle systemBundle = this.bundleContext.getBundle("System Bundle");
        this.fwStartLevel = (FrameworkStartLevel)systemBundle.adapt(FrameworkStartLevel.class);
        this.frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
        this.packageInspector.activate(this.bundleContext);
        this.variableRegistry.addVariable(featureGroupUsr, "${usr.extension.dir}/lib/features/");
        BundleRepositoryRegistry.initializeDefaults((String)this.locationService.getServerName(), (boolean)true);
        WsResource bundleCacheFile = this.locationService.getServerWorkareaResource(INSTALLED_BUNDLE_CACHE);
        WsResource featureCacheFile = this.locationService.getServerWorkareaResource(FEATURE_DEF_CACHE_FILE);
        this.processProductExtensionsPropertiesFiles();
        this.featureRepository = new FeatureRepository(featureCacheFile, this.bundleContext);
        this.bundleCache = new BundleList(bundleCacheFile, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Feature Manager activated", (Object[])new Object[0]);
        }
        this.provisioningMode = ServerContentHelper.isServerContentRequest(this.bundleContext) ? ProvisioningMode.CONTENT_REQUEST : (ServerFeaturesHelper.isServerFeaturesRequest(this.bundleContext) ? ProvisioningMode.FEATURES_REQUEST : ProvisioningMode.INITIAL_PROVISIONING);
        this.kernelFeaturesHolder = new KernelFeaturesHolder(this, this.provisioningMode);
        this.bundleOriginsListener = new BundleInstallOriginBundleListener(this.bundleContext);
        this.bundleContext.addBundleListener(this.bundleOriginsListener);
    }

    private void setSupportedProcessTypes(ComponentContext componentContext) {
        String processTypeProp = componentContext.getBundleContext().getProperty("wlp.process.type");
        this.supportedProcessTypes = ProcessType.fromString(processTypeProp);
        this.processTypeString = processTypeProp;
    }

    private void processProductExtensionsPropertiesFiles() {
        for (ProductExtensionInfo prodExt : ProductExtension.getProductExtensions()) {
            String featureType = prodExt.getName();
            String fileName = featureType + FEATURE_PRODUCT_EXTENSIONS_FILE_EXTENSION;
            if (0 == featureType.length()) continue;
            String featurePath = prodExt.getLocation();
            if (featurePath != null) {
                String installDir;
                WsResource location;
                String normalPath = PathUtils.normalize((String)(featurePath = featurePath + "/"));
                if (PathUtils.containsSymbol((String)normalPath)) {
                    Tr.error((TraceComponent)tc, (String)"PRODUCT_FEATURE_INSTALL_PATH_SYMBOL_ERROR", (Object[])new Object[]{fileName, PathUtils.getSymbol((String)normalPath)});
                    continue;
                }
                WsLocationAdmin wsLocationAdmin = this.locationService;
                if (PathUtils.pathIsAbsolute((String)normalPath)) {
                    location = wsLocationAdmin.resolveResource(featurePath + "lib/features/");
                } else {
                    location = wsLocationAdmin.resolveResource("${wlp.parent.dir}/" + featurePath + "lib/features/");
                    featurePath = "${wlp.parent.dir}/" + featurePath;
                }
                if (location != null && location.exists()) {
                    installDir = wsLocationAdmin.resolveString(featurePath);
                    if (installDir.equalsIgnoreCase(wsLocationAdmin.resolveString("${wlp.install.dir}/"))) {
                        Tr.error((TraceComponent)tc, (String)"PRODUCT_FEATURE_INSTALL_PATH_WLP_ERROR", (Object[])new Object[]{fileName});
                        continue;
                    }
                    this.variableRegistry.addVariable("feature:" + featureType, featurePath + "lib/features/");
                    wsLocationAdmin.addLocation(installDir, featureType + ".extension.dir");
                    ProductExtensionServiceFingerprint.putProductExtension((String)prodExt.getName(), (String)installDir);
                    BundleRepositoryRegistry.addBundleRepository((String)installDir, (String)featureType);
                    continue;
                }
                installDir = wsLocationAdmin.resolveString(featurePath);
                Tr.error((TraceComponent)tc, (String)"PRODUCT_FEATURE_INSTALL_PATH_ERROR", (Object[])new Object[]{installDir, fileName});
                continue;
            }
            Tr.error((TraceComponent)tc, (String)"PRODUCT_FEATURE_PROPERTIES_FILE_ERROR", (Object[])new Object[]{fileName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    @FFDCIgnore(value={InterruptedException.class})
    protected void deactivate(int reason) {
        boolean lockObtained = false;
        try {
            lockObtained = this.iAmUpdater.tryLock(30L, TimeUnit.SECONDS);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Feature Manager deactivated, update lock obtained=" + lockObtained), (Object[])new Object[]{this});
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.deactivated = true;
            if (lockObtained) {
                this.iAmUpdater.unlock();
            }
        }
        this.bundleContext.removeBundleListener(this.bundleOriginsListener);
        this.notifyFrameworkReady();
        this.packageInspector.deactivate();
    }

    @Reference(name="locationService", service=WsLocationAdmin.class)
    protected void setLocationService(WsLocationAdmin locationService) {
        this.locationService = locationService;
    }

    protected void unsetLocationService(WsLocationAdmin locationService) {
    }

    public WsLocationAdmin getLocationService() {
        return this.locationService;
    }

    @Reference(name="runtimeUpdateManager", service=RuntimeUpdateManager.class)
    protected void setRuntimeUpdateManager(RuntimeUpdateManager runtimeUpdateManager) {
        this.runtimeUpdateManager = runtimeUpdateManager;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setLibertyBoot(LibertyBootRuntime libertyBoot) {
        this.libertyBoot = libertyBoot;
    }

    public LibertyBootRuntime getLibertyBoot() {
        return this.libertyBoot;
    }

    protected void unsetLibertyBoot(LibertyBootRuntime libertyBoot) {
        if (this.libertyBoot == libertyBoot) {
            this.libertyBoot = null;
        }
    }

    protected void unsetRuntimeUpdateManager(RuntimeUpdateManager runtimeUpdateManager) {
    }

    @Reference(name="eventAdminService", service=EventAdmin.class)
    protected void setEventAdminService(EventAdmin eventAdminService) {
        this.eventAdminService = eventAdminService;
    }

    protected void unsetEventAdminService(EventAdmin eventAdminService) {
    }

    @Reference(name="digraph", service=RegionDigraph.class)
    protected void setDigraph(RegionDigraph digraph) {
        this.digraph = digraph;
    }

    RegionDigraph getDigraph() {
        return this.digraph;
    }

    protected void unsetDigraph(RegionDigraph digraph) {
    }

    @Reference(name="executorService", service=ExecutorService.class)
    protected void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    protected void unsetExecutorService(ExecutorService executorService) {
    }

    @Reference(name="variableRegistry", service=VariableRegistry.class)
    protected void setVariableRegistry(VariableRegistry variableRegistry) {
        this.variableRegistry = variableRegistry;
    }

    protected void unsetVariableRegistry(VariableRegistry variableRegistry) {
    }

    public void updated(Dictionary<String, ?> configuration) throws ConfigurationException {
        String[] platforms;
        String[] features;
        ProvisioningMode mode = this.provisioningMode;
        this.provisioningMode = ProvisioningMode.UPDATE;
        if (configuration == null) {
            if (mode != ProvisioningMode.UPDATE) {
                this.notifyFrameworkReady();
            }
            return;
        }
        this.onError = (OnErrorUtil.OnError)configuration.get("onError");
        String packageServerConflictString = (String)configuration.get("package.server.conflict");
        if (packageServerConflictString != null && !packageServerConflictString.equalsIgnoreCase("false") && packageServerConflictString.length() != 0) {
            this.packageServerConflict = new HashSet<String>();
            if (!packageServerConflictString.equalsIgnoreCase("true")) {
                int startingIndex = 0;
                int index = packageServerConflictString.indexOf(",");
                while (index != -1) {
                    this.packageServerConflict.add(packageServerConflictString.substring(startingIndex, index).trim());
                    startingIndex = index + 1;
                    index = packageServerConflictString.indexOf(",", startingIndex);
                }
                this.packageServerConflict.add(packageServerConflictString.substring(startingIndex).trim());
            }
        }
        if ((features = (String[])configuration.get("feature")) == null) {
            features = new String[]{};
        }
        if ((platforms = (String[])configuration.get(CFG_KEY_PLATFORMS)) == null) {
            platforms = new String[]{};
        }
        this.queueFeatureChange(mode, features, platforms);
    }

    private void queueFeatureChange(final ProvisioningMode mode, String[] features, String[] platforms) {
        this.featureChanges.add(new FeatureChange(this.runtimeUpdateManager, mode, features, platforms));
        this.executorService.execute(new Runnable(){
            static final long serialVersionUID = 5741097686319075745L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void run() {
                try {
                    FeatureManager.this.processFeatureChanges();
                }
                finally {
                    if (mode != ProvisioningMode.UPDATE) {
                        FeatureManager.this.notifyFrameworkReady();
                    }
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureManager$1", 1.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        });
    }

    private void notifyFrameworkReady() {
        this.initialProvisioningLatch.countDown();
        this.shutdownHook.removeListener(this.initialProvisioningLatch);
    }

    public void waitForFrameworkReady() throws InterruptedException {
        this.initialProvisioningLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void update(FeatureChange featureChange) throws IllegalStateException {
        featureChange.createNotifications();
        preInstalledFeatures = Collections.emptySet();
        deletedAutoFeatures = new HashSet<String>();
        deletedPublicAutoFeatures = new HashSet<String>();
        preInstalledAutoFeatures = new HashSet<String>();
        preInstalledPublicAutoFeatures = new HashSet<String>();
        result = null;
        try {
            switch (6.$SwitchMap$com$ibm$ws$kernel$feature$internal$FeatureManager$ProvisioningMode[featureChange.provisioningMode.ordinal()]) {
                case 1: {
                    if (this.getStartLevel() >= 7) break;
                    startStatus = this.setStartLevel(7);
                    this.checkBundleStatus(startStatus);
                    break;
                }
                case 2: {
                    for (String featureName : this.featureRepository.getResolvedFeatures()) {
                        feature = this.featureRepository.getFeature(featureName);
                        if (feature == null || !feature.isAutoFeature()) continue;
                        preInstalledAutoFeatures.add(feature.getFeatureName());
                        if (feature.getVisibility() != Visibility.PUBLIC) continue;
                        preInstalledPublicAutoFeatures.add(feature.getFeatureName());
                    }
                    break;
                }
                case 3: {
                    if (!TraceComponent.isAnyTracingEnabled() || !FeatureManager.tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)FeatureManager.tc, (String)"Liberty server being held in paused state for minify operation", (Object[])new Object[0]);
                    break;
                }
            }
            this.featureRepository.init();
            this.bundleCache.init();
            if (FeatureManager.tc.isInfoEnabled()) {
                Tr.info((TraceComponent)FeatureManager.tc, (String)"STARTING_AUDIT", (Object[])new Object[0]);
            }
            preInstalledFeatures = new HashSet<String>(this.featureRepository.getResolvedFeatures());
            pkgs = this.bundleContext.getProperty("com.ibm.ws.kernel.classloading.apiPackagesToHide");
            apiPkgsToIgnore = pkgs == null ? null : new HashSet<String>(Arrays.asList(pkgs.split(",")));
            provisioner = new Provisioner(this, apiPkgsToIgnore);
            if (featureChange.provisioningMode == ProvisioningMode.REFRESH) {
                for (String featureName : preInstalledAutoFeatures) {
                    feature = this.featureRepository.getFeature(featureName);
                    if (feature != null) continue;
                    deletedAutoFeatures.add(featureName);
                    if (!preInstalledPublicAutoFeatures.contains(featureName)) continue;
                    deletedPublicAutoFeatures.add(featureName);
                }
                featureChange.features = this.getPublicFeatures(preInstalledFeatures, false).toArray(new String[0]);
            }
            result = this.updateFeatures(this.locationService, provisioner, preInstalledFeatures, featureChange, FeatureManager.featureUpdateNumber.incrementAndGet());
            switch (6.$SwitchMap$com$ibm$ws$kernel$feature$internal$FeatureManager$ProvisioningMode[featureChange.provisioningMode.ordinal()]) {
                case 3: {
                    new ServerContentHelper(this.bundleContext, this, this.locationService).processServerContentRequest();
                    ** break;
                }
                case 1: {
                    startStatus = this.setStartLevel(20);
                    this.checkBundleStatus(startStatus);
                    this.checkServerReady();
                    this.bundleContext.registerService(ServerStarted.class, (Object)new ServerStarted(){
                        static final long serialVersionUID = -4500943322592187549L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureManager$2", 2.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
                        }
                    }, null);
                    this.bundleContext.registerService(ServerStartedPhase2.class, (Object)new ServerStartedPhase2(){
                        static final long serialVersionUID = 5290140483028702291L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureManager$3", 3.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
                        }
                    }, null);
                    ** break;
                }
            }
        }
        catch (Throwable var14_14) {
            BundleRepositoryRegistry.disposeAll();
            KernelFeatureDefinitionImpl.dispose();
            this.bundleCache.dispose();
            this.featureRepository.dispose();
            this.fixLock.set(false);
            this.writeUpdateMessages(featureChange.provisioningMode, preInstalledFeatures, deletedAutoFeatures, deletedPublicAutoFeatures, result);
            throw var14_14;
        }
lbl74:
        // 3 sources

        BundleRepositoryRegistry.disposeAll();
        KernelFeatureDefinitionImpl.dispose();
        this.bundleCache.dispose();
        this.featureRepository.dispose();
        this.fixLock.set(false);
        this.writeUpdateMessages(featureChange.provisioningMode, preInstalledFeatures, deletedAutoFeatures, deletedPublicAutoFeatures, result);
    }

    private void checkServerReady() {
        this.serverReadyChecks.forEach(ServerReadyStatus::check);
    }

    public void queryServer(FeatureChange featureChange) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Liberty server being held in paused state for query operation", (Object[])new Object[0]);
        }
        try {
            this.featureRepository.init();
            this.bundleCache.init();
            if (tc.isInfoEnabled()) {
                Tr.info((TraceComponent)tc, (String)"STARTING_AUDIT", (Object[])new Object[0]);
            }
            new ServerFeaturesHelper(this.bundleContext).processServerFeaturesRequest(this.resolveFeatures(featureChange));
            if (featureChange.featureUpdatesCompleted != null) {
                featureChange.featureUpdatesCompleted.setResult(true);
            }
            if (featureChange.appForceRestart != null) {
                featureChange.appForceRestart.setResult(true);
            }
            if (featureChange.featureBundlesResolved != null) {
                featureChange.featureBundlesResolved.setResult(true);
            }
        }
        finally {
            this.writeServiceMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void processFeatureChanges() {
        do {
            retry = false;
            if (!this.iAmUpdater.tryLock()) continue;
            if (this.deactivated) {
                this.featureChanges.clear();
                return;
            }
            startTime = System.nanoTime();
            featureChange = this.featureChanges.poll();
            if (featureChange == null) {
                return;
            }
            try {
                switch (6.$SwitchMap$com$ibm$ws$kernel$feature$internal$FeatureManager$ProvisioningMode[featureChange.provisioningMode.ordinal()]) {
                    case 4: {
                        this.queryServer(featureChange);
                        ** break;
lbl16:
                        // 1 sources

                        break;
                    }
                    default: {
                        this.update(featureChange);
                        break;
                    }
                }
            }
            catch (IllegalStateException var5_6) {
                FFDCFilter.processException((Throwable)var5_6, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"939", (Object)this, (Object[])new Object[0]);
                this.featureChanges.clear();
            }
            catch (Exception var5_7) {
                FFDCFilter.processException((Throwable)var5_7, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"943", (Object)this, (Object[])new Object[0]);
            }
            finally {
                try {
                    this.writeFeatureChangeMessages(startTime, featureChange.provisioningMode);
                }
                finally {
                    this.iAmUpdater.unlock();
                }
            }
            if (this.featureChanges.isEmpty()) continue;
            retry = true;
        } while (retry);
    }

    private void writeUpdateMessages(ProvisioningMode provisioningMode, Set<String> preInstalledFeatures, Set<String> deletedAutoFeatures, Set<String> deletedPublicAutoFeatures, FeatureResolver.Result result) {
        this.writeServiceMessages();
        HashSet<String> postInstalledFeatures = new HashSet<String>(this.featureRepository.getResolvedFeatures());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("all installed features " + postInstalledFeatures), (Object[])new Object[0]);
        }
        if (result != null) {
            if (!result.getResolvedPlatforms().isEmpty()) {
                Tr.info((TraceComponent)tc, (String)"RESOLVED_PLATFORM", (Object[])new Object[]{result.getResolvedPlatforms()});
            }
            ArrayList<String> resolvedVersionless = new ArrayList<String>();
            ArrayList<String> resolvedVersioned = new ArrayList<String>();
            for (Map.Entry<String, String> versionlessResolved : result.getVersionlessFeatures().entrySet()) {
                if (versionlessResolved.getValue() == null) continue;
                ProvisioningFeatureDefinition versionless = this.featureRepository.getFeature(versionlessResolved.getKey());
                ProvisioningFeatureDefinition versioned = this.featureRepository.getFeature(versionlessResolved.getValue());
                if (!postInstalledFeatures.contains(versionless.getFeatureName()) && !postInstalledFeatures.contains(versionless.getSymbolicName()) || !postInstalledFeatures.contains(versioned.getFeatureName()) && !postInstalledFeatures.contains(versioned.getSymbolicName())) continue;
                resolvedVersionless.add(versionless.getFeatureName());
                resolvedVersioned.add(versioned.getFeatureName());
            }
            if (!resolvedVersionless.isEmpty()) {
                Tr.info((TraceComponent)tc, (String)"VERSIONLESS_FEATURE_RESOLVED_TO_FEATURE", (Object[])new Object[]{resolvedVersionless, resolvedVersioned});
            }
        }
        postInstalledFeatures.removeAll(preInstalledFeatures);
        Set<Object> installedPublicFeatures = Collections.emptySet();
        if (!postInstalledFeatures.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"added features", (Object[])new Object[]{postInstalledFeatures});
            }
            installedPublicFeatures = this.getPublicFeatures(postInstalledFeatures, true);
        }
        if (this.supportedProcessTypes.contains((Object)ProcessType.CLIENT)) {
            if (!installedPublicFeatures.isEmpty() && !preInstalledFeatures.isEmpty()) {
                Tr.audit((TraceComponent)tc, (String)"FEATURES_ADDED_CLIENT_DELTA", (Object[])new Object[]{installedPublicFeatures});
            }
            Tr.audit((TraceComponent)tc, (String)"FEATURES_ADDED_CLIENT", (Object[])new Object[]{this.getPublicFeatures(this.featureRepository.getResolvedFeatures(), true)});
        } else {
            if (!installedPublicFeatures.isEmpty() && !preInstalledFeatures.isEmpty()) {
                Tr.audit((TraceComponent)tc, (String)"FEATURES_ADDED_DELTA", (Object[])new Object[]{installedPublicFeatures});
            }
            Tr.audit((TraceComponent)tc, (String)"FEATURES_ADDED", (Object[])new Object[]{this.getPublicFeatures(this.featureRepository.getResolvedFeatures(), true)});
        }
        this.featureRepository.copyResolvedFeaturesTo(postInstalledFeatures);
        preInstalledFeatures.removeAll(postInstalledFeatures);
        preInstalledFeatures.addAll(deletedAutoFeatures);
        if (!preInstalledFeatures.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"removed features", (Object[])new Object[]{preInstalledFeatures});
            }
            Set<String> publicFeatures = this.getPublicFeatures(preInstalledFeatures, true);
            publicFeatures.addAll(deletedPublicAutoFeatures);
            if (!publicFeatures.isEmpty()) {
                Tr.audit((TraceComponent)tc, (String)"FEATURES_REMOVED", (Object[])new Object[]{publicFeatures});
            }
        }
    }

    private void writeFeatureChangeMessages(long startTime, ProvisioningMode provisioningMode) {
        String time = TimestampUtils.getElapsedTimeNanos((long)startTime);
        if (provisioningMode == ProvisioningMode.INITIAL_PROVISIONING && CheckpointPhase.getPhase() != CheckpointPhase.INACTIVE) {
            time = TimestampUtils.getElapsedTime();
        }
        if (FrameworkState.isStopping()) {
            return;
        }
        if (provisioningMode == ProvisioningMode.UPDATE) {
            Tr.audit((TraceComponent)tc, (String)"COMPLETE_AUDIT", (Object[])new Object[]{time});
        } else {
            if (tc.isInfoEnabled()) {
                Tr.info((TraceComponent)tc, (String)"COMPLETE_AUDIT", (Object[])new Object[]{time});
            }
            if (provisioningMode == ProvisioningMode.CONTENT_REQUEST) {
                Tr.audit((TraceComponent)tc, (String)"SERVER_MINIFY", (Object[])new Object[]{this.locationService.getServerName()});
            } else if (provisioningMode == ProvisioningMode.FEATURES_REQUEST) {
                Tr.audit((TraceComponent)tc, (String)"SERVER_GATHER_FEATURES", (Object[])new Object[]{this.locationService.getServerName()});
            } else if (this.supportedProcessTypes.contains((Object)ProcessType.CLIENT)) {
                Tr.audit((TraceComponent)tc, (String)"CLIENT_STARTED", (Object[])new Object[]{this.locationService.getServerName()});
            } else {
                Tr.audit((TraceComponent)tc, (String)"SERVER_STARTED", (Object[])new Object[]{this.locationService.getServerName(), TimestampUtils.getElapsedTime()});
            }
        }
    }

    @FFDCIgnore(value={IOException.class})
    public PrintStream getFixWriter(PrintStream out) {
        WsLocationAdmin locAdmin;
        if (out == null && (locAdmin = this.locationService) != null) {
            WsResource fixData = locAdmin.getServerWorkareaResource("platform/fix.data");
            try {
                out = new PrintStream(fixData.putStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    private final void populateFixSets() {
        if (this.fixLock.compareAndSet(false, true)) {
            Bundle[] bundles;
            HashSet<String> newTFixSet = new HashSet<String>();
            HashSet<String> newIFixSet = new HashSet<String>();
            PrintStream out = null;
            HashMap<Bundle, Map<String, String>> cachedFixes = new HashMap<Bundle, Map<String, String>>();
            boolean dirtyFixCache = this.readCachedFixes(cachedFixes);
            for (Bundle b : bundles = this.bundleContext.getBundles()) {
                String iFixes;
                String tFixes;
                boolean hasTFixes = false;
                boolean hasIFixes = false;
                HashMap<String, String> cachedHeaders = (HashMap<String, String>)cachedFixes.get(b);
                if (cachedHeaders == null) {
                    Dictionary headers;
                    try {
                        headers = b.getHeaders("");
                    }
                    catch (IllegalStateException illegalStateException) {
                        void ise;
                        FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"1129", (Object)this, (Object[])new Object[0]);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("writeServiceMessages - caught exception getting manifest headers for bundle " + b), (Object[])new Object[]{ise});
                        continue;
                    }
                    cachedHeaders = new HashMap<String, String>(2);
                    tFixes = (String)headers.get(FEATURE_TEST_FIXES);
                    boolean bl = hasTFixes = tFixes != null;
                    if (hasTFixes) {
                        cachedHeaders.put(FEATURE_TEST_FIXES, tFixes);
                    }
                    boolean bl2 = hasIFixes = (iFixes = (String)headers.get(FEATURE_INTERIM_FIXES)) != null;
                    if (hasIFixes) {
                        cachedHeaders.put(FEATURE_INTERIM_FIXES, iFixes);
                    }
                    cachedFixes.put(b, cachedHeaders);
                    dirtyFixCache = true;
                } else {
                    tFixes = (String)cachedHeaders.get(FEATURE_TEST_FIXES);
                    hasTFixes = tFixes != null;
                    iFixes = (String)cachedHeaders.get(FEATURE_INTERIM_FIXES);
                    boolean bl = hasIFixes = iFixes != null;
                }
                if (hasTFixes) {
                    out = this.getFixWriter(out);
                    out.print("tFix: ");
                    out.print(b.getLocation());
                    out.print(": ");
                    out.println(tFixes);
                    newTFixSet.addAll(Arrays.asList(tFixes.replaceAll(" ", "").split(",")));
                }
                if (!hasIFixes) continue;
                out = this.getFixWriter(out);
                out.print("iFix: ");
                out.print(b.getLocation());
                out.print(": ");
                out.println(iFixes);
                newIFixSet.addAll(Arrays.asList(iFixes.replaceAll(" ", "").split(",")));
            }
            if (out != null) {
                out.flush();
                out.close();
            }
            if (dirtyFixCache) {
                this.writeCachedFixes(cachedFixes);
            }
            this.tFixSet.clear();
            this.iFixSet.clear();
            this.tFixSet.addAll(newTFixSet);
            this.iFixSet.addAll(newIFixSet);
        }
    }

    @Override
    public Set<String> getTFixes() {
        this.populateFixSets();
        return Collections.unmodifiableSet(this.tFixSet);
    }

    @Override
    public Set<String> getIFixes() {
        this.populateFixSets();
        return Collections.unmodifiableSet(this.iFixSet);
    }

    private void writeServiceMessages() {
        Object fixes;
        StringBuilder builder;
        Set<String> tempTFixSet = this.getTFixes();
        Set<String> tempIFixSet = this.getIFixes();
        if (!tempIFixSet.isEmpty()) {
            builder = new StringBuilder();
            for (String fix : tempIFixSet) {
                if ("".equals(fix)) continue;
                builder.append(',');
                builder.append(fix);
            }
            builder.deleteCharAt(0);
            fixes = builder.toString();
            Tr.audit((TraceComponent)tc, (String)"INTERIM_FIX_DETECTED", (Object[])new Object[]{fixes});
        }
        if (!tempTFixSet.isEmpty()) {
            builder = new StringBuilder();
            for (String fix : tempTFixSet) {
                if ("".equals(fix)) continue;
                builder.append(',');
                builder.append(fix);
            }
            builder.deleteCharAt(0);
            fixes = builder.toString();
            Tr.warning((TraceComponent)tc, (String)"TEST_FIX_DETECTED", (Object[])new Object[]{fixes});
        }
    }

    private void writeCachedFixes(Map<Bundle, Map<String, String>> cachedFixes) {
        File cache = this.bundleContext.getDataFile(FEATURE_FIX_CACHE_FILE);
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(cache)));
            try {
                out.writeInt(1);
                out.writeInt(cachedFixes.size());
                for (Map.Entry<Bundle, Map<String, String>> bFixes : cachedFixes.entrySet()) {
                    out.writeLong(bFixes.getKey().getBundleId());
                    out.writeLong(bFixes.getKey().getLastModified());
                    this.writeFixHeader(FEATURE_TEST_FIXES, bFixes.getValue(), out);
                    this.writeFixHeader(FEATURE_INTERIM_FIXES, bFixes.getValue(), out);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"1250", (Object)this, (Object[])new Object[]{cachedFixes});
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"1250", (Object)this, (Object[])new Object[]{cachedFixes});
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            out.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"1260", (Object)this, (Object[])new Object[]{cachedFixes});
        }
    }

    private void writeFixHeader(String fixHeader, Map<String, String> headers, DataOutputStream out) throws IOException {
        String fixes = headers.get(fixHeader);
        boolean hasFixes = fixes != null;
        out.writeBoolean(hasFixes);
        if (hasFixes) {
            out.writeUTF(fixes);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readCachedFixes(Map<Bundle, Map<String, String>> result) {
        BundleContext systemContext = this.bundleContext.getBundle("System Bundle").getBundleContext();
        boolean dirty = false;
        File cache = this.bundleContext.getDataFile(FEATURE_FIX_CACHE_FILE);
        if (!cache.isFile()) {
            return true;
        }
        try {
            DataInputStream in;
            block13: {
                in = new DataInputStream(new BufferedInputStream(new FileInputStream(cache)));
                if (in.readInt() == 1) break block13;
                boolean bl = true;
                in.close();
                return bl;
            }
            try {
                int numBundles = in.readInt();
                for (int i = 0; i < numBundles; ++i) {
                    long id = in.readLong();
                    long lastModified = in.readLong();
                    String tFixes = this.readFixHeader(in);
                    String iFixes = this.readFixHeader(in);
                    boolean hasTFixes = tFixes != null;
                    boolean hasIFixes = iFixes != null;
                    Bundle b = systemContext.getBundle(id);
                    if (b != null && b.getLastModified() == lastModified) {
                        if (!hasTFixes && !hasIFixes) {
                            result.put(b, Collections.emptyMap());
                            continue;
                        }
                        HashMap<String, String> bFixes = new HashMap<String, String>(2);
                        if (hasTFixes) {
                            bFixes.put(FEATURE_TEST_FIXES, tFixes);
                        }
                        if (hasIFixes) {
                            bFixes.put(FEATURE_INTERIM_FIXES, iFixes);
                        }
                        result.put(b, bFixes);
                        continue;
                    }
                    dirty = true;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"1279", (Object)this, (Object[])new Object[]{result});
                try {
                    in.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"1279", (Object)this, (Object[])new Object[]{result});
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            in.close();
            return dirty;
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"1313", (Object)this, (Object[])new Object[]{result});
            return dirty;
        }
    }

    private String readFixHeader(DataInputStream in) throws IOException {
        return in.readBoolean() ? in.readUTF() : null;
    }

    private Set<String> getPublicFeatures(Set<String> postInstalledFeatures, boolean includeAutoFeatures) {
        TreeSet<String> publicFeatures = new TreeSet<String>();
        for (String feature : postInstalledFeatures) {
            ProvisioningFeatureDefinition fd = this.getFeatureDefinition(feature);
            if (fd == null || fd.getVisibility() != Visibility.PUBLIC || fd.isVersionless()) continue;
            if (!includeAutoFeatures) {
                if (fd instanceof ProvisioningFeatureDefinition) {
                    if (fd.isAutoFeature()) continue;
                    publicFeatures.add(fd.getFeatureName());
                    continue;
                }
                publicFeatures.add(fd.getFeatureName());
                continue;
            }
            publicFeatures.add(fd.getFeatureName());
        }
        return publicFeatures;
    }

    private FeatureResolver.Result resolveFeatures(FeatureChange featureChange) {
        Set<String> newConfiguredFeatures = featureChange.getFeaturesWithLowerCaseName(this.featureRepository);
        Set<String> newConfiguredPlatforms = featureChange.getPlatformsWithLowerCaseName();
        return this.resolveFeatures(newConfiguredFeatures, new ArrayList<String>(), featureChange.provisioningMode, newConfiguredPlatforms);
    }

    private FeatureResolver.Result resolveFeatures(Set<String> rootFeatures, Collection<String> restrictedAccessAttempts, ProvisioningMode mode, Set<String> newConfiguredPlatforms) {
        FeatureResolver.Repository restrictedRespository;
        if (rootFeatures.isEmpty() && this.featureRepository.emptyFeatures()) {
            Tr.warning((TraceComponent)tc, (String)"EMPTY_FEATURES_WARNING", (Object[])new Object[0]);
        }
        Collection<Object> restrictedRepoAccessAttempts = new ArrayList();
        boolean allowMultipleVersions = false;
        boolean featureListIsComplete = false;
        Set<String> currentPackageServerConflict = null;
        if (ProvisioningMode.CONTENT_REQUEST == mode || ProvisioningMode.FEATURES_REQUEST == mode) {
            allowMultipleVersions = Boolean.getBoolean("internal.minify.ignore.singleton");
            featureListIsComplete = Boolean.getBoolean("internal.minify.feature.list.complete");
            restrictedRespository = this.featureRepository;
            currentPackageServerConflict = this.packageServerConflict;
        } else if (this.supportedProcessTypes.contains((Object)ProcessType.CLIENT)) {
            restrictedRespository = this.featureRepository;
            Iterator<String> iRootFeatures = rootFeatures.iterator();
            while (iRootFeatures.hasNext()) {
                ProvisioningFeatureDefinition rootDef = this.featureRepository.getFeature(iRootFeatures.next());
                if (rootDef == null || ALL_ALLOWED_ON_CLIENT_FEATURES.contains(rootDef.getSymbolicName())) continue;
                restrictedRepoAccessAttempts.add(rootDef.getSymbolicName());
                iRootFeatures.remove();
            }
        } else {
            RestrictedFeatureRespository temp = new RestrictedFeatureRespository(this.featureRepository, FeatureDefinitionUtils.ALLOWED_ON_CLIENT_ONLY_FEATURES);
            restrictedRepoAccessAttempts = temp.getRestrictedFeatureAttempts();
            restrictedRespository = temp;
        }
        FeatureResolver.Result result = featureListIsComplete ? this.createResultFromCompleteList(restrictedRespository, rootFeatures) : this.callFeatureResolver(restrictedRespository, this.kernelFeaturesHolder.getKernelFeatures(), rootFeatures, allowMultipleVersions, currentPackageServerConflict, newConfiguredPlatforms);
        restrictedAccessAttempts.addAll(restrictedRepoAccessAttempts);
        return result;
    }

    private FeatureResolver.Result callFeatureResolver(FeatureResolver.Repository restrictedRespository, Collection<ProvisioningFeatureDefinition> kernelFeatures, Set<String> rootFeatures, boolean allowMultipleVersions, Set<String> currentPackageServerConflict, Set<String> newConfiguredPlatforms) {
        if (currentPackageServerConflict != null) {
            return featureResolver.resolve(restrictedRespository, kernelFeatures, rootFeatures, Collections.emptySet(), currentPackageServerConflict, EnumSet.allOf(ProcessType.class), newConfiguredPlatforms);
        }
        FeatureResolver.Result result = featureResolver.resolve(restrictedRespository, kernelFeatures, rootFeatures, Collections.emptySet(), false, newConfiguredPlatforms);
        if (allowMultipleVersions && !result.getConflicts().isEmpty()) {
            result = featureResolver.resolve(restrictedRespository, kernelFeatures, rootFeatures, Collections.emptySet(), true, newConfiguredPlatforms);
        }
        return result;
    }

    private FeatureResolver.Result createResultFromCompleteList(FeatureResolver.Repository repository, Set<String> rootFeatures) {
        final HashSet<String> missing = new HashSet<String>();
        final LinkedHashSet<String> resolved = new LinkedHashSet<String>();
        for (String featureName : rootFeatures) {
            ProvisioningFeatureDefinition feature = repository.getFeature(featureName);
            if (feature == null) {
                missing.add(featureName);
                continue;
            }
            resolved.add(feature.getFeatureName());
        }
        return new FeatureResolver.Result(){
            static final long serialVersionUID = 8592276837783548837L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public boolean hasErrors() {
                return !this.getMissing().isEmpty();
            }

            @Override
            public Map<String, FeatureResolver.Chain> getWrongProcessTypes() {
                return Collections.emptyMap();
            }

            @Override
            public Set<String> getResolvedFeatures() {
                return resolved;
            }

            @Override
            public Set<String> getNonPublicRoots() {
                return Collections.emptySet();
            }

            @Override
            public Set<String> getMissing() {
                return missing;
            }

            @Override
            public Map<String, Collection<FeatureResolver.Chain>> getConflicts() {
                return Collections.emptyMap();
            }

            @Override
            public Map<String, String> getVersionlessFeatures() {
                return Collections.emptyMap();
            }

            @Override
            public Set<String> getResolvedPlatforms() {
                return Collections.emptySet();
            }

            @Override
            public Set<String> getMissingPlatforms() {
                return Collections.emptySet();
            }

            @Override
            public Map<String, Set<String>> getDuplicatePlatforms() {
                return Collections.emptyMap();
            }

            @Override
            public Map<String, Set<String>> getNoPlatformVersionless() {
                return Collections.emptyMap();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureManager$4", 4.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        };
    }

    @FFDCIgnore(value={Throwable.class})
    protected FeatureResolver.Result updateFeatures(WsLocationAdmin locService, Provisioner provisioner, Set<String> preInstalledFeatures, FeatureChange featureChange, long sequenceNumber) {
        Set<String> goodFeatures;
        ArrayList<Bundle> installedBundles;
        BundleLifecycleStatus startStatus;
        BundleInstallStatus installStatus;
        FeatureResolver.Result result;
        block22: {
            BundleList newBundleList = null;
            result = null;
            Set<String> newConfiguredFeatures = featureChange.getFeaturesWithLowerCaseName(this.featureRepository);
            Set<String> newConfiguredPlatforms = featureChange.getPlatformsWithLowerCaseName();
            if (newConfiguredFeatures.isEmpty() && this.featureRepository.emptyFeatures()) {
                newBundleList = new BundleList(this);
            }
            installStatus = new BundleInstallStatus();
            startStatus = null;
            installedBundles = new ArrayList<Bundle>();
            boolean continueOnError = this.onError != OnErrorUtil.OnError.FAIL;
            goodFeatures = null;
            boolean featuresHaveChanges = true;
            boolean appForceRestartSet = false;
            boolean sameJavaSpecVersion = this.sameJavaSpecVersion();
            try {
                if (this.areConfiguredFeaturesGood(newConfiguredFeatures, newConfiguredPlatforms) && sameJavaSpecVersion) {
                    featuresHaveChanges = false;
                    goodFeatures = preInstalledFeatures;
                } else {
                    ArrayList<String> restrictedAccessAttempts = new ArrayList<String>();
                    result = this.resolveFeatures(newConfiguredFeatures, restrictedAccessAttempts, featureChange.provisioningMode, newConfiguredPlatforms);
                    boolean reportedConfigurationErrors = this.reportErrors(result, restrictedAccessAttempts, newConfiguredFeatures, installStatus);
                    goodFeatures = result.getResolvedFeatures();
                    if (!(sameJavaSpecVersion && this.featureRepository.featureSetEquals(goodFeatures) || !installStatus.canContinue(continueOnError))) {
                        if (newBundleList == null) {
                            newBundleList = new BundleList(this);
                        }
                        for (String featureName : goodFeatures) {
                            ProvisioningFeatureDefinition fdefinition = this.featureRepository.getFeature(featureName);
                            if (fdefinition == null) continue;
                            newBundleList.addAll(fdefinition, this);
                        }
                        this.bundleCache.addAllNoReplace(newBundleList);
                        this.featureRepository.setResolvedFeatures(goodFeatures, newConfiguredFeatures, reportedConfigurationErrors, newConfiguredPlatforms, platformEnvironmentVariable);
                    }
                }
                if (featureChange.appForceRestart != null) {
                    Set<String> featureSet = this.featureRepository.getResolvedFeatures();
                    if (this.featureChangesRequireRestart(preInstalledFeatures, featureSet)) {
                        featureChange.appForceRestart.setResult(true);
                        appForceRestartSet = true;
                        RuntimeUpdateNotification applicationsStopped = this.runtimeUpdateManager.getNotification("ApplicationsStopped");
                        if (applicationsStopped != null) {
                            applicationsStopped.waitForCompletion();
                        }
                    } else {
                        featureChange.appForceRestart.setResult(false);
                        appForceRestartSet = true;
                    }
                }
                if (installStatus.canContinue(continueOnError)) {
                    Set<String> regionsToRemove = Collections.emptySet();
                    if (featureChange.provisioningMode != ProvisioningMode.CONTENT_REQUEST) {
                        if (featuresHaveChanges) {
                            this.packageInspector.populateSPIInfo(this.bundleContext, this);
                            regionsToRemove = provisioner.createAndUpdateProductRegions();
                        }
                        provisioner.installBundles(this.bundleContext, this.bundleCache, installStatus, 8, 12, this.fwStartLevel.getInitialBundleStartLevel(), locService);
                        if (installStatus.contextIsValid() && installStatus.bundlesToStart()) {
                            installedBundles.addAll(installStatus.getBundlesToStart());
                        }
                    }
                    this.featureRepository.updateServices();
                    if (featuresHaveChanges && featureChange.provisioningMode != ProvisioningMode.CONTENT_REQUEST) {
                        BundleList remove;
                        if (installStatus.contextIsValid() && newBundleList != null && (remove = this.bundleCache.findExtraBundles(newBundleList, this)) != null && !remove.isEmpty()) {
                            provisioner.uninstallBundles(this.bundleContext, remove, installStatus, this.shutdownHook);
                        }
                        provisioner.refreshFeatureBundles(this.packageInspector, this.bundleContext, this.shutdownHook);
                        provisioner.removeStaleProductRegions(regionsToRemove);
                        provisioner.refreshGatewayBundles(this.shutdownHook);
                    }
                }
            }
            catch (Throwable t) {
                installStatus.addOtherException(t);
                if (appForceRestartSet || featureChange.appForceRestart == null) break block22;
                featureChange.appForceRestart.setResult(t);
            }
        }
        boolean status = this.checkInstallStatus(installStatus);
        ResolutionReportHelper resolutionReport = provisioner.resolveBundles(this.bundleContext, installedBundles, this.shutdownHook);
        if (featureChange.featureBundlesResolved != null) {
            HashMap<String, Collection<Bundle>> props = new HashMap<String, Collection<Bundle>>(1);
            props.put("InstalledBundles", installStatus.getBundlesAddedDelta());
            props.put("RemovedBundles", installStatus.getBundlesRemovedDelta());
            featureChange.featureBundlesResolved.setProperties(props);
            featureChange.featureBundlesResolved.setResult(true);
            RuntimeUpdateNotification featureBundlesProcessed = this.runtimeUpdateManager.getNotification("FeatureBundlesProcessed");
            if (featureBundlesProcessed != null) {
                featureBundlesProcessed.waitForCompletion();
            }
        }
        this.analyzeUnresolvedBundles(installedBundles, goodFeatures);
        startStatus = provisioner.preStartBundles(installedBundles, resolutionReport);
        status &= this.checkBundleStatus(startStatus);
        if (featureChange.featureUpdatesCompleted != null) {
            featureChange.featureUpdatesCompleted.setResult(true);
        }
        if (this.eventAdminService != null) {
            HashMap<String, Object> eventProps = new HashMap<String, Object>(2);
            Set<String> featureSet = this.featureRepository.getResolvedFeatures();
            eventProps.put("features", featureSet.toArray(new String[featureSet.size()]));
            eventProps.put("sequenceNumber", sequenceNumber);
            Event e = new Event("com/ibm/ws/kernel/feature/internal/FeatureManager/FEATURE_CHANGE", eventProps);
            this.eventAdminService.postEvent(e);
        }
        return result;
    }

    private static boolean isVersionOf(String versionedFeature, String versionlessFeature) {
        int headLen;
        int fullLen = versionedFeature.length();
        return fullLen > (headLen = versionlessFeature.length()) && versionedFeature.charAt(headLen) == '-' && versionedFeature.regionMatches(true, 0, versionlessFeature, 0, headLen);
    }

    private boolean sameJavaSpecVersion() {
        return Objects.equals(JavaInfo.majorVersion(), this.bundleCache.getJavaSpecVersion());
    }

    private boolean areConfiguredFeaturesGood(Set<String> newConfiguredFeatures, Set<String> newConfiguredPlatforms) {
        if (!this.featureRepository.isDirty() && !this.featureRepository.hasConfigurationError() && this.featureRepository.getConfiguredFeatures().equals(newConfiguredFeatures) && this.featureRepository.getPlatforms().equals(newConfiguredPlatforms) && FeatureManager.equals(this.featureRepository.getPlatformEnvVar(), platformEnvironmentVariable)) {
            for (String resolvedFeature : this.featureRepository.getResolvedFeatures()) {
                if (this.featureRepository.getFeature(resolvedFeature) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void analyzeUnresolvedBundles(List<Bundle> installedBundles, Set<String> features) {
        String m = "analyzeUnresolvedBundles";
        Set<Bundle> unresolvedBundles = this.getUnresolvedBundles(installedBundles);
        if (unresolvedBundles.isEmpty()) {
            return;
        }
        HashMap<String, Set<String>> javaVersiontoFeatureMap = new HashMap<String, Set<String>>();
        for (Bundle bundle : unresolvedBundles) {
            BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
            if (revision == null) continue;
            List eeReqs = revision.getDeclaredRequirements("osgi.ee");
            for (BundleRequirement eeReq : eeReqs) {
                Collection eeCaps = this.frameworkWiring.findProviders((Requirement)eeReq);
                if (!eeCaps.isEmpty()) continue;
                String javaSEVersion = this.getJavaSEValue((Requirement)eeReq);
                Bundle b = eeReq.getResource().getBundle();
                if (javaSEVersion == null) continue;
                Set<String> foundInFeatures = this.findIncludingFeatures(features, b);
                if (javaVersiontoFeatureMap.containsKey(javaSEVersion)) {
                    ((Set)javaVersiontoFeatureMap.get(javaSEVersion)).addAll(foundInFeatures);
                    continue;
                }
                javaVersiontoFeatureMap.put(javaSEVersion, foundInFeatures);
            }
        }
        for (Map.Entry entry : javaVersiontoFeatureMap.entrySet()) {
            for (String feature : (Set)entry.getValue()) {
                Tr.error((TraceComponent)tc, (String)"FEATURE_JAVA_LEVEL_NOT_MET_ERROR", (Object[])new Object[]{feature, entry.getKey()});
                this.featureRepository.removeResolvedFeature(feature);
            }
        }
        if (!javaVersiontoFeatureMap.isEmpty() && this.onError.equals((Object)OnErrorUtil.OnError.FAIL)) {
            IllegalArgumentException t = new IllegalArgumentException("Unresolved feature java dependencies: " + javaVersiontoFeatureMap);
            FFDCFilter.processException((Throwable)t, (String)ME, (String)"analyzeUnresolvedBundles");
            this.shutdownFramework();
        }
    }

    private Set<Bundle> getUnresolvedBundles(List<Bundle> installedBundles) {
        HashSet<Bundle> unresolvedBundles = new HashSet<Bundle>();
        if (installedBundles == null || installedBundles.isEmpty()) {
            return Collections.emptySet();
        }
        for (Bundle b : installedBundles) {
            if (b.getState() != 2) continue;
            unresolvedBundles.add(b);
        }
        return unresolvedBundles;
    }

    private String getJavaSEValue(Requirement req) {
        String javaSEValue = null;
        String filterString = (String)req.getDirectives().get("filter");
        Filter filter = null;
        try {
            filter = FrameworkUtil.createFilter((String)filterString);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"1881", (Object)this, (Object[])new Object[]{req});
            return null;
        }
        HashMap<String, Object> matchAttrs = new HashMap<String, Object>();
        EEValue eeValue = EEValue.getInstance();
        VersionValue versionValue = VersionValue.getInstance();
        matchAttrs.put("osgi.ee", eeValue);
        matchAttrs.put("version", versionValue);
        if (filter.matches(matchAttrs)) {
            List<String> eeValueStr = EEValue.getValues();
            List<String> versionValueStr = VersionValue.getValues();
            if (eeValueStr.isEmpty() || versionValueStr.isEmpty()) {
                return filterString;
            }
            String java = eeValueStr.iterator().next();
            String version = versionValueStr.iterator().next();
            javaSEValue = java + " " + version;
        }
        return javaSEValue;
    }

    public Set<String> findIncludingFeatures(Set<String> features, Bundle b1) {
        HashSet<String> foundInFeatures = new HashSet<String>();
        for (String feature : features) {
            ProvisioningFeatureDefinition fdefinition = this.featureRepository.getFeature(feature);
            for (FeatureResource fr : fdefinition.getConstituents(SubsystemContentType.BUNDLE_TYPE)) {
                try {
                    Bundle rfr = this.bundleCache.getBundle(this.bundleContext, fr);
                    if (!b1.equals(rfr)) continue;
                    foundInFeatures.add(feature);
                }
                catch (MalformedURLException malformedURLException) {
                    FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"1929", (Object)this, (Object[])new Object[]{features, b1});
                }
            }
        }
        return foundInFeatures;
    }

    boolean reportErrors(FeatureResolver.Result result, Collection<String> restrictedAccessAttempts, Collection<String> rootFeatures, BundleInstallStatus installStatus) {
        boolean reportedErrors = false;
        for (String string : result.getNonPublicRoots()) {
            reportedErrors = true;
            if (this.supportedProcessTypes.contains((Object)ProcessType.CLIENT)) {
                Tr.error((TraceComponent)tc, (String)"UPDATE_NOT_PUBLIC_FEATURE_CLIENT_ERROR", (Object[])new Object[]{string});
                continue;
            }
            Tr.error((TraceComponent)tc, (String)"UPDATE_NOT_PUBLIC_FEATURE_ERROR", (Object[])new Object[]{string});
        }
        for (String string : result.getMissing()) {
            reportedErrors = true;
            boolean isRootFeature = rootFeatures.contains(string);
            boolean isExtension = string.indexOf(":") > -1;
            String string2 = this.featureRepository.matchesAlternate(string);
            if (!this.getProductInfoDisplayName().startsWith(PRODUCT_INFO_STRING_OPEN_LIBERTY)) {
                if (isRootFeature && !isExtension) {
                    Tr.error((TraceComponent)tc, (String)"UPDATE_MISSING_CORE_FEATURE_ERROR", (Object[])new Object[]{string, this.locationService.getServerName()});
                } else {
                    Tr.error((TraceComponent)tc, (String)"UPDATE_MISSING_FEATURE_ERROR", (Object[])new Object[]{string});
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"UPDATE_MISSING_FEATURE_ERROR", (Object[])new Object[]{string});
            }
            if (string2 != null && isRootFeature && !isExtension) {
                Tr.error((TraceComponent)tc, (String)"MISSING_FEATURE_HAS_ALT_NAME", (Object[])new Object[]{string, string2});
            }
            installStatus.addMissingFeature(string);
        }
        for (Map.Entry entry : result.getWrongProcessTypes().entrySet()) {
            reportedErrors = true;
            List<String> chain = ((FeatureResolver.Chain)entry.getValue()).getChain();
            if (chain.isEmpty()) {
                if (this.supportedProcessTypes.contains((Object)ProcessType.CLIENT)) {
                    Tr.error((TraceComponent)tc, (String)"UPDATE_WRONG_PROCESS_TYPE_CONFIGURED_CLIENT_ERROR", (Object[])new Object[]{this.getFeatureName((String)entry.getKey()), this.processTypeString + ".xml"});
                } else {
                    Tr.error((TraceComponent)tc, (String)"UPDATE_WRONG_PROCESS_TYPE_CONFIGURED_ERROR", (Object[])new Object[]{this.getFeatureName((String)entry.getKey()), this.processTypeString + ".xml"});
                }
            } else if (this.supportedProcessTypes.contains((Object)ProcessType.CLIENT)) {
                Tr.error((TraceComponent)tc, (String)"UPDATE_WRONG_PROCESS_TYPE_DEPENDENCY_CLIENT_ERROR", (Object[])new Object[]{this.getFeatureName((String)entry.getKey()), this.getFeatureName(chain.get(0)), this.processTypeString + ".xml"});
            } else {
                Tr.error((TraceComponent)tc, (String)"UPDATE_WRONG_PROCESS_TYPE_DEPENDENCY_ERROR", (Object[])new Object[]{this.getFeatureName((String)entry.getKey()), this.getFeatureName(chain.get(0)), this.processTypeString + ".xml"});
            }
            String wrongProcessTypeMsg = "Unable to load feature \"" + (String)entry.getKey() + "\" because it does not support the correct container type.  The feature dependency chain that led to the feature is: " + this.buildChainString(chain, (String)entry.getKey());
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(wrongProcessTypeMsg);
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)ME, (String)"reportErrors", (Object[])new Object[]{entry.getKey(), ((FeatureResolver.Chain)entry.getValue()).toString()});
        }
        for (String string : restrictedAccessAttempts) {
            if (this.supportedProcessTypes.contains((Object)ProcessType.CLIENT)) {
                Tr.error((TraceComponent)tc, (String)"UPDATE_WRONG_PROCESS_TYPE_CONFIGURED_CLIENT_ERROR", (Object[])new Object[]{this.getFeatureName(string), this.processTypeString + ".xml"});
                continue;
            }
            Tr.error((TraceComponent)tc, (String)"UPDATE_WRONG_PROCESS_TYPE_CONFIGURED_ERROR", (Object[])new Object[]{this.getFeatureName(string), this.processTypeString + ".xml"});
        }
        if (!result.getDuplicatePlatforms().isEmpty()) {
            for (Map.Entry entry : result.getDuplicatePlatforms().entrySet()) {
                Tr.error((TraceComponent)tc, (String)"DUPLICATE_PLATFORMS", (Object[])new Object[]{entry.getValue()});
            }
        }
        if (!result.getMissingPlatforms().isEmpty()) {
            reportedErrors = true;
            Iterator<Map.Entry<String, String>> remainingMissingPlatforms = new HashSet<String>();
            if (platformEnvironmentVariable != null) {
                for (String plat : result.getMissingPlatforms()) {
                    if (platformEnvironmentVariable.contains(plat)) {
                        Tr.error((TraceComponent)tc, (String)"UNKNOWN_PLATFORM_VALUE_ENV_VAR", (Object[])new Object[]{plat});
                        continue;
                    }
                    remainingMissingPlatforms.add((Map.Entry<String, String>)((Object)plat));
                }
            } else {
                remainingMissingPlatforms.addAll(result.getMissingPlatforms());
            }
            if (!remainingMissingPlatforms.isEmpty()) {
                Iterator iterator = remainingMissingPlatforms.iterator();
                while (iterator.hasNext()) {
                    String missingPlat = (String)iterator.next();
                    Tr.error((TraceComponent)tc, (String)"UNKNOWN_PLATFORM_ELEMENT", (Object[])new Object[]{missingPlat});
                }
            }
        }
        if (!result.getNoPlatformVersionless().isEmpty()) {
            for (Map.Entry<String, String> entry : result.getNoPlatformVersionless().entrySet()) {
                Tr.error((TraceComponent)tc, (String)"NO_RESOLVED_PLATFORM", (Object[])new Object[]{entry.getValue()});
            }
        }
        block8: for (Map.Entry<String, String> entry : result.getVersionlessFeatures().entrySet()) {
            Object platform;
            Set<String> set;
            String versionlessResolved = entry.getKey();
            String versionedResolved = entry.getValue();
            if (versionedResolved != null || (set = this.featureRepository.getPlatformsForVersionlessFeature(versionlessResolved)) == null || set.isEmpty()) continue;
            FeatureDefinition compatibility = null;
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext() && (compatibility = this.featureRepository.getCompatibilityFeature((String)(platform = iterator.next()))) == null) {
            }
            if (compatibility == null) continue;
            String compatibilityBaseName = this.featureRepository.getFeatureBaseName(compatibility.getFeatureName());
            platform = result.getResolvedPlatforms().iterator();
            while (platform.hasNext()) {
                String resolvedBaseName;
                String resolvedPlat = (String)platform.next();
                ProvisioningFeatureDefinition compatibilityFeature = this.featureRepository.getCompatibilityFeature(resolvedPlat);
                if (compatibilityFeature == null || !compatibilityBaseName.equals(resolvedBaseName = this.featureRepository.getFeatureBaseName(compatibilityFeature.getFeatureName())) || set.contains(resolvedPlat)) continue;
                Tr.error((TraceComponent)tc, (String)"INCOMPATIBLE_VERSIONLESS_FEATURE_WITH_PLATFORM", (Object[])new Object[]{this.getFeatureName(versionlessResolved), resolvedPlat});
                continue block8;
            }
        }
        ArrayList<Map.Entry<String, Collection<FeatureResolver.Chain>>> sortedConflicts = new ArrayList<Map.Entry<String, Collection<FeatureResolver.Chain>>>(result.getConflicts().entrySet());
        sortedConflicts.sort(new ConflictComparator());
        ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>();
        boolean disableAllOnConflict = this.disableAllOnConflict(result);
        for (Map.Entry entry : sortedConflicts) {
            String compatibleFeatureBase = (String)entry.getKey();
            Collection inConflictChains = (Collection)entry.getValue();
            reportedErrors = true;
            ConflictRecord conflictRecord1 = null;
            ConflictRecord conflictRecord2 = null;
            for (FeatureResolver.Chain chain : inConflictChains) {
                if (conflictRecord1 == null) {
                    conflictRecord1 = this.getConflictRecord(chain, inConflictChains, compatibleFeatureBase);
                    continue;
                }
                if (conflictRecord1.conflict.equals(chain.getCandidates().get(0))) continue;
                conflictRecord2 = this.getConflictRecord(chain, inConflictChains, compatibleFeatureBase);
                break;
            }
            if (!this.configuredAlreadyReported(conflictRecord1.configured, conflictRecord2.configured, arrayList)) {
                if (conflictRecord1.compatibleConflict != null) {
                    boolean ignoreVersion = true;
                    if (this.getEeCompatiblePlatform(conflictRecord1.conflict, true).equals(this.getEeCompatiblePlatform(conflictRecord2.conflict, true))) {
                        if (conflictRecord1.configured.equals(conflictRecord1.compatibleConflict) && conflictRecord2.configured.equals(conflictRecord2.compatibleConflict)) {
                            Tr.error((TraceComponent)tc, (String)"UPDATE_CONFLICT_INCOMPATIBLE_EE_FEATURES_SAME_PLATFORM_ERROR", (Object[])new Object[]{this.getPreferredEePlatform(conflictRecord1.compatibleConflict, compatibleFeatureBase), this.getPreferredEePlatform(conflictRecord2.compatibleConflict, compatibleFeatureBase), this.getFeatureName(conflictRecord1.configured), this.getFeatureName(conflictRecord2.configured), this.getEeCompatiblePlatform(conflictRecord1.conflict, true)});
                        } else {
                            Tr.error((TraceComponent)tc, (String)"UPDATE_INDIRECT_CONFLICT_INCOMPATIBLE_FEATURES_SAME_PLATFORM_ERROR", (Object[])new Object[]{this.getPreferredEePlatform(conflictRecord1.compatibleConflict, compatibleFeatureBase), this.getPreferredEePlatform(conflictRecord2.compatibleConflict, compatibleFeatureBase), this.getFeatureName(conflictRecord1.compatibleConflict), this.getFeatureName(conflictRecord2.compatibleConflict), this.getFeatureName(conflictRecord1.configured), this.getFeatureName(conflictRecord2.configured), this.getEeCompatiblePlatform(conflictRecord1.conflict, true)});
                        }
                    } else {
                        Tr.error((TraceComponent)tc, (String)"UPDATE_CONFLICT_INCOMPATIBLE_EE_FEATURES_DIFFERENT_PLATFORM_ERROR", (Object[])new Object[]{this.getPreferredEePlatform(conflictRecord1.compatibleConflict, compatibleFeatureBase), this.getPreferredEePlatform(conflictRecord2.compatibleConflict, compatibleFeatureBase), this.getFeatureName(conflictRecord1.compatibleConflict), this.getFeatureName(conflictRecord2.compatibleConflict), this.getFeatureName(conflictRecord1.configured), this.getFeatureName(conflictRecord2.configured), this.getEeCompatiblePlatform(conflictRecord1.conflict, true), this.getEeCompatiblePlatform(conflictRecord2.conflict, true)});
                        result.getResolvedFeatures().remove(this.getFeatureName(conflictRecord1.compatibleConflict));
                        result.getResolvedFeatures().remove(this.getFeatureName(conflictRecord2.compatibleConflict));
                    }
                } else {
                    Tr.error((TraceComponent)tc, (String)"UPDATE_CONFLICT_FEATURE_ERROR", (Object[])new Object[]{this.getFeatureName(conflictRecord1.conflict), this.getFeatureName(conflictRecord2.conflict), this.getFeatureName(conflictRecord1.configured), this.getFeatureName(conflictRecord2.configured)});
                }
                arrayList.add(new AbstractMap.SimpleImmutableEntry<String, String>(conflictRecord1.configured, conflictRecord2.configured));
            }
            String conflictMsg = "Unable to load conflicting versions of features \"" + conflictRecord1.conflict + "\" and \"" + conflictRecord2.conflict + "\".  The feature dependency chains that led to the conflict are: " + conflictRecord1.chain + " and " + conflictRecord2.chain;
            IllegalArgumentException ffdcError = new IllegalArgumentException(conflictMsg);
            FFDCFilter.processException((Throwable)ffdcError, (String)ME, (String)"reportErrors", (Object[])new Object[]{entry.getKey(), inConflictChains.toString()});
            for (FeatureResolver.Chain chain : inConflictChains) {
                installStatus.addConflictFeature(chain.getFeatureRequirement());
            }
        }
        if (disableAllOnConflict) {
            Set<String> resolved = result.getResolvedFeatures();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Conflicts found in feature set, no features will be enabled:" + String.valueOf(sortedConflicts)), (Object[])new Object[0]);
            }
            resolved.clear();
            Tr.warning((TraceComponent)tc, (String)"UPDATE_DISABLED_FEATURES_ON_CONFLICT", (Object[])new Object[0]);
        }
        return reportedErrors;
    }

    private ConflictRecord getConflictRecord(FeatureResolver.Chain chain, Collection<FeatureResolver.Chain> inConflict, String compatibleFeatureBase) {
        List<String> candidates = chain.getCandidates();
        ConflictRecord result = new ConflictRecord();
        result.conflict = candidates.get(0);
        boolean isEeCompatibleConflict = this.isEeCompatible(result.conflict);
        if (chain.getChain().isEmpty()) {
            result.configured = result.conflict;
            result.chain = result.conflict;
            if (isEeCompatibleConflict) {
                result.compatibleConflict = result.conflict;
            }
        } else {
            result.configured = chain.getChain().get(0);
            if (isEeCompatibleConflict) {
                block0: for (String feature : chain.getChain()) {
                    ProvisioningFeatureDefinition featureDef = this.featureRepository.getFeature(feature);
                    for (FeatureResource fr : featureDef.getConstituents(SubsystemContentType.FEATURE_TYPE)) {
                        if (!this.isCompatibleInConflictWithChains(fr, chain, inConflict, compatibleFeatureBase)) continue;
                        result.compatibleConflict = feature;
                        break block0;
                    }
                }
                if (result.compatibleConflict == null) {
                    result.compatibleConflict = chain.getChain().get(chain.getChain().size() - 1);
                }
            }
            result.chain = this.buildChainString(chain.getChain(), result.conflict);
        }
        return result;
    }

    private boolean isCompatibleInConflictWithChains(FeatureResource fr, FeatureResolver.Chain chain, Collection<FeatureResolver.Chain> inConflict, String compatibleFeatureBase) {
        if (!fr.getSymbolicName().startsWith(compatibleFeatureBase)) {
            return false;
        }
        List<String> tolerates = fr.getTolerates();
        for (FeatureResolver.Chain chainInConflict : inConflict) {
            if (chainInConflict == chain) continue;
            List<String> conflictCandidates = chainInConflict.getCandidates();
            if (conflictCandidates.contains(fr.getSymbolicName())) {
                return false;
            }
            if (tolerates == null) continue;
            String[] nameAndVersion = FeatureResolverImpl.parseNameAndVersion(fr.getSymbolicName());
            for (String tolerate : tolerates) {
                if (!conflictCandidates.contains(nameAndVersion[0] + '-' + tolerate)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean disableAllOnConflict(FeatureResolver.Result result) {
        Map<String, Collection<FeatureResolver.Chain>> conflicts = result.getConflicts();
        if (conflicts.isEmpty()) {
            return false;
        }
        for (String string : result.getResolvedFeatures()) {
            if (!this.shouldDisableOnConflict(string)) continue;
            return true;
        }
        for (Map.Entry entry : conflicts.entrySet()) {
            for (FeatureResolver.Chain chain : (Collection)entry.getValue()) {
                if (chain.getCandidates().stream().filter(f -> !this.shouldDisableOnConflict((String)f)).findFirst().isPresent()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shouldDisableOnConflict(String featureName) {
        return this.featureRepository.disableAllFeaturesOnConflict(featureName);
    }

    private String getFeatureName(String symbolicName) {
        ProvisioningFeatureDefinition fd = this.featureRepository.getFeature(symbolicName);
        if (fd == null) {
            return symbolicName;
        }
        return fd.getFeatureName();
    }

    boolean configuredAlreadyReported(String c1, String c2, List<Map.Entry<String, String>> reported) {
        for (Map.Entry<String, String> featurePair : reported) {
            if (!c1.equals(featurePair.getKey()) || !c2.equals(featurePair.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean isEeCompatible(String symbolicName) {
        return symbolicName != null && symbolicName.lastIndexOf(EE_COMPATIBLE_NAME) >= 0;
    }

    private static int getEeCompatibleVersion(String symbolicName) {
        String version = symbolicName.substring(symbolicName.lastIndexOf("-") + 1);
        int dotIndex = version.indexOf(46);
        if (dotIndex != -1) {
            version = version.substring(0, dotIndex);
        }
        return Integer.parseInt(version);
    }

    private String getEeCompatiblePlatform(String symbolicName, boolean ignoreVersion) {
        String subsystemName;
        int intVersion = FeatureManager.getEeCompatibleVersion(symbolicName);
        switch (intVersion) {
            case 9: 
            case 10: 
            case 11: {
                return "Jakarta EE" + (ignoreVersion ? "" : " " + intVersion);
            }
            case 6: 
            case 7: 
            case 8: {
                return "Java EE" + (ignoreVersion ? "" : " " + intVersion);
            }
        }
        ProvisioningFeatureDefinition fd = this.getFeatureDefinition(symbolicName);
        if (fd != null && (subsystemName = fd.getHeader("Subsystem-Name")) != null) {
            return subsystemName + (ignoreVersion ? "" : " " + intVersion);
        }
        return "Unknown";
    }

    private String getPreferredEePlatform(String symbolicName, String compatibleFeatureBase) {
        if (symbolicName.startsWith(compatibleFeatureBase)) {
            return this.getEeCompatiblePlatform(symbolicName, false);
        }
        ProvisioningFeatureDefinition fdefinition = this.featureRepository.getFeature(symbolicName);
        for (FeatureResource fr : fdefinition.getConstituents(SubsystemContentType.FEATURE_TYPE)) {
            if (!fr.getSymbolicName().startsWith(compatibleFeatureBase)) continue;
            return this.getEeCompatiblePlatform(fr.getSymbolicName(), false);
        }
        return "";
    }

    private String buildChainString(List<String> chain, String theConflictFeature) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iChain = chain.iterator();
        while (iChain.hasNext()) {
            String chainFeature = iChain.next();
            if (!chainFeature.equals(theConflictFeature)) {
                builder.append(chainFeature);
            }
            if (!iChain.hasNext()) continue;
            builder.append(" -> ");
        }
        if (builder.length() != 0) {
            builder.append(" -> ");
        }
        builder.append(theConflictFeature);
        return builder.toString();
    }

    private boolean featureChangesRequireRestart(Set<String> oldFeatureSet, Set<String> newFeatureSet) {
        if (oldFeatureSet == null) {
            return false;
        }
        ArrayList<String> existingFeatures = new ArrayList<String>(oldFeatureSet);
        List<String> currentFeatures = Arrays.asList(newFeatureSet.toArray(new String[0]));
        ArrayList<String> newFeatures = new ArrayList<String>(currentFeatures);
        newFeatures.removeAll(existingFeatures);
        ArrayList<String> deletedFeatures = existingFeatures;
        deletedFeatures.removeAll(currentFeatures);
        boolean restartApps = this.shouldRestart(AppForceRestart.INSTALL, newFeatures) ? true : this.shouldRestart(AppForceRestart.UNINSTALL, deletedFeatures);
        return restartApps;
    }

    private boolean shouldRestart(AppForceRestart expectedValue, Collection<String> features) {
        for (String feature : features) {
            AppForceRestart restart;
            ProvisioningFeatureDefinition fd = this.featureRepository.getFeature(feature);
            if (fd == null || !(restart = fd.getAppForceRestart()).matches(expectedValue)) continue;
            return true;
        }
        return false;
    }

    public BundleRepositoryRegistry.BundleRepositoryHolder getBundleRepositoryHolder(String bundleRepositoryType) {
        return BundleRepositoryRegistry.getRepositoryHolder((String)bundleRepositoryType);
    }

    protected boolean checkInstallStatus(BundleInstallStatus installStatus) throws IllegalStateException {
        String m = "checkInstallStatus";
        boolean shutdownFramework = false;
        boolean noExceptions = true;
        if (installStatus == null) {
            return true;
        }
        boolean continueOnError = true;
        if (this.onError.equals((Object)OnErrorUtil.OnError.FAIL)) {
            continueOnError = false;
        }
        if (installStatus.bundlesMissing()) {
            if (!continueOnError) {
                shutdownFramework = true;
            }
            noExceptions = false;
            IllegalArgumentException t = new IllegalArgumentException("Missing bundles: " + installStatus.getMissingBundles());
            FFDCFilter.processException((Throwable)t, (String)ME, (String)"checkInstallStatus", (Object)this, (Object[])new Object[]{installStatus, this.bundleCache});
        }
        if (installStatus.featuresMissing()) {
            if (!continueOnError) {
                shutdownFramework = true;
            }
            noExceptions = false;
        }
        if (installStatus.featuresConflict()) {
            if (!continueOnError) {
                shutdownFramework = true;
            }
            noExceptions = false;
        }
        if (installStatus.otherExceptions()) {
            if (!continueOnError) {
                shutdownFramework = true;
            }
            noExceptions = false;
            List<Throwable> otherExceptions = installStatus.getOtherExceptions();
            for (Throwable throwable : otherExceptions) {
                Tr.error((TraceComponent)tc, (String)"UPDATE_OTHER_EXCEPTION_ERROR", (Object[])new Object[]{throwable});
                FFDCFilter.processException((Throwable)throwable, (String)ME, (String)"checkInstallStatus", (Object)this, (Object[])new Object[]{installStatus, this.featureRepository, this.bundleCache});
            }
        }
        if (!installStatus.contextIsValid()) {
            installStatus.rethrowInvalidContextException();
        }
        if (installStatus.installExceptions()) {
            if (!continueOnError) {
                shutdownFramework = true;
            }
            noExceptions = false;
            Map<String, Throwable> installExceptions = installStatus.getInstallExceptions();
            for (Map.Entry entry : installExceptions.entrySet()) {
                Tr.error((TraceComponent)tc, (String)"UPDATE_INSTALL_EXCEPTIONS_ERROR", (Object[])new Object[]{entry.getKey(), entry.getValue()});
                FFDCFilter.processException((Throwable)((Throwable)entry.getValue()), (String)ME, (String)"checkInstallStatus", (Object)this, (Object[])new Object[]{entry.getKey()});
            }
        }
        if (shutdownFramework) {
            this.shutdownFramework();
        }
        return noExceptions;
    }

    protected String getProductInfoDisplayName() {
        String result = null;
        try {
            Map products = ProductInfo.getAllProductInfo();
            StringBuilder builder = new StringBuilder();
            for (ProductInfo productInfo : products.values()) {
                if (productInfo.getReplacedBy() != null) continue;
                if (builder.length() != 0) {
                    builder.append(", ");
                }
                builder.append(productInfo.getDisplayName());
            }
            result = builder.toString();
        }
        catch (ProductInfoParseException productInfoParseException) {
            FFDCFilter.processException((Throwable)productInfoParseException, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"2574", (Object)this, (Object[])new Object[0]);
        }
        catch (DuplicateProductInfoException duplicateProductInfoException) {
            FFDCFilter.processException((Throwable)duplicateProductInfoException, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"2576", (Object)this, (Object[])new Object[0]);
        }
        catch (ProductInfoReplaceException productInfoReplaceException) {
            FFDCFilter.processException((Throwable)productInfoReplaceException, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"2578", (Object)this, (Object[])new Object[0]);
        }
        return result;
    }

    protected boolean checkBundleStatus(BundleLifecycleStatus bundleStatus) {
        boolean shutdownFramework = false;
        boolean noExceptions = true;
        boolean continueOnError = true;
        if (this.onError.equals((Object)OnErrorUtil.OnError.FAIL)) {
            continueOnError = false;
        }
        if (bundleStatus.startExceptions()) {
            if (!continueOnError) {
                shutdownFramework = true;
            }
            noExceptions = false;
            Map<Bundle, Throwable> bundleExceptions = bundleStatus.getStartExceptions();
            for (Map.Entry<Bundle, Throwable> entry : bundleExceptions.entrySet()) {
                if (entry.getValue() instanceof BundleException) {
                    StringBuilder exceptionMessages = new StringBuilder();
                    for (Throwable e = entry.getValue(); e != null; e = e.getCause()) {
                        exceptionMessages.append(e.getMessage() + "\n");
                    }
                    Tr.error((TraceComponent)tc, (String)"BUNDLE_EXCEPTION_ERROR", (Object[])new Object[]{exceptionMessages.toString()});
                    continue;
                }
                Tr.error((TraceComponent)tc, (String)"UPDATE_LIFECYCLE_EXCEPTIONS_ERROR", (Object[])new Object[]{entry.getKey(), entry.getValue()});
                FFDCFilter.processException((Throwable)entry.getValue(), (String)ME, (String)"checkBundleStatus", (Object)this, (Object[])new Object[]{entry.getKey()});
            }
        }
        if (!bundleStatus.contextIsValid()) {
            throw new IllegalStateException("Framework/VM shutting down");
        }
        if (shutdownFramework) {
            this.shutdownFramework();
        }
        return noExceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IllegalStateException.class})
    public BundleLifecycleStatus setStartLevel(int level) {
        StartLevelFrameworkListener slfw = new StartLevelFrameworkListener(this.shutdownHook);
        if (ServerContentHelper.isServerContentRequest(this.bundleContext)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Liberty server being held in paused state for minify operation", (Object[])new Object[0]);
            }
        } else {
            try {
                FeatureManager featureManager = this;
                synchronized (featureManager) {
                    this.fwStartLevel.setStartLevel(level, new FrameworkListener[]{slfw});
                    slfw.waitForLevel();
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return slfw.getStatus();
    }

    public int getStartLevel() {
        return this.fwStartLevel.getStartLevel();
    }

    private final void shutdownFramework() {
        try {
            Bundle bundle = this.bundleContext.getBundle("System Bundle");
            if (bundle != null) {
                final CountDownLatch stopping = new CountDownLatch(1);
                SynchronousBundleListener l = new SynchronousBundleListener(){
                    static final long serialVersionUID = 6186892912263765191L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public void bundleChanged(BundleEvent e) {
                        if (256 == e.getType() && e.getBundle().getBundleId() == 0L) {
                            stopping.countDown();
                        }
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureManager$5", 5.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
                    }
                };
                this.bundleContext.addBundleListener((BundleListener)l);
                bundle.stop();
                stopping.await(1000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.feature.internal.FeatureManager", (String)"2704", (Object)this, (Object[])new Object[0]);
        }
        throw new IllegalStateException("Shutting down framework due to startup problems");
    }

    @Override
    public Set<String> getInstalledFeatures() {
        return this.featureRepository.getResolvedFeatures();
    }

    public Collection<ProvisioningFeatureDefinition> getInstalledFeatureDefinitions() {
        ArrayList<ProvisioningFeatureDefinition> result = new ArrayList<ProvisioningFeatureDefinition>();
        for (String s : this.getInstalledFeatures()) {
            result.add(this.featureRepository.getFeature(s));
        }
        return result;
    }

    @Override
    public ProvisioningFeatureDefinition getFeatureDefinition(String featureName) {
        return this.featureRepository.getFeature(featureName);
    }

    @Override
    public String getKernelApiServices() {
        return KernelFeatureDefinitionImpl.getKernelApiServices();
    }

    @Override
    public void refreshFeatures() {
        this.queueFeatureChange(ProvisioningMode.REFRESH, null, null);
    }

    @Override
    public void refreshFeatures(Filter filter) {
        this.refreshFeatures();
    }

    boolean withinJavaRange(FeatureResource fr) {
        VersionRange range = fr.getJavaRange();
        return range == null ? true : range.includes(JAVA_MAJOR_VERSION);
    }

    @Trivial
    private static boolean equals(String s0, String s1) {
        if (s0 == null) {
            return s1 == null;
        }
        if (s1 == null) {
            return false;
        }
        return s0.equals(s1);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        ArrayList<String> temp = new ArrayList<String>();
        temp.addAll(FeatureDefinitionUtils.ALLOWED_ON_CLIENT_ONLY_FEATURES);
        temp.addAll(ALLOWED_ON_ALL_FEATURES);
        ALL_ALLOWED_ON_CLIENT_FEATURES = Collections.unmodifiableCollection(temp);
        featureUpdateNumber = new AtomicLong(0L);
    }

    static enum ProvisioningMode {
        CONTENT_REQUEST,
        FEATURES_REQUEST,
        INITIAL_PROVISIONING,
        UPDATE,
        REFRESH;

    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class KernelFeaturesHolder {
        private volatile Collection<ProvisioningFeatureDefinition> kernelFeatures;
        private final FeatureManager featureManager;
        private final ProvisioningMode initialMode;
        static final long serialVersionUID = -262786423820304061L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        KernelFeaturesHolder(FeatureManager featureManager, ProvisioningMode initialMode) {
            this.featureManager = featureManager;
            this.initialMode = initialMode;
        }

        Collection<ProvisioningFeatureDefinition> getKernelFeatures() {
            if (this.kernelFeatures == null) {
                this.kernelFeatures = this.initialMode == ProvisioningMode.INITIAL_PROVISIONING ? KernelFeatureDefinitionImpl.getKernelFeatures(this.featureManager.bundleContext, this.featureManager.locationService) : KernelFeatureDefinitionImpl.getAllKernelFeatures(this.featureManager.bundleContext, this.featureManager.locationService);
            }
            return this.kernelFeatures;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureManager$KernelFeaturesHolder", KernelFeaturesHolder.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class FeatureChange {
        final RuntimeUpdateManager runtimeUpdateManager;
        final ProvisioningMode provisioningMode;
        String[] features;
        String[] platforms;
        RuntimeUpdateNotification appForceRestart = null;
        RuntimeUpdateNotification featureBundlesResolved = null;
        RuntimeUpdateNotification featureUpdatesCompleted = null;
        static final long serialVersionUID = -8006685257927776228L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        FeatureChange(RuntimeUpdateManager runtimeUpdateManager, ProvisioningMode provisioningMode, String[] features) {
            this(runtimeUpdateManager, provisioningMode, features, null);
        }

        FeatureChange(RuntimeUpdateManager runtimeUpdateManager, ProvisioningMode provisioningMode, String[] features, String[] platforms) {
            this.runtimeUpdateManager = runtimeUpdateManager;
            this.provisioningMode = provisioningMode;
            this.features = features;
            this.platforms = platforms;
            if (provisioningMode == ProvisioningMode.UPDATE) {
                this.featureUpdatesCompleted = runtimeUpdateManager.createNotification("FeatureUpdatesCompleted");
            }
        }

        void createNotifications() {
            this.appForceRestart = this.runtimeUpdateManager.createNotification("AppForceRestart", true);
            this.featureBundlesResolved = this.runtimeUpdateManager.createNotification("FeatureBundlesResolved");
        }

        Set<String> getFeaturesWithLowerCaseName(FeatureRepository featureRepo) {
            HashSet<String> lcnFeatures = new HashSet<String>();
            for (String feature : this.features) {
                ProvisioningFeatureDefinition f = featureRepo.getFeature(feature);
                if (f == null || f.getVisibility() == Visibility.PUBLIC) {
                    lcnFeatures.add(FeatureRepository.lowerFeature(feature));
                    continue;
                }
                lcnFeatures.add(feature);
            }
            return lcnFeatures;
        }

        Set<String> getPlatformsWithLowerCaseName() {
            HashSet<String> lcnPlatforms = new HashSet<String>();
            if (this.platforms == null) {
                return lcnPlatforms;
            }
            for (String platform : this.platforms) {
                lcnPlatforms.add(platform.toLowerCase());
            }
            return lcnPlatforms;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureManager$FeatureChange", FeatureChange.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class ConflictComparator
    implements Comparator<Map.Entry<String, Collection<FeatureResolver.Chain>>> {
        static final long serialVersionUID = -2685124042036732706L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ConflictComparator() {
        }

        @Override
        public int compare(Map.Entry<String, Collection<FeatureResolver.Chain>> e1, Map.Entry<String, Collection<FeatureResolver.Chain>> e2) {
            int e2Rank;
            Iterator<FeatureResolver.Chain> e1ChainItr = e1.getValue().iterator();
            Iterator<FeatureResolver.Chain> e2ChainItr = e2.getValue().iterator();
            FeatureResolver.Chain e1Chain1 = e1ChainItr.next();
            FeatureResolver.Chain e2Chain1 = e2ChainItr.next();
            String e1Conflict = e1Chain1.getCandidates().get(0);
            String e2Conflict = e2Chain1.getCandidates().get(0);
            int e1Rank = this.rank(e1Conflict);
            if (e1Rank != (e2Rank = this.rank(e2Conflict))) {
                return e1Rank - e2Rank;
            }
            FeatureResolver.Chain e1Chain2 = e1ChainItr.next();
            FeatureResolver.Chain e2Chain2 = e2ChainItr.next();
            int e1MinChainSize = Math.min(e1Chain1.getChain().size(), e1Chain2.getChain().size());
            int e2MinChainSize = Math.min(e2Chain2.getChain().size(), e2Chain2.getChain().size());
            return e1MinChainSize - e2MinChainSize;
        }

        private int rank(String symbolicName) {
            if (FeatureManager.this.isEeCompatible(symbolicName)) {
                return 1;
            }
            switch (FeatureManager.this.featureRepository.getFeature(symbolicName).getVisibility()) {
                case PUBLIC: {
                    return 2;
                }
                case PROTECTED: {
                    return 3;
                }
                case PRIVATE: {
                    return 4;
                }
            }
            return 5;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureManager$ConflictComparator", ConflictComparator.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static final class ConflictRecord {
        String conflict;
        String configured;
        String chain;
        String compatibleConflict;
        static final long serialVersionUID = 2783420991503128516L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ConflictRecord() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureManager$ConflictRecord", ConflictRecord.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }
}

