/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.internal.FeatureManager;
import com.ibm.ws.kernel.feature.internal.Provisioner;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils;
import com.ibm.ws.kernel.feature.provisioning.ActivationType;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.kernel.provisioning.VersionUtility;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.VersionRange;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BundleList {
    private static final String CACHE_WRITE_TIME = "Cache-WriteTime";
    private static final TraceComponent tc = Tr.register(BundleList.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
    private final WsResource cacheFile;
    private final AtomicBoolean stale = new AtomicBoolean(false);
    private final List<RuntimeFeatureResource> resources = new ArrayList<RuntimeFeatureResource>();
    private long writeTime;
    private Integer javaSpecVersion;
    private final FeatureManager featureManager;
    static final long serialVersionUID = -3878131719277879131L;

    public BundleList(WsResource bundleCacheFile, FeatureManager featureManager) {
        this.cacheFile = bundleCacheFile;
        this.featureManager = featureManager;
    }

    public BundleList(FeatureManager featureManager) {
        this.cacheFile = null;
        this.featureManager = featureManager;
    }

    /*
     * WARNING - void declaration
     */
    public void init() {
        this.resources.clear();
        try {
            this.load(this.cacheFile, this.featureManager);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.BundleList", (String)"470", (Object)this, (Object[])new Object[0]);
            Tr.warning((TraceComponent)tc, (String)"UPDATE_BUNDLE_CACHE_WARNING", (Object[])new Object[]{this.cacheFile.toExternalURI(), e.getMessage()});
        }
    }

    public void dispose() {
        if (this.stale.get()) {
            this.store();
        }
        this.resources.clear();
    }

    public void addAllNoReplace(BundleList newBundleList) {
        for (RuntimeFeatureResource r : newBundleList.resources) {
            if (this.resources.contains(r)) continue;
            this.resources.add(r);
        }
        this.stale.set(true);
    }

    public BundleList findExtraBundles(BundleList newBundleList, FeatureManager featureManager) {
        ArrayList<RuntimeFeatureResource> bundles = new ArrayList<RuntimeFeatureResource>(this.resources);
        bundles.removeAll(newBundleList.resources);
        this.resources.removeAll(bundles);
        BundleList result = new BundleList(featureManager);
        result.resources.addAll(bundles);
        this.stale.set(true);
        return result;
    }

    public boolean isEmpty() {
        return this.resources.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(WsResource res, FeatureManager featureManager) throws IOException {
        if (res == null || !res.exists()) {
            return;
        }
        InputStream in = res.get();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(CACHE_WRITE_TIME)) {
                    this.readWriteTimeAndJavaSpecVersion(res, line);
                    continue;
                }
                int index = line.indexOf(61);
                if (index == -1) continue;
                this.resources.add(new RuntimeFeatureResource(line.substring(0, index), line.substring(index + 1)));
            }
        }
        finally {
            FeatureDefinitionUtils.tryToClose(reader);
            FeatureDefinitionUtils.tryToClose(in);
        }
    }

    @FFDCIgnore(value={NumberFormatException.class})
    private void readWriteTimeAndJavaSpecVersion(WsResource res, String line) {
        int javaSpecVersionIndex;
        int timeIndex = line.indexOf(61);
        int n = javaSpecVersionIndex = timeIndex >= 0 ? line.indexOf(59, timeIndex) : -1;
        if (timeIndex != -1) {
            try {
                String sTime = javaSpecVersionIndex > timeIndex ? line.substring(timeIndex + 1, javaSpecVersionIndex) : line.substring(timeIndex + 1);
                this.writeTime = Long.parseLong(sTime);
                if (javaSpecVersionIndex != -1) {
                    this.javaSpecVersion = Integer.valueOf(line.substring(javaSpecVersionIndex + 1));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.writeTime <= 0L) {
            this.writeTime = res.getLastModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized void store() {
        if (this.cacheFile != null) {
            OutputStream out = null;
            try {
                out = this.cacheFile.putStream();
                PrintWriter writer = new PrintWriter(out);
                writer.write(CACHE_WRITE_TIME);
                writer.write(61);
                this.writeTime = System.currentTimeMillis();
                writer.write(String.valueOf(this.writeTime));
                writer.write(59);
                writer.write(Integer.toString(JavaInfo.majorVersion()));
                writer.write("\r\n");
                for (RuntimeFeatureResource entry : this.resources) {
                    if (entry.getURLString() == null) continue;
                    String bundleRepositoryType = entry.getBundleRepositoryType();
                    if (bundleRepositoryType.length() > 0) {
                        writer.write(bundleRepositoryType);
                        writer.write(124);
                    }
                    writer.write(entry.getMatchString());
                    writer.write(61);
                    writer.write(entry.getURLString());
                    writer.write(59);
                    writer.write(Integer.toString(entry.getStartLevel()));
                    writer.write(64);
                    writer.write(entry.getActivationType().toString());
                    writer.write("\r\n");
                }
                writer.flush();
                writer.close();
                out.close();
                this.stale.set(false);
            }
            catch (IOException writer) {
                void e;
                FFDCFilter.processException((Throwable)writer, (String)"com.ibm.ws.kernel.feature.internal.BundleList", (String)"593", (Object)this, (Object[])new Object[0]);
                Tr.warning((TraceComponent)tc, (String)"UPDATE_BUNDLE_CACHE_WARNING", (Object[])new Object[]{this.cacheFile.toExternalURI(), e.getMessage()});
            }
            finally {
                FeatureDefinitionUtils.tryToClose(out);
            }
        }
    }

    public void addAll(ProvisioningFeatureDefinition fdefinition, FeatureManager featureManager) {
        for (FeatureResource fr : fdefinition.getConstituents(SubsystemContentType.BUNDLE_TYPE)) {
            RuntimeFeatureResource rfr = (RuntimeFeatureResource)(fr instanceof RuntimeFeatureResource ? fr : new RuntimeFeatureResource(fr));
            if (!featureManager.withinJavaRange(rfr)) continue;
            this.resources.add(rfr);
        }
        this.stale.set(true);
    }

    public void foreach(FeatureResourceHandler featureResourceHandler) {
        FeatureResource fr;
        Iterator<RuntimeFeatureResource> iterator = this.resources.iterator();
        while (iterator.hasNext() && featureResourceHandler.handle(fr = (FeatureResource)iterator.next())) {
        }
    }

    public void createAssociation(FeatureResource fr, Bundle bundle, WsResource resource, int level) {
        if (fr instanceof RuntimeFeatureResource) {
            RuntimeFeatureResource rfr = (RuntimeFeatureResource)fr;
            rfr.setBundle(bundle);
            rfr.setResource(resource);
            rfr.setStartLevel(level);
        }
    }

    public Bundle getBundle(BundleContext ctx, FeatureResource fr) throws MalformedURLException {
        Bundle b;
        block2: {
            block1: {
                long id;
                b = null;
                if (!(fr instanceof RuntimeFeatureResource)) break block1;
                RuntimeFeatureResource rfr = (RuntimeFeatureResource)fr;
                b = rfr.getBundle();
                if (b != null || (b = ctx.getBundle(id = rfr.getBundleId())) != null) break block2;
                String location = rfr.getResolvedLocation(this.featureManager);
                b = location == null ? null : ctx.getBundle(location);
                break block2;
            }
            for (RuntimeFeatureResource res : this.resources) {
                if (!res.getSymbolicName().equals(fr.getSymbolicName())) continue;
                Bundle checkBundle = res.getBundle();
                if (!fr.getVersionRange().includes(checkBundle.getVersion())) continue;
                b = checkBundle;
                break;
            }
        }
        return b;
    }

    public Integer getJavaSpecVersion() {
        return this.javaSpecVersion;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static final class RuntimeFeatureResource
    implements FeatureResource {
        private final FeatureResource fr;
        private int startLevel = -1;
        private long bundleId;
        private WsResource resource;
        private Bundle bundle;
        static final long serialVersionUID = -5223852679247010161L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public RuntimeFeatureResource(FeatureResource resource) {
            this.fr = resource;
        }

        public RuntimeFeatureResource(String key, String value) {
            this.fr = new CachedFeatureResource(key, value);
        }

        @Override
        @Trivial
        public String getSymbolicName() {
            return this.fr.getSymbolicName();
        }

        @Override
        @Trivial
        public VersionRange getVersionRange() {
            return this.fr.getVersionRange();
        }

        @Override
        @Trivial
        public Map<String, String> getAttributes() {
            return this.fr.getAttributes();
        }

        @Override
        @Trivial
        public Map<String, String> getDirectives() {
            return this.fr.getDirectives();
        }

        @Override
        @Trivial
        public String getLocation() {
            return this.fr.getLocation();
        }

        @Override
        @Trivial
        public List<String> getOsList() {
            return this.fr.getOsList();
        }

        @Override
        @Trivial
        public SubsystemContentType getType() {
            return this.fr.getType();
        }

        @Override
        @Trivial
        public String getRawType() {
            return this.fr.getRawType();
        }

        @Override
        @Trivial
        public int getStartLevel() {
            return this.startLevel == -1 ? this.fr.getStartLevel() : this.startLevel;
        }

        @Trivial
        public String toString() {
            String location = this.getLocation();
            return this.fr.toString() + (location != null ? '@' + location : "");
        }

        public void setBundle(Bundle bundle) {
            this.bundle = bundle;
            this.bundleId = bundle.getBundleId();
        }

        public void setResource(WsResource resource) {
            this.resource = resource;
        }

        public void setStartLevel(int level) {
            this.startLevel = level;
        }

        @Trivial
        public Bundle getBundle() {
            return this.bundle;
        }

        @Trivial
        public long getBundleId() {
            return this.bundleId;
        }

        public String getResolvedLocation(FeatureManager featureManager) throws MalformedURLException {
            if (this.resource != null) {
                BundleRepositoryRegistry.BundleRepositoryHolder bundleRepositoryHolder;
                String productName = "";
                String bundleRepositoryType = this.fr.getBundleRepositoryType();
                if (bundleRepositoryType != null && (bundleRepositoryHolder = featureManager.getBundleRepositoryHolder(bundleRepositoryType)) != null) {
                    productName = bundleRepositoryHolder.getFeatureType();
                }
                String urlString = "reference:" + this.resource.toExternalURI().toURL().toExternalForm();
                return Provisioner.getBundleLocation(urlString, productName);
            }
            return null;
        }

        public String getURLString() throws MalformedURLException {
            if (this.resource != null) {
                return this.resource.toExternalURI().toURL().toExternalForm();
            }
            return null;
        }

        public int hashCode() {
            String repoType;
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bundle == null ? 0 : this.bundle.hashCode());
            result = 31 * result + (this.fr == null ? 0 : this.fr.hashCode());
            String string = repoType = this.fr == null ? null : this.fr.getBundleRepositoryType();
            if (repoType != null) {
                result = 31 * result + repoType.hashCode();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof RuntimeFeatureResource) {
                RuntimeFeatureResource other = (RuntimeFeatureResource)obj;
                if (this.bundle == other.bundle && this.bundle != null) {
                    return true;
                }
                if (!Objects.equals(this.getBundleRepositoryType(), other.getBundleRepositoryType())) {
                    return false;
                }
                if (this.bundle != other.bundle && (this.bundle == null || other.bundle == null)) {
                    RuntimeFeatureResource rfr;
                    Bundle b = this.bundle == null ? other.bundle : this.bundle;
                    RuntimeFeatureResource runtimeFeatureResource = rfr = this.bundle == null ? this : other;
                    if (b.getSymbolicName().equals(rfr.getSymbolicName()) && rfr.getVersionRange().includes(b.getVersion())) {
                        return true;
                    }
                }
                return this.fr.getMatchString().equals(other.fr.getMatchString());
            }
            return false;
        }

        @Override
        @Trivial
        public String getMatchString() {
            return this.fr.getMatchString();
        }

        @Override
        @Trivial
        public String getBundleRepositoryType() {
            return this.fr.getBundleRepositoryType();
        }

        @Override
        public boolean isType(SubsystemContentType type) {
            return this.fr.isType(type);
        }

        @Override
        public String getExtendedAttributes() {
            return this.fr.getExtendedAttributes();
        }

        @Override
        public String setExecutablePermission() {
            return this.fr.setExecutablePermission();
        }

        @Override
        public String getFileEncoding() {
            return null;
        }

        @Override
        public List<String> getTolerates() {
            return this.fr.getTolerates();
        }

        @Override
        public VersionRange getJavaRange() {
            return this.fr.getJavaRange();
        }

        @Override
        public ActivationType getActivationType() {
            return this.fr.getActivationType();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.BundleList$RuntimeFeatureResource", RuntimeFeatureResource.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }

    public static interface FeatureResourceHandler {
        public boolean handle(FeatureResource var1);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class CachedFeatureResource
    implements FeatureResource {
        private final String stringRepresentation;
        private final String symbolicName;
        private final VersionRange range;
        private final String location;
        private final String bundleRepositoryType;
        private final int startLevel;
        private final ActivationType activationType;
        static final long serialVersionUID = 3229910876168211744L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public CachedFeatureResource(String key, String value) {
            String repoType = null;
            String vRange = null;
            int ix1 = key.indexOf(124);
            if (ix1 > -1) {
                repoType = key.substring(0, ix1++);
            } else {
                ix1 = 0;
            }
            int ix2 = key.indexOf(47);
            if (ix2 != -1) {
                this.symbolicName = key.substring(ix1, ix2);
                vRange = key.substring(ix2 + 1);
            } else {
                this.symbolicName = key;
            }
            this.stringRepresentation = key.substring(ix1);
            this.bundleRepositoryType = FeatureDefinitionUtils.emptyIfNull(repoType);
            this.range = VersionUtility.stringToVersionRange((String)vRange);
            int ix3 = value.lastIndexOf(59);
            if (ix3 != -1) {
                this.location = value.substring(0, ix3);
                int ix4 = value.lastIndexOf(64);
                if (ix4 != -1) {
                    this.startLevel = Integer.valueOf(value.substring(ix3 + 1, ix4));
                    this.activationType = ActivationType.fromString(value.substring(ix4 + 1));
                } else {
                    this.startLevel = Integer.valueOf(value.substring(ix3 + 1));
                    this.activationType = ActivationType.SEQUENTIAL;
                }
            } else {
                this.location = value;
                this.startLevel = 0;
                this.activationType = ActivationType.SEQUENTIAL;
            }
        }

        @Override
        public String getSymbolicName() {
            return this.symbolicName;
        }

        @Override
        public VersionRange getVersionRange() {
            return this.range;
        }

        @Override
        public Map<String, String> getAttributes() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, String> getDirectives() {
            return Collections.emptyMap();
        }

        @Override
        public String getLocation() {
            return this.location;
        }

        @Override
        public List<String> getOsList() {
            return null;
        }

        @Override
        public SubsystemContentType getType() {
            return SubsystemContentType.BUNDLE_TYPE;
        }

        @Override
        public String getRawType() {
            return SubsystemContentType.BUNDLE_TYPE.getValue();
        }

        public String toString() {
            return this.stringRepresentation;
        }

        @Override
        public int getStartLevel() {
            return this.startLevel;
        }

        @Override
        public String getMatchString() {
            return this.stringRepresentation;
        }

        @Override
        public String getBundleRepositoryType() {
            return this.bundleRepositoryType;
        }

        @Override
        public boolean isType(SubsystemContentType type) {
            return type == SubsystemContentType.BUNDLE_TYPE;
        }

        @Override
        public String getExtendedAttributes() {
            return null;
        }

        @Override
        public String setExecutablePermission() {
            return Boolean.FALSE.toString();
        }

        @Override
        public String getFileEncoding() {
            return null;
        }

        @Override
        public List<String> getTolerates() {
            return Collections.emptyList();
        }

        @Override
        public VersionRange getJavaRange() {
            return null;
        }

        @Override
        public ActivationType getActivationType() {
            return this.activationType;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.BundleList$CachedFeatureResource", CachedFeatureResource.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }
}

