/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.feature.internal.util.VerifyData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class VerifyDelta {
    private final Map<String, List<String>> errors = new LinkedHashMap<String, List<String>>();
    private final Map<String, List<String>> warnings = new LinkedHashMap<String, List<String>>();
    private final Map<String, List<String>> info = new LinkedHashMap<String, List<String>>();
    public static final String GLOBAL_CASE_KEY = "global results";
    public static final boolean USED_KERNEL = true;
    public static final int ORIGINAL_FEATURE_OFFSET = 0;
    public static final int VERSIONLESS_FEATURE_OFFSET = 1;
    public static final int PLATFORM_OFFSET = 2;
    public static final int OLD_FEATURE_OFFSET = 3;
    public static final int NEW_FEATURE_OFFSET = 4;
    public static final boolean ORIGINAL_USED_KERNEL = true;
    public static final boolean UPDATED_USED_KERNEL = true;
    static final long serialVersionUID = 312118680831621888L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static Map<String, List<String>> compare(FeatureSupplier repo, VerifyData expectedCases, VerifyData actualCases, boolean actualUsedKernel) {
        VerifyDelta delta = new VerifyDelta();
        delta.doCompare(repo, expectedCases, actualCases, actualUsedKernel);
        return delta.getErrors();
    }

    public void clear() {
        this.clearErrors();
        this.clearWarnings();
        this.clearInfo();
    }

    public void clearErrors() {
        this.errors.clear();
    }

    public boolean isEmpty() {
        return this.errors.isEmpty();
    }

    public int size() {
        return this.errors.size();
    }

    public int totalSize() {
        int total = 0;
        for (List<String> caseErrors : this.errors.values()) {
            total += caseErrors.size();
        }
        return total;
    }

    public Map<String, List<String>> getErrors() {
        return this.errors;
    }

    private void setErrors(String name, List<String> caseErrors) {
        this.errors.put(name, caseErrors);
    }

    private void addError(String name, String error) {
        List<String> caseErrors = this.errors.get(name);
        if (caseErrors == null) {
            caseErrors = new ArrayList<String>();
            this.errors.put(name, caseErrors);
        }
        caseErrors.add(error);
    }

    public static List<String> addMessage(List<String> messages, String message) {
        if (messages == null) {
            messages = new ArrayList<String>();
        }
        messages.add(message);
        return messages;
    }

    public void clearWarnings() {
        this.warnings.clear();
    }

    public int getWarningCount() {
        return this.warnings.size();
    }

    public int totalWarningCount() {
        int total = 0;
        for (List<String> caseWarnings : this.warnings.values()) {
            total += caseWarnings.size();
        }
        return total;
    }

    public Map<String, List<String>> getWarnings() {
        return this.warnings;
    }

    private void setWarnings(String name, List<String> caseWarnings) {
        this.warnings.put(name, caseWarnings);
    }

    public void clearInfo() {
        this.info.clear();
    }

    public int getInfoCount() {
        return this.info.size();
    }

    public int totalInfoCount() {
        int total = 0;
        for (List<String> caseWarnings : this.info.values()) {
            total += caseWarnings.size();
        }
        return total;
    }

    public Map<String, List<String>> getInfo() {
        return this.info;
    }

    private void setInfo(String name, List<String> caseInfo) {
        this.info.put(name, caseInfo);
    }

    private void setMessages(String caseKey, ChangeMessages messages) {
        if (messages.errors != null) {
            this.setErrors(caseKey, messages.errors);
        }
        if (messages.warnings != null) {
            this.setWarnings(caseKey, messages.warnings);
        }
        if (messages.info != null) {
            this.setInfo(caseKey, messages.info);
        }
    }

    public void doCompare(FeatureSupplier repo, VerifyData expectedCases, VerifyData actualCases, boolean actualUsedKernel) {
        String caseKey;
        int expectedSize;
        int actualSize = actualCases.cases.size();
        if (actualSize != (expectedSize = expectedCases.cases.size())) {
            this.addError(GLOBAL_CASE_KEY, "Incorrect case count; expected [ " + expectedSize + " ] actual [ " + actualSize + " ]");
        }
        Map<String, VerifyData.VerifyCase> actual = actualCases.mapCases();
        Map<String, VerifyData.VerifyCase> expected = expectedCases.mapCases();
        for (Map.Entry<String, VerifyData.VerifyCase> caseEntry : actual.entrySet()) {
            caseKey = caseEntry.getKey();
            if (expected.containsKey(caseKey)) continue;
            this.addError(GLOBAL_CASE_KEY, "Extra case [ " + caseKey + " ]");
        }
        for (Map.Entry<String, VerifyData.VerifyCase> caseEntry : expected.entrySet()) {
            caseKey = caseEntry.getKey();
            if (actual.containsKey(caseKey)) continue;
            this.addError(GLOBAL_CASE_KEY, "Missing case [ " + caseKey + " ]");
        }
        for (Map.Entry<String, VerifyData.VerifyCase> caseEntry : actual.entrySet()) {
            caseKey = caseEntry.getKey();
            VerifyData.VerifyCase actualCase = caseEntry.getValue();
            VerifyData.VerifyCase expectedCase = expected.get(caseKey);
            if (expectedCase == null) {
                return;
            }
            ChangeMessages caseMessages = VerifyDelta.compare(repo, expectedCase, actualCase, actualUsedKernel, null, null, null);
            this.setMessages(caseKey, caseMessages);
        }
    }

    public static String substitutionKey(String vFeature, String platform) {
        String sKey = vFeature + ":" + platform;
        System.out.println("Substitution key [ " + sKey + " ]");
        return sKey;
    }

    public static void putSubstitution(String[] substitution, Map<String, String[]> substitutions) {
        String vFeature = substitution[1];
        String platform = substitution[2];
        substitutions.put(VerifyDelta.substitutionKey(vFeature, platform), substitution);
    }

    public static String[] getSubstitution(String vFeature, String platform, Map<String, String[]> substitutions) {
        return substitutions.get(VerifyDelta.substitutionKey(vFeature, platform));
    }

    public static ChangeMessages compare(FeatureSupplier repo, VerifyData.VerifyCase expectedCase, VerifyData.VerifyCase actualCase, boolean actualUsedKernel, List<String> extra, List<String> missing, String[] allowedSubstitution) {
        ChangeMessages messages = new ChangeMessages();
        for (VerifyData.ResultData resultType : VerifyData.ResultData.values()) {
            if (resultType == VerifyData.ResultData.FEATURE_RESOLVED) continue;
            VerifyDelta.compare(resultType.description, expectedCase.output.get(resultType), actualCase.output.get(resultType), messages);
        }
        VerifyDelta.compare("Versionless resolutions", expectedCase.output.getVersionlessResolved(), actualCase.output.getVersionlessResolved(), messages);
        VerifyDelta.compareResolved(repo, VerifyData.ResultData.FEATURE_RESOLVED.description, expectedCase.output.getResolved(), expectedCase.output.kernelOnly, expectedCase.output.kernelBlocked, actualCase.output.getResolved(), actualUsedKernel, extra, missing, allowedSubstitution, messages);
        return messages;
    }

    public static void compare(String description, Map<String, String> expectedResolved, Map<String, String> actualResolved, ChangeMessages messages) {
        for (Map.Entry<String, String> expectedEntry : expectedResolved.entrySet()) {
            String expectedKey = expectedEntry.getKey();
            String expectedValue = expectedEntry.getValue();
            if (!actualResolved.containsKey(expectedKey)) {
                messages.addError("Missing [ " + description + " ]: Key [ " + expectedKey + " ] Expected value [ " + expectedValue + " ]");
                continue;
            }
            String actualValue = actualResolved.get(expectedKey);
            boolean failed = expectedValue == null ? actualValue != null : (actualValue == null ? true : !expectedValue.equals(actualValue));
            if (!failed) continue;
            messages.addError("Incorrect [ " + description + " ]: Key [ " + expectedKey + " ] Expected value [ " + expectedValue + " ] Actual value [ " + actualValue + " ]");
        }
    }

    public static void compare(String description, List<String> expected, List<String> actual, ChangeMessages messages) {
        HashSet<String> expectedSet = new HashSet<String>(expected);
        HashSet<String> actualSet = new HashSet<String>(actual);
        for (String expectedElement : expectedSet) {
            if (actualSet.contains(expectedElement)) continue;
            messages.addError("Missing [ " + description + " ]: [ " + expectedElement + " ]");
        }
        for (String actualElement : actualSet) {
            if (expectedSet.contains(actualElement)) continue;
            messages.addError("Extra [ " + description + " ]: [ " + actualElement + " ]");
        }
    }

    private static void add(List<String> storage, String element) {
        if (storage != null) {
            storage.add(element);
        }
    }

    private static <T> T getAny(Set<T> set) {
        Iterator<T> iterator = set.iterator();
        if (iterator.hasNext()) {
            T elem = iterator.next();
            return elem;
        }
        return null;
    }

    private static Set<String> compactMap(Map<String, Set<String>> map, String key, String value) {
        Set<String> values = map.get(key);
        if (values == null) {
            values = Collections.singleton(value);
            map.put(key, values);
        } else if (values.size() == 1) {
            HashSet<String> newValues = new HashSet<String>(2);
            newValues.add(VerifyDelta.getAny(values));
            newValues.add(value);
            values = newValues;
            map.put(key, values);
        } else {
            values.add(value);
        }
        return values;
    }

    private static Map<String, Set<String>> mapVersions(Collection<String> features) {
        HashMap<String, Set<String>> featureVersions = new HashMap<String, Set<String>>(features.size());
        for (String feature : features) {
            int versionOffset = feature.lastIndexOf(45);
            if (versionOffset == -1) continue;
            String base = feature.substring(0, versionOffset);
            String version = feature.substring(versionOffset + 1);
            Set<String> set = VerifyDelta.compactMap(featureVersions, base, version);
        }
        return featureVersions;
    }

    /*
     * WARNING - void declaration
     */
    public static void compareResolved(FeatureSupplier repo, String description, List<String> expected, List<String> expectedKernelOnly, List<String> expectedKernelBlocked, List<String> actual, boolean actualUsedKernel, List<String> extra, List<String> missing, String[] allowedSubstitution, ChangeMessages messages) {
        HashSet<String> actualSet = new HashSet<String>();
        for (String string : actual) {
            if (!repo.getVisibility(string).equals("PUBLIC")) continue;
            actualSet.add(string);
        }
        HashSet<String> expectedSet = new HashSet<String>();
        for (String string : expected) {
            if (!repo.getVisibility(string).equals("PUBLIC")) continue;
            expectedSet.add(string);
        }
        System.out.println("Expected: " + expectedSet);
        System.out.println("Actual: " + actualSet);
        for (String string : expectedSet) {
            if (actualSet.contains(string)) continue;
            if (repo.isNoShip(string) || repo.dependsOnNoShip(string)) {
                messages.addWarning("Missing no-ship [ " + description + " ]: [ " + string + " ]");
                continue;
            }
            VerifyDelta.add(missing, string);
            messages.addError("Missing [ " + description + " ]: [ " + string + " ]");
        }
        for (String string : actualSet) {
            String extraTag = expectedSet.contains(string) ? null : (expectedKernelOnly.contains(string) ? (actualUsedKernel ? null : "Extra kernel only") : (expectedKernelBlocked.contains(string) ? (actualUsedKernel ? "Extra kernel blocked" : null) : "Extra"));
            if (extraTag == null) continue;
            if (repo.isNoShip(string) || repo.dependsOnNoShip(string)) {
                messages.addWarning((String)extraTag + " no-ship [ " + description + " ]: [ " + string + " ]");
                continue;
            }
            VerifyDelta.add(extra, string);
            messages.addError((String)extraTag + " [ " + description + " ]: [ " + string + " ]");
        }
        if (missing != null && !missing.isEmpty() && extra != null && !extra.isEmpty()) {
            Map<String, Set<String>> map = VerifyDelta.mapVersions(missing);
            Map<String, Set<String>> map2 = VerifyDelta.mapVersions(extra);
            for (Map.Entry entry : map.entrySet()) {
                Set<String> extraVersionsOfBase;
                String missingBase = (String)entry.getKey();
                Set missingVersionsOfBase = (Set)entry.getValue();
                if (missingVersionsOfBase.size() != 1 || (extraVersionsOfBase = map2.get(missingBase)) == null || extraVersionsOfBase.size() != 1) continue;
                String oldVersion = (String)VerifyDelta.getAny(missingVersionsOfBase);
                String newVersion = VerifyDelta.getAny(extraVersionsOfBase);
                messages.addInfo("Feature [ " + missingBase + " ] changed from [ " + oldVersion + " ] to [ " + newVersion + " ]");
            }
        }
        if (!messages.hasErrors()) {
            void var16_32;
            int n;
            int n2 = actual.size();
            int minSize = n2 > (n = expected.size()) ? n : n2;
            Object var16_31 = null;
            int actualNo = 0;
            int expectedNo = 0;
            while (var16_32 == null && actualNo < minSize && expectedNo < minSize) {
                boolean skipExpected;
                String actualAt = actual.get(actualNo);
                boolean skipActual = repo.isNoShip(actualAt) || repo.dependsOnNoShip(actualAt);
                String expectedAt = expected.get(expectedNo);
                boolean bl = skipExpected = repo.isNoShip(expectedAt) || repo.dependsOnNoShip(expectedAt);
                if (skipActual || !skipExpected) {
                    ++actualNo;
                }
                if (skipExpected || !skipActual) {
                    ++expectedNo;
                }
                if (skipActual || skipExpected || expectedAt.equals(actualAt)) continue;
                String string = "Order error at [ " + (actualNo - 1) + " ]: Expected [ " + expectedAt + " ] Actual [ " + actualAt + " ]";
            }
            if (var16_32 != null) {
                messages.addWarning((String)var16_32);
            }
        }
    }

    public static void kernelAdjust(VerifyData.VerifyCase original, boolean originalUsedKernel, Set<String> updatedResolved, boolean updatedUsedKernel) {
        List<String> removed;
        List<String> added;
        if (originalUsedKernel == updatedUsedKernel) {
            return;
        }
        if (originalUsedKernel) {
            added = original.output.kernelBlocked;
            removed = original.output.kernelOnly;
        } else {
            added = original.output.kernelBlocked;
            removed = original.output.kernelOnly;
        }
        VerifyDelta.moveDifference(original.output.getResolved(), updatedResolved, added, removed);
    }

    protected static void moveDifference(List<String> original, Set<String> updated, List<String> added, List<String> removed) {
        int numOriginal = original.size();
        for (int originalNo = 0; originalNo < numOriginal; ++originalNo) {
            String originalElement = original.get(originalNo);
            if (updated.contains(originalElement)) continue;
            removed.add(originalElement);
            original.remove(originalNo);
            --numOriginal;
        }
        HashSet<String> originalSet = new HashSet<String>(original);
        for (String updatedElement : updated) {
            if (originalSet.contains(updatedElement)) continue;
            added.add(updatedElement);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyDelta", VerifyDelta.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
    }

    public static interface FeatureSupplier {
        public String getVisibility(String var1);

        public boolean isNoShip(String var1);

        public boolean dependsOnNoShip(String var1);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class ChangeMessages {
        public final List<String> errors;
        public final List<String> warnings;
        public final List<String> info;
        static final long serialVersionUID = -268228252263622823L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ChangeMessages() {
            this(new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>());
        }

        public ChangeMessages(List<String> errors, List<String> warnings, List<String> info) {
            this.errors = errors;
            this.warnings = warnings;
            this.info = info;
        }

        public void addError(String message) {
            this.errors.add(message);
        }

        public boolean hasErrors() {
            return this.errors != null && !this.errors.isEmpty();
        }

        public void addWarning(String message) {
            this.warnings.add(message);
        }

        public boolean hasWarnings() {
            return this.warnings != null && !this.warnings.isEmpty();
        }

        public void addInfo(String message) {
            this.info.add(message);
        }

        public boolean hasInfo() {
            return this.info != null && !this.info.isEmpty();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyDelta$ChangeMessages", ChangeMessages.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }
}

