/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.util.custom;

import com.ibm.ws.crypto.util.MessageUtils;
import com.ibm.ws.crypto.util.custom.CustomUtils;
import com.ibm.ws.kernel.provisioning.ProductExtension;
import com.ibm.ws.kernel.provisioning.ProductExtensionInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomManifest {
    private static final Class<?> CLASS_NAME = CustomManifest.class;
    private static final String RB = "com.ibm.ws.crypto.util.internal.resources.Messages";
    private static final Logger logger = Logger.getLogger(CLASS_NAME.getCanonicalName(), "com.ibm.ws.crypto.util.internal.resources.Messages");
    private final String extensionJarName;
    private final String extensionJarLocation;
    private final String implClassName;
    private final String algorithmName;
    private final String featureDescription;
    private final String featureName;
    private final String featureSymbolicName;
    private final String featureId;
    private static final String DEFAULT_ALGORITHM = "custom";
    private static final String DEFAULT_DESC = "Custom password encryption";
    private static final String MANIFEST_EXT = ".mf";
    private static final String HDR_IMPL_CLASS = "IBM-ImplementationClass";
    private static final String HDR_SUB_CONTENT = "Subsystem-Content";
    private static final String HDR_SUB_SYM_NAME = "Subsystem-SymbolicName";
    private static final String HDR_SUB_SHORT_NAME = "IBM-ShortName";
    private static final String HDR_SUB_DESC = "Subsystem-Description";
    private static final String HDR_ATTR_LOCATION = "location";
    private static final String HDR_ATTR_TYPE = "type";
    private static final String HDR_ATTR_VALUE_FILE = "file";
    private static final String FEATURE_DIR = "lib/features";

    protected CustomManifest() {
        this.extensionJarName = null;
        this.extensionJarLocation = null;
        this.algorithmName = null;
        this.implClassName = null;
        this.featureDescription = null;
        this.featureName = null;
        this.featureSymbolicName = null;
        this.featureId = null;
    }

    public CustomManifest(File file) throws IOException, IllegalArgumentException {
        String desc;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("extension manifest file : " + file);
        }
        Attributes attrs = this.loadExtensionJarFile(file);
        this.implClassName = attrs.getValue(HDR_IMPL_CLASS);
        if (this.implClassName == null) {
            throw new IllegalArgumentException(MessageUtils.getMessage("PASSWORDUTIL_ERROR_MISSING_HEADER", HDR_IMPL_CLASS, file));
        }
        this.extensionJarName = file.getName();
        this.extensionJarLocation = CustomUtils.getCanonicalPath(file);
        this.algorithmName = DEFAULT_ALGORITHM;
        File featureManifest = this.findFeatureManifest();
        if (featureManifest != null) {
            Attributes fattrs = this.getAttributes(featureManifest);
            this.featureSymbolicName = this.getFeatureSymbolicName(fattrs);
            this.featureName = this.getFeatureName(fattrs);
            desc = this.getLocalizedString(featureManifest, fattrs.getValue(HDR_SUB_DESC));
            if (desc == null) {
                desc = DEFAULT_DESC;
            }
        } else {
            throw new IllegalArgumentException(MessageUtils.getMessage("PASSWORDUTIL_ERROR_NO_FEATURE_MANIFEST", this.extensionJarLocation));
        }
        this.featureDescription = desc;
        this.featureId = CustomManifest.getFeatureId(featureManifest);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toString());
        }
    }

    public String getName() {
        return this.extensionJarName;
    }

    public String getLocation() {
        return this.extensionJarLocation;
    }

    public String getImplClass() {
        return this.implClassName;
    }

    public String getAlgorithm() {
        return this.algorithmName;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public String getDescription() {
        return this.featureDescription;
    }

    protected File findFeatureManifest() throws IOException {
        for (File root : CustomUtils.listExtensionDirectories()) {
            File[] files = CustomUtils.listFiles(new File(root, FEATURE_DIR));
            if (files == null) continue;
            for (File file : files) {
                if (!CustomUtils.isFile(file) || !file.getName().toLowerCase().endsWith(MANIFEST_EXT)) continue;
                List<String> fileLocations = this.getFileLocationsFromSubsystemContent(this.getSubsystemContent(file));
                for (String fileLocation : fileLocations) {
                    for (File jarRoot : CustomUtils.listRootAndExtensionDirectories()) {
                        if (!this.getCanonicalPath(jarRoot, fileLocation).equals(this.extensionJarLocation)) continue;
                        return file;
                    }
                }
            }
        }
        return null;
    }

    protected List<String> getFileLocationsFromSubsystemContent(String subsystemContent) {
        String sc = subsystemContent + ",";
        ArrayList<String> files = new ArrayList<String>();
        boolean isFile = false;
        String location = null;
        int strLen = sc.length();
        boolean quoted = false;
        int pos = 0;
        for (int i = 0; i < strLen; ++i) {
            char c = sc.charAt(i);
            if (!(quoted || c != ';' && c != ',')) {
                String str = sc.substring(pos, i);
                pos = i + 1;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("element : " + str);
                }
                if (str.contains(":=")) {
                    if (this.getKey(str).equals(HDR_ATTR_LOCATION)) {
                        location = this.getValue(str);
                    }
                } else if (str.contains("=") && this.getKey(str).equals(HDR_ATTR_TYPE) && this.getValue(str).equals(HDR_ATTR_VALUE_FILE)) {
                    isFile = true;
                }
                if (c != ',') continue;
                if (isFile && location != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("location : " + location);
                    }
                    files.add(location);
                }
                location = null;
                isFile = false;
                continue;
            }
            if (c != '\"') continue;
            quoted = !quoted;
        }
        return files;
    }

    protected String getSubsystemContent(File file) throws IOException {
        return this.getAttributes(file).getValue(HDR_SUB_CONTENT);
    }

    protected Attributes getAttributes(final File file) throws IOException {
        FileInputStream fis = null;
        try {
            fis = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws IOException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
        return new Manifest(fis).getMainAttributes();
    }

    protected static String getFeatureId(File featureManifest) throws IOException {
        String rootDir = CustomUtils.getCanonicalPath(featureManifest.getParentFile().getParentFile().getParentFile());
        String output = null;
        if (rootDir.equals(CustomUtils.getCanonicalPath(new File(CustomUtils.getInstallRoot(), "usr/extension/")))) {
            output = "usr";
        } else {
            for (ProductExtensionInfo info : ProductExtension.getProductExtensions()) {
                File extensionDir = new File(info.getLocation());
                if (!CustomUtils.isAbsolute(extensionDir)) {
                    File parentDir = new File(CustomUtils.getInstallRoot()).getParentFile();
                    extensionDir = new File(parentDir, info.getLocation());
                }
                if (!rootDir.equals(CustomUtils.getCanonicalPath(extensionDir))) continue;
                output = info.getProductID();
                break;
            }
        }
        return output;
    }

    protected String getKey(String str) {
        int index = str.indexOf(61);
        String key = null;
        if (index > 0 && (key = str.substring(0, index).trim()).charAt(key.length() - 1) == ':') {
            key = key.substring(0, key.length() - 1).trim();
        }
        return key;
    }

    protected String getValue(String str) {
        int index = str.indexOf(61);
        String value = null;
        if (index > 0 && (value = str.substring(index + 1).trim()).charAt(0) == '\"') {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    protected String getFeatureSymbolicName(Attributes attrs) {
        String[] parts;
        String value;
        String output = null;
        if (attrs != null && (value = attrs.getValue(HDR_SUB_SYM_NAME)) != null && (parts = value.split(";")).length > 0) {
            output = parts[0].trim();
        }
        return output;
    }

    protected String getFeatureName(Attributes attrs) {
        String output = null;
        if (attrs != null) {
            String value = attrs.getValue(HDR_SUB_SHORT_NAME);
            output = value != null ? value.trim() : this.getFeatureSymbolicName(attrs);
        }
        return output;
    }

    protected String getLocalizedString(File featureManifest, String value) {
        String loc;
        ResourceBundle res;
        if (value != null && value.startsWith("%") && (res = CustomUtils.getResourceBundle(new File(featureManifest.getParentFile(), "l10n"), this.featureSymbolicName, Locale.getDefault())) != null && (loc = res.getString(value.substring(1))) != null) {
            value = loc;
        }
        return value;
    }

    protected String getCanonicalPath(File root, String fileName) throws IOException {
        File file = new File(fileName);
        if (!CustomUtils.isAbsolute(file)) {
            file = new File(root, fileName);
        }
        return CustomUtils.getCanonicalPath(file);
    }

    private Attributes loadExtensionJarFile(final File file) throws IOException {
        JarFile jar = null;
        try {
            jar = AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                @Override
                public JarFile run() throws IOException {
                    return new JarFile(file);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
        Attributes attrs = jar.getManifest().getMainAttributes();
        jar.close();
        return attrs;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" extensionJarName: ").append(this.extensionJarName);
        sb.append(" extensionJarLocation: ").append(this.extensionJarLocation);
        sb.append(" implClassName: ").append(this.implClassName);
        sb.append(" algorithmName: ").append(this.algorithmName);
        sb.append(" featureDescription: ").append(this.featureDescription);
        sb.append(" featureSymbolicName: ").append(this.featureSymbolicName);
        sb.append(" featureName: ").append(this.featureName);
        sb.append(" featureId: ").append(this.featureId);
        return sb.toString();
    }
}

